/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.contraptions.phys.bearing;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.content.contraptions.ControlledContraptionEntity;
import com.simibubi.create.content.contraptions.IDisplayAssemblyExceptions;
import com.simibubi.create.content.contraptions.bearing.BearingBlock;
import com.simibubi.create.content.contraptions.bearing.IBearingBlockEntity;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.kinetics.transmission.sequencer.SequencerInstructions;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.ServerSpeedProvider;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.createmod.catnip.math.AngleHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.AxisAngle4d;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3ic;
import org.valkyrienskies.clockwork.ClockworkMod;
import org.valkyrienskies.clockwork.ClockworkSounds;
import org.valkyrienskies.clockwork.content.contraptions.phys.bearing.PhysBearingAssembler;
import org.valkyrienskies.clockwork.content.contraptions.phys.bearing.PhysBearingBlockEntityKt;
import org.valkyrienskies.clockwork.content.contraptions.phys.bearing.Return;
import org.valkyrienskies.clockwork.content.contraptions.phys.bearing.data.PhysBearingData;
import org.valkyrienskies.clockwork.content.contraptions.phys.bearing.data.PhysBearingUpdateData;
import org.valkyrienskies.clockwork.content.forces.contraption.BearingController;
import org.valkyrienskies.clockwork.platform.api.ContraptionController;
import org.valkyrienskies.clockwork.util.ClockworkConstants;
import org.valkyrienskies.clockwork.util.ClockworkUtils;
import org.valkyrienskies.clockwork.util.GetGTFAKt;
import org.valkyrienskies.clockwork.util.GlueAssembler;
import org.valkyrienskies.core.api.attachment.AttachmentHolder;
import org.valkyrienskies.core.api.bodies.properties.BodyTransform;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.LoadedShip;
import org.valkyrienskies.core.api.ships.PhysShip;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.core.api.world.PhysLevel;
import org.valkyrienskies.core.impl.bodies.properties.BodyTransformFactory;
import org.valkyrienskies.core.impl.util.serialization.VSJacksonUtil;
import org.valkyrienskies.core.internal.joints.VSFixedJoint;
import org.valkyrienskies.core.internal.joints.VSJoint;
import org.valkyrienskies.core.internal.joints.VSJointAndId;
import org.valkyrienskies.core.internal.joints.VSJointPose;
import org.valkyrienskies.core.internal.joints.VSRevoluteJoint;
import org.valkyrienskies.core.internal.world.VsiPhysLevel;
import org.valkyrienskies.core.util.datastructures.DenseBlockPosSet;
import org.valkyrienskies.kelvin.util.KelvinExtensions;
import org.valkyrienskies.mod.api.BlockEntityPhysicsListener;
import org.valkyrienskies.mod.api.ValkyrienSkies;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.GameToPhysicsAdapter;
import org.valkyrienskies.mod.common.util.SplittingDisablerAttachment;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;
import org.valkyrienskies.mod.common.world.RaycastUtilsKt;
import org.valkyrienskies.mod.util.NbtUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0088\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00bc\u00012\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u0005:\u0002\u00bc\u0001B0\u0012\u000e\u0010\u00b6\u0001\u001a\t\u0012\u0002\b\u0003\u0018\u00010\u00b5\u0001\u0012\t\u0010\u00b7\u0001\u001a\u0004\u0018\u00010Z\u0012\n\u0010\u00b9\u0001\u001a\u0005\u0018\u00010\u00b8\u0001\u00a2\u0006\u0006\b\u00ba\u0001\u0010\u00bb\u0001J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u001d\u0010\u000e\u001a\u00020\b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001b\u0010\u0012\u001a\u00020\b2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J!\u0010\u0018\u001a\u00020\b2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0017\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001f\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001cH\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u001f\u0010\"\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010!\u001a\u00020 H\u0002\u00a2\u0006\u0004\b\"\u0010#J\u001f\u0010$\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001cH\u0014\u00a2\u0006\u0004\b$\u0010\u001fJ\u0017\u0010'\u001a\u00020%2\u0006\u0010&\u001a\u00020%H\u0016\u00a2\u0006\u0004\b'\u0010(J\r\u0010)\u001a\u00020%\u00a2\u0006\u0004\b)\u0010*J\u0015\u0010+\u001a\u00020%2\u0006\u0010&\u001a\u00020%\u00a2\u0006\u0004\b+\u0010(J\u0017\u0010/\u001a\u00020.2\u0006\u0010-\u001a\u00020,H\u0002\u00a2\u0006\u0004\b/\u00100J\r\u00101\u001a\u00020\b\u00a2\u0006\u0004\b1\u00102J\u000f\u00103\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b3\u00102J\u000f\u00104\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b4\u00102J\r\u00105\u001a\u00020\b\u00a2\u0006\u0004\b5\u00102J\u000f\u00106\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b6\u00102J\u000f\u00107\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b7\u00102J\u000f\u00108\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b8\u00102J\u000f\u00109\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b9\u00102J\u000f\u0010:\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b:\u00102J\r\u0010;\u001a\u00020%\u00a2\u0006\u0004\b;\u0010*J\r\u0010<\u001a\u00020%\u00a2\u0006\u0004\b<\u0010*J\u000f\u0010=\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b=\u00102J\u0017\u0010?\u001a\u00020\b2\u0006\u0010>\u001a\u00020%H\u0016\u00a2\u0006\u0004\b?\u0010@J\u000f\u0010A\u001a\u00020\bH\u0016\u00a2\u0006\u0004\bA\u00102J%\u0010F\u001a\u00020\u001c2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020C0B2\u0006\u0010E\u001a\u00020\u001cH\u0016\u00a2\u0006\u0004\bF\u0010GJ\u000f\u0010I\u001a\u0004\u0018\u00010H\u00a2\u0006\u0004\bI\u0010JJ\u0017\u0010M\u001a\u00020\b2\u0006\u0010L\u001a\u00020KH\u0016\u00a2\u0006\u0004\bM\u0010NJ\u000f\u0010O\u001a\u00020\bH\u0016\u00a2\u0006\u0004\bO\u00102J\u000f\u0010P\u001a\u00020\u001cH\u0016\u00a2\u0006\u0004\bP\u0010QJ\u0017\u0010S\u001a\u00020\u001c2\u0006\u0010L\u001a\u00020RH\u0016\u00a2\u0006\u0004\bS\u0010TJ\u0017\u0010V\u001a\u00020\b2\u0006\u0010U\u001a\u00020%H\u0016\u00a2\u0006\u0004\bV\u0010@J\u0011\u0010X\u001a\u0004\u0018\u00010WH\u0016\u00a2\u0006\u0004\bX\u0010YJ\u000f\u0010[\u001a\u00020ZH\u0016\u00a2\u0006\u0004\b[\u0010\\J\u000f\u0010]\u001a\u00020\u001cH\u0016\u00a2\u0006\u0004\b]\u0010QR\"\u0010^\u001a\u00020\u001c8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b^\u0010_\u001a\u0004\b`\u0010Q\"\u0004\ba\u0010bR*\u0010e\u001a\n\u0012\u0004\u0012\u00020d\u0018\u00010c8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\be\u0010f\u001a\u0004\bg\u0010h\"\u0004\bi\u0010jR$\u0010k\u001a\u00020\u001c2\u0006\u0010\u0007\u001a\u00020\u001c8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\bk\u0010_\u001a\u0004\bk\u0010QR$\u0010m\u001a\u00020l2\u0006\u0010\u0007\u001a\u00020l8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\bm\u0010n\u001a\u0004\bo\u0010pR$\u0010q\u001a\u00020%2\u0006\u0010\u0007\u001a\u00020%8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\bq\u0010r\u001a\u0004\bs\u0010*R$\u0010t\u001a\u00020\u001c2\u0006\u0010\u0007\u001a\u00020\u001c8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\bt\u0010_\u001a\u0004\bu\u0010QR(\u0010w\u001a\u0004\u0018\u00010v2\b\u0010\u0007\u001a\u0004\u0018\u00010v8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\bw\u0010x\u001a\u0004\by\u0010zR$\u0010{\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00068\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b{\u0010|\u001a\u0004\b}\u0010~R\u0019\u0010\u007f\u001a\u0004\u0018\u00010W8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0007\n\u0005\b\u007f\u0010\u0080\u0001R\u0018\u0010\u0081\u0001\u001a\u00020\u001c8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0007\n\u0005\b\u0081\u0001\u0010_R\u001b\u0010\u0082\u0001\u001a\u0004\u0018\u00010,8\u0002@\u0002X\u0082\u000e\u00a2\u0006\b\n\u0006\b\u0082\u0001\u0010\u0083\u0001R\u0018\u0010\u0084\u0001\u001a\u00020%8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0007\n\u0005\b\u0084\u0001\u0010rR\u0018\u0010\u0085\u0001\u001a\u00020%8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0007\n\u0005\b\u0085\u0001\u0010rR\u0018\u0010\u0086\u0001\u001a\u00020%8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0007\n\u0005\b\u0086\u0001\u0010rR\u0018\u0010\u0087\u0001\u001a\u00020%8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0007\n\u0005\b\u0087\u0001\u0010rR\u0018\u0010\u0088\u0001\u001a\u00020\u001c8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0007\n\u0005\b\u0088\u0001\u0010_R\u0018\u0010\u0089\u0001\u001a\u00020%8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0007\n\u0005\b\u0089\u0001\u0010rR\u0018\u0010\u008a\u0001\u001a\u00020%8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0007\n\u0005\b\u008a\u0001\u0010rR\u0018\u0010\u008b\u0001\u001a\u00020%8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0007\n\u0005\b\u008b\u0001\u0010rR\u0018\u0010\u008c\u0001\u001a\u00020\u001c8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0007\n\u0005\b\u008c\u0001\u0010_R\u0018\u0010\u008d\u0001\u001a\u00020\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0007\n\u0005\b\u008d\u0001\u0010|R\u0018\u0010\u008e\u0001\u001a\u00020\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0007\n\u0005\b\u008e\u0001\u0010|R\u0018\u0010\u008f\u0001\u001a\u00020\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0007\n\u0005\b\u008f\u0001\u0010|R\u0018\u0010\u0090\u0001\u001a\u00020%8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0007\n\u0005\b\u0090\u0001\u0010rR\u0018\u0010\u0091\u0001\u001a\u00020%8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0007\n\u0005\b\u0091\u0001\u0010rR\u001a\u0010\u0093\u0001\u001a\u00030\u0092\u00018\u0002@\u0002X\u0082\u000e\u00a2\u0006\b\n\u0006\b\u0093\u0001\u0010\u0094\u0001R\u0018\u0010\u0095\u0001\u001a\u00020\u001c8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0007\n\u0005\b\u0095\u0001\u0010_R\u001a\u0010\u0096\u0001\u001a\u00030\u0092\u00018\u0002@\u0002X\u0082\u000e\u00a2\u0006\b\n\u0006\b\u0096\u0001\u0010\u0094\u0001R\u0018\u0010\u0097\u0001\u001a\u00020\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0007\n\u0005\b\u0097\u0001\u0010|R\u0018\u0010\u0098\u0001\u001a\u00020%8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0007\n\u0005\b\u0098\u0001\u0010rR\u0019\u0010\u0099\u0001\u001a\u00020d8\u0002@\u0002X\u0082\u000e\u00a2\u0006\b\n\u0006\b\u0099\u0001\u0010\u009a\u0001R\u001c\u0010\u009c\u0001\u001a\u0005\u0018\u00010\u009b\u00018\u0002@\u0002X\u0082\u000e\u00a2\u0006\b\n\u0006\b\u009c\u0001\u0010\u009d\u0001R\u001c\u0010\u009f\u0001\u001a\u0005\u0018\u00010\u009e\u00018\u0002@\u0002X\u0082\u000e\u00a2\u0006\b\n\u0006\b\u009f\u0001\u0010\u00a0\u0001R(\u0010\u00a2\u0001\u001a\u0011\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\b\u0018\u00010\u00a1\u00018\u0002@\u0002X\u0082\u000e\u00a2\u0006\b\n\u0006\b\u00a2\u0001\u0010\u00a3\u0001R/\u0010\u00a6\u0001\u001a\b0\u00a4\u0001j\u0003`\u00a5\u00018\u0016@\u0016X\u0096.\u00a2\u0006\u0018\n\u0006\b\u00a6\u0001\u0010\u00a7\u0001\u001a\u0006\b\u00a8\u0001\u0010\u00a9\u0001\"\u0006\b\u00aa\u0001\u0010\u00ab\u0001R\u001c\u0010\u00ad\u0001\u001a\u0005\u0018\u00010\u00ac\u00018\u0002@\u0002X\u0082\u000e\u00a2\u0006\b\n\u0006\b\u00ad\u0001\u0010\u00ae\u0001R\u001c\u0010\u00af\u0001\u001a\u0005\u0018\u00010\u00ac\u00018\u0002@\u0002X\u0082\u000e\u00a2\u0006\b\n\u0006\b\u00af\u0001\u0010\u00ae\u0001R\u0018\u0010\u00b0\u0001\u001a\u00020\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0007\n\u0005\b\u00b0\u0001\u0010|R\u0018\u0010\u00b1\u0001\u001a\u00020%8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0007\n\u0005\b\u00b1\u0001\u0010rR\u0018\u0010\u00b2\u0001\u001a\u00020%8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0007\n\u0005\b\u00b2\u0001\u0010rR\u0013\u0010\u00b4\u0001\u001a\u00020%8F\u00a2\u0006\u0007\u001a\u0005\b\u00b3\u0001\u0010*\u00a8\u0006\u00bd\u0001"}, d2={"Lorg/valkyrienskies/clockwork/content/contraptions/phys/bearing/PhysBearingBlockEntity;", "Lcom/simibubi/create/content/kinetics/base/GeneratingKineticBlockEntity;", "Lcom/simibubi/create/content/contraptions/bearing/IBearingBlockEntity;", "Lcom/simibubi/create/content/contraptions/IDisplayAssemblyExceptions;", "Lorg/valkyrienskies/clockwork/platform/api/ContraptionController;", "Lorg/valkyrienskies/mod/api/BlockEntityPhysicsListener;", "", "value", "", "movementModeChanged", "(I)V", "", "Lcom/simibubi/create/foundation/blockEntity/behaviour/BlockEntityBehaviour;", "behaviours", "addBehaviours", "(Ljava/util/List;)V", "Lorg/valkyrienskies/core/internal/joints/VSRevoluteJoint$VSRevoluteDriveVelocity;", "driveVelocity", "updateDrive", "(Lorg/valkyrienskies/core/internal/joints/VSRevoluteJoint$VSRevoluteDriveVelocity;)V", "Lorg/valkyrienskies/core/api/ships/PhysShip;", "physShip", "Lorg/valkyrienskies/core/api/world/PhysLevel;", "physLevel", "physTick", "(Lorg/valkyrienskies/core/api/ships/PhysShip;Lorg/valkyrienskies/core/api/world/PhysLevel;)V", "Lnet/minecraft/nbt/CompoundTag;", "tag", "", "clientPacket", "write", "(Lnet/minecraft/nbt/CompoundTag;Z)V", "Lnet/minecraft/server/level/ServerLevel;", "level", "loadTheRest", "(Lnet/minecraft/nbt/CompoundTag;Lnet/minecraft/server/level/ServerLevel;)V", "read", "", "partialTicks", "getInterpolatedAngle", "(F)F", "getWingRotOffset", "()F", "getInterpolatedCoreAngle", "Lnet/minecraft/core/Direction;", "localDirection", "Lorg/joml/Quaterniond;", "getHingeRotation", "(Lnet/minecraft/core/Direction;)Lorg/joml/Quaterniond;", "tryMakeJoint", "()V", "assemble", "destroy", "disassemble", "shipDisassemble", "resetState", "tryAssembleNextTick", "tryUpdateData", "tickAnimationLogic", "getActualAngularSpeed", "getRealisticAngularSpeed", "tick", "previousSpeed", "onSpeedChanged", "(F)V", "lazyTick", "", "Lnet/minecraft/network/chat/Component;", "tooltip", "isPlayerSneaking", "addToTooltip", "(Ljava/util/List;Z)Z", "", "getActualAngle", "()Ljava/lang/Double;", "Lcom/simibubi/create/content/contraptions/ControlledContraptionEntity;", "contraption", "attach", "(Lcom/simibubi/create/content/contraptions/ControlledContraptionEntity;)V", "onStall", "isValid", "()Z", "Lcom/simibubi/create/content/contraptions/AbstractContraptionEntity;", "isAttachedTo", "(Lcom/simibubi/create/content/contraptions/AbstractContraptionEntity;)Z", "forcedAngle", "setAngle", "Lcom/simibubi/create/content/contraptions/AssemblyException;", "getLastAssemblyException", "()Lcom/simibubi/create/content/contraptions/AssemblyException;", "Lnet/minecraft/core/BlockPos;", "getBlockPosition", "()Lnet/minecraft/core/BlockPos;", "isWoodenTop", "assembleNextTick", "Z", "getAssembleNextTick", "setAssembleNextTick", "(Z)V", "Lcom/simibubi/create/foundation/blockEntity/behaviour/scrollValue/ScrollOptionBehaviour;", "Lorg/valkyrienskies/clockwork/platform/api/ContraptionController$LockedMode;", "movementMode", "Lcom/simibubi/create/foundation/blockEntity/behaviour/scrollValue/ScrollOptionBehaviour;", "getMovementMode", "()Lcom/simibubi/create/foundation/blockEntity/behaviour/scrollValue/ScrollOptionBehaviour;", "setMovementMode", "(Lcom/simibubi/create/foundation/blockEntity/behaviour/scrollValue/ScrollOptionBehaviour;)V", "isRunning", "", "shiptraptionID", "J", "getShiptraptionID", "()J", "targetAngle", "F", "getTargetAngle", "disassembleWhenPossible", "getDisassembleWhenPossible", "Lorg/valkyrienskies/core/internal/joints/VSJoint;", "joint", "Lorg/valkyrienskies/core/internal/joints/VSJoint;", "getJoint", "()Lorg/valkyrienskies/core/internal/joints/VSJoint;", "jointID", "I", "getJointID", "()I", "lastException", "Lcom/simibubi/create/content/contraptions/AssemblyException;", "open", "originalDirection", "Lnet/minecraft/core/Direction;", "clientAngleDiff", "prevAngle", "coreAngle", "previousCoreAngle", "opening", "openProgress", "openProgressMax", "inOutCorner", "cornerShrinking", "ticks", "lastStateChanged", "cooldown", "sequencedAngleLimit", "sequencedAngleProgress", "Lorg/joml/Vector3d;", "bearingPos", "Lorg/joml/Vector3d;", "aligning", "bearingAxis", "bearingID", "lastSpeed", "lastMode", "Lorg/valkyrienskies/clockwork/platform/api/ContraptionController$LockedMode;", "Lorg/valkyrienskies/clockwork/content/contraptions/phys/bearing/data/PhysBearingData;", "controllerCreationData", "Lorg/valkyrienskies/clockwork/content/contraptions/phys/bearing/data/PhysBearingData;", "Lorg/valkyrienskies/clockwork/content/contraptions/phys/bearing/data/PhysBearingUpdateData;", "controllerUpdateData", "Lorg/valkyrienskies/clockwork/content/contraptions/phys/bearing/data/PhysBearingUpdateData;", "Lkotlin/Function1;", "loadingFn", "Lkotlin/jvm/functions/Function1;", "", "Lorg/valkyrienskies/core/api/world/properties/DimensionId;", "dimension", "Ljava/lang/String;", "getDimension", "()Ljava/lang/String;", "setDimension", "(Ljava/lang/String;)V", "Lorg/joml/Vector3dc;", "sDir1", "Lorg/joml/Vector3dc;", "sDir2", "pTick", "lastAngle", "curAngle", "getAngularSpeed", "angularSpeed", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "type", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "<init>", "(Lnet/minecraft/world/level/block/entity/BlockEntityType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "Companion", "clockwork"})
@SourceDebugExtension(value={"SMAP\nPhysBearingBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PhysBearingBlockEntity.kt\norg/valkyrienskies/clockwork/content/contraptions/phys/bearing/PhysBearingBlockEntity\n+ 2 Vector3dUtils.kt\norg/valkyrienskies/clockwork/util/Vector3dUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 AttachmentHolder.kt\norg/valkyrienskies/core/api/attachment/AttachmentHolderKt\n*L\n1#1,857:1\n7#2:858\n19#2:859\n7#2:860\n19#2:861\n7#2:862\n19#2:863\n7#2:864\n19#2:865\n26#2:866\n6#2:867\n26#2:868\n6#2:869\n24#2:870\n20#2:871\n20#2:872\n19#2:873\n7#2:874\n19#2:875\n1#3:876\n66#4:877\n66#4:878\n66#4:879\n66#4:880\n*S KotlinDebug\n*F\n+ 1 PhysBearingBlockEntity.kt\norg/valkyrienskies/clockwork/content/contraptions/phys/bearing/PhysBearingBlockEntity\n*L\n273#1:858\n273#1:859\n274#1:860\n274#1:861\n276#1:862\n276#1:863\n277#1:864\n277#1:865\n480#1:866\n480#1:867\n481#1:868\n481#1:869\n516#1:870\n516#1:871\n526#1:872\n526#1:873\n527#1:874\n527#1:875\n617#1:877\n618#1:878\n622#1:879\n623#1:880\n*E\n"})
public final class PhysBearingBlockEntity
extends GeneratingKineticBlockEntity
implements IBearingBlockEntity,
IDisplayAssemblyExceptions,
ContraptionController,
BlockEntityPhysicsListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean assembleNextTick;
    @Nullable
    private ScrollOptionBehaviour<ContraptionController.LockedMode> movementMode;
    private boolean isRunning;
    private long shiptraptionID = -1L;
    private float targetAngle;
    private boolean disassembleWhenPossible;
    @Nullable
    private volatile VSJoint joint;
    private volatile int jointID = -1;
    @Nullable
    private AssemblyException lastException;
    private boolean open;
    @Nullable
    private Direction originalDirection;
    private float clientAngleDiff;
    private float prevAngle;
    private float coreAngle;
    private float previousCoreAngle;
    private boolean opening;
    private float openProgress;
    private float openProgressMax = 70.0f;
    private float inOutCorner;
    private boolean cornerShrinking;
    private int ticks;
    private int lastStateChanged;
    private int cooldown = 20;
    private float sequencedAngleLimit = -1.0f;
    private float sequencedAngleProgress;
    @NotNull
    private Vector3d bearingPos = new Vector3d();
    private boolean aligning;
    @NotNull
    private Vector3d bearingAxis = new Vector3d();
    private int bearingID = -1;
    private float lastSpeed;
    @NotNull
    private ContraptionController.LockedMode lastMode = ContraptionController.LockedMode.UNLOCKED;
    @Nullable
    private PhysBearingData controllerCreationData;
    @Nullable
    private PhysBearingUpdateData controllerUpdateData;
    @Nullable
    private Function1<? super ServerLevel, Unit> loadingFn;
    public volatile String dimension;
    @Nullable
    private volatile Vector3dc sDir1;
    @Nullable
    private volatile Vector3dc sDir2;
    private volatile int pTick;
    private volatile float lastAngle;
    private volatile float curAngle;
    public static final long NO_SHIPTRAPTION_ID = -1L;

    public PhysBearingBlockEntity(@Nullable BlockEntityType<?> type, @Nullable BlockPos pos, @Nullable BlockState state) {
        super(type, pos, state);
        this.setLazyTickRate(3);
        this.lastAngle = this.targetAngle;
        this.curAngle = this.targetAngle;
    }

    public final boolean getAssembleNextTick() {
        return this.assembleNextTick;
    }

    public final void setAssembleNextTick(boolean bl) {
        this.assembleNextTick = bl;
    }

    @Nullable
    public final ScrollOptionBehaviour<ContraptionController.LockedMode> getMovementMode() {
        return this.movementMode;
    }

    public final void setMovementMode(@Nullable ScrollOptionBehaviour<ContraptionController.LockedMode> scrollOptionBehaviour) {
        this.movementMode = scrollOptionBehaviour;
    }

    public final boolean isRunning() {
        return this.isRunning;
    }

    public final long getShiptraptionID() {
        return this.shiptraptionID;
    }

    public final float getTargetAngle() {
        return this.targetAngle;
    }

    public final boolean getDisassembleWhenPossible() {
        return this.disassembleWhenPossible;
    }

    @Nullable
    public final VSJoint getJoint() {
        return this.joint;
    }

    public final int getJointID() {
        return this.jointID;
    }

    private final void movementModeChanged(int value) {
        block3: {
            block2: {
                if (this.f_58857_ == null) break block2;
                Level level = this.f_58857_;
                Intrinsics.checkNotNull((Object)level);
                if (!level.f_46443_) break block3;
            }
            return;
        }
        this.sendData();
    }

    public void addBehaviours(@NotNull List<BlockEntityBehaviour> behaviours) {
        Intrinsics.checkNotNullParameter(behaviours, (String)"behaviours");
        super.addBehaviours(behaviours);
        this.movementMode = new ScrollOptionBehaviour(ContraptionController.LockedMode.class, (Component)Component.m_237115_((String)"vs_clockwork.phys_bearing.rotation_mode"), (SmartBlockEntity)this, this.getMovementModeSlot());
        ScrollOptionBehaviour<ContraptionController.LockedMode> scrollOptionBehaviour = this.movementMode;
        Intrinsics.checkNotNull(scrollOptionBehaviour);
        scrollOptionBehaviour.withCallback(arg_0 -> PhysBearingBlockEntity.addBehaviours$lambda$0(this, arg_0));
        ScrollOptionBehaviour<ContraptionController.LockedMode> scrollOptionBehaviour2 = this.movementMode;
        Intrinsics.checkNotNull(scrollOptionBehaviour2);
        scrollOptionBehaviour2.requiresWrench();
        ScrollOptionBehaviour<ContraptionController.LockedMode> scrollOptionBehaviour3 = this.movementMode;
        Intrinsics.checkNotNull(scrollOptionBehaviour3);
        behaviours.add((BlockEntityBehaviour)scrollOptionBehaviour3);
    }

    private final void updateDrive(VSRevoluteJoint.VSRevoluteDriveVelocity driveVelocity) {
        ScrollOptionBehaviour<ContraptionController.LockedMode> scrollOptionBehaviour = this.movementMode;
        Intrinsics.checkNotNull(scrollOptionBehaviour);
        if (scrollOptionBehaviour.get() == ContraptionController.LockedMode.FOLLOW_ANGLE || this.aligning) {
            VSJoint vSJoint = this.joint;
            Intrinsics.checkNotNull((Object)vSJoint);
            Long l = vSJoint.getShipId0();
            VSJoint vSJoint2 = this.joint;
            Intrinsics.checkNotNull((Object)vSJoint2);
            VSJointPose vSJointPose = vSJoint2.getPose0();
            VSJoint vSJoint3 = this.joint;
            Intrinsics.checkNotNull((Object)vSJoint3);
            Long l2 = vSJoint3.getShipId1();
            VSJoint vSJoint4 = this.joint;
            Intrinsics.checkNotNull((Object)vSJoint4);
            this.joint = (VSJoint)new VSFixedJoint(l, vSJointPose, l2, vSJoint4.getPose1(), null, 1.0E-100, 16, null);
            this.controllerUpdateData = new PhysBearingUpdateData(Math.toRadians(this.targetAngle), 0.0f, false);
        } else {
            VSJoint vSJoint = this.joint;
            Intrinsics.checkNotNull((Object)vSJoint);
            Long l = vSJoint.getShipId0();
            VSJoint vSJoint5 = this.joint;
            Intrinsics.checkNotNull((Object)vSJoint5);
            VSJointPose vSJointPose = vSJoint5.getPose0();
            VSJoint vSJoint6 = this.joint;
            Intrinsics.checkNotNull((Object)vSJoint6);
            Long l3 = vSJoint6.getShipId1();
            VSJoint vSJoint7 = this.joint;
            Intrinsics.checkNotNull((Object)vSJoint7);
            this.joint = (VSJoint)new VSRevoluteJoint(l, vSJointPose, l3, vSJoint7.getPose1(), null, 1.0E-100, null, null, null, null, Boolean.valueOf(true), 976, null);
            this.controllerUpdateData = new PhysBearingUpdateData(Math.toRadians(this.targetAngle), this.getRealisticAngularSpeed(), false);
            Level level = this.f_58857_;
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            GameToPhysicsAdapter gameToPhysicsAdapter = GetGTFAKt.getGtpa((ServerLevel)level);
            VSJoint vSJoint8 = this.joint;
            Intrinsics.checkNotNull((Object)vSJoint8);
            GetGTFAKt.updateJoint(gameToPhysicsAdapter, this.jointID, vSJoint8);
        }
    }

    static /* synthetic */ void updateDrive$default(PhysBearingBlockEntity physBearingBlockEntity, VSRevoluteJoint.VSRevoluteDriveVelocity vSRevoluteDriveVelocity, int n, Object object) {
        if ((n & 1) != 0) {
            vSRevoluteDriveVelocity = null;
        }
        physBearingBlockEntity.updateDrive(vSRevoluteDriveVelocity);
    }

    @NotNull
    public String getDimension() {
        String string = this.dimension;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"dimension");
        return null;
    }

    public void setDimension(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.dimension = string;
    }

    public void physTick(@Nullable PhysShip physShip, @NotNull PhysLevel physLevel) {
        Intrinsics.checkNotNullParameter((Object)physLevel, (String)"physLevel");
        if (this.m_58901_() || !this.isRunning) {
            return;
        }
        if (this.jointID == -1) {
            return;
        }
        VSJoint vSJoint = this.joint;
        VSFixedJoint vSFixedJoint = vSJoint instanceof VSFixedJoint ? (VSFixedJoint)vSJoint : null;
        if (vSFixedJoint == null) {
            return;
        }
        VSFixedJoint joint = vSFixedJoint;
        if (!(this.curAngle == this.targetAngle)) {
            this.pTick = 0;
            this.lastAngle = this.curAngle;
            this.curAngle = this.targetAngle;
        }
        double angle = (double)this.lastAngle + (double)(this.targetAngle - this.lastAngle) * ((double)(this.pTick + 1) / 3.0);
        if (this.aligning) {
            angle = 0.0;
        }
        VsiPhysLevel cfr_ignored_0 = (VsiPhysLevel)physLevel;
        if (this.sDir1 == null || this.sDir2 == null) {
            this.sDir1 = (Vector3dc)this.bearingAxis;
            this.sDir2 = (Vector3dc)this.bearingAxis;
        }
        Quaterniond quaterniond = new Quaterniond(new AxisAngle4d(Math.toRadians(angle), this.sDir1));
        Vector3dc vector3dc = this.sDir1;
        Intrinsics.checkNotNull((Object)vector3dc);
        Quaterniond fRot2 = quaterniond.mul((Quaterniondc)PhysBearingBlockEntityKt.getHingeRotation$default(vector3dc, null, 2, null));
        Vector3dc vector3dc2 = this.sDir2;
        Intrinsics.checkNotNull((Object)vector3dc2);
        Quaterniond fRot1 = PhysBearingBlockEntityKt.getHingeRotation$default(vector3dc2, null, 2, null);
        Long l = joint.getShipId0();
        VSJointPose vSJointPose = new VSJointPose(joint.getPose0().getPos(), (Quaterniondc)fRot1);
        Long l2 = joint.getShipId1();
        Vector3dc vector3dc3 = joint.getPose1().getPos();
        Intrinsics.checkNotNull((Object)fRot2);
        this.joint = (VSJoint)new VSFixedJoint(l, vSJointPose, l2, new VSJointPose(vector3dc3, (Quaterniondc)fRot2), null, 1.0E-100, 16, null);
        VsiPhysLevel vsiPhysLevel = (VsiPhysLevel)physLevel;
        VSJoint vSJoint2 = this.joint;
        Intrinsics.checkNotNull((Object)vSJoint2);
        vsiPhysLevel.updateJoint(this.jointID, vSJoint2);
        int n = this.pTick;
        this.pTick = n + 1;
        int n2 = 2;
        this.pTick = Math.max(n, n2);
    }

    public void write(@NotNull CompoundTag tag, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        super.write(tag, clientPacket);
        tag.m_128379_(ClockworkConstants.Nbt.INSTANCE.getRUNNING(), this.isRunning);
        tag.m_128350_(ClockworkConstants.Nbt.INSTANCE.getANGLE(), this.targetAngle);
        if (this.shiptraptionID != -1L) {
            tag.m_128356_(ClockworkConstants.Nbt.INSTANCE.getSHIPTRAPTION_ID(), this.shiptraptionID);
        }
        if (this.originalDirection != null) {
            String string = ClockworkConstants.Nbt.INSTANCE.getORIGINAL_DIRECTION();
            Direction direction = this.originalDirection;
            Intrinsics.checkNotNull((Object)direction);
            tag.m_128405_(string, direction.ordinal());
        }
        AssemblyException.write((CompoundTag)tag, (AssemblyException)this.lastException);
        tag.m_128379_(ClockworkConstants.Nbt.INSTANCE.getOPEN(), this.open);
        tag.m_128350_(ClockworkConstants.Nbt.INSTANCE.getSEQUENCED_ANGLE_LIMIT(), this.sequencedAngleLimit);
        tag.m_128350_(ClockworkConstants.Nbt.INSTANCE.getSEQUENCED_ANGLE_PROGRESS(), this.sequencedAngleProgress);
        NbtUtilKt.putVector3d((CompoundTag)tag, (String)"bearingPos", (Vector3dc)((Vector3dc)this.bearingPos));
        NbtUtilKt.putVector3d((CompoundTag)tag, (String)"bearingAxis", (Vector3dc)((Vector3dc)this.bearingAxis));
        tag.m_128379_("aligning", this.aligning);
        ObjectMapper mapper = VSJacksonUtil.INSTANCE.getDtoMapper();
        VSJoint vSJoint = this.joint;
        if (vSJoint instanceof VSRevoluteJoint) {
            VSJoint vSJoint2 = this.joint;
            Intrinsics.checkNotNull((Object)vSJoint2);
            tag.m_128382_("joint", mapper.writeValueAsBytes((Object)vSJoint2));
        } else if (vSJoint instanceof VSFixedJoint) {
            VSJoint vSJoint3 = this.joint;
            Intrinsics.checkNotNull((Object)vSJoint3);
            tag.m_128382_("fjoint", mapper.writeValueAsBytes((Object)vSJoint3));
        }
        tag.m_128405_("jointID", this.jointID);
        if (this.shiptraptionID == -1L) {
            return;
        }
        tag.m_128356_(ClockworkConstants.Nbt.INSTANCE.getOLD_POS(), this.f_58858_.m_121878_());
        NbtUtilKt.putVector3d((CompoundTag)tag, (String)ClockworkConstants.Nbt.INSTANCE.getOLD_SHIPTRAPTION_CENTER(), (Vector3dc)((Vector3dc)this.bearingPos));
        NbtUtilKt.putVector3d((CompoundTag)tag, (String)ClockworkConstants.Nbt.INSTANCE.getNEW_SHIPTRAPTION_CENTER(), (Vector3dc)((Vector3dc)this.bearingPos));
    }

    private final void loadTheRest(CompoundTag tag, ServerLevel level) {
        VSJoint vSJoint;
        VSJoint vSJoint2;
        VSJoint vSJoint3 = this.joint;
        if (vSJoint3 == null) {
            return;
        }
        VSJoint joint = vSJoint3;
        BlockPos blockPos = this.f_58858_;
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"worldPosition");
        ServerShip serverShip = VSGameUtilsKt.getShipManagingPos((ServerLevel)level, (BlockPos)blockPos);
        Long mainId = serverShip != null ? Long.valueOf(serverShip.getId()) : null;
        BlockPos oldBPos = BlockPos.m_122022_((long)tag.m_128454_(ClockworkConstants.Nbt.INSTANCE.getOLD_POS()));
        Intrinsics.checkNotNull((Object)oldBPos);
        Vector3d oldPos = VectorConversionsMCKt.toJOMLD((Vec3i)((Vec3i)oldBPos));
        BlockPos blockPos2 = this.f_58858_;
        Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"worldPosition");
        Vector3d newPos = VectorConversionsMCKt.toJOMLD((Vec3i)((Vec3i)blockPos2));
        Vector3d vector3d = ClockworkUtils.INSTANCE.getVector3d(tag, ClockworkConstants.Nbt.INSTANCE.getOLD_SHIPTRAPTION_CENTER());
        if (vector3d == null) {
            return;
        }
        Vector3d oldSPos = vector3d;
        Vector3d vector3d2 = ClockworkUtils.INSTANCE.getVector3d(tag, ClockworkConstants.Nbt.INSTANCE.getNEW_SHIPTRAPTION_CENTER());
        if (vector3d2 == null) {
            return;
        }
        Vector3d newSPos = vector3d2;
        this.bearingPos = this.bearingPos.sub((Vector3dc)oldSPos).add((Vector3dc)newSPos);
        VSJoint vSJoint4 = joint;
        if (vSJoint4 instanceof VSRevoluteJoint) {
            VSRevoluteJoint vSRevoluteJoint = (VSRevoluteJoint)joint;
            Long l = this.shiptraptionID;
            Vector3dc $this$minus$iv = ((VSRevoluteJoint)joint).getPose0().getPos();
            boolean $i$f$minus = false;
            Vector3d vector3d3 = $this$minus$iv.sub((Vector3dc)oldSPos, new Vector3d());
            Intrinsics.checkNotNullExpressionValue((Object)vector3d3, (String)"minus(...)");
            Vector3d $this$plus$iv = vector3d3;
            boolean $i$f$plus = false;
            Vector3d vector3d4 = $this$plus$iv.add((Vector3dc)newSPos, new Vector3d());
            Intrinsics.checkNotNullExpressionValue((Object)vector3d4, (String)"plus(...)");
            VSJointPose vSJointPose = new VSJointPose((Vector3dc)vector3d4, ((VSRevoluteJoint)joint).getPose0().getRot());
            $this$minus$iv = ((VSRevoluteJoint)joint).getPose1().getPos();
            $i$f$minus = false;
            Vector3d vector3d5 = $this$minus$iv.sub((Vector3dc)oldPos, new Vector3d());
            Intrinsics.checkNotNullExpressionValue((Object)vector3d5, (String)"minus(...)");
            $this$plus$iv = vector3d5;
            $i$f$plus = false;
            Vector3d vector3d6 = $this$plus$iv.add((Vector3dc)newPos, new Vector3d());
            Intrinsics.checkNotNullExpressionValue((Object)vector3d6, (String)"plus(...)");
            vSJoint2 = (VSJoint)VSRevoluteJoint.copy$default((VSRevoluteJoint)vSRevoluteJoint, (Long)l, (VSJointPose)vSJointPose, (Long)mainId, (VSJointPose)new VSJointPose((Vector3dc)vector3d6, ((VSRevoluteJoint)joint).getPose1().getRot()), null, (double)0.0, null, null, null, null, null, (int)2032, null);
        } else if (vSJoint4 instanceof VSFixedJoint) {
            VSFixedJoint vSFixedJoint = (VSFixedJoint)joint;
            Long l = this.shiptraptionID;
            Vector3dc $this$minus$iv = ((VSFixedJoint)joint).getPose0().getPos();
            boolean $i$f$minus = false;
            Vector3d vector3d7 = $this$minus$iv.sub((Vector3dc)oldSPos, new Vector3d());
            Intrinsics.checkNotNullExpressionValue((Object)vector3d7, (String)"minus(...)");
            Vector3d $this$plus$iv = vector3d7;
            boolean $i$f$plus = false;
            Vector3d vector3d8 = $this$plus$iv.add((Vector3dc)newSPos, new Vector3d());
            Intrinsics.checkNotNullExpressionValue((Object)vector3d8, (String)"plus(...)");
            VSJointPose vSJointPose = new VSJointPose((Vector3dc)vector3d8, ((VSFixedJoint)joint).getPose0().getRot());
            $this$minus$iv = ((VSFixedJoint)joint).getPose1().getPos();
            $i$f$minus = false;
            Vector3d vector3d9 = $this$minus$iv.sub((Vector3dc)oldPos, new Vector3d());
            Intrinsics.checkNotNullExpressionValue((Object)vector3d9, (String)"minus(...)");
            $this$plus$iv = vector3d9;
            $i$f$plus = false;
            Vector3d vector3d10 = $this$plus$iv.add((Vector3dc)newPos, new Vector3d());
            Intrinsics.checkNotNullExpressionValue((Object)vector3d10, (String)"plus(...)");
            vSJoint2 = (VSJoint)VSFixedJoint.copy$default((VSFixedJoint)vSFixedJoint, (Long)l, (VSJointPose)vSJointPose, (Long)mainId, (VSJointPose)new VSJointPose((Vector3dc)vector3d10, ((VSFixedJoint)joint).getPose1().getRot()), null, (double)0.0, (int)48, null);
        } else {
            throw new AssertionError();
        }
        this.joint = vSJoint2;
        Vector3dc vector3dc = (Vector3dc)this.bearingAxis.get(new Vector3d());
        double d = Math.toRadians(this.targetAngle);
        float f = this.getRealisticAngularSpeed();
        ScrollOptionBehaviour<ContraptionController.LockedMode> scrollOptionBehaviour = this.movementMode;
        Intrinsics.checkNotNull(scrollOptionBehaviour);
        boolean bl = scrollOptionBehaviour.get() == ContraptionController.LockedMode.FOLLOW_ANGLE;
        Long l = mainId;
        long l2 = l != null ? l : -1L;
        VSJoint vSJoint5 = this.joint;
        if (vSJoint5 == null || (vSJoint5 = vSJoint5.getPose1()) == null || (vSJoint5 = vSJoint5.getPos()) == null || (vSJoint5 = vSJoint5.get(new Vector3d())) == null) {
            vSJoint5 = new Vector3d();
        }
        if ((vSJoint = this.joint) == null || (vSJoint = vSJoint.getPose0()) == null || (vSJoint = vSJoint.getPos()) == null || (vSJoint = vSJoint.get(new Vector3d())) == null) {
            vSJoint = new Vector3d();
        }
        this.controllerCreationData = new PhysBearingData(vector3dc, d, f, bl, this.aligning, l2, (Vector3d)vSJoint5, (Vector3d)vSJoint, 0.0, 256, null);
        this.tryMakeJoint();
    }

    protected void read(@NotNull CompoundTag tag, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        if (this.wasMoved) {
            super.read(tag, clientPacket);
            return;
        }
        float angleBefore = this.targetAngle;
        this.open = tag.m_128471_(ClockworkConstants.Nbt.INSTANCE.getOPEN());
        this.isRunning = tag.m_128471_(ClockworkConstants.Nbt.INSTANCE.getRUNNING());
        this.targetAngle = tag.m_128457_(ClockworkConstants.Nbt.INSTANCE.getANGLE());
        this.lastException = AssemblyException.read((CompoundTag)tag);
        if (tag.m_128441_(ClockworkConstants.Nbt.INSTANCE.getSHIPTRAPTION_ID())) {
            this.shiptraptionID = tag.m_128454_(ClockworkConstants.Nbt.INSTANCE.getSHIPTRAPTION_ID());
        }
        if (tag.m_128441_(ClockworkConstants.Nbt.INSTANCE.getORIGINAL_DIRECTION())) {
            this.originalDirection = (Direction)EntriesMappings.entries$0.get(tag.m_128451_(ClockworkConstants.Nbt.INSTANCE.getORIGINAL_DIRECTION()));
        }
        if (this.isRunning) {
            if (this.shiptraptionID == -1L) {
                this.clientAngleDiff = AngleHelper.getShortestAngleDiff((double)angleBefore, (double)this.targetAngle);
                this.targetAngle = angleBefore;
            }
        } else {
            this.shiptraptionID = -1L;
        }
        this.sequencedAngleLimit = tag.m_128457_(ClockworkConstants.Nbt.INSTANCE.getSEQUENCED_ANGLE_LIMIT());
        this.sequencedAngleProgress = tag.m_128457_(ClockworkConstants.Nbt.INSTANCE.getSEQUENCED_ANGLE_PROGRESS());
        Vector3d vector3d = ClockworkUtils.INSTANCE.getVector3d(tag, "bearingPos");
        Intrinsics.checkNotNull((Object)vector3d);
        this.bearingPos = vector3d;
        Vector3d vector3d2 = ClockworkUtils.INSTANCE.getVector3d(tag, "bearingAxis");
        Intrinsics.checkNotNull((Object)vector3d2);
        this.bearingAxis = vector3d2;
        this.aligning = tag.m_128471_("aligning");
        ObjectMapper mapper = VSJacksonUtil.INSTANCE.getDtoMapper();
        if (tag.m_128441_("constraint")) {
            VSJointAndId temp = (VSJointAndId)mapper.readValue(tag.m_128463_("constraint"), VSJointAndId.class);
            VSJoint vSJoint = temp.getJoint();
            Intrinsics.checkNotNull((Object)vSJoint, (String)"null cannot be cast to non-null type org.valkyrienskies.core.internal.joints.VSRevoluteJoint");
            this.joint = (VSJoint)((VSRevoluteJoint)vSJoint);
            this.jointID = temp.getJointId();
        } else if (tag.m_128441_("joint")) {
            this.joint = (VSJoint)mapper.readValue(tag.m_128463_("joint"), VSRevoluteJoint.class);
            this.jointID = tag.m_128451_("jointID");
        } else if (tag.m_128441_("fjoint")) {
            this.joint = (VSJoint)mapper.readValue(tag.m_128463_("fjoint"), VSFixedJoint.class);
            this.jointID = tag.m_128451_("jointID");
        }
        super.read(tag, clientPacket);
        if (clientPacket) {
            return;
        }
        this.loadingFn = arg_0 -> PhysBearingBlockEntity.read$lambda$1(this, tag, arg_0);
        Level level = this.f_58857_;
        ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
        if (serverLevel == null) {
            return;
        }
        ServerLevel level2 = serverLevel;
        Function1<? super ServerLevel, Unit> function1 = this.loadingFn;
        Intrinsics.checkNotNull(function1);
        function1.invoke((Object)level2);
        this.loadingFn = null;
    }

    public float getInterpolatedAngle(float partialTicks) {
        float partialTicks2 = partialTicks;
        if (this.isVirtual()) {
            return Mth.m_14179_((float)(partialTicks2 + 0.5f), (float)this.prevAngle, (float)this.targetAngle);
        }
        if (this.shiptraptionID == -1L || !this.isRunning) {
            partialTicks2 = 0.0f;
        }
        return Mth.m_14179_((float)partialTicks2, (float)this.targetAngle, (float)(this.targetAngle + this.getAngularSpeed()));
    }

    public final float getWingRotOffset() {
        return this.isRunning && this.open ? (float)((double)this.openProgressMax) : (this.isRunning ? (float)Mth.m_14139_((double)this.openProgress, (double)0.0, (double)this.openProgressMax) : (!this.isRunning && this.open ? (float)Mth.m_14139_((double)this.openProgress, (double)1.0, (double)this.openProgressMax) : 0.0f));
    }

    public final float getInterpolatedCoreAngle(float partialTicks) {
        this.previousCoreAngle = this.coreAngle;
        float f = this.coreAngle;
        this.coreAngle = f + 1.0f;
        if (this.coreAngle == 360.0f) {
            this.coreAngle = 0.0f;
        }
        return this.isVirtual() ? Mth.m_14179_((float)(partialTicks + 0.5f), (float)this.previousCoreAngle, (float)this.coreAngle) : Mth.m_14179_((float)partialTicks, (float)this.coreAngle, (float)(this.coreAngle + 4.0f));
    }

    public final float getAngularSpeed() {
        float speed = GeneratingKineticBlockEntity.convertToAngular((float)this.getSpeed());
        if (this.getSpeed() == 0.0f) {
            speed = 0.0f;
        }
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        if (level.f_46443_) {
            speed *= ServerSpeedProvider.get();
            speed += this.clientAngleDiff / 3.0f;
        }
        return speed;
    }

    private final Quaterniond getHingeRotation(Direction localDirection) {
        Quaterniond rotationQuaternion = switch (WhenMappings.$EnumSwitchMapping$0[localDirection.ordinal()]) {
            case 1 -> new Quaterniond();
            case 2 -> new Quaterniond(new AxisAngle4d(Math.PI, (Vector3dc)new Vector3d(1.0, 0.0, 0.0)));
            case 3 -> {
                Quaterniond var4_2 = new Quaterniond(new AxisAngle4d(Math.PI, (Vector3dc)new Vector3d(0.0, 1.0, 0.0))).mul((Quaterniondc)new Quaterniond(new AxisAngle4d(1.5707963267948966, (Vector3dc)new Vector3d(1.0, 0.0, 0.0)))).normalize();
                Intrinsics.checkNotNull((Object)var4_2);
                yield var4_2;
            }
            case 4 -> {
                Quaterniond var4_2 = new Quaterniond(new AxisAngle4d(1.5707963267948966, (Vector3dc)new Vector3d(0.0, 1.0, 0.0))).mul((Quaterniondc)new Quaterniond(new AxisAngle4d(1.5707963267948966, (Vector3dc)new Vector3d(1.0, 0.0, 0.0)))).normalize();
                Intrinsics.checkNotNull((Object)var4_2);
                yield var4_2;
            }
            case 5 -> {
                Quaterniond var4_2 = new Quaterniond(new AxisAngle4d(1.5707963267948966, (Vector3dc)new Vector3d(1.0, 0.0, 0.0))).normalize();
                Intrinsics.checkNotNull((Object)var4_2);
                yield var4_2;
            }
            case 6 -> {
                Quaterniond var4_2 = new Quaterniond(new AxisAngle4d(4.71238898038469, (Vector3dc)new Vector3d(0.0, 1.0, 0.0))).mul((Quaterniondc)new Quaterniond(new AxisAngle4d(1.5707963267948966, (Vector3dc)new Vector3d(1.0, 0.0, 0.0)))).normalize();
                Intrinsics.checkNotNull((Object)var4_2);
                yield var4_2;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
        Quaterniond quaterniond = rotationQuaternion.mul((Quaterniondc)new Quaterniond(new AxisAngle4d(Math.toRadians(90.0), 0.0, 0.0, 1.0)), new Quaterniond()).normalize();
        Intrinsics.checkNotNullExpressionValue((Object)quaterniond, (String)"normalize(...)");
        Quaterniond hingeOrientation = quaterniond;
        return hingeOrientation;
    }

    public final void tryMakeJoint() {
        VSJoint vSJoint = this.joint;
        if (vSJoint == null) {
            return;
        }
        VSJoint joint = vSJoint;
        String string = ValkyrienSkies.getDimensionId((Level)this.f_58857_);
        Intrinsics.checkNotNull((Object)string);
        ClockworkMod.physTickOnce(string, (Function3<? super PhysLevel, ? super Double, ? super Function0<Unit>, Unit>)((Function3)(arg_0, arg_1, arg_2) -> PhysBearingBlockEntity.tryMakeJoint$lambda$2(this, joint, arg_0, arg_1, arg_2)));
    }

    /*
     * WARNING - void declaration
     */
    private final void assemble() {
        LoadedServerShip loadedServerShip;
        LoadedServerShip rotInWorld;
        LoadedServerShip loadedServerShip2;
        LoadedServerShip posInWorld;
        Long shipOnID;
        ServerShip shiptraption;
        Vector3d bearingPos;
        Vector3d posInOwnerShip;
        LoadedServerShip shipOn;
        Vector3d axis;
        Direction direction;
        block16: {
            Vector3d $this$plus$iv;
            boolean $i$f$plus;
            Vector3dc other$iv;
            void $this$minus$iv;
            boolean $i$f$minus;
            LoadedServerShip loadedServerShip3;
            Vector3dc worldPos;
            block15: {
                Triple triple;
                void $this$plus$iv2;
                void $this$times$iv;
                void $this$plus$iv3;
                void $this$times$iv2;
                Level level = this.f_58857_;
                Intrinsics.checkNotNull((Object)level);
                if (!(level.m_8055_(this.f_58858_).m_60734_() instanceof BearingBlock)) {
                    return;
                }
                Level level2 = this.f_58857_;
                Intrinsics.checkNotNull((Object)level2, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                ServerLevel level3 = (ServerLevel)level2;
                Direction direction2 = this.originalDirection = (Direction)this.m_58900_().m_61143_((Property)BearingBlock.FACING);
                Intrinsics.checkNotNull((Object)direction2);
                direction = direction2;
                BlockPos attachPoint = this.f_58858_.m_121945_(direction);
                Vec3 vec3 = this.f_58858_.m_252807_();
                Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getCenter(...)");
                worldPos = (Vector3dc)VectorConversionsMCKt.toJOML((Vec3)vec3);
                Vec3i vec3i = direction.m_122436_();
                Intrinsics.checkNotNullExpressionValue((Object)vec3i, (String)"getNormal(...)");
                axis = VectorConversionsMCKt.toJOMLD((Vec3i)vec3i);
                BlockPos blockPos = this.f_58858_;
                Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"worldPosition");
                shipOn = VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)level3, (Vec3i)((Vec3i)blockPos));
                Vector3dc vector3dc = worldPos;
                Vector3d vector3d = axis;
                double other$iv22 = 0.5;
                boolean $i$f$times = false;
                Vector3d vector3d2 = $this$times$iv2.mul(other$iv22, new Vector3d());
                Intrinsics.checkNotNullExpressionValue((Object)vector3d2, (String)"times(...)");
                Vector3dc other$iv3 = (Vector3dc)vector3d2;
                boolean $i$f$plus2 = false;
                Vector3d startPos = $this$plus$iv3.add(other$iv3, new Vector3d());
                other$iv3 = worldPos;
                Vector3d other$iv22 = axis;
                double other$iv4 = 1.5;
                boolean $i$f$times2 = false;
                Vector3d vector3d3 = $this$times$iv.mul(other$iv4, new Vector3d());
                Intrinsics.checkNotNullExpressionValue((Object)vector3d3, (String)"times(...)");
                Vector3dc other$iv5 = (Vector3dc)vector3d3;
                boolean $i$f$plus3 = false;
                Vector3d endPos = $this$plus$iv2.add(other$iv5, new Vector3d());
                Level level4 = (Level)level3;
                LoadedServerShip loadedServerShip4 = shipOn;
                if (loadedServerShip4 == null || (loadedServerShip4 = loadedServerShip4.getTransform()) == null || (loadedServerShip4 = loadedServerShip4.getShipToWorld()) == null || (loadedServerShip4 = loadedServerShip4.transformPosition(startPos)) == null) {
                    loadedServerShip4 = startPos;
                }
                other$iv5 = loadedServerShip4;
                Intrinsics.checkNotNull((Object)other$iv5);
                Vec3 vec32 = VectorConversionsMCKt.toMinecraft((Vector3dc)other$iv5);
                LoadedServerShip loadedServerShip5 = shipOn;
                if (loadedServerShip5 == null || (loadedServerShip5 = loadedServerShip5.getTransform()) == null || (loadedServerShip5 = loadedServerShip5.getShipToWorld()) == null || (loadedServerShip5 = loadedServerShip5.transformPosition(endPos)) == null) {
                    loadedServerShip5 = endPos;
                }
                other$iv5 = loadedServerShip5;
                Intrinsics.checkNotNull((Object)other$iv5);
                LoadedServerShip loadedServerShip6 = shipOn;
                BlockHitResult otherPos = RaycastUtilsKt.clipIncludeShips$default((Level)level4, (ClipContext)new ClipContext(vec32, VectorConversionsMCKt.toMinecraft((Vector3dc)other$iv5), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null), (boolean)false, (Long)(loadedServerShip6 != null ? Long.valueOf(loadedServerShip6.getId()) : null), (boolean)false, (int)8, null);
                BlockPos blockPos2 = otherPos.m_82425_();
                Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"getBlockPos(...)");
                LoadedServerShip otherShip = VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)level3, (Vec3i)((Vec3i)blockPos2));
                posInOwnerShip = new Vector3d(worldPos);
                if (otherShip == null) {
                    selection = null;
                    try {
                        Level level5 = (Level)level3;
                        Intrinsics.checkNotNull((Object)attachPoint);
                        DenseBlockPosSet denseBlockPosSet = selection = GlueAssembler.INSTANCE.collectGlued(level5, attachPoint);
                        if (denseBlockPosSet != null) {
                            denseBlockPosSet.remove(this.m_58899_().m_123341_(), this.m_58899_().m_123342_(), this.m_58899_().m_123343_());
                        }
                        this.lastException = null;
                    }
                    catch (AssemblyException e) {
                        this.lastException = e;
                        this.sendData();
                        return;
                    }
                    if (selection == null) {
                        return;
                    }
                    e = PhysBearingAssembler.assembleToShip(level3, selection, true, 1.0, true);
                    ServerShip shiptraption2 = ((Return)e).component1();
                    Vector3ic previousCenterBP = ((Return)e).component2();
                    Vector3d newCenter = ((Return)e).component3();
                    Vector3d previousCenter = new Vector3d(previousCenterBP);
                    this.shiptraptionID = shiptraption2.getId();
                    triple = new Triple((Object)new Vector3d(worldPos).sub((Vector3dc)previousCenter).add((Vector3dc)newCenter), (Object)shiptraption2, (Object)direction);
                } else {
                    void $this$minus$iv2;
                    void $this$plus$iv4;
                    this.shiptraptionID = otherShip.getId();
                    BlockPos blockPos3 = otherPos.m_82425_();
                    Intrinsics.checkNotNullExpressionValue((Object)blockPos3, (String)"getBlockPos(...)");
                    e = KelvinExtensions.INSTANCE.toVector3d(blockPos3);
                    double other$iv6 = 0.5;
                    boolean $i$f$plus4 = false;
                    Vector3d vector3d4 = $this$plus$iv4.add((Vector3dc)new Vector3d(other$iv6, other$iv6, other$iv6), new Vector3d());
                    Intrinsics.checkNotNullExpressionValue((Object)vector3d4, (String)"plus(...)");
                    selection = vector3d4;
                    Vec3i vec3i2 = direction.m_122436_();
                    Intrinsics.checkNotNullExpressionValue((Object)vec3i2, (String)"getNormal(...)");
                    Vector3dc other$iv7 = (Vector3dc)VectorConversionsMCKt.toJOMLD((Vec3i)vec3i2);
                    boolean $i$f$minus2 = false;
                    Triple triple2 = new Triple((Object)$this$minus$iv2.sub(other$iv7, new Vector3d()), (Object)otherShip, (Object)otherPos.m_82434_());
                    triple = triple2;
                }
                Triple triple3 = triple;
                bearingPos = (Vector3d)triple3.component1();
                shiptraption = (ServerShip)triple3.component2();
                Direction otherDirection = (Direction)triple3.component3();
                ClockworkSounds.SoundEntry soundEntry = ClockworkSounds.INSTANCE.getPHYSICS_INFUSER_LIGHTNING();
                Level level6 = (Level)level3;
                BlockPos blockPos4 = this.f_58858_;
                Intrinsics.checkNotNullExpressionValue((Object)blockPos4, (String)"worldPosition");
                ClockworkSounds.SoundEntry.playOnServer$default(soundEntry, level6, (Vec3i)blockPos4, 0.0f, 0.0f, 12, null);
                LoadedServerShip loadedServerShip7 = shipOn;
                shipOnID = loadedServerShip7 != null ? Long.valueOf(loadedServerShip7.getId()) : null;
                loadedServerShip3 = shipOn;
                if (loadedServerShip3 == null || (loadedServerShip3 = loadedServerShip3.getTransform()) == null || (loadedServerShip3 = loadedServerShip3.getShipToWorld()) == null) break block15;
                Vector3d vector3d5 = posInOwnerShip;
                Intrinsics.checkNotNull((Object)bearingPos);
                Vector3dc other$iv8 = (Vector3dc)bearingPos;
                $i$f$minus = false;
                Vector3d vector3d6 = $this$minus$iv.sub(other$iv8, new Vector3d());
                Intrinsics.checkNotNullExpressionValue((Object)vector3d6, (String)"minus(...)");
                Vector3d vector3d7 = vector3d6;
                other$iv = shiptraption.getInertiaData().getCenterOfMass();
                $i$f$plus = false;
                if ((loadedServerShip3 = loadedServerShip3.transformPosition((Vector3dc)$this$plus$iv.add(other$iv, new Vector3d()), new Vector3d())) != null) break block16;
            }
            other$iv = worldPos;
            Intrinsics.checkNotNull((Object)bearingPos);
            Vector3dc other$iv9 = (Vector3dc)bearingPos;
            $i$f$minus = false;
            Vector3d vector3d = $this$minus$iv.sub(other$iv9, new Vector3d());
            Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"minus(...)");
            $this$plus$iv = vector3d;
            other$iv = shiptraption.getInertiaData().getCenterOfMass();
            $i$f$plus = false;
            loadedServerShip3 = posInWorld = $this$plus$iv.add(other$iv, new Vector3d());
        }
        if ((loadedServerShip2 = shipOn) == null || (loadedServerShip2 = loadedServerShip2.getTransform()) == null || (loadedServerShip2 = loadedServerShip2.getShipToWorldRotation()) == null) {
            loadedServerShip2 = rotInWorld = (Quaterniondc)new Quaterniond();
        }
        if ((loadedServerShip = shipOn) == null || (loadedServerShip = loadedServerShip.getTransform()) == null || (loadedServerShip = loadedServerShip.getShipToWorldScaling()) == null) {
            loadedServerShip = (Vector3dc)new Vector3d(1.0, 1.0, 1.0);
        }
        LoadedServerShip scaling = loadedServerShip;
        Intrinsics.checkNotNull((Object)posInWorld);
        shiptraption.unsafeSetTransform((BodyTransform)BodyTransformFactory.INSTANCE.create((Vector3dc)posInWorld, (Quaterniondc)rotInWorld, (Vector3dc)scaling, shiptraption.getTransform().getPositionInModel()));
        Quaterniond ship1rot = this.getHingeRotation(direction);
        Quaterniond ship2rot = this.getHingeRotation(direction);
        double extraDist = 1.0;
        Long l = this.shiptraptionID;
        Vector3d vector3d = bearingPos.fma(-extraDist, (Vector3dc)axis, new Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"fma(...)");
        VSJointPose vSJointPose = new VSJointPose((Vector3dc)vector3d, (Quaterniondc)ship1rot);
        Vector3d vector3d8 = posInOwnerShip.fma(-extraDist, (Vector3dc)axis, new Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d8, (String)"fma(...)");
        this.joint = (VSJoint)new VSRevoluteJoint(l, vSJointPose, shipOnID, new VSJointPose((Vector3dc)vector3d8, (Quaterniondc)ship2rot), null, 1.0E-100, null, null, null, null, Boolean.valueOf(true), 976, null);
        this.bearingAxis = axis;
        this.bearingPos = bearingPos;
        Vector3dc vector3dc = (Vector3dc)this.bearingAxis.get(new Vector3d());
        double d = Math.toRadians(this.targetAngle);
        float f = this.getRealisticAngularSpeed();
        ScrollOptionBehaviour<ContraptionController.LockedMode> scrollOptionBehaviour = this.movementMode;
        Intrinsics.checkNotNull(scrollOptionBehaviour);
        boolean bl = scrollOptionBehaviour.get() == ContraptionController.LockedMode.FOLLOW_ANGLE;
        Long l2 = shipOnID;
        long l3 = l2 != null ? l2 : -1L;
        VSJoint vSJoint = this.joint;
        Intrinsics.checkNotNull((Object)vSJoint);
        Vector3d vector3d9 = vSJoint.getPose1().getPos().get(new Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d9, (String)"get(...)");
        VSJoint vSJoint2 = this.joint;
        Intrinsics.checkNotNull((Object)vSJoint2);
        Vector3d vector3d10 = vSJoint2.getPose0().getPos().get(new Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d10, (String)"get(...)");
        this.controllerCreationData = new PhysBearingData(vector3dc, d, f, bl, this.aligning, l3, vector3d9, vector3d10, 0.0, 256, null);
        this.tryMakeJoint();
        this.sendData();
        this.updateGeneratedRotation();
    }

    public void destroy() {
        block3: {
            Level level = this.f_58857_;
            if (level == null) {
                return;
            }
            Level level2 = level;
            if (level2.f_46443_ || !(level2 instanceof ServerLevel)) {
                return;
            }
            LoadedServerShip loadedServerShip = (LoadedServerShip)VSGameUtilsKt.getShipObjectWorld((ServerLevel)((ServerLevel)level2)).getLoadedShips().getById(this.shiptraptionID);
            if (loadedServerShip == null) {
                return;
            }
            LoadedServerShip ship = loadedServerShip;
            BearingController bearingController = BearingController.Companion.getOrCreate(ship);
            Intrinsics.checkNotNull((Object)bearingController);
            bearingController.removePhysBearing(this.bearingID);
            VSJoint vSJoint = this.joint;
            if (vSJoint == null) break block3;
            VSJoint it = vSJoint;
            boolean bl = false;
            GetGTFAKt.getGtpa((ServerLevel)level2).removeJoint(this.jointID);
        }
    }

    public final void disassemble() {
        if (!this.isRunning && this.shiptraptionID == -1L) {
            return;
        }
        if (this.ticks - this.lastStateChanged <= this.cooldown) {
            return;
        }
        this.targetAngle = 0.0f;
        if (this.shiptraptionID == -1L) {
            return;
        }
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        ServerLevel level2 = (ServerLevel)level;
        LoadedServerShip loadedServerShip = (LoadedServerShip)VSGameUtilsKt.getShipObjectWorld((ServerLevel)level2).getLoadedShips().getById(this.shiptraptionID);
        if (loadedServerShip == null) {
            this.resetState();
            return;
        }
        LoadedServerShip ship = loadedServerShip;
        ServerShip serverShip = (ServerShip)ship;
        BlockPos blockPos = this.f_58858_;
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"worldPosition");
        if (!org.valkyrienskies.clockwork.content.contraptions.phys.bearing.PhysBearingBlockEntity$Companion.canDisassemble$default(Companion, this.bearingAxis, serverShip, (ServerShip)VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)level2, (Vec3i)((Vec3i)blockPos)), 0, 8, null)) {
            this.disassembleWhenPossible = !this.disassembleWhenPossible;
            this.aligning = !this.aligning;
            BearingController bearingController = BearingController.Companion.getOrCreate(ship);
            Intrinsics.checkNotNull((Object)bearingController);
            PhysBearingData physBearingData = bearingController.getBearingData().get(this.bearingID);
            if (physBearingData != null) {
                PhysBearingData it = physBearingData;
                boolean bl = false;
                it.setAligning(this.aligning);
            }
        } else {
            this.shipDisassemble();
        }
        AllSoundEvents.CONTRAPTION_DISASSEMBLE.playOnServer((Level)level2, (Vec3i)this.f_58858_);
    }

    /*
     * Unable to fully structure code
     */
    private final void shipDisassemble() {
        block23: {
            block22: {
                if (this.shiptraptionID == -1L) break block22;
                v0 = this.f_58857_;
                Intrinsics.checkNotNull((Object)v0);
                if (!v0.f_46443_) break block23;
            }
            return;
        }
        v1 = this.f_58857_;
        Intrinsics.checkNotNull((Object)v1, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        level = (ServerLevel)v1;
        v2 = (LoadedServerShip)VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getLoadedShips().getById(this.shiptraptionID);
        if (v2 == null) {
            return;
        }
        subShip = v2;
        v3 = this.f_58858_;
        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"worldPosition");
        mainShip = VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)level, (Vec3i)((Vec3i)v3));
        if (!org.valkyrienskies.clockwork.content.contraptions.phys.bearing.PhysBearingBlockEntity$Companion.canDisassemble$default(PhysBearingBlockEntity.Companion, this.bearingAxis, (ServerShip)subShip, (ServerShip)mainShip, 0, 8, null)) {
            return;
        }
        v4 = this.originalDirection;
        if (v4 == null) {
            v4 = (Direction)this.m_58900_().m_61143_((Property)BearingBlock.FACING);
        }
        direction = v4;
        inMain = this.f_58858_.m_5484_(direction, 1);
        inSubship = this.bearingPos.add((Vector3dc)this.bearingAxis, new Vector3d());
        v5 = subShip.getShipAABB();
        Intrinsics.checkNotNull((Object)v5);
        aabb = v5;
        blocks = new DenseBlockPosSet();
        var10_10 = aabb.maxX() + 1;
        for (x = aabb.minX() - 1; x < var10_10; ++x) {
            var12_14 = aabb.maxZ() + 1;
            for (z = aabb.minZ() - 1; z < var12_14; ++z) {
                var14_22 = aabb.maxY() + 1;
                for (y = aabb.minY() - 1; y < var14_22; ++y) {
                    blocks.add(x, y, z);
                }
            }
        }
        $this$getAttachment$iv = (AttachmentHolder)subShip;
        $i$f$getAttachment = false;
        v6 = (SplittingDisablerAttachment)$this$getAttachment$iv.getAttachment(SplittingDisablerAttachment.class);
        if (v6 != null) {
            it = v6;
            $i$a$-let-PhysBearingBlockEntity$shipDisassemble$subCouldSplit$1 = false;
            if (it.canSplit()) {
                it.disableSplitting();
                v7 = true;
            } else {
                v7 = false;
            }
        } else {
            v7 = subCouldSplit = false;
        }
        if ((v8 = mainShip) == null) ** GOTO lbl-1000
        $this$getAttachment$iv = (AttachmentHolder)v8;
        $i$f$getAttachment = false;
        v8 = (SplittingDisablerAttachment)$this$getAttachment$iv.getAttachment(SplittingDisablerAttachment.class);
        if (v8 != null) {
            it = v8;
            $i$a$-let-PhysBearingBlockEntity$shipDisassemble$mainCouldSplit$1 = false;
            if (it.canSplit()) {
                it.disableSplitting();
                v9 = true;
            } else {
                v9 = false;
            }
        } else lbl-1000:
        // 2 sources

        {
            v9 = false;
        }
        mainCouldSplit = v9;
        Intrinsics.checkNotNull((Object)inSubship);
        v10 = BlockPos.m_274446_((Position)((Position)VectorConversionsMCKt.toMinecraft((Vector3dc)((Vector3dc)inSubship))));
        Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"containing(...)");
        Intrinsics.checkNotNull((Object)inMain);
        hasMoved = PhysBearingAssembler.moveBlocksFromTo(level, blocks, true, v10, inMain);
        if (subCouldSplit) {
            $this$getAttachment$iv = (AttachmentHolder)subShip;
            $i$f$getAttachment = false;
            v11 = (SplittingDisablerAttachment)$this$getAttachment$iv.getAttachment(SplittingDisablerAttachment.class);
            if (v11 != null) {
                v11.enableSplitting();
            }
        }
        if (mainCouldSplit && (v12 = mainShip) != null) {
            $this$getAttachment$iv = (AttachmentHolder)v12;
            $i$f$getAttachment = false;
            v12 = (SplittingDisablerAttachment)$this$getAttachment$iv.getAttachment(SplittingDisablerAttachment.class);
            if (v12 != null) {
                v12.enableSplitting();
            }
        }
        if (!hasMoved) {
            this.aligning = false;
            this.assembleNextTick = false;
            this.disassembleWhenPossible = false;
            return;
        }
        v13 = BearingController.Companion.getOrCreate(subShip);
        Intrinsics.checkNotNull((Object)v13);
        v13.removePhysBearing(this.bearingID);
        this.lastStateChanged = this.ticks;
        this.resetState();
    }

    private final void resetState() {
        this.bearingID = -1;
        this.shiptraptionID = -1L;
        this.isRunning = false;
        this.updateGeneratedRotation();
        this.assembleNextTick = false;
        this.disassembleWhenPossible = false;
        this.sequencedAngleLimit = -1.0f;
        this.sequencedAngleProgress = 0.0f;
        this.targetAngle = 0.0f;
        this.sendData();
        this.jointID = -1;
        this.aligning = false;
        this.sDir1 = null;
        this.sDir2 = null;
        this.pTick = 0;
        this.lastAngle = 0.0f;
        this.curAngle = 0.0f;
    }

    private final void tryAssembleNextTick() {
        if (!this.assembleNextTick) {
            return;
        }
        if (this.ticks - this.lastStateChanged <= this.cooldown) {
            return;
        }
        this.assembleNextTick = false;
        if (!this.isRunning) {
            this.assemble();
        }
    }

    private final void tryUpdateData() {
        if (this.shiptraptionID == -1L) {
            return;
        }
        if (this.lastSpeed == this.getSpeed()) {
            ScrollOptionBehaviour<ContraptionController.LockedMode> scrollOptionBehaviour = this.movementMode;
            if (this.lastMode == (scrollOptionBehaviour != null ? (ContraptionController.LockedMode)scrollOptionBehaviour.get() : null)) {
                ScrollOptionBehaviour<ContraptionController.LockedMode> scrollOptionBehaviour2 = this.movementMode;
                Intrinsics.checkNotNull(scrollOptionBehaviour2);
                if (scrollOptionBehaviour2.get() != ContraptionController.LockedMode.FOLLOW_ANGLE && !this.aligning) {
                    return;
                }
            }
        }
        ScrollOptionBehaviour<ContraptionController.LockedMode> scrollOptionBehaviour = this.movementMode;
        if (this.lastMode != (scrollOptionBehaviour != null ? (ContraptionController.LockedMode)scrollOptionBehaviour.get() : null)) {
            ScrollOptionBehaviour<ContraptionController.LockedMode> scrollOptionBehaviour3 = this.movementMode;
            if ((scrollOptionBehaviour3 != null ? (ContraptionController.LockedMode)scrollOptionBehaviour3.get() : null) == ContraptionController.LockedMode.FOLLOW_ANGLE) {
                Level level = this.f_58857_;
                Intrinsics.checkNotNull((Object)level);
                BlockPos blockPos = this.m_58899_();
                Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
                LoadedShip loadedShip = VSGameUtilsKt.getShipObjectManagingPos((Level)level, (Vec3i)((Vec3i)blockPos));
                ShipTransform shipOn = loadedShip != null ? loadedShip.getTransform() : null;
                Level level2 = this.f_58857_;
                Intrinsics.checkNotNull((Object)level2);
                Ship ship = VSGameUtilsKt.getShipObjectWorld((Level)level2).getAllShips().getById(this.shiptraptionID);
                if (ship == null || (ship = ship.getTransform()) == null) {
                    return;
                }
                Ship shiptraption = ship;
                this.targetAngle = (float)Math.toDegrees(BearingController.Companion.getAngle((Vector3dc)this.bearingAxis, (ShipTransform)shiptraption, shipOn));
            }
        }
        this.lastSpeed = this.getSpeed();
        ScrollOptionBehaviour<ContraptionController.LockedMode> scrollOptionBehaviour4 = this.movementMode;
        Intrinsics.checkNotNull(scrollOptionBehaviour4);
        this.lastMode = (ContraptionController.LockedMode)scrollOptionBehaviour4.get();
        float realSpeed = Math.abs(this.getSpeed()) > 0.0f ? this.getRealisticAngularSpeed() : 0.0f;
        VSRevoluteJoint.VSRevoluteDriveVelocity newDriveVelocity = !(realSpeed == 0.0f) ? new VSRevoluteJoint.VSRevoluteDriveVelocity(this.getRealisticAngularSpeed(), true) : null;
        this.updateDrive(newDriveVelocity);
    }

    private final void tickAnimationLogic() {
        if (this.inOutCorner < 1.0f && !this.cornerShrinking) {
            this.inOutCorner += 0.0075f;
        } else if (this.inOutCorner >= 1.0f) {
            this.cornerShrinking = true;
        }
        if (this.inOutCorner > 0.0f && this.cornerShrinking) {
            this.inOutCorner -= 0.0075f;
        } else if (this.inOutCorner <= 0.0f) {
            this.cornerShrinking = false;
        }
        if (this.isRunning && !this.open && !this.opening) {
            this.opening = true;
        }
        if (this.opening && this.isRunning && this.openProgress < 1.0f) {
            this.openProgress += 0.05f;
        } else if (this.openProgress >= 1.0f) {
            this.opening = false;
            this.open = true;
            this.openProgress = 1.0f;
        }
        if (this.open && !this.isRunning && this.openProgress > 0.0f) {
            this.openProgress -= 0.05f;
        } else if (this.openProgress <= 0.0f) {
            this.open = false;
            this.openProgress = 0.0f;
        }
    }

    public final float getActualAngularSpeed() {
        Direction direction = this.originalDirection;
        Intrinsics.checkNotNull((Object)direction);
        Direction dir = direction;
        return GeneratingKineticBlockEntity.convertToAngular((float)this.getSpeed()) * (float)(dir == Direction.WEST || dir == Direction.NORTH || dir == Direction.DOWN ? 1 : -1);
    }

    public final float getRealisticAngularSpeed() {
        Direction direction = this.originalDirection;
        Intrinsics.checkNotNull((Object)direction);
        Direction dir = direction;
        return this.getSpeed() * 2.0f * (float)Math.PI / 60.0f * (float)(dir == Direction.WEST || dir == Direction.NORTH || dir == Direction.DOWN ? 1 : -1);
    }

    public void tick() {
        super.tick();
        this.prevAngle = this.targetAngle;
        int n = this.ticks;
        this.ticks = n + 1;
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        if (level.f_46443_) {
            this.clientAngleDiff /= 2.0f;
        }
        Level level2 = this.f_58857_;
        Intrinsics.checkNotNull((Object)level2);
        if (!level2.f_46443_) {
            Object it;
            Function1<? super ServerLevel, Unit> function1 = this.loadingFn;
            if (function1 != null) {
                Function1<? super ServerLevel, Unit> function12;
                it = function12 = function1;
                boolean bl = false;
                Level level3 = this.f_58857_;
                Intrinsics.checkNotNull((Object)level3, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                it.invoke((Object)((ServerLevel)level3));
                this.loadingFn = null;
            }
            Level level4 = this.f_58857_;
            Intrinsics.checkNotNull((Object)level4, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            LoadedServerShip subShip = (LoadedServerShip)VSGameUtilsKt.getShipObjectWorld((ServerLevel)((ServerLevel)level4)).getLoadedShips().getById(this.shiptraptionID);
            PhysBearingData physBearingData = this.controllerCreationData;
            if (physBearingData != null) {
                Object it2 = it = physBearingData;
                boolean bl = false;
                LoadedServerShip loadedServerShip = subShip;
                if (loadedServerShip != null) {
                    BearingController bearingController = BearingController.Companion.getOrCreate(loadedServerShip);
                    Intrinsics.checkNotNull((Object)bearingController);
                    this.bearingID = bearingController.addPhysBearing((PhysBearingData)it2);
                    this.controllerCreationData = null;
                }
            }
            PhysBearingUpdateData physBearingUpdateData = this.controllerUpdateData;
            if (physBearingUpdateData != null) {
                Object it3 = it = physBearingUpdateData;
                boolean bl = false;
                LoadedServerShip loadedServerShip = subShip;
                if (loadedServerShip != null) {
                    BearingController bearingController = BearingController.Companion.getOrCreate(loadedServerShip);
                    Intrinsics.checkNotNull((Object)bearingController);
                    bearingController.updatePhysBearing(this.bearingID, (PhysBearingUpdateData)it3);
                    this.controllerUpdateData = null;
                }
            }
            this.tryAssembleNextTick();
            if (this.disassembleWhenPossible) {
                this.shipDisassemble();
            }
        }
        this.tickAnimationLogic();
        if (!this.isRunning) {
            return;
        }
        if (this.shiptraptionID == -1L) {
            this.targetAngle = 0.0f;
        } else if (this.joint != null && this.jointID != -1) {
            float newAngle;
            float angularSpeed = -this.getActualAngularSpeed();
            float diff = 0.0f;
            if (this.sequencedAngleLimit >= 0.0f) {
                float sequencedAngleLimit = this.sequencedAngleLimit * Math.signum(angularSpeed);
                this.sequencedAngleProgress += angularSpeed;
                if (angularSpeed > 0.0f && this.sequencedAngleProgress > sequencedAngleLimit || angularSpeed < 0.0f && this.sequencedAngleProgress < sequencedAngleLimit) {
                    diff = this.sequencedAngleProgress - sequencedAngleLimit;
                    this.sequencedAngleProgress = sequencedAngleLimit;
                }
            }
            float f = (newAngle = this.targetAngle + angularSpeed - diff) >= 360.0f ? this.lastAngle - 360.0f : (this.lastAngle = newAngle < 0.0f ? this.lastAngle + 360.0f : this.lastAngle);
            float f2 = newAngle >= 360.0f ? this.curAngle - 360.0f : (this.curAngle = newAngle < 0.0f ? this.curAngle + 360.0f : this.curAngle);
            this.targetAngle = newAngle >= 360.0f ? newAngle - 360.0f : (newAngle < 0.0f ? newAngle + 360.0f : newAngle);
        }
        Level level5 = this.f_58857_;
        Intrinsics.checkNotNull((Object)level5);
        if (!level5.f_46443_) {
            this.tryUpdateData();
        }
    }

    public void onSpeedChanged(float previousSpeed) {
        this.sequencedAngleLimit = -1.0f;
        this.sequencedAngleProgress = 0.0f;
        if (this.sequenceContext != null && this.sequenceContext.instruction() == SequencerInstructions.TURN_ANGLE) {
            this.sequencedAngleLimit = (float)this.sequenceContext.getEffectiveValue((double)this.getTheoreticalSpeed());
        }
        if (this.f_58857_ != null) {
            Level level = this.f_58857_;
            Intrinsics.checkNotNull((Object)level);
            if (!level.f_46443_ && this.joint != null) {
                this.lastSpeed = this.getSpeed();
                float realSpeed = Math.abs(this.getSpeed()) > 0.0f ? this.getRealisticAngularSpeed() : 0.0f;
                VSRevoluteJoint.VSRevoluteDriveVelocity newDriveVelocity = !(realSpeed == 0.0f) ? new VSRevoluteJoint.VSRevoluteDriveVelocity(this.getRealisticAngularSpeed(), true) : new VSRevoluteJoint.VSRevoluteDriveVelocity(0.0f, true);
                this.updateDrive(newDriveVelocity);
            }
        }
        super.onSpeedChanged(previousSpeed);
    }

    public void lazyTick() {
        super.lazyTick();
        if (this.shiptraptionID != -1L) {
            Level level = this.f_58857_;
            Intrinsics.checkNotNull((Object)level);
            if (!level.f_46443_) {
                this.sendData();
            }
        }
    }

    public boolean addToTooltip(@NotNull List<? extends Component> tooltip, boolean isPlayerSneaking) {
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        if (super.addToTooltip(tooltip, isPlayerSneaking)) {
            return true;
        }
        if (isPlayerSneaking) {
            return false;
        }
        if (this.getSpeed() == 0.0f) {
            return false;
        }
        if (this.isRunning) {
            return false;
        }
        if (!(this.m_58900_().m_60734_() instanceof BearingBlock)) {
            return false;
        }
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        BlockState attachedState = level.m_8055_(this.f_58858_.m_121945_((Direction)this.m_58900_().m_61143_((Property)BearingBlock.FACING)));
        if (attachedState.m_247087_()) {
            return false;
        }
        TooltipHelper.addHint(tooltip, (String)"hint.empty_bearing", (Object[])new Object[0]);
        return true;
    }

    @Nullable
    public final Double getActualAngle() {
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        ServerLevel level2 = (ServerLevel)level;
        LoadedServerShip loadedServerShip = (LoadedServerShip)VSGameUtilsKt.getShipObjectWorld((ServerLevel)level2).getLoadedShips().getById(this.shiptraptionID);
        if (loadedServerShip == null) {
            return null;
        }
        LoadedServerShip shiptraption = loadedServerShip;
        BlockPos blockPos = this.f_58858_;
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"worldPosition");
        ServerShip mainShip = VSGameUtilsKt.getShipManagingPos((ServerLevel)level2, (BlockPos)blockPos);
        ServerShip serverShip = mainShip;
        return BearingController.Companion.getAngle((Vector3dc)this.bearingAxis, shiptraption.getTransform(), (ShipTransform)(serverShip != null ? serverShip.getTransform() : null));
    }

    public void attach(@NotNull ControlledContraptionEntity contraption) {
        Intrinsics.checkNotNullParameter((Object)contraption, (String)"contraption");
    }

    public void onStall() {
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        if (!level.f_46443_) {
            this.sendData();
        }
    }

    public boolean isValid() {
        return !this.m_58901_();
    }

    public boolean isAttachedTo(@NotNull AbstractContraptionEntity contraption) {
        Intrinsics.checkNotNullParameter((Object)contraption, (String)"contraption");
        return false;
    }

    public void setAngle(float forcedAngle) {
        this.targetAngle = forcedAngle;
    }

    @Nullable
    public AssemblyException getLastAssemblyException() {
        return this.lastException;
    }

    @NotNull
    public BlockPos getBlockPosition() {
        BlockPos blockPos = this.f_58858_;
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"worldPosition");
        return blockPos;
    }

    public boolean isWoodenTop() {
        return false;
    }

    private static final void addBehaviours$lambda$0(PhysBearingBlockEntity this$0, Integer it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)it);
        this$0.movementModeChanged(it);
    }

    private static final Unit read$lambda$1(PhysBearingBlockEntity this$0, CompoundTag $tag, ServerLevel level) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$tag, (String)"$tag");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        this$0.loadTheRest($tag, level);
        return Unit.INSTANCE;
    }

    private static final Unit tryMakeJoint$lambda$2(PhysBearingBlockEntity this$0, VSJoint $joint, PhysLevel level, double d, Function0 tryNextTick) {
        int id;
        block7: {
            block6: {
                block5: {
                    Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                    Intrinsics.checkNotNullParameter((Object)$joint, (String)"$joint");
                    Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                    Intrinsics.checkNotNullParameter((Object)tryNextTick, (String)"tryNextTick");
                    VsiPhysLevel cfr_ignored_0 = (VsiPhysLevel)level;
                    VSJoint existing = ((VsiPhysLevel)level).getJointById(this$0.jointID);
                    if (existing != null && Intrinsics.areEqual((Object)existing, (Object)$joint)) {
                        this$0.isRunning = true;
                        return Unit.INSTANCE;
                    }
                    if ($joint.getShipId0() == null) break block5;
                    Long l = $joint.getShipId0();
                    Intrinsics.checkNotNull((Object)l);
                    if (level.getShipById(l.longValue()) == null) break block6;
                }
                if ($joint.getShipId1() == null) break block7;
                Long l = $joint.getShipId1();
                Intrinsics.checkNotNull((Object)l);
                if (level.getShipById(l.longValue()) != null) break block7;
            }
            tryNextTick.invoke();
            return Unit.INSTANCE;
        }
        if ((id = ((VsiPhysLevel)level).addJoint($joint)) == -1) {
            tryNextTick.invoke();
            return Unit.INSTANCE;
        }
        this$0.jointID = id;
        this$0.isRunning = true;
        this$0.targetAngle = 0.0f;
        this$0.lastStateChanged = this$0.ticks;
        return Unit.INSTANCE;
    }

    @JvmStatic
    public static final boolean canDisassemble(@NotNull Vector3d bearingAxis, @NotNull ServerShip mainShip, @Nullable ServerShip otherShip, int tolerance) {
        return Companion.canDisassemble(bearingAxis, mainShip, otherShip, tolerance);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J3\u0010\n\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u0010\b\u001a\u00020\u0007H\u0007\u00a2\u0006\u0004\b\n\u0010\u000bR\u0014\u0010\r\u001a\u00020\f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000e\u00a8\u0006\u0011"}, d2={"Lorg/valkyrienskies/clockwork/content/contraptions/phys/bearing/PhysBearingBlockEntity$Companion;", "", "Lorg/joml/Vector3d;", "bearingAxis", "Lorg/valkyrienskies/core/api/ships/ServerShip;", "mainShip", "otherShip", "", "tolerance", "", "canDisassemble", "(Lorg/joml/Vector3d;Lorg/valkyrienskies/core/api/ships/ServerShip;Lorg/valkyrienskies/core/api/ships/ServerShip;I)Z", "", "NO_SHIPTRAPTION_ID", "J", "<init>", "()V", "clockwork"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean canDisassemble(@NotNull Vector3d bearingAxis, @NotNull ServerShip mainShip, @Nullable ServerShip otherShip, int tolerance) {
            Intrinsics.checkNotNullParameter((Object)bearingAxis, (String)"bearingAxis");
            Intrinsics.checkNotNullParameter((Object)mainShip, (String)"mainShip");
            Vector3dc vector3dc = (Vector3dc)bearingAxis;
            ShipTransform shipTransform = mainShip.getTransform();
            ServerShip serverShip = otherShip;
            Object object = serverShip != null ? serverShip.getTransform() : null;
            return !(Math.abs(Math.toDegrees(BearingController.Companion.getAngle(vector3dc, shipTransform, (ShipTransform)object))) > (double)tolerance);
        }

        public static /* synthetic */ boolean canDisassemble$default(Companion companion, Vector3d vector3d, ServerShip serverShip, ServerShip serverShip2, int n, int n2, Object object) {
            if ((n2 & 8) != 0) {
                n = 5;
            }
            return companion.canDisassemble(vector3d, serverShip, serverShip2, n);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<Direction> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])Direction.values()));
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.UP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.DOWN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.NORTH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.EAST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.SOUTH.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.WEST.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

