/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.contraptions.flap.smart_flap;

import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.valkyrienskies.clockwork.content.contraptions.flap.FlapBearingBlockEntity;
import org.valkyrienskies.clockwork.content.contraptions.flap.dual_link.DualLinkBehaviour;
import org.valkyrienskies.clockwork.content.contraptions.flap.dual_link.FlapBearingFrequencySlot;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B%\u0012\f\u0010\u001d\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001c\u0012\u0006\u0010\u001f\u001a\u00020\u001e\u0012\u0006\u0010!\u001a\u00020 \u00a2\u0006\u0004\b\"\u0010#J\u000f\u0010\u0003\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001d\u0010\t\u001a\u00020\b2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u000b\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\u000e\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0010\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0010\u0010\u000fR\"\u0010\u0011\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0004\"\u0004\b\u0014\u0010\u000fR\"\u0010\u0015\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\u0012\u001a\u0004\b\u0016\u0010\u0004\"\u0004\b\u0017\u0010\u000fR\u0018\u0010\u0019\u001a\u0004\u0018\u00010\u00188\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR\u0018\u0010\u001b\u001a\u0004\u0018\u00010\u00188\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001a\u00a8\u0006$"}, d2={"Lorg/valkyrienskies/clockwork/content/contraptions/flap/smart_flap/SmartFlapBearingBlockEntity;", "Lorg/valkyrienskies/clockwork/content/contraptions/flap/FlapBearingBlockEntity;", "", "getPower", "()I", "", "Lcom/simibubi/create/foundation/blockEntity/behaviour/BlockEntityBehaviour;", "behaviours", "", "addBehaviours", "(Ljava/util/List;)V", "createSmartFlap", "()V", "power", "setFirstSignal", "(I)V", "setSecondSignal", "firstReceivedSignal", "I", "getFirstReceivedSignal", "setFirstReceivedSignal", "secondReceivedSignal", "getSecondReceivedSignal", "setSecondReceivedSignal", "Lorg/valkyrienskies/clockwork/content/contraptions/flap/dual_link/DualLinkBehaviour;", "linkFirst", "Lorg/valkyrienskies/clockwork/content/contraptions/flap/dual_link/DualLinkBehaviour;", "linkSecond", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "type", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "<init>", "(Lnet/minecraft/world/level/block/entity/BlockEntityType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "clockwork"})
public final class SmartFlapBearingBlockEntity
extends FlapBearingBlockEntity {
    private int firstReceivedSignal;
    private int secondReceivedSignal;
    @Nullable
    private DualLinkBehaviour linkFirst;
    @Nullable
    private DualLinkBehaviour linkSecond;

    public SmartFlapBearingBlockEntity(@Nullable BlockEntityType<?> type, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(type, pos, state, -1L);
    }

    public final int getFirstReceivedSignal() {
        return this.firstReceivedSignal;
    }

    public final void setFirstReceivedSignal(int n) {
        this.firstReceivedSignal = n;
    }

    public final int getSecondReceivedSignal() {
        return this.secondReceivedSignal;
    }

    public final void setSecondReceivedSignal(int n) {
        this.secondReceivedSignal = n;
    }

    @Override
    protected int getPower() {
        if (this.firstReceivedSignal == 0 && this.secondReceivedSignal == 0) {
            return super.getPower();
        }
        if (!this.m_58900_().m_61138_((Property)BlockStateProperties.f_61372_)) {
            return 0;
        }
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_);
        if (facing == Direction.EAST || facing == Direction.SOUTH) {
            return this.secondReceivedSignal - this.firstReceivedSignal;
        }
        return this.firstReceivedSignal - this.secondReceivedSignal;
    }

    public void addBehaviours(@NotNull List<BlockEntityBehaviour> behaviours) {
        Intrinsics.checkNotNullParameter(behaviours, (String)"behaviours");
        super.addBehaviours(behaviours);
        this.createSmartFlap();
        DualLinkBehaviour dualLinkBehaviour = this.linkFirst;
        Intrinsics.checkNotNull((Object)((Object)dualLinkBehaviour));
        behaviours.add(dualLinkBehaviour);
        DualLinkBehaviour dualLinkBehaviour2 = this.linkSecond;
        Intrinsics.checkNotNull((Object)((Object)dualLinkBehaviour2));
        behaviours.add(dualLinkBehaviour2);
    }

    private final void createSmartFlap() {
        Pair valueBoxes = ValueBoxTransform.Dual.makeSlots(SmartFlapBearingBlockEntity::createSmartFlap$lambda$0);
        Pair valueBoxesSecond = ValueBoxTransform.Dual.makeSlots(SmartFlapBearingBlockEntity::createSmartFlap$lambda$1);
        SmartBlockEntity smartBlockEntity = (SmartBlockEntity)this;
        Intrinsics.checkNotNull((Object)valueBoxes);
        this.linkFirst = new DualLinkBehaviour(smartBlockEntity, (Pair<ValueBoxTransform, ValueBoxTransform>)valueBoxes, arg_0 -> SmartFlapBearingBlockEntity.createSmartFlap$lambda$2(this, arg_0), true);
        SmartBlockEntity smartBlockEntity2 = (SmartBlockEntity)this;
        Intrinsics.checkNotNull((Object)valueBoxesSecond);
        this.linkSecond = new DualLinkBehaviour(smartBlockEntity2, (Pair<ValueBoxTransform, ValueBoxTransform>)valueBoxesSecond, arg_0 -> SmartFlapBearingBlockEntity.createSmartFlap$lambda$3(this, arg_0), false);
    }

    public final void setFirstSignal(int power) {
        this.firstReceivedSignal = power;
    }

    public final void setSecondSignal(int power) {
        this.secondReceivedSignal = power;
    }

    private static final ValueBoxTransform.Dual createSmartFlap$lambda$0(boolean first) {
        return new FlapBearingFrequencySlot(first, true);
    }

    private static final ValueBoxTransform.Dual createSmartFlap$lambda$1(boolean first) {
        return new FlapBearingFrequencySlot(first, false);
    }

    private static final void createSmartFlap$lambda$2(SmartFlapBearingBlockEntity this$0, int it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.setFirstSignal(it);
    }

    private static final void createSmartFlap$lambda$3(SmartFlapBearingBlockEntity this$0, int it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.setSecondSignal(it);
    }
}

