/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.contraptions.flap.dual_link;

import com.simibubi.create.AllItems;
import com.simibubi.create.content.kinetics.base.DirectionalAxisKineticBlock;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.RaycastHelper;
import dev.architectury.event.EventResult;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.valkyrienskies.clockwork.content.contraptions.flap.dual_link.DualLinkBehaviour;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J/\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0013"}, d2={"Lorg/valkyrienskies/clockwork/content/contraptions/flap/dual_link/DualLinkHandler;", "", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "Lnet/minecraft/core/Direction;", "getFrontFacing", "(Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/core/Direction;", "Lnet/minecraft/world/entity/player/Player;", "player", "Lnet/minecraft/world/InteractionHand;", "hand", "Lnet/minecraft/core/BlockPos;", "pos", "face", "Ldev/architectury/event/EventResult;", "handler", "(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction;)Ldev/architectury/event/EventResult;", "<init>", "()V", "clockwork"})
public final class DualLinkHandler {
    @NotNull
    public static final DualLinkHandler INSTANCE = new DualLinkHandler();

    private DualLinkHandler() {
    }

    @JvmStatic
    @NotNull
    public static final Direction getFrontFacing(@NotNull BlockState state) {
        Direction original_direction;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Direction direction = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
        Boolean axis_along = (Boolean)state.m_61143_((Property)DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE);
        Direction direction2 = direction;
        switch (direction2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[direction2.ordinal()]) {
            case 1: {
                Direction direction3 = Direction.NORTH;
                break;
            }
            case 2: {
                Direction direction3 = Direction.SOUTH;
                break;
            }
            case 3: {
                Direction direction3 = Direction.WEST;
                break;
            }
            default: {
                Direction direction3 = original_direction = Direction.EAST;
            }
        }
        if (direction.m_122434_().m_122478_() && axis_along.booleanValue()) {
            original_direction = original_direction.m_122427_();
        }
        return original_direction;
    }

    @JvmStatic
    @NotNull
    public static final EventResult handler(@NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockPos pos, @NotNull Direction face) {
        Boolean[] localHit;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)face, (String)"face");
        Level world = player.m_9236_();
        if (player.m_6144_() || player.m_5833_()) {
            EventResult eventResult = EventResult.pass();
            Intrinsics.checkNotNullExpressionValue((Object)eventResult, (String)"pass(...)");
            return eventResult;
        }
        BlockState state = world.m_8055_(pos);
        if (!state.m_61138_((Property)BlockStateProperties.f_61372_) || !state.m_61138_((Property)DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE)) {
            EventResult eventResult = EventResult.pass();
            Intrinsics.checkNotNullExpressionValue((Object)eventResult, (String)"pass(...)");
            return eventResult;
        }
        BehaviourType<DualLinkBehaviour> type = null;
        Intrinsics.checkNotNull((Object)state);
        type = face == DualLinkHandler.getFrontFacing(state) ? DualLinkBehaviour.Companion.getFRONT_TYPE() : DualLinkBehaviour.Companion.getBACK_TYPE();
        DualLinkBehaviour dualLinkBehaviour = (DualLinkBehaviour)BlockEntityBehaviour.get((BlockGetter)((BlockGetter)world), (BlockPos)pos, type);
        if (dualLinkBehaviour == null) {
            EventResult eventResult = EventResult.pass();
            Intrinsics.checkNotNullExpressionValue((Object)eventResult, (String)"pass(...)");
            return eventResult;
        }
        DualLinkBehaviour behaviour = dualLinkBehaviour;
        ItemStack heldItem = player.m_21120_(hand);
        BlockHitResult blockHitResult = RaycastHelper.rayTraceRange((Level)world, (Player)player, (double)10.0);
        if (blockHitResult == null) {
            EventResult eventResult = EventResult.pass();
            Intrinsics.checkNotNullExpressionValue((Object)eventResult, (String)"pass(...)");
            return eventResult;
        }
        BlockHitResult ray = blockHitResult;
        if (AllItems.LINKED_CONTROLLER.isIn(heldItem)) {
            EventResult eventResult = EventResult.pass();
            Intrinsics.checkNotNullExpressionValue((Object)eventResult, (String)"pass(...)");
            return eventResult;
        }
        if (AllItems.WRENCH.isIn(heldItem)) {
            EventResult eventResult = EventResult.pass();
            Intrinsics.checkNotNullExpressionValue((Object)eventResult, (String)"pass(...)");
            return eventResult;
        }
        boolean fakePlayer = player instanceof ServerPlayer && !Intrinsics.areEqual(player.getClass(), ServerPlayer.class);
        boolean fakePlayerChoice = false;
        if (fakePlayer) {
            BlockState blockState = world.m_8055_(pos);
            localHit = ray.m_82450_().m_82546_(Vec3.m_82528_((Vec3i)((Vec3i)pos))).m_82549_(Vec3.m_82528_((Vec3i)ray.m_82434_().m_122436_()).m_82490_(0.25));
            fakePlayerChoice = localHit.m_82557_(behaviour.getFirstSlot().getLocalOffset((LevelAccessor)world, pos, blockState)) > localHit.m_82557_(behaviour.getSecondSlot().getLocalOffset((LevelAccessor)world, pos, blockState));
        }
        localHit = new Boolean[]{false, true};
        Iterator iterator = CollectionsKt.mutableListOf((Object[])localHit).iterator();
        while (iterator.hasNext()) {
            boolean first = (Boolean)iterator.next();
            Vec3 vec3 = ray.m_82450_();
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getLocation(...)");
            if (!behaviour.testHit(first, vec3) && (!fakePlayer || fakePlayerChoice != first)) continue;
            if (!world.m_5776_()) {
                Intrinsics.checkNotNull((Object)heldItem);
                behaviour.setFrequency(first, heldItem);
            }
            world.m_5594_(null, pos, SoundEvents.f_12013_, SoundSource.BLOCKS, 0.25f, 0.1f);
            EventResult eventResult = EventResult.interruptTrue();
            Intrinsics.checkNotNullExpressionValue((Object)eventResult, (String)"interruptTrue(...)");
            return eventResult;
        }
        EventResult eventResult = EventResult.pass();
        Intrinsics.checkNotNullExpressionValue((Object)eventResult, (String)"pass(...)");
        return eventResult;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.EAST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.WEST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.NORTH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

