/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.core.event.brew_event;

import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.satisfy.brewery.core.block.BrewKettleBlock;
import net.satisfy.brewery.core.block.BrewWhistleBlock;
import net.satisfy.brewery.core.block.entity.BrewstationBlockEntity;
import net.satisfy.brewery.core.block.property.Liquid;
import net.satisfy.brewery.core.event.brew_event.BrewEvent;
import net.satisfy.brewery.core.event.brew_event.BrewHelper;
import net.satisfy.brewery.core.registry.BlockStateRegistry;
import net.satisfy.brewery.core.registry.ObjectRegistry;

public class WhistleEvent
extends BrewEvent {
    @Override
    public CompoundTag save(CompoundTag compoundTag) {
        return compoundTag;
    }

    @Override
    public void load(CompoundTag compoundTag) {
    }

    @Override
    public void onTick(BrewstationBlockEntity entity) {
        Level level = entity.m_58904_();
        assert (level != null);
        if (!level.m_5776_()) {
            return;
        }
        RandomSource randomSource = level.m_213780_();
        if (this.getTimeLeft() % 3 != 0 || !(randomSource.m_188501_() < 0.05f)) {
            return;
        }
        BlockPos blockPos = BrewHelper.getBlock(BrewWhistleBlock.class, entity.getComponents(), level);
        BlockState blockState = level.m_8055_(blockPos);
        if (((Boolean)blockState.m_61143_((Property)BrewWhistleBlock.WHISTLE)).booleanValue() && blockState.m_61143_(BrewWhistleBlock.HALF) == DoubleBlockHalf.UPPER) {
            assert (blockPos != null);
            double x = (double)blockPos.m_123341_() + 0.5;
            double y = blockPos.m_123342_();
            double z = (double)blockPos.m_123343_() + 0.5;
            if (randomSource.m_188500_() < 0.1) {
                level.m_7785_(x, y, z, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.8f, 0.5f, false);
            }
            double j = randomSource.m_188500_() * 12.0 / 16.0;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x, y + j, z, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void start(Set<BlockPos> components, Level level) {
        if (components.isEmpty() || level == null) {
            return;
        }
        BlockPos basinPos = BrewHelper.getBlock(BrewKettleBlock.class, components, level);
        BlockPos whistlePos = BrewHelper.getBlock((Block)ObjectRegistry.BREW_WHISTLE.get(), components, level);
        if (basinPos != null && whistlePos != null) {
            BlockState basinState = level.m_8055_(basinPos);
            BlockState whistleState = level.m_8055_(whistlePos);
            level.m_46597_(basinPos, (BlockState)basinState.m_61124_(BlockStateRegistry.LIQUID, (Comparable)((Object)Liquid.DRAINED)));
            level.m_46597_(whistlePos, (BlockState)whistleState.m_61124_((Property)BlockStateRegistry.WHISTLE, (Comparable)Boolean.valueOf(true)));
        }
    }

    @Override
    public boolean isFinish(Set<BlockPos> components, Level level) {
        if (components == null || level == null) {
            return true;
        }
        BlockPos basinPos = BrewHelper.getBlock(BrewKettleBlock.class, components, level);
        if (basinPos != null) {
            BlockState basinState = level.m_8055_(basinPos);
            return basinState.m_61143_(BlockStateRegistry.LIQUID) == Liquid.FILLED;
        }
        return true;
    }

    @Override
    public void finish(Set<BlockPos> components, Level level) {
        BlockPos whistlePos = BrewHelper.getBlock((Block)ObjectRegistry.BREW_WHISTLE.get(), components, level);
        if (whistlePos != null) {
            BlockState whistleState = level.m_8055_(whistlePos);
            level.m_7731_(whistlePos, (BlockState)whistleState.m_61124_((Property)BlockStateRegistry.WHISTLE, (Comparable)Boolean.valueOf(false)), 3);
        }
        BrewHelper.resetWater(components, level);
    }
}

