/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.core.block.entity.rope;

import dev.architectury.extensions.network.EntitySpawnExtension;
import dev.architectury.networking.NetworkManager;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.satisfy.brewery.core.block.HopsCropBlock;
import net.satisfy.brewery.core.block.entity.rope.IRopeEntity;
import net.satisfy.brewery.core.network.BreweryNetworking;
import net.satisfy.brewery.core.registry.EntityTypeRegistry;
import net.satisfy.brewery.core.registry.ObjectRegistry;
import net.satisfy.brewery.core.util.rope.RopeConnection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HangingRopeEntity
extends Entity
implements IRopeEntity,
EntitySpawnExtension {
    public static final int MAX_LENGTH = 8;
    @Nullable
    private RopeConnection connection;
    private boolean active;
    @OnlyIn(value=Dist.CLIENT)
    private int length;
    private int checkTimer = 50;

    public HangingRopeEntity(EntityType<? extends HangingRopeEntity> entityType, Level level) {
        super(entityType, level);
    }

    private HangingRopeEntity(Level level, double x, double y, double z, @NotNull RopeConnection connection, boolean active) {
        this((EntityType<? extends HangingRopeEntity>)((EntityType)EntityTypeRegistry.HANGING_ROPE.get()), level);
        this.connection = connection;
        this.active = active;
        this.m_6034_(x, y, z);
    }

    public static HangingRopeEntity create(Level level, double x, double y, double z, RopeConnection connection) {
        return HangingRopeEntity.create(level, x, y, z, connection, true);
    }

    public static HangingRopeEntity create(Level level, double x, double y, double z, RopeConnection connection, boolean active) {
        return new HangingRopeEntity(level, x, y, z, connection, active);
    }

    public static void notifyBlock(BlockPos blockPos, ServerLevel serverLevel, Block block) {
        for (int below = 0; below < 8; ++below) {
            BlockPos belowPos = blockPos.m_6625_(below);
            BlockState blockState = serverLevel.m_8055_(belowPos);
            if (!blockState.m_60713_(block)) continue;
            serverLevel.m_186460_(belowPos, blockState.m_60734_(), 1);
            return;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vec3 getRopeVec() {
        return new Vec3(0.0, (double)(-this.length), 0.0);
    }

    public boolean active() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void m_8119_() {
        if (this.m_9236_().m_5776_()) {
            if (this.checkTimer++ >= 50) {
                this.checkTimer = 0;
                this.checkLength();
            }
            return;
        }
        if (this.connection != null && this.connection.needsBeDestroyed()) {
            this.connection.destroy(true);
        }
        if (this.connection == null || this.connection.dead()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void checkLength() {
        int length;
        BlockPos blockPos = this.m_20183_();
        for (length = 0; !this.m_9236_().m_8055_(blockPos.m_6625_(length + 1)).m_280296_() && length < 8; ++length) {
        }
        this.length = length;
    }

    @NotNull
    public InteractionResult m_6096_(Player player, InteractionHand interactionHand) {
        boolean changed;
        ItemStack itemStack = player.m_21120_(interactionHand);
        boolean bl = changed = !this.active && itemStack.m_150930_((Item)ObjectRegistry.ROPE.get()) || this.active && IRopeEntity.canDestroyWith(itemStack);
        if (changed) {
            Level level;
            boolean bl2 = this.active = !this.active;
            if (this.connection != null && !player.m_9236_().f_46443_) {
                this.connection.setActive(this.active, this.m_19879_());
            }
            if ((level = player.m_9236_()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                this.sendChangePacket(serverLevel);
                if (!this.active) {
                    HangingRopeEntity.notifyBlock(this.m_20183_(), serverLevel, HopsCropBlock.getHeadBlock());
                }
            }
            player.m_5496_(this.active ? SoundEvents.f_12087_ : SoundEvents.f_12033_, 0.5f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private void sendChangePacket(ServerLevel serverLevel) {
        List trackingPlayers = serverLevel.m_6907_();
        for (ServerPlayer serverPlayer : trackingPlayers) {
            FriendlyByteBuf buf = BreweryNetworking.createPacketBuf();
            buf.writeInt(this.m_19879_());
            buf.writeBoolean(this.active);
            NetworkManager.sendToPlayer((ServerPlayer)serverPlayer, (ResourceLocation)BreweryNetworking.CHANGE_HANGING_ROPE_S2C_ID, (FriendlyByteBuf)buf);
        }
    }

    public boolean m_7313_(Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.m_6469_(this.m_269291_().m_269075_(player), 0.0f);
        } else {
            this.m_5496_(SoundEvents.f_12641_, 0.5f, 1.0f);
        }
        return true;
    }

    public boolean m_6469_(DamageSource damageSource, float f) {
        InteractionResult result = IRopeEntity.onDamageFrom(this, damageSource);
        if (result.m_19077_()) {
            this.destroyConnections(result == InteractionResult.SUCCESS);
            return true;
        }
        return false;
    }

    public void m_6034_(double x, double y, double z) {
        super.m_6034_((double)Mth.m_14107_((double)x) + 0.5, y, (double)Mth.m_14107_((double)z) + 0.5);
    }

    @NotNull
    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)((EntityType)EntityTypeRegistry.HANGING_ROPE.get()).m_20679_(), 0.0);
    }

    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    public Vec3 m_7398_(float f) {
        return this.m_20318_(f).m_82549_(this.m_7939_());
    }

    protected float m_6380_(Pose pose, EntityDimensions dimensions) {
        return ((EntityType)EntityTypeRegistry.HANGING_ROPE.get()).m_20679_() / 2.0f;
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_5829_() {
        return false;
    }

    @Override
    public void destroyConnections(boolean mayDrop) {
        if (this.connection != null) {
            this.connection.destroy(mayDrop);
        }
    }

    protected void m_8097_() {
    }

    protected void m_7380_(CompoundTag tag) {
        if (this.connection != null) {
            CompoundTag connTag = new CompoundTag();
            this.connection.saveTo(connTag);
            tag.m_128365_("Connection", (Tag)connTag);
        }
        tag.m_128379_("Active", this.active);
    }

    protected void m_7378_(CompoundTag tag) {
        this.active = tag.m_128471_("Active");
        if (tag.m_128441_("Connection")) {
            CompoundTag connTag = tag.m_128469_("Connection");
            this.connection = RopeConnection.loadFrom(this, connTag);
        }
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkManager.createAddEntityPacket((Entity)this);
    }

    public void saveAdditionalSpawnData(FriendlyByteBuf buf) {
        buf.writeBoolean(this.active);
    }

    public void loadAdditionalSpawnData(FriendlyByteBuf buf) {
        this.active = buf.readBoolean();
    }
}

