/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.satisfy.meadow.client.gui.handler.CheeseFormGuiHandler;
import org.joml.Vector2i;

public class CheeseFormGui
extends AbstractContainerScreen<CheeseFormGuiHandler> {
    public static final ResourceLocation BACKGROUND = new ResourceLocation("meadow", "textures/gui/cheese_form_gui.png");
    public static final int ARROW_X = 78;
    public static final int ARROW_Y = 36;
    public static final int TIME_X = 81;
    public static final int TIME_Y = 8;
    private final Vector2i screenPos = new Vector2i();

    public CheeseFormGui(CheeseFormGuiHandler handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
        this.f_96547_ = Minecraft.m_91087_().f_91062_;
    }

    protected void m_7286_(GuiGraphics guiGraphics, float f, int i, int j) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BACKGROUND);
        int posX = this.f_97735_;
        int posY = this.f_97736_;
        guiGraphics.m_280218_(BACKGROUND, posX, posY, 0, 0, this.f_97726_ - 1, this.f_97727_);
        this.renderProgressArrow(guiGraphics);
    }

    protected void renderProgressArrow(GuiGraphics guiGraphics) {
        int progressX = ((CheeseFormGuiHandler)this.f_97732_).getScaledXProgress();
        guiGraphics.m_280218_(BACKGROUND, this.f_97735_ + 78, this.f_97736_ + 36, 176, 4, progressX, 10);
        int progressY = ((CheeseFormGuiHandler)this.f_97732_).getScaledYProgress();
        guiGraphics.m_280218_(BACKGROUND, this.f_97735_ + 81, this.f_97736_ + 8, 180, 22, 16, progressY);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, delta);
        this.screenPos.set(this.f_97735_, this.f_97736_);
        if (this.isMouseOverProgressArrow(mouseX, mouseY)) {
            int remainingTicks = Math.max(((CheeseFormGuiHandler)this.f_97732_).getRequiredDuration() - ((CheeseFormGuiHandler)this.f_97732_).getCookingTime(), 0);
            String formattedTime = this.formatTicks(remainingTicks);
            MutableComponent tooltip = Component.m_237110_((String)"tooltip.meadow.cooking_cauldron.remaining_time", (Object[])new Object[]{formattedTime});
            guiGraphics.m_280557_(this.f_96547_, (Component)tooltip, mouseX, mouseY);
        } else {
            super.m_280072_(guiGraphics, mouseX, mouseY);
        }
    }

    private boolean isMouseOverProgressArrow(int mouseX, int mouseY) {
        int left = this.screenPos.x() + 78;
        int top = this.screenPos.y() + 36;
        return mouseX >= left && mouseX < left + 24 && mouseY >= top && mouseY < top + 17;
    }

    private String formatTicks(int ticks) {
        int seconds = Math.max(ticks / 20, 0);
        int minutes = seconds / 60;
        return String.format("%d:%02d", minutes, seconds %= 60);
    }
}

