/*
 * Decompiled with CFR 0.152.
 */
package krelox.compat_o_plenty.core;

import biomesoplenty.api.item.BOPItems;
import com.teamabnormals.blueprint.core.util.registry.ISubRegistryHelper;
import com.teamabnormals.blueprint.core.util.registry.RegistryHelper;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import krelox.compat_o_plenty.core.data.client.COPBlockStateProvider;
import krelox.compat_o_plenty.core.data.client.COPItemModelProvider;
import krelox.compat_o_plenty.core.data.client.COPLanguageProvider;
import krelox.compat_o_plenty.core.data.server.COPLootTableProvider;
import krelox.compat_o_plenty.core.data.server.COPRecipeProvider;
import krelox.compat_o_plenty.core.data.server.tags.COPBlockTagsProvider;
import krelox.compat_o_plenty.core.data.server.tags.COPItemTagsProvider;
import krelox.compat_o_plenty.core.other.COPClientCompat;
import krelox.compat_o_plenty.core.other.COPCompat;
import krelox.compat_o_plenty.core.registry.COPBlocks;
import krelox.compat_o_plenty.core.registry.COPItems;
import krelox.compat_o_plenty.core.registry.helper.COPBlockSubRegistryHelper;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.util.MutableHashedLinkedMap;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;

@Mod(value="compat_o_plenty")
public class CompatOPlenty {
    public static final String MOD_ID = "compat_o_plenty";
    public static final String QUARK_ID = "quark";
    public static final String WOODWORKS_ID = "woodworks";
    public static final String TWIGS_ID = "twigs";
    public static final String FARMERS_DELIGHT_ID = "farmersdelight";
    public static final String BOATLOAD_ID = "boatload";
    public static final RegistryHelper REGISTRY_HELPER = RegistryHelper.create((String)"compat_o_plenty", helper -> helper.putSubHelper(ForgeRegistries.BLOCKS, (ISubRegistryHelper)new COPBlockSubRegistryHelper((RegistryHelper)helper)));

    public CompatOPlenty() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        MinecraftForge.EVENT_BUS.register((Object)this);
        REGISTRY_HELPER.register(bus);
        bus.addListener(this::setupTabEditors);
        bus.addListener(this::commonSetup);
        bus.addListener(this::clientSetup);
        bus.addListener(this::dataSetup);
        if (ModList.get().isLoaded("everycomp")) {
            EveryCompat.addOtherCompatMod((String)MOD_ID, (String)"biomesoplenty", (String[])new String[]{WOODWORKS_ID, BOATLOAD_ID, FARMERS_DELIGHT_ID, TWIGS_ID, QUARK_ID});
        }
    }

    public static ResourceLocation modLoc(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    public static ResourceLocation bopLoc(String path) {
        return new ResourceLocation("biomesoplenty", path);
    }

    public static Supplier<Item> bopItem(String path) {
        return () -> (Item)ForgeRegistries.ITEMS.getValue(CompatOPlenty.bopLoc(path));
    }

    public static Supplier<Block> bopBlock(String path) {
        return () -> (Block)ForgeRegistries.BLOCKS.getValue(CompatOPlenty.bopLoc(path));
    }

    private void setupTabEditors(BuildCreativeModeTabContentsEvent event) {
        MutableHashedLinkedMap entries = event.getEntries();
        BiConsumer<Item, Supplier> after = (item, toPut) -> entries.putAfter((Object)item.m_7968_(), (Object)((ItemLike)toPut.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        BiConsumer<Item, Supplier> before = (item, toPut) -> entries.putBefore((Object)item.m_7968_(), (Object)((ItemLike)toPut.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        if (!event.getTabKey().m_135782_().equals((Object)CompatOPlenty.bopLoc("main"))) {
            return;
        }
        for (WoodType woodType : COPBlocks.WOOD_PROPERTIES.keySet()) {
            String materialName = woodType.f_61839_().replace("biomesoplenty:", "");
            Item chestBoat = CompatOPlenty.bopItem(materialName + "_chest_boat").get();
            Item leaves = CompatOPlenty.bopItem(materialName + "_leaves").get();
            Item planks = CompatOPlenty.bopItem(materialName + "_planks").get();
            Item sign = CompatOPlenty.bopItem(materialName + "_sign").get();
            Item hangingSign = CompatOPlenty.bopItem(materialName + "_hanging_sign").get();
            Item log = CompatOPlenty.bopItem(materialName + "_log").get();
            Item slab = CompatOPlenty.bopItem(materialName + "_slab").get();
            if (ModList.get().isLoaded(BOATLOAD_ID)) {
                after.accept(chestBoat, (Supplier)COPItems.LARGE_BOATS.get(woodType));
                after.accept(chestBoat, (Supplier)COPItems.FURNACE_BOATS.get(woodType));
            }
            if (ModList.get().isLoaded(WOODWORKS_ID) || ModList.get().isLoaded(QUARK_ID)) {
                before.accept(sign, (Supplier)COPBlocks.LADDERS.get(woodType));
                if (ModList.get().isLoaded(WOODWORKS_ID)) {
                    after.accept(leaves, (Supplier)COPBlocks.LEAF_PILES.get(woodType));
                    after.accept(planks, (Supplier)COPBlocks.BOARDS.get(woodType));
                    before.accept(sign, (Supplier)COPBlocks.BEEHIVES.get(woodType));
                }
                before.accept(sign, (Supplier)COPBlocks.BOOKSHELVES.get(woodType));
                after.accept(hangingSign, (Supplier)COPBlocks.TRAPPED_CHESTS.get(woodType));
                after.accept(hangingSign, (Supplier)COPBlocks.CHESTS.get(woodType));
                if (ModList.get().isLoaded(QUARK_ID)) {
                    before.accept(log, (Supplier)COPBlocks.HOLLOW_LOGS.get(woodType));
                    after.accept(leaves, (Supplier)COPBlocks.HEDGES.get(woodType));
                    after.accept(planks, (Supplier)COPBlocks.VERTICAL_PLANKS.get(woodType));
                    after.accept(slab, (Supplier)COPBlocks.STRIPPED_POSTS.get(woodType));
                    after.accept(slab, (Supplier)COPBlocks.POSTS.get(woodType));
                    after.accept(slab, (Supplier)COPBlocks.VERTICAL_SLABS.get(woodType));
                }
            }
            if (ModList.get().isLoaded(FARMERS_DELIGHT_ID)) {
                before.accept(sign, (Supplier)COPBlocks.CABINETS.get(woodType));
            }
            if (!ModList.get().isLoaded(TWIGS_ID)) continue;
            before.accept(sign, (Supplier)COPBlocks.TABLES.get(woodType));
        }
        if (ModList.get().isLoaded(WOODWORKS_ID)) {
            after.accept(BOPItems.ORIGIN_LEAVES, (Supplier)COPBlocks.ORIGIN_LEAF_PILE);
            after.accept(BOPItems.FLOWERING_OAK_LEAVES, (Supplier)COPBlocks.FLOWERING_OAK_LEAF_PILE);
            after.accept(BOPItems.RAINBOW_BIRCH_LEAVES, (Supplier)COPBlocks.RAINBOW_BIRCH_LEAF_PILE);
            after.accept(BOPItems.CYPRESS_LEAVES, (Supplier)COPBlocks.CYPRESS_LEAF_PILE);
            after.accept(BOPItems.SNOWBLOSSOM_LEAVES, (Supplier)COPBlocks.SNOWBLOSSOM_LEAF_PILE);
            after.accept(BOPItems.RED_MAPLE_LEAVES, (Supplier)COPBlocks.RED_MAPLE_LEAF_PILE);
            after.accept(BOPItems.ORANGE_MAPLE_LEAVES, (Supplier)COPBlocks.ORANGE_MAPLE_LEAF_PILE);
            after.accept(BOPItems.YELLOW_MAPLE_LEAVES, (Supplier)COPBlocks.YELLOW_MAPLE_LEAF_PILE);
        }
        if (ModList.get().isLoaded(QUARK_ID)) {
            after.accept(BOPItems.WHITE_SANDSTONE_SLAB, (Supplier)COPBlocks.WHITE_SANDSTONE_VERTICAL_SLAB);
            after.accept(BOPItems.SMOOTH_WHITE_SANDSTONE_SLAB, (Supplier)COPBlocks.SMOOTH_WHITE_SANDSTONE_VERTICAL_SLAB);
            after.accept(BOPItems.CUT_WHITE_SANDSTONE_SLAB, (Supplier)COPBlocks.CUT_WHITE_SANDSTONE_VERTICAL_SLAB);
            after.accept(BOPItems.ORANGE_SANDSTONE_SLAB, (Supplier)COPBlocks.ORANGE_SANDSTONE_VERTICAL_SLAB);
            after.accept(BOPItems.SMOOTH_ORANGE_SANDSTONE_SLAB, (Supplier)COPBlocks.SMOOTH_ORANGE_SANDSTONE_VERTICAL_SLAB);
            after.accept(BOPItems.CUT_ORANGE_SANDSTONE_SLAB, (Supplier)COPBlocks.CUT_ORANGE_SANDSTONE_VERTICAL_SLAB);
            after.accept(BOPItems.BLACK_SANDSTONE_SLAB, (Supplier)COPBlocks.BLACK_SANDSTONE_VERTICAL_SLAB);
            after.accept(BOPItems.SMOOTH_BLACK_SANDSTONE_SLAB, (Supplier)COPBlocks.SMOOTH_BLACK_SANDSTONE_VERTICAL_SLAB);
            after.accept(BOPItems.CUT_BLACK_SANDSTONE_SLAB, (Supplier)COPBlocks.CUT_BLACK_SANDSTONE_VERTICAL_SLAB);
            after.accept(BOPItems.WHITE_SANDSTONE_WALL, (Supplier)COPBlocks.WHITE_SANDSTONE_BRICK_WALL);
            after.accept(BOPItems.WHITE_SANDSTONE_WALL, (Supplier)COPBlocks.WHITE_SANDSTONE_BRICK_VERTICAL_SLAB);
            after.accept(BOPItems.WHITE_SANDSTONE_WALL, (Supplier)COPBlocks.WHITE_SANDSTONE_BRICK_SLAB);
            after.accept(BOPItems.WHITE_SANDSTONE_WALL, (Supplier)COPBlocks.WHITE_SANDSTONE_BRICK_STAIRS);
            after.accept(BOPItems.WHITE_SANDSTONE_WALL, (Supplier)COPBlocks.WHITE_SANDSTONE_BRICKS);
            after.accept(BOPItems.ORANGE_SANDSTONE_WALL, (Supplier)COPBlocks.ORANGE_SANDSTONE_BRICK_WALL);
            after.accept(BOPItems.ORANGE_SANDSTONE_WALL, (Supplier)COPBlocks.ORANGE_SANDSTONE_BRICK_VERTICAL_SLAB);
            after.accept(BOPItems.ORANGE_SANDSTONE_WALL, (Supplier)COPBlocks.ORANGE_SANDSTONE_BRICK_SLAB);
            after.accept(BOPItems.ORANGE_SANDSTONE_WALL, (Supplier)COPBlocks.ORANGE_SANDSTONE_BRICK_STAIRS);
            after.accept(BOPItems.ORANGE_SANDSTONE_WALL, (Supplier)COPBlocks.ORANGE_SANDSTONE_BRICKS);
            after.accept(BOPItems.BLACK_SANDSTONE_WALL, (Supplier)COPBlocks.BLACK_SANDSTONE_BRICK_WALL);
            after.accept(BOPItems.BLACK_SANDSTONE_WALL, (Supplier)COPBlocks.BLACK_SANDSTONE_BRICK_VERTICAL_SLAB);
            after.accept(BOPItems.BLACK_SANDSTONE_WALL, (Supplier)COPBlocks.BLACK_SANDSTONE_BRICK_SLAB);
            after.accept(BOPItems.BLACK_SANDSTONE_WALL, (Supplier)COPBlocks.BLACK_SANDSTONE_BRICK_STAIRS);
            after.accept(BOPItems.BLACK_SANDSTONE_WALL, (Supplier)COPBlocks.BLACK_SANDSTONE_BRICKS);
            after.accept(BOPItems.GLOWING_MOSS_CARPET, (Supplier)COPItems.GLOWING_MOSS_PASTE);
            after.accept(BOPItems.GLOWING_MOSS_CARPET, (Supplier)COPBlocks.GALANOS_VERTICAL_SLAB);
            after.accept(BOPItems.GLOWING_MOSS_CARPET, (Supplier)COPBlocks.GALANOS_SLAB);
            after.accept(BOPItems.GLOWING_MOSS_CARPET, (Supplier)COPBlocks.GALANOS_STAIRS);
            after.accept(BOPItems.GLOWING_MOSS_CARPET, (Supplier)COPBlocks.GALANOS_PILLAR);
            after.accept(BOPItems.GLOWING_MOSS_CARPET, (Supplier)COPBlocks.GALANOS_BLOCK);
            after.accept(BOPItems.ORIGIN_LEAVES, (Supplier)COPBlocks.ORIGIN_HEDGE);
            after.accept(BOPItems.FLOWERING_OAK_LEAVES, (Supplier)COPBlocks.FLOWERING_OAK_HEDGE);
            after.accept(BOPItems.RAINBOW_BIRCH_LEAVES, (Supplier)COPBlocks.RAINBOW_BIRCH_HEDGE);
            after.accept(BOPItems.CYPRESS_LEAVES, (Supplier)COPBlocks.CYPRESS_HEDGE);
            after.accept(BOPItems.SNOWBLOSSOM_LEAVES, (Supplier)COPBlocks.SNOWBLOSSOM_HEDGE);
            after.accept(BOPItems.RED_MAPLE_LEAVES, (Supplier)COPBlocks.RED_MAPLE_HEDGE);
            after.accept(BOPItems.ORANGE_MAPLE_LEAVES, (Supplier)COPBlocks.ORANGE_MAPLE_HEDGE);
            after.accept(BOPItems.YELLOW_MAPLE_LEAVES, (Supplier)COPBlocks.YELLOW_MAPLE_HEDGE);
        }
        if (ModList.get().isLoaded(TWIGS_ID)) {
            before.accept(BOPItems.ROSE_QUARTZ_BLOCK, (Supplier)COPBlocks.POLISHED_ROSE_QUARTZ);
            before.accept(BOPItems.ROSE_QUARTZ_BLOCK, (Supplier)COPBlocks.CHISELED_POLISHED_ROSE_QUARTZ);
            before.accept(BOPItems.ROSE_QUARTZ_BLOCK, (Supplier)COPBlocks.POLISHED_ROSE_QUARTZ_STAIRS);
            before.accept(BOPItems.ROSE_QUARTZ_BLOCK, (Supplier)COPBlocks.POLISHED_ROSE_QUARTZ_SLAB);
            if (ModList.get().isLoaded(QUARK_ID)) {
                before.accept(BOPItems.ROSE_QUARTZ_BLOCK, (Supplier)COPBlocks.POLISHED_ROSE_QUARTZ_VERTICAL_SLAB);
            }
            before.accept(BOPItems.ROSE_QUARTZ_BLOCK, (Supplier)COPBlocks.POLISHED_ROSE_QUARTZ_BRICKS);
            before.accept(BOPItems.ROSE_QUARTZ_BLOCK, (Supplier)COPBlocks.CRACKED_POLISHED_ROSE_QUARTZ_BRICKS);
            before.accept(BOPItems.ROSE_QUARTZ_BLOCK, (Supplier)COPBlocks.POLISHED_ROSE_QUARTZ_BRICK_STAIRS);
            before.accept(BOPItems.ROSE_QUARTZ_BLOCK, (Supplier)COPBlocks.POLISHED_ROSE_QUARTZ_BRICK_SLAB);
            if (ModList.get().isLoaded(QUARK_ID)) {
                before.accept(BOPItems.ROSE_QUARTZ_BLOCK, (Supplier)COPBlocks.POLISHED_ROSE_QUARTZ_BRICK_VERTICAL_SLAB);
            }
            before.accept(BOPItems.ROSE_QUARTZ_BLOCK, (Supplier)COPBlocks.POLISHED_ROSE_QUARTZ_BRICK_WALL);
        }
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(COPCompat::registerCompat);
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(COPClientCompat::registerClientCompat);
    }

    private void dataSetup(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        PackOutput packOutput = generator.getPackOutput();
        Consumer<DataProvider> client = provider -> generator.addProvider(event.includeClient(), provider);
        Consumer<DataProvider> server = provider -> generator.addProvider(event.includeServer(), provider);
        client.accept((DataProvider)new COPLanguageProvider(packOutput));
        client.accept((DataProvider)new COPBlockStateProvider(packOutput, fileHelper));
        client.accept((DataProvider)new COPItemModelProvider(packOutput, fileHelper));
        COPBlockTagsProvider blockTags = new COPBlockTagsProvider(packOutput, lookupProvider, fileHelper);
        server.accept((DataProvider)blockTags);
        server.accept((DataProvider)new COPItemTagsProvider(packOutput, lookupProvider, blockTags.m_274426_(), fileHelper));
        server.accept((DataProvider)new COPLootTableProvider(packOutput));
        server.accept((DataProvider)new COPRecipeProvider(packOutput));
    }
}

