/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.builder;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.KiwiCommonConfig;
import snownee.kiwi.customization.CustomizationClient;
import snownee.kiwi.customization.block.family.BlockFamilies;
import snownee.kiwi.customization.block.family.BlockFamily;
import snownee.kiwi.customization.builder.BuilderModePreview;
import snownee.kiwi.customization.builder.BuilderRule;
import snownee.kiwi.customization.builder.ConvertScreen;
import snownee.kiwi.customization.network.CApplyBuilderRulePacket;
import snownee.kiwi.customization.network.CConvertItemPacket;
import snownee.kiwi.util.ClientProxy;
import snownee.kiwi.util.KHolder;

public class BuildersButton {
    private static final BuilderModePreview PREVIEW_RENDERER = new BuilderModePreview();
    private static boolean builderMode;

    public static BuilderModePreview getPreviewRenderer() {
        return PREVIEW_RENDERER;
    }

    public static boolean isBuilderModeOn() {
        if (builderMode && CustomizationClient.buildersButtonKey != null && CustomizationClient.buildersButtonKey.m_90862_()) {
            builderMode = false;
        }
        return builderMode;
    }

    public static boolean onLongPress() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null || player.m_5833_()) {
            return false;
        }
        builderMode = !builderMode;
        RandomSource random = RandomSource.m_216327_();
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11871_, (float)((random.m_188501_() - random.m_188501_()) * 0.35f + 0.9f)));
        Minecraft.m_91087_().m_240442_().m_240494_((Component)Component.m_237115_((String)"kiwi.builder_mode.%s".formatted(builderMode ? "on" : "off")), false);
        return true;
    }

    public static boolean onDoublePress() {
        return false;
    }

    public static boolean onShortPress() {
        AbstractContainerScreen containerScreen;
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return false;
        }
        Screen screen = mc.f_91080_;
        if (screen instanceof ConvertScreen) {
            screen.m_7379_();
            return true;
        }
        if (KiwiCommonConfig.kSwitchCreativeOnly && !player.m_7500_()) {
            return false;
        }
        if (screen instanceof AbstractContainerScreen && (containerScreen = (AbstractContainerScreen)screen).m_6262_().m_142621_().m_41619_()) {
            Slot slot = ClientProxy.getSlotUnderMouse(containerScreen);
            if (slot == null || !slot.m_6657_() || !slot.m_150651_((Player)player)) {
                return false;
            }
            if (screen instanceof CreativeModeInventoryScreen && slot.f_40218_ != player.m_150109_()) {
                return false;
            }
            List<CConvertItemPacket.Group> groups = BuildersButton.findConvertGroups((Player)player, slot.m_7993_());
            if (groups.isEmpty()) {
                return false;
            }
            ClientProxy.pushScreen(mc, new ConvertScreen(screen, slot, slot.f_40219_, groups));
            return true;
        }
        if (screen != null) {
            return false;
        }
        List<CConvertItemPacket.Group> groups = BuildersButton.findConvertGroups((Player)player, player.m_21205_());
        if (!groups.isEmpty()) {
            mc.m_91152_((Screen)new ConvertScreen(null, null, player.m_150109_().f_35977_, groups));
            return true;
        }
        groups = BuildersButton.findConvertGroups((Player)player, player.m_21206_());
        if (!groups.isEmpty()) {
            mc.m_91152_((Screen)new ConvertScreen(null, null, 40, groups));
            return true;
        }
        return false;
    }

    public static List<CConvertItemPacket.Group> findConvertGroups(Player player, ItemStack itemStack) {
        List<KHolder<BlockFamily>> families = BlockFamilies.findQuickSwitch(itemStack.m_41720_(), player.m_7500_());
        if (families.isEmpty()) {
            return List.of();
        }
        ArrayList groups = Lists.newArrayListWithExpectedSize((int)families.size());
        HashSet addedItems = Sets.newHashSet();
        float ratio = BlockFamilies.getConvertRatio(itemStack.m_41720_());
        for (KHolder<BlockFamily> family : families) {
            CConvertItemPacket.Group group2 = new CConvertItemPacket.Group();
            boolean cascading = family.value().switchAttrs().cascading();
            List<CConvertItemPacket.Entry> unresolved = cascading ? Lists.newLinkedList() : List.of();
            HashSet iteratedFamilies = cascading ? Sets.newHashSet((Object[])new BlockFamily[]{family.value()}) : Set.of();
            Set<Item> iteratedItems = cascading ? Sets.newHashSet() : Set.of();
            for (Item item : family.value().items().toList()) {
                float convertRatio = BlockFamilies.getConvertRatio(item);
                CConvertItemPacket.Entry entry2 = new CConvertItemPacket.Entry(ratio / convertRatio);
                Pair pair = Pair.of((Object)family.key(), (Object)item);
                entry2.steps().add((Pair<ResourceLocation, Item>)pair);
                if (cascading) {
                    unresolved.add(entry2);
                    iteratedItems.add(item);
                }
                if (!addedItems.contains(item)) {
                    group2.entries().add(entry2);
                }
                addedItems.add(item);
            }
            while (!unresolved.isEmpty()) {
                CConvertItemPacket.Entry parentEntry = (CConvertItemPacket.Entry)unresolved.remove(0);
                Pair<ResourceLocation, Item> lastStep = parentEntry.steps().get(parentEntry.steps().size() - 1);
                Item lastItem = (Item)lastStep.getSecond();
                ratio = BlockFamilies.getConvertRatio(lastItem);
                for (KHolder<BlockFamily> nextFamily : BlockFamilies.findQuickSwitch(lastItem, player.m_7500_())) {
                    if (!iteratedFamilies.add(nextFamily.value())) continue;
                    for (Item nextItem : nextFamily.value().items().toList()) {
                        if (!iteratedItems.add(nextItem)) continue;
                        float convertRatio = BlockFamilies.getConvertRatio(nextItem);
                        CConvertItemPacket.Entry entry3 = new CConvertItemPacket.Entry(parentEntry.ratio() * ratio / convertRatio);
                        entry3.steps().addAll(parentEntry.steps());
                        entry3.steps().add((Pair<ResourceLocation, Item>)Pair.of((Object)nextFamily.key(), (Object)nextItem));
                        if (!addedItems.contains(nextItem)) {
                            group2.entries().add(entry3);
                            addedItems.add(nextItem);
                        }
                        if (entry3.steps().size() >= 4 || !nextFamily.value().switchAttrs().cascading()) continue;
                        unresolved.add(entry3);
                    }
                }
            }
            if (group2.entries().isEmpty()) continue;
            groups.add(group2);
        }
        if (player.m_7500_()) {
            return groups;
        }
        Predicate<CConvertItemPacket.Entry> filter = entry -> {
            if (entry.ratio() >= 1.0f) {
                return false;
            }
            return !player.m_150109_().m_216874_($ -> $.m_150930_(entry.item()));
        };
        int count = 0;
        for (CConvertItemPacket.Group group3 : groups) {
            group3.entries().removeIf(filter);
            count += group3.entries().size();
        }
        if (count <= 1) {
            return List.of();
        }
        groups.removeIf(group -> group.entries().isEmpty());
        return groups;
    }

    public static boolean startDestroyBlock(BlockPos pos, Direction face) {
        LocalPlayer player = BuildersButton.ensureBuilderMode();
        return player != null;
    }

    public static boolean performUseItemOn(InteractionHand hand, BlockHitResult hitResult) {
        LocalPlayer player = BuildersButton.ensureBuilderMode();
        if (player == null) {
            return false;
        }
        if (hand == InteractionHand.OFF_HAND) {
            return false;
        }
        BuilderModePreview preview = BuildersButton.getPreviewRenderer();
        KHolder<BuilderRule> rule = preview.rule;
        BlockPos pos = preview.pos;
        List<BlockPos> positions = preview.positions;
        if (rule == null || positions.isEmpty() || !hitResult.m_82425_().equals((Object)pos)) {
            return true;
        }
        CApplyBuilderRulePacket.send(new UseOnContext((Player)player, hand, hitResult), rule, positions);
        return true;
    }

    @Nullable
    private static LocalPlayer ensureBuilderMode() {
        if (!BuildersButton.isBuilderModeOn()) {
            return null;
        }
        return Minecraft.m_91087_().f_91074_;
    }

    public static void renderDebugText(List<String> left, List<String> right) {
        if (!BuildersButton.isBuilderModeOn()) {
            return;
        }
        left.add("Builder Mode is on, long press %s to toggle".formatted(Objects.requireNonNull(CustomizationClient.buildersButtonKey).m_90863_().getString()));
    }

    public static boolean cancelRenderHighlight() {
        return !BuildersButton.getPreviewRenderer().positions.isEmpty();
    }
}

