/*
 * Decompiled with CFR 0.152.
 */
package dev.tomwmth.citreforged.pack.format;

import dev.tomwmth.citreforged.pack.format.PropertiesGroupAdapter;
import dev.tomwmth.citreforged.pack.format.PropertyKey;
import dev.tomwmth.citreforged.pack.format.PropertySeparator;
import dev.tomwmth.citreforged.pack.format.PropertyValue;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;

public abstract class PropertyGroup {
    public final Map<PropertyKey, Set<PropertyValue>> properties = new LinkedHashMap<PropertyKey, Set<PropertyValue>>();
    public final ResourceLocation identifier;
    public final String packName;

    protected PropertyGroup(String packName, ResourceLocation identifier) {
        this.packName = packName;
        this.identifier = identifier;
    }

    public static PropertyGroup tryParseGroup(String packName, ResourceLocation identifier, InputStream is) throws IOException {
        PropertiesGroupAdapter group = null;
        if (identifier.m_135815_().endsWith(".properties")) {
            group = new PropertiesGroupAdapter(packName, identifier);
        }
        return group == null ? null : ((PropertyGroup)group).load(packName, identifier, is);
    }

    public abstract String getExtension();

    public abstract PropertyGroup load(String var1, ResourceLocation var2, InputStream var3) throws IOException, ResourceLocationException;

    protected void put(int position, String packName, ResourceLocation propertiesIdentifier, String key, String keyMetadata, PropertySeparator separator, String value) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        this.properties.computeIfAbsent(PropertyKey.of(key), id -> new LinkedHashSet()).add(new PropertyValue(keyMetadata, value, separator, position, propertiesIdentifier, packName));
    }

    public Set<PropertyValue> get(String namespace, String ... pathAliases) {
        LinkedHashSet<PropertyValue> values = new LinkedHashSet<PropertyValue>();
        for (String path : pathAliases) {
            Set<PropertyValue> possibleValues = this.properties.get(new PropertyKey(namespace, path));
            if (possibleValues == null) continue;
            values.addAll(possibleValues);
        }
        return values;
    }

    public PropertyValue getLastWithoutMetadata(String namespace, String ... pathAliases) {
        PropertyValue value = null;
        for (PropertyValue next : this.get(namespace, pathAliases)) {
            if (next.keyMetadata() != null) continue;
            value = next;
        }
        return value;
    }

    public PropertyValue getLastWithoutMetadataOrDefault(String defaultValue, String namespace, String ... pathAliases) {
        PropertyValue property = this.getLastWithoutMetadata(namespace, pathAliases);
        if (property == null) {
            property = new PropertyValue(null, defaultValue, PropertySeparator.EQUALS, -1, this.identifier, this.packName);
        }
        return property;
    }

    public String stripName() {
        return this.identifier.m_135815_().substring(this.identifier.m_135815_().lastIndexOf(47) + 1, this.identifier.m_135815_().length() - this.getExtension().length());
    }

    public String messageWithDescriptorOf(String message, int position) {
        return message + (String)(position != -1 ? " @L" + position : "") + " in " + this.identifier.toString() + " from " + this.packName;
    }
}

