/*
 * Decompiled with CFR 0.152.
 */
package dev.tomwmth.citreforged.defaults.cit.types;

import dev.tomwmth.citreforged.api.CITTypeContainer;
import dev.tomwmth.citreforged.cit.CIT;
import dev.tomwmth.citreforged.cit.CITCache;
import dev.tomwmth.citreforged.cit.CITCondition;
import dev.tomwmth.citreforged.cit.CITContext;
import dev.tomwmth.citreforged.cit.CITParsingException;
import dev.tomwmth.citreforged.cit.CITType;
import dev.tomwmth.citreforged.defaults.cit.conditions.ConditionItems;
import dev.tomwmth.citreforged.pack.format.PropertyGroup;
import dev.tomwmth.citreforged.pack.format.PropertyKey;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class TypeElytra
extends CITType {
    public static final Container CONTAINER = new Container();
    public ResourceLocation texture;

    @Override
    public Set<PropertyKey> typeProperties() {
        return Set.of(PropertyKey.of("texture"));
    }

    @Override
    public void load(List<CITCondition> conditions, PropertyGroup properties, ResourceManager resourceManager) throws CITParsingException {
        for (CITCondition condition : conditions) {
            if (!(condition instanceof ConditionItems)) continue;
            ConditionItems items = (ConditionItems)condition;
            for (Item item : items.items) {
                if (item instanceof ElytraItem) continue;
                this.warn("Non elytra item type condition", null, properties);
            }
        }
        this.texture = TypeElytra.resolveAsset(properties.identifier, properties.getLastWithoutMetadata("citresewn", "texture"), "textures", ".png", resourceManager);
        if (this.texture == null) {
            throw new CITParsingException("Texture not specified", properties, -1);
        }
    }

    public static class Container
    extends CITTypeContainer<TypeElytra> {
        public final List<Function<LivingEntity, ItemStack>> getItemInSlotCompatRedirects = new ArrayList<Function<LivingEntity, ItemStack>>();
        public Set<CIT<TypeElytra>> loaded = new HashSet<CIT<TypeElytra>>();

        public Container() {
            super(TypeElytra.class, TypeElytra::new, "elytra");
        }

        @Override
        public void load(List<CIT<TypeElytra>> parsedCITs) {
            this.loaded.addAll(parsedCITs);
        }

        @Override
        public void dispose() {
            this.loaded.clear();
        }

        public CIT<TypeElytra> getCIT(CITContext context) {
            return (CIT)((CITCacheElytra)context.stack).citresewn$getCacheTypeElytra().get(context).get();
        }

        public CIT<TypeElytra> getRealTimeCIT(CITContext context) {
            for (CIT<TypeElytra> cit : this.loaded) {
                if (!cit.test(context)) continue;
                return cit;
            }
            return null;
        }

        public ItemStack getVisualElytraItem(LivingEntity entity) {
            for (Function<LivingEntity, ItemStack> redirect : this.getItemInSlotCompatRedirects) {
                ItemStack stack = redirect.apply(entity);
                if (stack == null) continue;
                return stack;
            }
            return entity.m_6844_(EquipmentSlot.CHEST);
        }
    }

    public static interface CITCacheElytra {
        public CITCache.Single<TypeElytra> citresewn$getCacheTypeElytra();
    }
}

