/*
 * Decompiled with CFR 0.152.
 */
package dev.tomwmth.citreforged.defaults.cit.conditions;

import dev.tomwmth.citreforged.api.CITConditionContainer;
import dev.tomwmth.citreforged.cit.CITCondition;
import dev.tomwmth.citreforged.cit.CITContext;
import dev.tomwmth.citreforged.cit.CITParsingException;
import dev.tomwmth.citreforged.pack.format.PropertyGroup;
import dev.tomwmth.citreforged.pack.format.PropertyValue;
import java.util.Locale;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;

public class ConditionNBT
extends CITCondition {
    public static final CITConditionContainer<ConditionNBT> CONTAINER = new CITConditionContainer<ConditionNBT>(ConditionNBT.class, ConditionNBT::new, "nbt");
    protected String[] path;
    protected StringMatcher matchString = null;
    protected IntTag matchInteger = null;
    protected ByteTag matchByte = null;
    protected FloatTag matchFloat = null;
    protected DoubleTag matchDouble = null;
    protected LongTag matchLong = null;
    protected ShortTag matchShort = null;
    protected CompoundTag matchCompound = null;

    @Override
    public void load(PropertyValue value, PropertyGroup properties) throws CITParsingException {
        if (value.keyMetadata() == null || value.keyMetadata().isEmpty()) {
            throw new CITParsingException("Missing nbt path", properties, value.position());
        }
        for (String s : this.path = value.keyMetadata().split("\\.")) {
            if (!s.isEmpty()) continue;
            throw new CITParsingException("Path segment cannot be empty", properties, value.position());
        }
        try {
            this.matchString = value.value().startsWith("regex:") ? new StringMatcher.RegexMatcher(value.value().substring(6)) : (value.value().startsWith("iregex:") ? new StringMatcher.IRegexMatcher(value.value().substring(7)) : (value.value().startsWith("pattern:") ? new StringMatcher.PatternMatcher(value.value().substring(8)) : (value.value().startsWith("ipattern:") ? new StringMatcher.IPatternMatcher(value.value().substring(9)) : new StringMatcher.DirectMatcher(value.value()))));
        }
        catch (PatternSyntaxException e) {
            throw new CITParsingException("Malformatted regex expression", properties, value.position(), e);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.matchInteger = value.value().startsWith("#") ? IntTag.m_128679_((int)Integer.parseInt(value.value().substring(1).toLowerCase(Locale.ENGLISH), 16)) : (value.value().startsWith("0x") ? IntTag.m_128679_((int)Integer.parseInt(value.value().substring(2).toLowerCase(Locale.ENGLISH), 16)) : IntTag.m_128679_((int)Integer.parseInt(value.value())));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.matchByte = ByteTag.m_128266_((byte)Byte.parseByte(value.value()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.matchFloat = FloatTag.m_128566_((float)Float.parseFloat(value.value()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.matchDouble = DoubleTag.m_128500_((double)Double.parseDouble(value.value()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.matchLong = LongTag.m_128882_((long)Long.parseLong(value.value()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.matchShort = ShortTag.m_129258_((short)Short.parseShort(value.value()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.matchCompound = TagParser.m_129359_((String)value.value());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean test(CITContext context) {
        return this.testPath((Tag)context.stack.m_41783_(), 0);
    }

    protected boolean testPath(Tag element, int pathIndex) {
        if (element == null) {
            return false;
        }
        if (pathIndex >= this.path.length) {
            return this.testValue(element);
        }
        String path = this.path[pathIndex];
        if (path.equals("*")) {
            if (element instanceof CompoundTag) {
                CompoundTag compound = (CompoundTag)element;
                for (Tag subElement : compound.f_128329_.values()) {
                    if (!this.testPath(subElement, pathIndex + 1)) continue;
                    return true;
                }
            } else if (element instanceof ListTag) {
                ListTag list = (ListTag)element;
                for (Tag subElement : list) {
                    if (!this.testPath(subElement, pathIndex + 1)) continue;
                    return true;
                }
            }
        } else {
            if (element instanceof CompoundTag) {
                CompoundTag compound = (CompoundTag)element;
                return this.testPath(compound.m_128423_(path), pathIndex + 1);
            }
            if (element instanceof ListTag) {
                ListTag list = (ListTag)element;
                if (path.equals("count")) {
                    return this.testValue((Tag)IntTag.m_128679_((int)list.size()));
                }
                try {
                    return this.testPath(list.get(Integer.parseInt(path)), pathIndex + 1);
                }
                catch (IndexOutOfBoundsException | NumberFormatException runtimeException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    private boolean testValue(Tag element) {
        try {
            if (element instanceof StringTag) {
                StringTag nbtString = (StringTag)element;
                String elementString = nbtString.m_7916_();
                if (this.matchString.matches(elementString)) {
                    return true;
                }
                for (int i = 0; i < elementString.length(); ++i) {
                    char ch = elementString.charAt(i);
                    if (Character.isWhitespace(ch)) continue;
                    return this.matchString.matches(nbtString.m_7916_()) || this.matchString.matches(Component.Serializer.m_130701_((String)nbtString.m_7916_()).getString());
                }
            } else {
                if (element instanceof IntTag) {
                    IntTag nbtInt = (IntTag)element;
                    if (this.matchInteger != null) {
                        return nbtInt.equals((Object)this.matchInteger);
                    }
                }
                if (element instanceof ByteTag) {
                    ByteTag nbtByte = (ByteTag)element;
                    if (this.matchByte != null) {
                        return nbtByte.equals((Object)this.matchByte);
                    }
                }
                if (element instanceof FloatTag) {
                    FloatTag nbtFloat = (FloatTag)element;
                    if (this.matchFloat != null) {
                        return nbtFloat.equals((Object)this.matchFloat);
                    }
                }
                if (element instanceof DoubleTag) {
                    DoubleTag nbtDouble = (DoubleTag)element;
                    if (this.matchDouble != null) {
                        return nbtDouble.equals((Object)this.matchDouble);
                    }
                }
                if (element instanceof LongTag) {
                    LongTag nbtLong = (LongTag)element;
                    if (this.matchLong != null) {
                        return nbtLong.equals((Object)this.matchLong);
                    }
                }
                if (element instanceof ShortTag) {
                    ShortTag nbtShort = (ShortTag)element;
                    if (this.matchShort != null) {
                        return nbtShort.equals((Object)this.matchShort);
                    }
                }
                if (element instanceof CompoundTag) {
                    CompoundTag nbtCompound = (CompoundTag)element;
                    if (this.matchCompound != null) {
                        return NbtUtils.m_129235_((Tag)this.matchCompound, (Tag)nbtCompound, (boolean)true);
                    }
                }
            }
            if (element instanceof NumericTag) {
                NumericTag nbtNumber = (NumericTag)element;
                if (!(this.matchString instanceof StringMatcher.DirectMatcher)) {
                    return this.matchString.matches(String.valueOf(nbtNumber.m_8103_()));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    protected static abstract class StringMatcher {
        protected StringMatcher() {
        }

        public abstract boolean matches(String var1);

        public static class IPatternMatcher
        extends PatternMatcher {
            public IPatternMatcher(String pattern) {
                super(pattern.toLowerCase(Locale.ROOT));
            }

            @Override
            protected boolean charsEqual(char p, char v) {
                return p == v || p == Character.toLowerCase(v);
            }
        }

        public static class IRegexMatcher
        extends RegexMatcher {
            public IRegexMatcher(String pattern) {
                super(Pattern.compile(pattern, 66));
            }
        }

        public static class PatternMatcher
        extends StringMatcher {
            protected final String pattern;

            public PatternMatcher(String pattern) {
                this.pattern = pattern;
            }

            @Override
            public boolean matches(String value) {
                return this.matchesPattern(value, this.pattern, 0, value.length(), 0, this.pattern.length());
            }

            protected boolean matchesPattern(String value, String pattern, int curV, int maxV, int curG, int maxG) {
                while (curG < maxG) {
                    char g = pattern.charAt(curG);
                    if (g == '*') {
                        while (true) {
                            if (this.matchesPattern(value, pattern, curV, maxV, curG + 1, maxG)) {
                                return true;
                            }
                            if (curV >= maxV) break;
                            ++curV;
                        }
                        return false;
                    }
                    if (curV >= maxV) break;
                    if (g != '?') {
                        if (g == '\\' && curG + 1 < maxG) {
                            g = pattern.charAt(++curG);
                        }
                        if (!this.charsEqual(g, value.charAt(curV))) {
                            return false;
                        }
                    }
                    ++curG;
                    ++curV;
                }
                return curG == maxG && curV == maxV;
            }

            protected boolean charsEqual(char p, char v) {
                return p == v;
            }
        }

        public static class RegexMatcher
        extends StringMatcher {
            protected final Pattern pattern;

            public RegexMatcher(String pattern) {
                this(Pattern.compile(pattern));
            }

            protected RegexMatcher(Pattern pattern) {
                this.pattern = pattern;
            }

            @Override
            public boolean matches(String value) {
                return this.pattern.matcher(value).matches();
            }
        }

        public static class DirectMatcher
        extends StringMatcher {
            protected final String pattern;

            public DirectMatcher(String pattern) {
                this.pattern = pattern;
            }

            @Override
            public boolean matches(String value) {
                return this.pattern.equals(value);
            }
        }
    }
}

