/*
 * Decompiled with CFR 0.152.
 */
package dev.tomwmth.citreforged.cit;

import dev.tomwmth.citreforged.CITRegistrarImpl;
import dev.tomwmth.citreforged.api.CITDisposable;
import dev.tomwmth.citreforged.api.CITTypeContainer;
import dev.tomwmth.citreforged.cit.CIT;
import dev.tomwmth.citreforged.cit.CITRegistry;
import dev.tomwmth.citreforged.cit.CITType;
import dev.tomwmth.citreforged.cit.builtin.conditions.core.FallbackCondition;
import dev.tomwmth.citreforged.cit.builtin.conditions.core.WeightCondition;
import dev.tomwmth.citreforged.config.CITResewnConfig;
import dev.tomwmth.citreforged.pack.GlobalProperties;
import dev.tomwmth.citreforged.pack.PackParser;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;

public class ActiveCITs {
    private static ActiveCITs active = null;
    public final GlobalProperties globalProperties = new GlobalProperties();
    public final Map<Class<? extends CITType>, List<CIT<?>>> cits = new IdentityHashMap();

    private ActiveCITs() {
    }

    public static ActiveCITs getActive() {
        return active;
    }

    public static boolean isActive() {
        return active != null;
    }

    public static void load(ResourceManager resourceManager, ProfilerFiller profiler) {
        profiler.m_6180_("citresewn:disposing");
        for (CITDisposable cITDisposable : CITRegistrarImpl.getDisposables()) {
            cITDisposable.dispose();
        }
        for (CITTypeContainer cITTypeContainer : CITRegistry.TYPES.values()) {
            cITTypeContainer.unload();
        }
        if (active != null) {
            ActiveCITs.active.globalProperties.properties.replaceAll((key, value) -> Set.of());
            ActiveCITs.active.globalProperties.callHandlers();
            active = null;
        }
        if (!CITResewnConfig.INSTANCE.enabled) {
            profiler.m_7238_();
            return;
        }
        ActiveCITs active = new ActiveCITs();
        profiler.m_6182_("citresewn:load_global_properties");
        PackParser.loadGlobalProperties(resourceManager, active.globalProperties).callHandlers();
        profiler.m_6182_("citresewn:load_cits");
        List<CIT<?>> list = PackParser.parseCITs(resourceManager);
        FallbackCondition.apply(list);
        for (CIT<?> cIT : list) {
            active.cits.computeIfAbsent(cIT.type.getClass(), type -> new ArrayList()).add(cIT);
        }
        block3: for (Map.Entry entry : active.cits.entrySet()) {
            WeightCondition.apply((List)entry.getValue());
            for (CITTypeContainer<? extends CITType> typeContainer : CITRegistry.TYPES.values()) {
                if (typeContainer.type != entry.getKey()) continue;
                typeContainer.loadUntyped((List)entry.getValue());
                continue block3;
            }
        }
        profiler.m_7238_();
        if (!list.isEmpty()) {
            ActiveCITs.active = active;
        }
    }
}

