/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.registry;

import dev.architectury.registry.level.entity.EntityAttributeRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.HashSet;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.satisfy.vinery.core.Vinery;
import net.satisfy.vinery.core.block.entity.ApplePressBlockEntity;
import net.satisfy.vinery.core.block.entity.BasketBlockEntity;
import net.satisfy.vinery.core.block.entity.CabinetBlockEntity;
import net.satisfy.vinery.core.block.entity.CompletionistBannerEntity;
import net.satisfy.vinery.core.block.entity.FermentationBarrelBlockEntity;
import net.satisfy.vinery.core.block.entity.FlowerPotBlockEntity;
import net.satisfy.vinery.core.block.entity.LatticeBlockEntity;
import net.satisfy.vinery.core.block.entity.ModHangingSignBlockEntity;
import net.satisfy.vinery.core.block.entity.ModSignBlockEntity;
import net.satisfy.vinery.core.block.entity.StorageBlockEntity;
import net.satisfy.vinery.core.entity.ChairEntity;
import net.satisfy.vinery.core.entity.DarkCherryBoatEntity;
import net.satisfy.vinery.core.entity.DarkCherryChestBoatEntity;
import net.satisfy.vinery.core.entity.TraderMuleEntity;
import net.satisfy.vinery.core.entity.WanderingWinemakerEntity;
import net.satisfy.vinery.core.registry.ObjectRegistry;
import net.satisfy.vinery.core.registry.StorageTypeRegistry;
import net.satisfy.vinery.platform.PlatformHelper;

public class EntityTypeRegistry {
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((String)"vinery", (ResourceKey)Registries.f_256922_);
    private static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((String)"vinery", (ResourceKey)Registries.f_256939_);
    public static final RegistrySupplier<BlockEntityType<ModSignBlockEntity>> MOD_SIGN = BLOCK_ENTITY_TYPES.register("mod_sign", () -> BlockEntityType.Builder.m_155273_(ModSignBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.DARK_CHERRY_SIGN.get(), (Block)ObjectRegistry.DARK_CHERRY_WALL_SIGN.get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<ModHangingSignBlockEntity>> MOD_HANGING_SIGN = BLOCK_ENTITY_TYPES.register("mod_hanging_sign", () -> BlockEntityType.Builder.m_155273_(ModHangingSignBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.DARK_CHERRY_HANGING_SIGN.get(), (Block)ObjectRegistry.DARK_CHERRY_WALL_HANGING_SIGN.get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<StorageBlockEntity>> STORAGE_ENTITY = EntityTypeRegistry.registerBlockEntity("storage", () -> BlockEntityType.Builder.m_155273_(StorageBlockEntity::new, (Block[])StorageTypeRegistry.registerBlocks(new HashSet<Block>()).toArray(new Block[0])).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<FlowerPotBlockEntity>> FLOWER_POT_ENTITY = EntityTypeRegistry.registerBlockEntity("flower_pot", () -> BlockEntityType.Builder.m_155273_(FlowerPotBlockEntity::new, (Block[])StorageTypeRegistry.registerBlocks(new HashSet<Block>()).toArray(new Block[0])).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<CabinetBlockEntity>> CABINET_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("cabinet", () -> BlockEntityType.Builder.m_155273_(CabinetBlockEntity::new, (Block[])StorageTypeRegistry.registerBlocks(new HashSet<Block>()).toArray(new Block[0])).m_58966_(null));
    public static final Supplier<EntityType<DarkCherryBoatEntity>> DARK_CHERRY_BOAT = PlatformHelper.registerBoatType("dark_cherry_boat", DarkCherryBoatEntity::new, MobCategory.MISC, 1.375f, 0.5625f, 10);
    public static final Supplier<EntityType<DarkCherryChestBoatEntity>> DARK_CHERRY_CHEST_BOAT = PlatformHelper.registerBoatType("dark_cherry_chest_boat", DarkCherryChestBoatEntity::new, MobCategory.MISC, 1.375f, 0.5625f, 10);
    public static final RegistrySupplier<BlockEntityType<ApplePressBlockEntity>> APPLE_PRESS_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("apple_press", () -> BlockEntityType.Builder.m_155273_(ApplePressBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.APPLE_PRESS.get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<FermentationBarrelBlockEntity>> FERMENTATION_BARREL_ENTITY = EntityTypeRegistry.registerBlockEntity("fermentation_barrel", () -> BlockEntityType.Builder.m_155273_(FermentationBarrelBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.FERMENTATION_BARREL.get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<BasketBlockEntity>> BASKET_ENTITY = EntityTypeRegistry.registerBlockEntity("basket", () -> BlockEntityType.Builder.m_155273_(BasketBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.BASKET.get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<CompletionistBannerEntity>> VINERY_STANDARD = EntityTypeRegistry.registerBlockEntity("vinery_standard", () -> BlockEntityType.Builder.m_155273_(CompletionistBannerEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.VINERY_STANDARD.get(), (Block)ObjectRegistry.VINERY_WALL_STANDARD.get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<LatticeBlockEntity>> LATTICE = EntityTypeRegistry.registerBlockEntity("lattice", () -> BlockEntityType.Builder.m_155273_(LatticeBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.OAK_LATTICE.get(), (Block)ObjectRegistry.SPRUCE_LATTICE.get(), (Block)ObjectRegistry.CHERRY_LATTICE.get(), (Block)ObjectRegistry.BIRCH_LATTICE.get(), (Block)ObjectRegistry.DARK_OAK_LATTICE.get(), (Block)ObjectRegistry.ACACIA_LATTICE.get(), (Block)ObjectRegistry.BAMBOO_LATTICE.get(), (Block)ObjectRegistry.JUNGLE_LATTICE.get(), (Block)ObjectRegistry.MANGROVE_LATTICE.get(), (Block)ObjectRegistry.DARK_CHERRY_LATTICE.get()}).m_58966_(null));
    public static final RegistrySupplier<EntityType<TraderMuleEntity>> MULE = EntityTypeRegistry.registerEntity("mule", () -> EntityType.Builder.m_20704_(TraderMuleEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.9f, 1.87f).m_20702_(10).m_20712_(Vinery.identifier("mule").toString()));
    public static final RegistrySupplier<EntityType<WanderingWinemakerEntity>> WANDERING_WINEMAKER = EntityTypeRegistry.registerEntity("wandering_winemaker", () -> EntityType.Builder.m_20704_(WanderingWinemakerEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.6f, 1.95f).m_20702_(10).m_20712_(Vinery.identifier("wandering_winemaker").toString()));
    public static final RegistrySupplier<EntityType<ChairEntity>> CHAIR = EntityTypeRegistry.registerEntity("chair", () -> EntityType.Builder.m_20704_(ChairEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.001f, 0.001f).m_20712_(Vinery.identifier("chair").toString()));

    public static <T extends EntityType<?>> RegistrySupplier<T> registerEntity(String path, Supplier<T> type) {
        return ENTITY_TYPES.register(Vinery.identifier(path), type);
    }

    private static <T extends BlockEntityType<?>> RegistrySupplier<T> registerBlockEntity(String path, Supplier<T> type) {
        return BLOCK_ENTITY_TYPES.register(Vinery.identifier(path), type);
    }

    static void registerAttributes() {
        EntityAttributeRegistry.register(MULE, () -> Llama.m_30824_().m_22268_(Attributes.f_22279_, (double)0.2f));
        EntityAttributeRegistry.register(WANDERING_WINEMAKER, () -> Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.5).m_22268_(Attributes.f_22277_, 16.0));
    }

    public static void init() {
        ENTITY_TYPES.register();
        BLOCK_ENTITY_TYPES.register();
        EntityTypeRegistry.registerAttributes();
    }
}

