/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.core.registry.blocks;

import com.codinglitch.simpleradio.SimpleRadioLibrary;
import com.codinglitch.simpleradio.api.central.Listening;
import com.codinglitch.simpleradio.api.central.WorldlyPosition;
import com.codinglitch.simpleradio.client.ClientRadioManager;
import com.codinglitch.simpleradio.core.registry.SimpleRadioBlockEntities;
import com.codinglitch.simpleradio.core.registry.SimpleRadioBlocks;
import com.codinglitch.simpleradio.core.registry.SimpleRadioSounds;
import com.codinglitch.simpleradio.core.registry.blocks.AuditoryBlockEntity;
import com.codinglitch.simpleradio.platform.Services;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class MicrophoneBlockEntity
extends AuditoryBlockEntity
implements Listening {
    public boolean isActive = false;
    private boolean listening = true;
    public float tilt = 1.5f;
    public float currentTilt = this.tilt - 1.5f;

    public MicrophoneBlockEntity(BlockPos pos, BlockState state) {
        super(SimpleRadioBlockEntities.MICROPHONE, pos, state);
    }

    public void m_7651_() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_ && this.listener != null) {
            this.f_58857_.m_6263_(null, (double)this.listener.location.x, (double)this.listener.location.y, (double)this.listener.location.z, SimpleRadioSounds.RADIO_CLOSE, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        this.inactivate();
        super.m_7651_();
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.loadTag(tag);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        this.saveTag(tag);
        super.m_183515_(tag);
    }

    public void m_187476_(ItemStack stack) {
        this.saveTag(stack.m_41784_());
        super.m_187476_(stack);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, MicrophoneBlockEntity blockEntity) {
        if (!blockEntity.isActive && blockEntity.id != null) {
            blockEntity.activate();
        }
        if (blockEntity.f_58857_ == null) {
            return;
        }
        if (blockEntity.listener != null && blockEntity.listener.activityTime >= 0) {
            if (blockEntity.listener.activityTime % SimpleRadioLibrary.SERVER_CONFIG.microphone.redstonePolling == 0) {
                level.m_46672_(pos, (Block)SimpleRadioBlocks.MICROPHONE);
            }
            if (SimpleRadioLibrary.CLIENT_CONFIG.speaker.particleInterval != 0 && blockEntity.f_58857_.f_46443_ && blockEntity.listener.activityTime % SimpleRadioLibrary.CLIENT_CONFIG.microphone.particleInterval == 0) {
                ClientRadioManager.handleListenParticle(state, blockEntity);
            }
        }
    }

    public boolean isListening() {
        return this.listening;
    }

    public void setListening(boolean listening) {
        this.listening = listening;
        if (this.listener != null) {
            this.listener.active = this.listening;
        }
    }

    public void inactivate() {
        if (this.isActive) {
            this.stopListening();
        }
        this.isActive = false;
    }

    public void activate() {
        WorldlyPosition location = Services.COMPAT.modifyPosition(WorldlyPosition.of(this.f_58858_, this.f_58857_, this.f_58858_));
        this.listener = SimpleRadioBlocks.MICROPHONE.getOrCreateListener(location, this.id, this.m_58900_());
        this.listener.active = this.listening;
        if (!this.f_58857_.f_46443_) {
            this.f_58857_.m_6263_(null, (double)location.x, (double)location.y, (double)location.z, SimpleRadioSounds.RADIO_OPEN, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        this.isActive = true;
    }

    @Override
    public void loadTag(CompoundTag tag) {
        this.inactivate();
        super.loadTag(tag);
        if (tag.m_128441_("tilt")) {
            this.tilt = tag.m_128457_("tilt");
        }
        if (tag.m_128441_("listening")) {
            this.setListening(tag.m_128471_("listening"));
        }
    }

    @Override
    public void saveTag(CompoundTag tag) {
        super.saveTag(tag);
        tag.m_128350_("tilt", this.tilt);
        tag.m_128379_("listening", this.listening);
    }

    @Override
    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }
}

