/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.core.registry.blocks;

import com.codinglitch.simpleradio.SimpleRadioLibrary;
import com.codinglitch.simpleradio.api.central.Listening;
import com.codinglitch.simpleradio.api.central.Routing;
import com.codinglitch.simpleradio.api.central.WorldlyPosition;
import com.codinglitch.simpleradio.core.registry.SimpleRadioBlockEntities;
import com.codinglitch.simpleradio.core.registry.SimpleRadioSounds;
import com.codinglitch.simpleradio.core.registry.blocks.MicrophoneBlockEntity;
import com.codinglitch.simpleradio.core.registry.blocks.RadioBlockEntity;
import com.codinglitch.simpleradio.radio.RadioListener;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import org.joml.Vector3f;

public class MicrophoneBlock
extends BaseEntityBlock
implements Routing,
Listening {
    public static final int MAX_ROTATION_INDEX = RotationSegment.m_247348_();
    private static final int MAX_ROTATIONS = MAX_ROTATION_INDEX + 1;
    public static final IntegerProperty ROTATION = BlockStateProperties.f_61390_;
    private static final VoxelShape SHAPE = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0);

    public MicrophoneBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(0)));
    }

    public float getYRotationDegrees(BlockState state) {
        return RotationSegment.m_245107_((int)((Integer)state.m_61143_((Property)ROTATION)));
    }

    @Override
    public RadioListener getOrCreateListener(WorldlyPosition location, UUID id, BlockState state) {
        RadioListener listener = this.startListening(location, id);
        listener.range = SimpleRadioLibrary.SERVER_CONFIG.microphone.listeningRange.intValue();
        float rotation = Math.toRadians((float)(this.getYRotationDegrees(state) - 90.0f));
        Vector3f normal = new Vector3f(Math.cos((float)rotation), 0.0f, Math.sin((float)rotation));
        listener.connectionOffset = new Vec3((double)(normal.x * 0.1f), (double)-0.2f, (double)(normal.z * 0.1f));
        listener.allowDistribution();
        return listener;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        super.m_7926_(stateBuilder.m_61104_(new Property[]{ROTATION}));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(RotationSegment.m_246374_((float)(context.m_7074_() + 180.0f))));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(rotation.m_55949_(((Integer)state.m_61143_((Property)ROTATION)).intValue(), MAX_ROTATIONS)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return (BlockState)state.m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(mirror.m_54843_(((Integer)state.m_61143_((Property)ROTATION)).intValue(), MAX_ROTATIONS)));
    }

    public boolean m_7278_(BlockState $$0) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof MicrophoneBlockEntity) {
            MicrophoneBlockEntity microphone = (MicrophoneBlockEntity)blockEntity;
            if (microphone.listener != null) {
                return microphone.listener.getRedstoneMappedActivity();
            }
        }
        return 0;
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        ItemStack stack = new ItemStack((ItemLike)this);
        BlockEntity blockEntity = (BlockEntity)builder.m_287159_(LootContextParams.f_81462_);
        if (blockEntity instanceof RadioBlockEntity) {
            RadioBlockEntity radioBlockEntity = (RadioBlockEntity)blockEntity;
            radioBlockEntity.m_187476_(stack);
        }
        return List.of(stack);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof MicrophoneBlockEntity) {
            MicrophoneBlockEntity mic = (MicrophoneBlockEntity)blockEntity;
            if (player.m_6047_()) {
                mic.tilt = (mic.tilt + 0.1f) % 3.0f;
                if (!level.f_46443_) {
                    level.m_5594_(null, mic.m_58899_(), SimpleRadioSounds.TILT_MICROPHONE, SoundSource.BLOCKS, 0.1f, 0.9f + level.f_46441_.m_188501_() * 0.2f);
                }
                return InteractionResult.SUCCESS;
            }
            mic.setListening(!mic.isListening());
            if (!level.f_46443_) {
                float pitch = mic.isListening() ? 1.1f : 0.9f;
                level.m_5594_(null, mic.m_58899_(), SimpleRadioSounds.PRESS_MICROPHONE, SoundSource.BLOCKS, 0.4f, pitch + level.f_46441_.m_188501_() * 0.1f);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, level, pos, player, hand, result);
    }

    public void m_6402_(Level level, BlockPos blockPos, BlockState blockState, @Nullable LivingEntity entity, ItemStack stack) {
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (blockEntity instanceof MicrophoneBlockEntity) {
            MicrophoneBlockEntity microphoneBlockEntity = (MicrophoneBlockEntity)blockEntity;
            microphoneBlockEntity.loadFromItem(stack);
        }
        super.m_6402_(level, blockPos, blockState, entity, stack);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new MicrophoneBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return MicrophoneBlock.m_152132_(type, SimpleRadioBlockEntities.MICROPHONE, MicrophoneBlockEntity::tick);
    }
}

