/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.compat.create;

import com.codinglitch.simpleradio.api.central.WorldlyPosition;
import com.codinglitch.simpleradio.client.ClientRadioManager;
import com.codinglitch.simpleradio.compat.create.CentralMovementBehaviour;
import com.codinglitch.simpleradio.core.registry.SimpleRadioBlocks;
import com.codinglitch.simpleradio.core.registry.blocks.AuditoryBlockEntity;
import com.codinglitch.simpleradio.core.registry.blocks.InsulatorBlockEntity;
import com.codinglitch.simpleradio.core.registry.blocks.RadiosmitherBlock;
import com.codinglitch.simpleradio.platform.Services;
import com.codinglitch.simpleradio.radio.RadioManager;
import com.codinglitch.simpleradio.radio.RadioRouter;
import com.simibubi.create.api.behaviour.movement.MovementBehaviour;
import com.simibubi.create.api.contraption.BlockMovementChecks;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class CreateCompat {
    public static List<Block> CENTRAL_BLOCKS;

    public static void postInitialize() {
        BlockMovementChecks.registerAttachedCheck((state, level, pos, direction) -> {
            if (state.m_60713_((Block)SimpleRadioBlocks.RADIOSMITHER)) {
                Direction facing = (Direction)state.m_61143_((Property)RadiosmitherBlock.FACING);
                facing = state.m_61143_(RadiosmitherBlock.RADIOSMITHER_PART) == RadiosmitherBlock.RadiosmitherPart.MAIN ? facing.m_122428_() : facing.m_122427_();
                return BlockMovementChecks.CheckResult.of((direction == facing ? 1 : 0) != 0);
            }
            return BlockMovementChecks.CheckResult.PASS;
        });
        CENTRAL_BLOCKS = List.of(SimpleRadioBlocks.RADIO, SimpleRadioBlocks.SPEAKER, SimpleRadioBlocks.MICROPHONE, SimpleRadioBlocks.RECEIVER, SimpleRadioBlocks.TRANSMITTER, SimpleRadioBlocks.INSULATOR);
    }

    public static void contraptionAddBlock(Contraption contraption, BlockPos pos, BlockEntity blockEntity, StructureTemplate.StructureBlockInfo info) {
        if (blockEntity instanceof AuditoryBlockEntity) {
            AuditoryBlockEntity centralBlockEntity = (AuditoryBlockEntity)blockEntity;
            centralBlockEntity.receiver = null;
            centralBlockEntity.transmitter = null;
            centralBlockEntity.speaker = null;
            centralBlockEntity.listener = null;
        } else if (blockEntity instanceof InsulatorBlockEntity) {
            InsulatorBlockEntity insulatorBlockEntity = (InsulatorBlockEntity)blockEntity;
            insulatorBlockEntity.router = null;
        }
    }

    private static void resetRouter(RadioRouter router, BlockPos pos, Level level) {
        if (router == null) {
            return;
        }
        router.owner = null;
        router.location = Services.COMPAT.modifyPosition(WorldlyPosition.of(pos, level, pos));
    }

    public static void contraptionRemoveBlock(Contraption contraption, Level level, BlockPos pos, BlockState state, CompoundTag tag) {
        if (tag.m_128441_("uuid")) {
            UUID uuid = tag.m_128342_("uuid");
            if (level.f_46443_) {
                CreateCompat.resetRouter(ClientRadioManager.getReceiver(uuid), pos, level);
                CreateCompat.resetRouter(ClientRadioManager.getTransmitter(uuid), pos, level);
                CreateCompat.resetRouter(ClientRadioManager.getListener(uuid), pos, level);
                CreateCompat.resetRouter(ClientRadioManager.getSpeaker(uuid), pos, level);
                CreateCompat.resetRouter(ClientRadioManager.getRouter(uuid, null), pos, level);
            } else {
                CreateCompat.resetRouter(RadioRouter.getRouterFromReceivers(uuid), pos, level);
                CreateCompat.resetRouter(RadioRouter.getRouterFromTransmitters(uuid), pos, level);
                CreateCompat.resetRouter(RadioManager.getListener(uuid), pos, level);
                CreateCompat.resetRouter(RadioManager.getSpeaker(uuid), pos, level);
                CreateCompat.resetRouter(RadioManager.getRouter(uuid, null), pos, level);
            }
        }
    }

    public static void registerMovementBehaviours() {
        for (Block centralBlock : CENTRAL_BLOCKS) {
            if (MovementBehaviour.REGISTRY.get((Object)centralBlock) != null) continue;
            MovementBehaviour.REGISTRY.register((Object)centralBlock, (Object)new CentralMovementBehaviour());
        }
    }

    public static RadioManager.CollectionResult verifyContraptionCollection(Entity entity) {
        if (entity instanceof AbstractContraptionEntity) {
            AbstractContraptionEntity contraptionEntity = (AbstractContraptionEntity)entity;
            if (contraptionEntity.m_213877_()) {
                return RadioManager.CollectionResult.COLLECT;
            }
            Contraption contraption = contraptionEntity.getContraption();
            if (contraption != null) {
                return contraption.disassembled ? RadioManager.CollectionResult.COLLECT : RadioManager.CollectionResult.IGNORE;
            }
            return RadioManager.CollectionResult.COLLECT;
        }
        return RadioManager.CollectionResult.PASS;
    }
}

