/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.client.core.registry.renderers;

import com.codinglitch.simpleradio.client.ClientRadioManager;
import com.codinglitch.simpleradio.client.core.registry.models.InsulatorModel;
import com.codinglitch.simpleradio.core.registry.blocks.InsulatorBlock;
import com.codinglitch.simpleradio.core.registry.blocks.InsulatorBlockEntity;
import com.codinglitch.simpleradio.radio.RadioRouter;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.Math;

public class InsulatorRenderer
implements BlockEntityRenderer<InsulatorBlockEntity> {
    private InsulatorModel model;

    public InsulatorRenderer(BlockEntityRendererProvider.Context context) {
        this.model = new InsulatorModel(context.m_173582_(InsulatorModel.LAYER_LOCATION));
    }

    public void render(InsulatorBlockEntity blockEntity, float tickDelta, PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay) {
        BlockState state = blockEntity.m_58900_();
        Block block = state.m_60734_();
        if (block instanceof InsulatorBlock) {
            InsulatorBlock insulatorBlock = (InsulatorBlock)block;
            if (blockEntity.id != null) {
                poseStack.m_85836_();
                poseStack.m_252880_(0.5f, 0.5f, 0.5f);
                Direction facing = (Direction)state.m_61143_((Property)InsulatorBlock.FACING);
                poseStack.m_252781_(facing.m_253075_());
                poseStack.m_252880_(0.0f, 1.0f, 0.0f);
                poseStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
                poseStack.m_252781_(Axis.f_252436_.m_252977_((Boolean)state.m_61143_((Property)InsulatorBlock.ROTATED) != false ? 90.0f : 0.0f));
                float rotation = 0.5f;
                if (blockEntity.connector != null) {
                    Vec3 pos = blockEntity.m_58899_().m_252807_();
                    rotation = (float)(3.0 + blockEntity.connector.m_20275_(pos.f_82479_, pos.f_82480_, pos.f_82481_) * 0.5);
                }
                blockEntity.rotation = Math.lerp((float)blockEntity.rotation, (float)rotation, (float)Math.min((float)(Minecraft.m_91087_().m_91297_() * 0.2f), (float)1.0f));
                this.model.wire.f_104207_ = !blockEntity.getWires().isEmpty() || blockEntity.connector != null;
                this.model.spool.f_104203_ = blockEntity.rotation;
                RadioRouter router = ClientRadioManager.getRouter(blockEntity.id);
                if (router != null) {
                    // empty if block
                }
                VertexConsumer vertexConsumer = bufferSource.m_6299_(this.model.m_103119_(InsulatorModel.TEXTURE_LOCATION));
                this.model.m_7695_(poseStack, vertexConsumer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                poseStack.m_85849_();
            }
        }
    }
}

