/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.network.message;

import com.mrcrayfish.framework.api.network.MessageContext;
import com.mrcrayfish.framework.api.network.message.PlayMessage;
import com.mrcrayfish.framework.network.message.IMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import top.ribs.scguns.client.screen.ExoSuitMenu;
import top.ribs.scguns.common.exosuit.ExoSuitData;
import top.ribs.scguns.item.animated.ExoSuitItem;
import top.ribs.scguns.network.PacketHandler;
import top.ribs.scguns.network.message.S2CMessageSyncExoSuitUpgrades;

public class C2SMessageSaveExoSuitUpgrades
extends PlayMessage<C2SMessageSaveExoSuitUpgrades> {
    private List<ItemStack> upgradeStacks;

    public C2SMessageSaveExoSuitUpgrades() {
        this.upgradeStacks = new ArrayList<ItemStack>();
    }

    public C2SMessageSaveExoSuitUpgrades(List<ItemStack> upgradeStacks) {
        this.upgradeStacks = upgradeStacks != null ? upgradeStacks : new ArrayList();
    }

    public void encode(C2SMessageSaveExoSuitUpgrades message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.upgradeStacks.size());
        for (ItemStack stack : message.upgradeStacks) {
            buffer.m_130055_(stack);
        }
    }

    public C2SMessageSaveExoSuitUpgrades decode(FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < size; ++i) {
            stacks.add(buffer.m_130267_());
        }
        return new C2SMessageSaveExoSuitUpgrades(stacks);
    }

    public void handle(C2SMessageSaveExoSuitUpgrades message, MessageContext context) {
        context.execute(() -> {
            Item patt2205$temp;
            ExoSuitMenu menu;
            ItemStack menuArmorPiece;
            AbstractContainerMenu patt2034$temp;
            ServerPlayer serverPlayer = context.getPlayer();
            if (serverPlayer != null && (patt2034$temp = serverPlayer.f_36096_) instanceof ExoSuitMenu && !(menuArmorPiece = (menu = (ExoSuitMenu)patt2034$temp).getArmorPiece()).m_41619_() && (patt2205$temp = menuArmorPiece.m_41720_()) instanceof ExoSuitItem) {
                ExoSuitItem exoSuit = (ExoSuitItem)patt2205$temp;
                CompoundTag upgradeData = C2SMessageSaveExoSuitUpgrades.createUpgradeData(message);
                ExoSuitData.setUpgradeData(menuArmorPiece, upgradeData);
                EquipmentSlot armorSlot = this.getEquipmentSlotForArmorType(exoSuit.m_266204_());
                ItemStack equippedPiece = serverPlayer.m_6844_(armorSlot);
                if (!equippedPiece.m_41619_() && equippedPiece.m_41720_() instanceof ExoSuitItem && ItemStack.m_150942_((ItemStack)menuArmorPiece, (ItemStack)equippedPiece)) {
                    ExoSuitData.setUpgradeData(equippedPiece, upgradeData);
                    serverPlayer.m_8061_(armorSlot, equippedPiece);
                    List playersToSync = serverPlayer.m_284548_().m_45976_(ServerPlayer.class, serverPlayer.m_20191_().m_82400_(128.0));
                    if (!playersToSync.contains(serverPlayer)) {
                        playersToSync.add(serverPlayer);
                    }
                    for (ServerPlayer nearbyPlayer : playersToSync) {
                        PacketHandler.getPlayChannel().sendToPlayer(() -> nearbyPlayer, (IMessage)new S2CMessageSyncExoSuitUpgrades(serverPlayer.m_20148_(), armorSlot, upgradeData));
                    }
                }
            }
        });
        context.setHandled(true);
    }

    @NotNull
    private static CompoundTag createUpgradeData(C2SMessageSaveExoSuitUpgrades message) {
        CompoundTag upgradeData = new CompoundTag();
        ListTag upgradeList = new ListTag();
        for (int i = 0; i < message.upgradeStacks.size(); ++i) {
            ItemStack upgradeStack = message.upgradeStacks.get(i);
            if (upgradeStack.m_41619_()) continue;
            CompoundTag slotTag = new CompoundTag();
            slotTag.m_128405_("Slot", i);
            CompoundTag itemTag = new CompoundTag();
            upgradeStack.m_41739_(itemTag);
            slotTag.m_128365_("Item", (Tag)itemTag);
            upgradeList.add((Object)slotTag);
        }
        upgradeData.m_128365_("Upgrades", (Tag)upgradeList);
        return upgradeData;
    }

    private EquipmentSlot getEquipmentSlotForArmorType(ArmorItem.Type armorType) {
        return switch (armorType) {
            default -> throw new IncompatibleClassChangeError();
            case ArmorItem.Type.HELMET -> EquipmentSlot.HEAD;
            case ArmorItem.Type.CHESTPLATE -> EquipmentSlot.CHEST;
            case ArmorItem.Type.LEGGINGS -> EquipmentSlot.LEGS;
            case ArmorItem.Type.BOOTS -> EquipmentSlot.FEET;
        };
    }
}

