/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.item.animated;

import com.mrcrayfish.framework.network.message.IMessage;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.cache.AnimatableIdCache;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.keyframe.event.ParticleKeyframeEvent;
import software.bernie.geckolib.core.keyframe.event.SoundKeyframeEvent;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.ClientUtils;
import top.ribs.scguns.Config;
import top.ribs.scguns.animations.GunAnimations;
import top.ribs.scguns.attributes.SCAttributes;
import top.ribs.scguns.client.KeyBinds;
import top.ribs.scguns.client.handler.AimingHandler;
import top.ribs.scguns.client.handler.MeleeAttackHandler;
import top.ribs.scguns.client.render.gun.animated.AnimatedGunRenderer;
import top.ribs.scguns.client.util.GunRotationHandler;
import top.ribs.scguns.common.Gun;
import top.ribs.scguns.common.ReloadType;
import top.ribs.scguns.event.GunEventBus;
import top.ribs.scguns.init.ModSounds;
import top.ribs.scguns.init.ModSyncedDataKeys;
import top.ribs.scguns.item.GunItem;
import top.ribs.scguns.item.animated.AnimatedDualWieldGunItem;
import top.ribs.scguns.network.PacketHandler;
import top.ribs.scguns.network.message.C2SMessageEjectCasing;
import top.ribs.scguns.network.message.C2SMessageGunLoaded;
import top.ribs.scguns.network.message.C2SMessageReload;
import top.ribs.scguns.util.GunEnchantmentHelper;
import top.ribs.scguns.util.GunModifierHelper;

public class AnimatedGunItem
extends GunItem
implements GeoAnimatable,
GeoItem {
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private final String gunID;
    private final SoundEvent reloadSoundMagOut;
    private final SoundEvent reloadSoundMagIn;
    private final SoundEvent reloadSoundEnd;
    private final SoundEvent boltPullSound;
    private final SoundEvent boltReleaseSound;
    private int drawTick = 0;
    private static final String RELOAD_START_TIME = "reloadStartTime";
    public static final String RELOAD_STATE = "scguns:ReloadState";
    private final GunRotationHandler rotationHandler = new GunRotationHandler();

    public GunRotationHandler getRotationHandler() {
        return this.rotationHandler;
    }

    public AnimatedGunItem(Item.Properties properties, String path, SoundEvent reloadSoundMagOut, SoundEvent reloadSoundMagIn, SoundEvent reloadSoundEnd, SoundEvent boltPullSound, SoundEvent boltReleaseSound) {
        super(properties);
        this.gunID = path;
        this.reloadSoundMagOut = reloadSoundMagOut;
        this.reloadSoundMagIn = reloadSoundMagIn;
        this.reloadSoundEnd = reloadSoundEnd;
        this.boltPullSound = boltPullSound;
        this.boltReleaseSound = boltReleaseSound;
    }

    public boolean isInCarbineMode(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof GunItem) {
            GunItem gunItem = (GunItem)item;
            return gunItem.isOneHandedCarbineCandidate(stack) && (Gun.hasExtendedBarrel(stack) || Gun.hasStock(stack));
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void updateCarbineState(ItemStack stack, AnimationController<GeoAnimatable> controller) {
        String currentAnim;
        boolean isCurrentCarbine;
        boolean isCarbine = this.isInCarbineMode(stack);
        if (isCarbine != (isCurrentCarbine = (currentAnim = controller.getCurrentAnimation() != null ? controller.getCurrentAnimation().animation().name() : "").startsWith("carbine_"))) {
            controller.forceAnimationReset();
            controller.tryTriggerAnimation(isCarbine ? "carbine_idle" : "idle");
        }
    }

    public void m_6883_(@NotNull ItemStack stack, @NotNull Level world, @NotNull Entity entity, int slot, boolean selected) {
        CompoundTag nbtCompound;
        if (entity instanceof ItemEntity) {
            CompoundTag tag = stack.m_41784_();
            this.cleanupReloadState(tag);
            tag.m_128473_("IsShooting");
            tag.m_128473_("IsInspecting");
            tag.m_128473_("IsAiming");
            tag.m_128473_("IsRunning");
            tag.m_128473_("IsDrawn");
            tag.m_128473_("IsDrawing");
            tag.m_128473_("DrawnTick");
            tag.m_128473_("loaded");
            tag.m_128473_("shouldStopOnLoopEnd");
            tag.m_128473_("shouldTransitionToStop");
            tag.m_128473_("MagazinePosition");
            tag.m_128473_("MagazineOverride");
            tag.m_128473_("scguns:MagazineTracking");
            tag.m_128473_("_InitializedThisSession");
            tag.m_128379_("IsDroppedItem", true);
            if (world.m_5776_()) {
                tag.m_128471_("WasReloadingLastTick");
                boolean isReloading = tag.m_128471_("scguns:IsReloading");
                tag.m_128379_("WasReloadingLastTick", isReloading);
                this.clientInventoryTick(stack, entity, slot, selected);
            }
            return;
        }
        CompoundTag tag = stack.m_41784_();
        tag.m_128473_("IsDroppedItem");
        ItemStack mainHand = null;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            mainHand = player.m_21205_();
            boolean isCurrentlyHeld = mainHand == stack || GeoItem.getId((ItemStack)mainHand) == GeoItem.getId((ItemStack)stack);
            boolean wasHeld = tag.m_128471_("WasHeldLastTick");
            if (isCurrentlyHeld && !wasHeld) {
                tag.m_128473_("_InitializedThisSession");
                tag.m_128473_("IsDrawn");
                tag.m_128473_("DrawnTick");
            }
            tag.m_128379_("WasHeldLastTick", isCurrentlyHeld);
        }
        if (world.m_5776_()) {
            this.clientInventoryTick(stack, entity, slot, selected);
        }
        if (!(nbtCompound = stack.m_41784_()).m_128425_("GeckoLibID", 99) && world instanceof ServerLevel) {
            nbtCompound.m_128356_("GeckoLibID", AnimatableIdCache.getFreeId((ServerLevel)((ServerLevel)world)));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void clientInventoryTick(ItemStack stack, Entity entity, int slot, boolean selected) {
        CompoundTag nbtCompound = stack.m_41784_();
        this.handleReloadStateSynchronization(stack, entity, nbtCompound);
        this.handleAnimationControllerUpdates(stack, entity, nbtCompound);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.handlePlayerSpecificLogic(stack, player, nbtCompound);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void handleReloadStateSynchronization(ItemStack stack, Entity entity, CompoundTag nbtCompound) {
        long lastCleanup;
        boolean currentReloading = nbtCompound.m_128471_("scguns:IsReloading");
        boolean serverReloading = entity instanceof Player ? (Boolean)ModSyncedDataKeys.RELOADING.getValue((Entity)((Player)entity)) : false;
        String currentReloadState = nbtCompound.m_128461_(RELOAD_STATE);
        boolean inCriticalPhase = nbtCompound.m_128471_("InCriticalReloadPhase");
        Gun modifiedGun = ((GunItem)stack.m_41720_()).getModifiedGun(stack);
        boolean isManualReload = modifiedGun.getReloads().getReloadType() == ReloadType.MANUAL;
        long currentTime = System.currentTimeMillis();
        if (currentReloading && inCriticalPhase && !isManualReload) {
            long reloadStartTime = nbtCompound.m_128454_("ReloadStartTime");
            if (reloadStartTime == 0L) {
                nbtCompound.m_128356_("ReloadStartTime", currentTime);
                reloadStartTime = currentTime;
            }
            if (currentTime - reloadStartTime > 10000L) {
                this.cleanupReloadState(nbtCompound);
                nbtCompound.m_128473_("InCriticalReloadPhase");
                nbtCompound.m_128473_("ReloadStartTime");
                nbtCompound.m_128473_("ReloadAnimationStarted");
                nbtCompound.m_128473_("ReloadAnimationRestarted");
                nbtCompound.m_128473_("ReloadCompleted");
                if (entity instanceof Player) {
                    ModSyncedDataKeys.RELOADING.setValue((Entity)((Player)entity), (Object)false);
                }
                return;
            }
        } else {
            nbtCompound.m_128473_("ReloadStartTime");
        }
        if (!serverReloading && inCriticalPhase && !isManualReload) {
            this.cleanupReloadState(nbtCompound);
            nbtCompound.m_128473_("InCriticalReloadPhase");
            nbtCompound.m_128473_("ReloadStartTime");
            nbtCompound.m_128473_("ReloadAnimationStarted");
            nbtCompound.m_128473_("ReloadAnimationRestarted");
            nbtCompound.m_128473_("ReloadCompleted");
            return;
        }
        if (!isManualReload) {
            if (currentReloadState.equals("STOPPING") || currentReloadState.equals("LOADING") || currentReloadState.equals("STARTING")) {
                nbtCompound.m_128473_(RELOAD_STATE);
            }
            if (serverReloading && !currentReloading) {
                nbtCompound.m_128379_("scguns:IsReloading", true);
                nbtCompound.m_128473_(RELOAD_STATE);
                nbtCompound.m_128356_("ReloadStartTime", currentTime);
            } else if (!serverReloading && currentReloading) {
                nbtCompound.m_128473_("scguns:IsReloading");
                this.cleanupReloadState(nbtCompound);
                nbtCompound.m_128473_("InCriticalReloadPhase");
                nbtCompound.m_128473_("ReloadStartTime");
                nbtCompound.m_128473_("ReloadAnimationStarted");
                nbtCompound.m_128473_("ReloadAnimationRestarted");
                nbtCompound.m_128473_("ReloadCompleted");
            }
            return;
        }
        boolean isInTransitionState = currentReloadState.equals("STOPPING") || nbtCompound.m_128471_("scguns:IsPlayingReloadStop");
        boolean playerTryingToAim = false;
        if (entity instanceof Player) {
            playerTryingToAim = KeyBinds.getAimMapping().m_90857_();
        }
        if (serverReloading && !currentReloading && !isInTransitionState) {
            nbtCompound.m_128379_("scguns:IsReloading", true);
            if (!nbtCompound.m_128441_(RELOAD_STATE)) {
                nbtCompound.m_128359_(RELOAD_STATE, ReloadState.NONE.name());
            }
        } else if (!serverReloading && currentReloading && !isInTransitionState) {
            nbtCompound.m_128359_(RELOAD_STATE, ReloadState.STOPPING.name());
            nbtCompound.m_128379_("scguns:IsPlayingReloadStop", true);
        } else if (!serverReloading && isInTransitionState && !playerTryingToAim && currentTime - (lastCleanup = nbtCompound.m_128454_("LastCleanupTime")) > 50L) {
            nbtCompound.m_128356_("LastCleanupTime", currentTime);
            this.finishReloadTransition(nbtCompound);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void handleAnimationControllerUpdates(ItemStack stack, Entity entity, CompoundTag nbtCompound) {
        long id = GeoItem.getId((ItemStack)stack);
        AnimationController animationController = (AnimationController)this.getAnimatableInstanceCache().getManagerForId(id).getAnimationControllers().get("controller");
        this.rotationHandler.updateRotations(Minecraft.m_91087_().getPartialTick());
        if (nbtCompound.m_128471_("AttachmentChanged")) {
            if (animationController != null) {
                this.updateCarbineState(stack, (AnimationController<GeoAnimatable>)animationController);
            }
            nbtCompound.m_128473_("AttachmentChanged");
        }
        boolean inCriticalPhase = nbtCompound.m_128471_("InCriticalReloadPhase");
        boolean isReloading = nbtCompound.m_128471_("scguns:IsReloading");
        if (!(animationController == null || isReloading || inCriticalPhase || this.isAnimationPlaying((AnimationController<GeoAnimatable>)animationController, "draw") || this.isAnimationPlaying((AnimationController<GeoAnimatable>)animationController, "carbine_draw") || this.isAnimationPlaying((AnimationController<GeoAnimatable>)animationController, "shoot") || this.isAnimationPlaying((AnimationController<GeoAnimatable>)animationController, "shoot1") || this.isAnimationPlaying((AnimationController<GeoAnimatable>)animationController, "carbine_shoot") || this.isAnimationPlaying((AnimationController<GeoAnimatable>)animationController, "inspect") || this.isAnimationPlaying((AnimationController<GeoAnimatable>)animationController, "carbine_inspect") || this.isAnimationPlaying((AnimationController<GeoAnimatable>)animationController, "reload") || this.isAnimationPlaying((AnimationController<GeoAnimatable>)animationController, "carbine_reload") || this.isAnimationPlaying((AnimationController<GeoAnimatable>)animationController, "reload_start") || this.isAnimationPlaying((AnimationController<GeoAnimatable>)animationController, "carbine_reload_start") || this.isAnimationPlaying((AnimationController<GeoAnimatable>)animationController, "reload_loop") || this.isAnimationPlaying((AnimationController<GeoAnimatable>)animationController, "carbine_reload_loop") || this.isAnimationPlaying((AnimationController<GeoAnimatable>)animationController, "reload_stop") || this.isAnimationPlaying((AnimationController<GeoAnimatable>)animationController, "carbine_reload_stop"))) {
            this.updateCarbineState(stack, (AnimationController<GeoAnimatable>)animationController);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void handlePlayerSpecificLogic(ItemStack stack, Player player, CompoundTag nbtCompound) {
        long id = GeoItem.getId((ItemStack)stack);
        AnimationController animationController = (AnimationController)this.getAnimatableInstanceCache().getManagerForId(id).getAnimationControllers().get("controller");
        if (GeoItem.getId((ItemStack)player.m_21205_()) != id) {
            this.handleItemNotHeld(nbtCompound, (AnimationController<GeoAnimatable>)animationController, stack, player);
            return;
        }
        this.handleDrawingState(nbtCompound);
        this.handleActionStates(nbtCompound, (AnimationController<GeoAnimatable>)animationController, stack, player);
        this.handlePlayerStateUpdates(nbtCompound, player, stack);
        this.handleInitializationAndAnimations(nbtCompound, (AnimationController<GeoAnimatable>)animationController, stack, player);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void handleItemNotHeld(CompoundTag nbtCompound, AnimationController<GeoAnimatable> animationController, ItemStack stack, Player player) {
        if (nbtCompound.m_128471_("IsDrawn")) {
            nbtCompound.m_128473_("IsDrawn");
            nbtCompound.m_128473_("DrawnTick");
            this.drawTick = 0;
            this.cleanupAllReloadTags(nbtCompound);
            ModSyncedDataKeys.RELOADING.setValue((Entity)player, (Object)false);
            nbtCompound.m_128473_("IsShooting");
            nbtCompound.m_128473_("IsInspecting");
            nbtCompound.m_128473_("IsAiming");
            nbtCompound.m_128473_("IsRunning");
            nbtCompound.m_128473_("loaded");
            nbtCompound.m_128473_("DrawnTick");
        }
        animationController.setAnimationSpeed(1.0);
        animationController.forceAnimationReset();
        if (this.isInCarbineMode(stack)) {
            animationController.tryTriggerAnimation("carbine_idle");
        } else {
            animationController.tryTriggerAnimation("idle");
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void handleDrawingState(CompoundTag nbtCompound) {
        this.updateBooleanTag(nbtCompound, "IsDrawing", nbtCompound.m_128471_("IsDrawn"));
        if (nbtCompound.m_128471_("IsDrawing") && nbtCompound.m_128451_("DrawnTick") < 15) {
            ++this.drawTick;
            nbtCompound.m_128405_("DrawnTick", this.drawTick);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void handleActionStates(CompoundTag nbtCompound, AnimationController<GeoAnimatable> animationController, ItemStack stack, Player player) {
        Gun modifiedGun;
        boolean isMeleeActive = (Boolean)ModSyncedDataKeys.MELEE.getValue((Entity)player);
        if (isMeleeActive && (modifiedGun = ((GunItem)stack.m_41720_()).getModifiedGun(stack)).getGeneral().usesCustomMeleeAnimation()) {
            this.handleMeleeState(nbtCompound, animationController, stack, player);
            return;
        }
        if (nbtCompound.m_128471_("IsShooting")) {
            this.handleShootState(nbtCompound, animationController, stack);
        }
        if (nbtCompound.m_128471_("IsInspecting")) {
            this.handleInspectState(animationController, stack);
        }
        if (MeleeAttackHandler.isBanzaiActive() && (this.isAnimationPlaying(animationController, "inspect") || this.isAnimationPlaying(animationController, "carbine_inspect"))) {
            animationController.setAnimationSpeed(1.0);
            if (this.isInCarbineMode(stack)) {
                animationController.tryTriggerAnimation("carbine_idle");
            } else {
                animationController.tryTriggerAnimation("idle");
            }
        }
        if (player.m_20142_() && (this.isAnimationPlaying(animationController, "inspect") || this.isAnimationPlaying(animationController, "carbine_inspect"))) {
            animationController.setAnimationSpeed(1.0);
            if (this.isInCarbineMode(stack)) {
                animationController.tryTriggerAnimation("carbine_idle");
            } else {
                animationController.tryTriggerAnimation("idle");
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void handlePlayerStateUpdates(CompoundTag nbtCompound, Player player, ItemStack stack) {
        if (!nbtCompound.m_128471_("IsDrawn")) {
            nbtCompound.m_128379_("IsDrawn", true);
        }
        boolean isSprinting = player.m_20142_();
        boolean isAiming = (Boolean)ModSyncedDataKeys.AIMING.getValue((Entity)player);
        boolean serverReloading = (Boolean)ModSyncedDataKeys.RELOADING.getValue((Entity)player);
        boolean clientReloading = nbtCompound.m_128471_("scguns:IsReloading");
        if (serverReloading || clientReloading) {
            if (isAiming) {
                ModSyncedDataKeys.AIMING.setValue((Entity)player, (Object)false);
            }
            this.updateBooleanTag(nbtCompound, "IsAiming", false);
            this.updateBooleanTag(nbtCompound, "IsRunning", isSprinting);
            return;
        }
        if (isAiming && nbtCompound.m_128471_("IsDrawing") && nbtCompound.m_128451_("DrawnTick") < 15) {
            ModSyncedDataKeys.AIMING.setValue((Entity)player, (Object)false);
            isAiming = false;
        }
        this.updateBooleanTag(nbtCompound, "IsAiming", isAiming);
        this.updateBooleanTag(nbtCompound, "IsRunning", isSprinting);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void handleInitializationAndAnimations(CompoundTag nbtCompound, AnimationController<GeoAnimatable> animationController, ItemStack stack, Player player) {
        Gun modifiedGun;
        boolean isFirstTick;
        boolean wasDrawn = nbtCompound.m_128471_("IsDrawn");
        boolean bl = isFirstTick = !wasDrawn && !nbtCompound.m_128471_("_InitializedThisSession");
        if (isFirstTick) {
            this.handleFirstTickInitialization(nbtCompound, animationController, stack, player);
            return;
        }
        boolean isMeleeActive = (Boolean)ModSyncedDataKeys.MELEE.getValue((Entity)player);
        if (isMeleeActive && (modifiedGun = ((GunItem)stack.m_41720_()).getModifiedGun(stack)).getGeneral().usesCustomMeleeAnimation()) {
            return;
        }
        this.handleAnimationStateFixes(nbtCompound, animationController, stack, player);
        this.handleMainAnimationLogic(nbtCompound, animationController, stack, player);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void handleMeleeState(CompoundTag nbt, AnimationController<GeoAnimatable> animationController, ItemStack stack, Player player) {
        long startTime;
        String meleeAnimToPlay;
        Gun modifiedGun = ((GunItem)stack.m_41720_()).getModifiedGun(stack);
        boolean isCarbine = this.isInCarbineMode(stack);
        boolean hasBayonet = ((GunItem)stack.m_41720_()).hasBayonet(stack);
        if (hasBayonet) {
            meleeAnimToPlay = isCarbine ? "carbine_bayonet" : "bayonet";
        } else {
            String string = meleeAnimToPlay = isCarbine ? "carbine_melee" : "melee";
        }
        if (!this.isAnimationPlaying(animationController, meleeAnimToPlay)) {
            animationController.setAnimationSpeed(1.0);
            animationController.forceAnimationReset();
            animationController.tryTriggerAnimation(meleeAnimToPlay);
            nbt.m_128356_("CustomMeleeStartTime", System.currentTimeMillis());
        }
        if ((startTime = nbt.m_128454_("CustomMeleeStartTime")) > 0L && (float)(System.currentTimeMillis() - startTime) >= 400.0f) {
            nbt.m_128473_("CustomMeleeStartTime");
            ModSyncedDataKeys.MELEE.setValue((Entity)player, (Object)false);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void handleFirstTickInitialization(CompoundTag nbtCompound, AnimationController<GeoAnimatable> animationController, ItemStack stack, Player player) {
        ModSyncedDataKeys.RELOADING.getValue((Entity)player);
        nbtCompound.m_128379_("_InitializedThisSession", true);
        if (!nbtCompound.m_128471_("IsDrawn")) {
            nbtCompound.m_128379_("IsDrawn", true);
            nbtCompound.m_128405_("DrawnTick", 0);
            this.drawTick = 0;
        }
        if (animationController != null) {
            boolean isCurrentlyReloading;
            boolean hasNoAnimation = animationController.getCurrentAnimation() == null;
            boolean isStopped = animationController.getAnimationState() == AnimationController.State.STOPPED;
            boolean bl = isCurrentlyReloading = nbtCompound.m_128471_("scguns:IsReloading") || (Boolean)ModSyncedDataKeys.RELOADING.getValue((Entity)player) != false;
            if ((hasNoAnimation || isStopped) && !isCurrentlyReloading && nbtCompound.m_128451_("DrawnTick") >= 15) {
                animationController.setAnimationSpeed(1.0);
                this.updateCarbineState(stack, animationController);
                if (this.isInCarbineMode(stack)) {
                    animationController.tryTriggerAnimation("carbine_idle");
                } else {
                    animationController.tryTriggerAnimation("idle");
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void handleAnimationStateFixes(CompoundTag nbtCompound, AnimationController<GeoAnimatable> animationController, ItemStack stack, Player player) {
        if (animationController != null) {
            Gun modifiedGun;
            boolean hasNoAnimation = animationController.getCurrentAnimation() == null;
            boolean isStopped = animationController.getAnimationState() == AnimationController.State.STOPPED;
            boolean isMeleeActive = (Boolean)ModSyncedDataKeys.MELEE.getValue((Entity)player);
            if (isMeleeActive && (modifiedGun = ((GunItem)stack.m_41720_()).getModifiedGun(stack)).getGeneral().usesCustomMeleeAnimation()) {
                return;
            }
            if ((hasNoAnimation || isStopped) && !nbtCompound.m_128471_("scguns:IsReloading") && nbtCompound.m_128451_("DrawnTick") >= 15) {
                animationController.setAnimationSpeed(1.0);
                this.updateCarbineState(stack, animationController);
                if (this.isInCarbineMode(stack)) {
                    animationController.tryTriggerAnimation("carbine_idle");
                } else {
                    animationController.tryTriggerAnimation("idle");
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void handleMainAnimationLogic(CompoundTag nbtCompound, AnimationController<GeoAnimatable> animationController, ItemStack stack, Player player) {
        if (nbtCompound.m_128471_("IsDrawing") && nbtCompound.m_128451_("DrawnTick") < 15 && ((Boolean)Config.COMMON.gameplay.drawAnimation.get()).booleanValue()) {
            this.handleDrawingState(nbtCompound, animationController, stack);
            return;
        }
        if (nbtCompound.m_128451_("DrawnTick") >= 15) {
            assert (animationController != null);
            boolean isReloading = nbtCompound.m_128471_("scguns:IsReloading") || (Boolean)ModSyncedDataKeys.RELOADING.getValue((Entity)player) != false;
            boolean inCriticalPhase = nbtCompound.m_128471_("InCriticalReloadPhase");
            if (isReloading) {
                this.handleReloadingState(nbtCompound, animationController, stack);
                return;
            }
            if (inCriticalPhase) {
                return;
            }
            if (this.isPlayingCriticalAnimations(animationController)) {
                if (nbtCompound.m_128441_(RELOAD_STATE) && nbtCompound.m_128461_(RELOAD_STATE).equals(ReloadState.STOPPING.name())) {
                    this.handleReloadingState(nbtCompound, animationController, stack);
                } else if (nbtCompound.m_128471_("IsAiming")) {
                    this.handleAimingState(nbtCompound, animationController);
                } else if (nbtCompound.m_128471_("IsRunning") && this.isPlayingInspectOrReloadAnimations(animationController)) {
                    this.handleRunningState(animationController);
                } else if (this.isPlayingInspectOrReloadAnimations(animationController)) {
                    animationController.setAnimationSpeed(1.0);
                    if (this.isInCarbineMode(stack)) {
                        animationController.tryTriggerAnimation("carbine_idle");
                    } else {
                        animationController.tryTriggerAnimation("idle");
                    }
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private boolean isPlayingCriticalAnimations(AnimationController<GeoAnimatable> animationController) {
        return !this.isAnimationPlaying(animationController, "draw") && !this.isAnimationPlaying(animationController, "carbine_draw") && !this.isAnimationPlaying(animationController, "jam") && !this.isAnimationPlaying(animationController, "melee") && !this.isAnimationPlaying(animationController, "carbine_melee") && !this.isAnimationPlaying(animationController, "bayonet") && !this.isAnimationPlaying(animationController, "carbine_bayonet") && !this.isAnimationPlaying(animationController, "shoot") && !this.isAnimationPlaying(animationController, "shoot1") && !this.isAnimationPlaying(animationController, "carbine_shoot") && !this.isAnimationPlaying(animationController, "aim_shoot") && !this.isAnimationPlaying(animationController, "aim_shoot1") && !this.isAnimationPlaying(animationController, "carbine_aim_shoot") && !this.isAnimationPlaying(animationController, "inspect") && !this.isAnimationPlaying(animationController, "carbine_inspect") && !this.isAnimationPlaying(animationController, "reload_stop") && !this.isAnimationPlaying(animationController, "carbine_reload_stop");
    }

    @OnlyIn(value=Dist.CLIENT)
    private boolean isPlayingInspectOrReloadAnimations(AnimationController<GeoAnimatable> animationController) {
        return !this.isAnimationPlaying(animationController, "inspect") && !this.isAnimationPlaying(animationController, "carbine_inspect") && !this.isAnimationPlaying(animationController, "reload") && !this.isAnimationPlaying(animationController, "carbine_reload") && !this.isAnimationPlaying(animationController, "reload_alt") && !this.isAnimationPlaying(animationController, "carbine_reload_loop") && !this.isAnimationPlaying(animationController, "reload_loop");
    }

    @OnlyIn(value=Dist.CLIENT)
    private void finishReloadTransition(CompoundTag nbt) {
        nbt.m_128473_("scguns:IsReloading");
        nbt.m_128473_("scguns:IsPlayingReloadStop");
        nbt.m_128473_("scguns:ReloadComplete");
        nbt.m_128473_("IsManualReload");
        nbt.m_128473_("InReloadLoop");
        nbt.m_128473_("PendingStopTransition");
        nbt.m_128473_("PendingStopTime");
        nbt.m_128473_("LastReloadStateChange");
        nbt.m_128473_("ManualReloadInitialized");
        nbt.m_128473_("InCriticalReloadPhase");
        String currentState = nbt.m_128461_(RELOAD_STATE);
        if (currentState.equals("STOPPING")) {
            this.cleanupReloadState(nbt);
        }
    }

    private void cleanupAllReloadTags(CompoundTag nbt) {
        this.cleanupReloadState(nbt);
        nbt.m_128473_("IsMagReload");
        nbt.m_128473_("IsManualReload");
        nbt.m_128473_("shouldStopOnLoopEnd");
        nbt.m_128473_("shouldTransitionToStop");
    }

    public boolean isAnimationPlaying(AnimationController<GeoAnimatable> animationController, String animationName) {
        return animationController.getCurrentAnimation() != null && animationController.getCurrentAnimation().animation().name().equals(animationName);
    }

    private void updateBooleanTag(CompoundTag nbt, String key, boolean value) {
        if (value) {
            nbt.m_128379_(key, true);
        } else {
            nbt.m_128473_(key);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void handleDrawingState(CompoundTag nbt, AnimationController<GeoAnimatable> animationController, ItemStack stack) {
        int lightweightLevel;
        double drawSpeedMultiplier = 1.0;
        int quickHandsLevel = GunEnchantmentHelper.getQuickHands(stack);
        if (quickHandsLevel > 0) {
            drawSpeedMultiplier += 0.12 * (double)quickHandsLevel;
        }
        if ((lightweightLevel = GunEnchantmentHelper.getLightweight(stack)) > 0) {
            drawSpeedMultiplier += 0.05 * (double)lightweightLevel;
        }
        drawSpeedMultiplier = GunModifierHelper.getModifiedDrawSpeed(stack, drawSpeedMultiplier);
        animationController.setAnimationSpeed(drawSpeedMultiplier);
        if (nbt.m_128451_("DrawnTick") < 15 && !nbt.m_128471_("scguns:IsReloading") && this.isPlayingCriticalAnimations(animationController)) {
            if (this.isInCarbineMode(stack)) {
                animationController.tryTriggerAnimation("carbine_draw");
            } else {
                animationController.tryTriggerAnimation("draw");
            }
        }
        nbt.m_128473_("IsShooting");
        nbt.m_128473_("IsInspecting");
    }

    @OnlyIn(value=Dist.CLIENT)
    private void handleNormalReload(CompoundTag nbt, AnimationController<GeoAnimatable> animationController, ItemStack stack) {
        String reloadAnim;
        Gun modifiedGun = ((GunItem)stack.m_41720_()).getModifiedGun(stack);
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        boolean serverReloading = (Boolean)ModSyncedDataKeys.RELOADING.getValue((Entity)player);
        String currentAnim = animationController.getCurrentAnimation() != null ? animationController.getCurrentAnimation().animation().name() : "none";
        AnimationController.State animState = animationController.getAnimationState();
        if (!serverReloading) {
            animationController.setAnimationSpeed(1.0);
            this.cleanupReloadState(nbt);
            nbt.m_128473_("InCriticalReloadPhase");
            nbt.m_128473_("ReloadAnimationStarted");
            nbt.m_128473_("ReloadAnimationRestarted");
            nbt.m_128473_("ReloadCompleted");
            return;
        }
        boolean isCarbine = this.isInCarbineMode(stack);
        String string = reloadAnim = isCarbine ? "carbine_reload" : "reload";
        if (nbt.m_128471_("ReloadCompleted")) {
            animationController.setAnimationSpeed(1.0);
            return;
        }
        double reloadSpeedMultiplier = 1.0;
        AttributeInstance reloadSpeedAttribute = player.m_21051_((Attribute)SCAttributes.RELOAD_SPEED.get());
        if (reloadSpeedAttribute != null) {
            reloadSpeedMultiplier = reloadSpeedAttribute.m_22135_();
        }
        int actualReloadTime = (int)Math.ceil((double)GunEnchantmentHelper.getRealReloadSpeed(stack) / reloadSpeedMultiplier);
        float speedMultiplier = (float)modifiedGun.getReloads().getReloadTimer() / (float)actualReloadTime;
        boolean hasStartedReload = nbt.m_128471_("ReloadAnimationStarted");
        if (!(this.isAnimationPlaying(animationController, reloadAnim) || hasStartedReload || this.isAnimationPlaying(animationController, "draw") || this.isAnimationPlaying(animationController, "carbine_draw"))) {
            animationController.setAnimationSpeed((double)speedMultiplier);
            animationController.forceAnimationReset();
            animationController.tryTriggerAnimation(reloadAnim);
            nbt.m_128379_("ReloadAnimationStarted", true);
            return;
        }
        if (this.isAnimationPlaying(animationController, reloadAnim)) {
            animationController.setAnimationSpeed((double)speedMultiplier);
        }
        if (!this.isAnimationPlaying(animationController, reloadAnim) && hasStartedReload && animState == AnimationController.State.STOPPED && !nbt.m_128471_("ReloadAnimationRestarted")) {
            animationController.setAnimationSpeed((double)speedMultiplier);
            animationController.forceAnimationReset();
            animationController.tryTriggerAnimation(reloadAnim);
            nbt.m_128379_("ReloadAnimationRestarted", true);
            return;
        }
        if (animationController.getAnimationState() == AnimationController.State.STOPPED && hasStartedReload && !this.isAnimationPlaying(animationController, reloadAnim) && !this.isAnimationPlaying(animationController, "draw") && !this.isAnimationPlaying(animationController, "carbine_draw")) {
            animationController.setAnimationSpeed(1.0);
            if (modifiedGun.getReloads().getReloadType() == ReloadType.MAG_FED) {
                PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageGunLoaded());
            } else if (modifiedGun.getReloads().getReloadType() == ReloadType.SINGLE_ITEM) {
                PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageReload(false));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void handleReloadingState(CompoundTag nbt, AnimationController<GeoAnimatable> animationController, ItemStack stack) {
        ReloadState state;
        int maxAmmo;
        AttributeInstance reloadSpeedAttribute;
        long lastStateChange;
        Gun modifiedGun = ((GunItem)stack.m_41720_()).getModifiedGun(stack);
        String currentState = nbt.m_128461_(RELOAD_STATE);
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        if (((Boolean)ModSyncedDataKeys.AIMING.getValue((Entity)player)).booleanValue()) {
            ModSyncedDataKeys.AIMING.setValue((Entity)player, (Object)false);
            AimingHandler.get().aiming = false;
        }
        boolean serverReloading = (Boolean)ModSyncedDataKeys.RELOADING.getValue((Entity)player);
        boolean clientReloading = nbt.m_128471_("scguns:IsReloading");
        if (modifiedGun.getReloads().getReloadType() != ReloadType.MANUAL) {
            this.handleNormalReload(nbt, animationController, stack);
            return;
        }
        if (!serverReloading && clientReloading && !currentState.equals("STOPPING")) {
            nbt.m_128359_(RELOAD_STATE, ReloadState.STOPPING.name());
            nbt.m_128379_("scguns:IsPlayingReloadStop", true);
            nbt.m_128473_("scguns:IsReloading");
            animationController.stop();
            animationController.setAnimationSpeed(1.0);
            animationController.tryTriggerAnimation(this.isInCarbineMode(stack) ? "carbine_reload_stop" : "reload_stop");
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - (lastStateChange = nbt.m_128454_("LastReloadStateChange")) < 0L) {
            return;
        }
        double reloadSpeedMultiplier = 1.0;
        if (Minecraft.m_91087_().f_91074_ != null && (reloadSpeedAttribute = Minecraft.m_91087_().f_91074_.m_21051_((Attribute)SCAttributes.RELOAD_SPEED.get())) != null) {
            reloadSpeedMultiplier = reloadSpeedAttribute.m_22135_();
        }
        int actualReloadTime = (int)Math.ceil((double)GunEnchantmentHelper.getRealReloadSpeed(stack) / reloadSpeedMultiplier);
        float speedMultiplier = (float)modifiedGun.getReloads().getReloadTimer() / (float)actualReloadTime;
        CompoundTag tag = stack.m_41784_();
        int currentAmmo = tag.m_128451_("AmmoCount");
        boolean ammoFull = currentAmmo >= (maxAmmo = GunModifierHelper.getModifiedAmmoCapacity(stack, modifiedGun));
        boolean hasNoAmmo = Gun.findAmmo((Player)player, modifiedGun.getProjectile().getItem()).stack().m_41619_();
        if (currentState.isEmpty() || currentState.equals("NONE")) {
            currentState = ReloadState.NONE.name();
            nbt.m_128359_(RELOAD_STATE, currentState);
        }
        try {
            state = ReloadState.valueOf(currentState);
        }
        catch (IllegalArgumentException e) {
            state = ReloadState.NONE;
            nbt.m_128359_(RELOAD_STATE, ReloadState.NONE.name());
        }
        switch (state) {
            case NONE: {
                nbt.m_128359_(RELOAD_STATE, ReloadState.STARTING.name());
                nbt.m_128356_("LastReloadStateChange", currentTime);
                nbt.m_128379_("ManualReloadInitialized", true);
                animationController.setAnimationSpeed((double)speedMultiplier);
                animationController.tryTriggerAnimation(this.isInCarbineMode(stack) ? "carbine_reload_start" : "reload_start");
                break;
            }
            case STARTING: {
                boolean isStartAnimPlaying;
                boolean bl = isStartAnimPlaying = this.isAnimationPlaying(animationController, "reload_start") || this.isAnimationPlaying(animationController, "carbine_reload_start");
                if (isStartAnimPlaying || animationController.getAnimationState() != AnimationController.State.STOPPED) break;
                if (ammoFull || hasNoAmmo || !((Boolean)ModSyncedDataKeys.RELOADING.getValue((Entity)player)).booleanValue()) {
                    nbt.m_128359_(RELOAD_STATE, ReloadState.STOPPING.name());
                    nbt.m_128379_("scguns:IsPlayingReloadStop", true);
                    animationController.setAnimationSpeed(1.0);
                    animationController.tryTriggerAnimation(this.isInCarbineMode(stack) ? "carbine_reload_stop" : "reload_stop");
                    break;
                }
                nbt.m_128359_(RELOAD_STATE, ReloadState.LOADING.name());
                nbt.m_128356_("LastReloadStateChange", currentTime);
                nbt.m_128379_("InReloadLoop", true);
                animationController.setAnimationSpeed((double)speedMultiplier);
                animationController.tryTriggerAnimation(this.isInCarbineMode(stack) ? "carbine_reload_loop" : "reload_loop");
                break;
            }
            case LOADING: {
                boolean shouldStopAfterLoop;
                boolean isLoopPlaying = this.isAnimationPlaying(animationController, "reload_loop") || this.isAnimationPlaying(animationController, "carbine_reload_loop");
                boolean bl = shouldStopAfterLoop = ammoFull || hasNoAmmo || (Boolean)ModSyncedDataKeys.RELOADING.getValue((Entity)player) == false;
                if (shouldStopAfterLoop) {
                    long pendingTime;
                    if (!nbt.m_128471_("PendingStopTransition")) {
                        nbt.m_128379_("PendingStopTransition", true);
                        nbt.m_128356_("PendingStopTime", System.currentTimeMillis());
                    }
                    if (isLoopPlaying || animationController.getAnimationState() != AnimationController.State.STOPPED || (pendingTime = System.currentTimeMillis() - nbt.m_128454_("PendingStopTime")) <= 100L) break;
                    nbt.m_128359_(RELOAD_STATE, ReloadState.STOPPING.name());
                    nbt.m_128379_("scguns:IsPlayingReloadStop", true);
                    nbt.m_128473_("InReloadLoop");
                    nbt.m_128473_("PendingStopTransition");
                    nbt.m_128473_("PendingStopTime");
                    animationController.setAnimationSpeed(1.0);
                    animationController.tryTriggerAnimation(this.isInCarbineMode(stack) ? "carbine_reload_stop" : "reload_stop");
                    break;
                }
                nbt.m_128473_("PendingStopTransition");
                nbt.m_128473_("PendingStopTime");
                if (isLoopPlaying || animationController.getAnimationState() != AnimationController.State.STOPPED) break;
                animationController.setAnimationSpeed((double)speedMultiplier);
                animationController.tryTriggerAnimation(this.isInCarbineMode(stack) ? "carbine_reload_loop" : "reload_loop");
                break;
            }
            case STOPPING: {
                if (this.isAnimationPlaying(animationController, "reload_stop") || this.isAnimationPlaying(animationController, "carbine_reload_stop") || animationController.getAnimationState() != AnimationController.State.STOPPED) break;
                animationController.setAnimationSpeed(1.0);
                this.cleanupReloadState(nbt);
                nbt.m_128473_("LastReloadStateChange");
                nbt.m_128473_("ManualReloadInitialized");
                nbt.m_128473_("InReloadLoop");
                nbt.m_128473_("PendingStopTransition");
                if (this.isInCarbineMode(stack)) {
                    animationController.tryTriggerAnimation("carbine_idle");
                    break;
                }
                animationController.tryTriggerAnimation("idle");
            }
        }
    }

    public void cleanupReloadState(CompoundTag nbt) {
        nbt.m_128473_(RELOAD_STATE);
        nbt.m_128473_(RELOAD_START_TIME);
        nbt.m_128473_("scguns:ReloadComplete");
        nbt.m_128473_("scguns:IsPlayingReloadStop");
        nbt.m_128473_("scguns:IsMagReload");
        nbt.m_128473_("scguns:IsManualReload");
        nbt.m_128473_("loaded");
        nbt.m_128473_("IsReloading");
        nbt.m_128473_("scguns:IsReloading");
        nbt.m_128473_("scguns:PausedDuringReload");
        nbt.m_128473_("LastReloadStateChange");
        nbt.m_128473_("InCriticalReloadPhase");
        nbt.m_128473_("ReloadAnimStartTime");
        nbt.m_128473_("IsMagReload");
        nbt.m_128473_("IsManualReload");
        nbt.m_128473_("ReloadAnimationStarted");
        nbt.m_128473_("ReloadAnimationRestarted");
        nbt.m_128473_("ReloadCompleted");
    }

    @OnlyIn(value=Dist.CLIENT)
    private void handleAimingState(CompoundTag nbt, AnimationController<GeoAnimatable> animationController) {
        if (nbt.m_128471_("IsDrawing") && nbt.m_128451_("DrawnTick") < 15) {
            return;
        }
        animationController.setAnimationSpeed(1.0);
        nbt.m_128473_("IsInspecting");
        assert (Minecraft.m_91087_().f_91074_ != null);
        ItemStack stack = Minecraft.m_91087_().f_91074_.m_21205_();
        this.isInCarbineMode(stack);
        if (stack.m_41720_() instanceof AnimatedGunItem && this.isInCarbineMode(stack)) {
            animationController.tryTriggerAnimation("carbine_idle");
        } else {
            animationController.tryTriggerAnimation("idle");
        }
    }

    private void handleRunningState(AnimationController<GeoAnimatable> animationController) {
        animationController.setAnimationSpeed(1.0);
        assert (Minecraft.m_91087_().f_91074_ != null);
        ItemStack stack = Minecraft.m_91087_().f_91074_.m_21205_();
        boolean isCarbine = stack.m_41720_() instanceof AnimatedGunItem && this.isInCarbineMode(stack);
        if (this.isAnimationPlaying(animationController, isCarbine ? "carbine_inspect" : "inspect")) {
            animationController.tryTriggerAnimation(isCarbine ? "carbine_idle" : "idle");
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void handleInspectState(AnimationController<GeoAnimatable> animationController, ItemStack stack) {
        String animToPlay;
        boolean isCarbine = this.isInCarbineMode(stack);
        String string = animToPlay = isCarbine ? "carbine_inspect" : "inspect";
        if (!this.isAnimationPlaying(animationController, animToPlay)) {
            animationController.setAnimationSpeed(1.0);
            animationController.forceAnimationReset();
            animationController.tryTriggerAnimation(animToPlay);
        }
    }

    private void handleShootState(CompoundTag nbt, AnimationController<GeoAnimatable> animationController, ItemStack stack) {
        boolean isCarbine = this.isInCarbineMode(stack);
        animationController.setAnimationSpeed(1.0);
        if (!(stack.m_41720_() instanceof AnimatedDualWieldGunItem)) {
            if (nbt.m_128471_("IsAiming")) {
                animationController.tryTriggerAnimation(isCarbine ? "carbine_aim_shoot" : "aim_shoot");
            } else {
                animationController.tryTriggerAnimation(isCarbine ? "carbine_shoot" : "shoot");
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void soundListener(SoundKeyframeEvent<AnimatedGunItem> gunItemSoundKeyframeEvent) {
        boolean isOffHand;
        Player player = ClientUtils.getClientPlayer();
        if (player == null) {
            return;
        }
        ItemStack mainHand = player.m_21205_();
        ItemStack offHand = player.m_21206_();
        boolean isMainHand = mainHand.m_41720_() == this && !mainHand.m_41784_().m_128471_("IsDroppedItem");
        boolean bl = isOffHand = offHand.m_41720_() == this && !offHand.m_41784_().m_128471_("IsDroppedItem");
        if (!isMainHand && !isOffHand) {
            return;
        }
        ItemStack heldStack = isMainHand ? mainHand : offHand;
        CompoundTag heldTag = heldStack.m_41784_();
        if (!heldTag.m_128471_("IsDrawn")) {
            return;
        }
        switch (gunItemSoundKeyframeEvent.getKeyframeData().getSound()) {
            case "gun_rustle": {
                player.m_5496_((SoundEvent)ModSounds.GUN_RUSTLE.get(), 1.0f, 1.0f);
                break;
            }
            case "metal": {
                player.m_5496_((SoundEvent)ModSounds.METAL.get(), 1.0f, 1.0f);
                break;
            }
            case "pump": {
                player.m_5496_((SoundEvent)ModSounds.PUMP.get(), 1.0f, 1.0f);
                break;
            }
            case "pump_half": {
                player.m_5496_((SoundEvent)ModSounds.PUMP_HALF.get(), 1.0f, 1.0f);
                break;
            }
            case "insert": {
                player.m_5496_((SoundEvent)ModSounds.INSERT.get(), 1.0f, 1.0f);
                break;
            }
            case "jam": {
                player.m_5496_((SoundEvent)ModSounds.COPPER_GUN_JAM.get(), 0.2f, 1.0f);
                break;
            }
            case "lever": {
                player.m_5496_((SoundEvent)ModSounds.LEVER.get(), 1.0f, 1.0f);
                break;
            }
            case "slap": {
                player.m_5496_((SoundEvent)ModSounds.SLAP.get(), 1.0f, 1.0f);
                break;
            }
            case "rack": {
                player.m_5496_((SoundEvent)ModSounds.RACK.get(), 1.0f, 1.0f);
                break;
            }
            case "reload_mag_out": {
                player.m_5496_(this.reloadSoundMagOut, 1.0f, 1.0f);
                break;
            }
            case "reload_mag_in": {
                player.m_5496_(this.reloadSoundMagIn, 1.0f, 1.0f);
                break;
            }
            case "reload_end": {
                player.m_5496_(this.reloadSoundEnd, 1.0f, 1.0f);
                break;
            }
            case "bolt_pull": {
                player.m_5496_(this.boltPullSound, 1.0f, 1.0f);
                break;
            }
            case "bolt_release": {
                player.m_5496_(this.boltReleaseSound, 1.0f, 1.0f);
                break;
            }
            case "bolt": {
                player.m_5496_((SoundEvent)ModSounds.BOLT.get(), 1.0f, 1.0f);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void particleListener(ParticleKeyframeEvent<AnimatedGunItem> gunItemParticleKeyframeEvent) {
        String effect;
        boolean isOffHand;
        Player player = ClientUtils.getClientPlayer();
        if (player == null) {
            return;
        }
        ItemStack currentItem = player.m_21205_();
        ItemStack mainHand = player.m_21205_();
        ItemStack offHand = player.m_21206_();
        boolean isMainHand = mainHand.m_41720_() == this && !mainHand.m_41784_().m_128471_("IsDroppedItem");
        boolean bl = isOffHand = offHand.m_41720_() == this && !offHand.m_41784_().m_128471_("IsDroppedItem");
        if (!isMainHand && !isOffHand) {
            return;
        }
        ItemStack heldStack = isMainHand ? mainHand : offHand;
        CompoundTag heldTag = heldStack.m_41784_();
        if (!heldTag.m_128471_("IsDrawn")) {
            return;
        }
        GunItem gunItem = (GunItem)heldStack.m_41720_();
        Gun gun = gunItem.getModifiedGun(heldStack);
        CompoundTag tag = heldStack.m_41784_();
        switch (effect = gunItemParticleKeyframeEvent.getKeyframeData().getEffect()) {
            case "loaded": {
                heldStack.m_41784_();
                ModSyncedDataKeys.RELOADING.getValue((Entity)player);
                tag.m_128379_("loaded", true);
                PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageGunLoaded());
                break;
            }
            case "eject_casing": {
                if (!gun.getProjectile().ejectsCasing() || !gun.getProjectile().ejectDuringReload() || !((Boolean)Config.COMMON.gameplay.spawnCasings.get()).booleanValue()) break;
                Level level = player.m_9236_();
                GunEventBus.ejectCasing(level, (LivingEntity)player, false);
                if (gun.getProjectile().casingType == null || player.m_150110_().f_35937_) break;
                PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageEjectCasing());
                break;
            }
            case "rotate_cylinder": {
                Item item = heldStack.m_41720_();
                if (!(item instanceof AnimatedGunItem)) break;
                AnimatedGunItem animatedGun = (AnimatedGunItem)item;
                animatedGun.getRotationHandler().incrementCylinderRotation(90.0f);
                tag.m_128379_("UseManualCylinderRotation", true);
            }
        }
    }

    public boolean isPerspectiveAware() {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private AnimatedGunRenderer renderer;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    this.renderer = new AnimatedGunRenderer(new ResourceLocation("scguns", AnimatedGunItem.this.gunID));
                }
                return this.renderer;
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    private PlayState predicate(AnimationState<AnimatedGunItem> event) {
        boolean isOffHand;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return PlayState.STOP;
        }
        ItemStack mainHand = player.m_21205_();
        ItemStack offHand = player.m_21206_();
        boolean isMainHand = mainHand.m_41720_() == this && !mainHand.m_41784_().m_128471_("IsDroppedItem");
        boolean bl = isOffHand = offHand.m_41720_() == this && !offHand.m_41784_().m_128471_("IsDroppedItem");
        if (!isMainHand && !isOffHand) {
            return PlayState.STOP;
        }
        ItemStack heldStack = isMainHand ? mainHand : offHand;
        CompoundTag heldTag = heldStack.m_41784_();
        if (!heldTag.m_128471_("IsDrawn")) {
            return PlayState.STOP;
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            this.registerClientControllers(controllers);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerClientControllers(AnimatableManager.ControllerRegistrar controllers) {
        AnimationController controller = new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate).setSoundKeyframeHandler(this::soundListener).setParticleKeyframeHandler(this::particleListener).triggerableAnim("idle", GunAnimations.IDLE).triggerableAnim("carbine_idle", GunAnimations.CARBINE_IDLE).triggerableAnim("shoot", GunAnimations.SHOOT).triggerableAnim("shoot1", GunAnimations.SHOOT1).triggerableAnim("carbine_shoot", GunAnimations.CARBINE_SHOOT).triggerableAnim("aim_shoot", GunAnimations.AIM_SHOOT).triggerableAnim("aim_shoot1", GunAnimations.AIM_SHOOT1).triggerableAnim("carbine_aim_shoot", GunAnimations.CARBINE_AIM_SHOOT).triggerableAnim("reload", GunAnimations.RELOAD).triggerableAnim("carbine_reload", GunAnimations.CARBINE_RELOAD).triggerableAnim("reload_alt", GunAnimations.RELOAD_ALT).triggerableAnim("reload_start", GunAnimations.RELOAD_START).triggerableAnim("carbine_reload_start", GunAnimations.CARBINE_RELOAD_START).triggerableAnim("reload_loop", GunAnimations.RELOAD_LOOP).triggerableAnim("carbine_reload_loop", GunAnimations.CARBINE_RELOAD_LOOP).triggerableAnim("reload_stop", GunAnimations.RELOAD_STOP).triggerableAnim("carbine_reload_stop", GunAnimations.CARBINE_RELOAD_STOP).triggerableAnim("draw", GunAnimations.DRAW).triggerableAnim("carbine_draw", GunAnimations.CARBINE_DRAW).triggerableAnim("inspect", GunAnimations.INSPECT).triggerableAnim("carbine_inspect", GunAnimations.CARBINE_INSPECT).triggerableAnim("jam", GunAnimations.JAM).triggerableAnim("melee", GunAnimations.MELEE).triggerableAnim("carbine_melee", GunAnimations.CARBINE_MELEE).triggerableAnim("bayonet", GunAnimations.BAYONET).triggerableAnim("carbine_bayonet", GunAnimations.CARBINE_BAYONET);
        controllers.add(new AnimationController[]{controller});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    private static enum ReloadState {
        NONE,
        STARTING,
        LOADING,
        STOPPING;

    }
}

