/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.item;

import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.ribs.scguns.common.Gun;
import top.ribs.scguns.init.ModParticleTypes;
import top.ribs.scguns.item.GunItem;
import top.ribs.scguns.item.ScopeItem;
import top.ribs.scguns.item.attachment.impl.Scope;

@Mod.EventBusSubscriber(modid="scguns", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class LaserSightItem
extends ScopeItem {
    public LaserSightItem(Scope scope, Item.Properties properties) {
        super(scope, properties, true);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        return new LaserSightCapabilityProvider();
    }

    private static class LaserSightCapabilityProvider
    implements ICapabilitySerializable<CompoundTag> {
        private LaserSightCapabilityProvider() {
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return LazyOptional.empty();
        }

        public CompoundTag serializeNBT() {
            return new CompoundTag();
        }

        public void deserializeNBT(CompoundTag nbt) {
        }
    }

    @Mod.EventBusSubscriber(modid="scguns", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
    public static class ClientTickHandler {
        private static int tickCounter = 0;
        private static final int TICK_DELAY = 2;
        private static final double OFFSET = 0.1;

        @SubscribeEvent
        public static void onClientTick(TickEvent.ClientTickEvent event) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null && ++tickCounter >= 2) {
                tickCounter = 0;
                Level world = player.m_9236_();
                ItemStack heldItem = player.m_21120_(InteractionHand.MAIN_HAND);
                if (heldItem.m_41720_() instanceof LaserSightItem || heldItem.m_41720_() instanceof GunItem && Gun.hasLaserSight(heldItem)) {
                    Vec3 start = player.m_20299_(1.0f);
                    Vec3 direction = player.m_20154_();
                    Vec3 end = start.m_82549_(direction.m_82490_(50.0));
                    BlockHitResult hitResult = player.m_9236_().m_45547_(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
                    Vec3 finalEnd = hitResult.m_6662_() != HitResult.Type.MISS ? hitResult.m_82450_() : end;
                    AABB aabb = new AABB(start, finalEnd).m_82400_(0.5);
                    List entities = world.m_6249_((Entity)player, aabb, e -> !e.m_5833_() && e.m_6087_());
                    EntityHitResult entityHitResult = null;
                    double closestDistance = Double.MAX_VALUE;
                    for (Entity entity : entities) {
                        Vec3 hitVec;
                        double distance;
                        AABB entityAABB = entity.m_20191_().m_82400_(0.3);
                        Optional optionalHit = entityAABB.m_82371_(start, finalEnd);
                        if (!optionalHit.isPresent() || !((distance = start.m_82554_(hitVec = (Vec3)optionalHit.get())) < closestDistance)) continue;
                        closestDistance = distance;
                        entityHitResult = new EntityHitResult(entity, hitVec);
                    }
                    if (entityHitResult != null) {
                        finalEnd = entityHitResult.m_82450_();
                    }
                    Vec3 adjustedPosition = finalEnd.m_82546_(direction.m_82490_(0.1));
                    world.m_7106_((ParticleOptions)ModParticleTypes.LASER.get(), adjustedPosition.f_82479_, adjustedPosition.f_82480_, adjustedPosition.f_82481_, 0.0, 0.0, 0.0);
                }
            }
        }
    }
}

