/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import top.ribs.scguns.init.ModItems;

public class DepletedDiamondSteelItem
extends Item {
    private static final int XP_COST_PER_INGOT = 3;

    public DepletedDiamondSteelItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (level.f_46443_) {
            return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)true);
        }
        return this.convertToRegularSteel(level, player, itemStack);
    }

    private InteractionResultHolder<ItemStack> convertToRegularSteel(Level level, Player player, ItemStack depletedStack) {
        int playerXP;
        int maxConvertible;
        int stackSize = depletedStack.m_41613_();
        int actualConvertible = Math.min(stackSize, maxConvertible = (playerXP = this.getTotalExperience(player)) / 3);
        if (actualConvertible <= 0) {
            return InteractionResultHolder.m_19100_((Object)depletedStack);
        }
        ItemStack diamondSteelStack = new ItemStack((ItemLike)ModItems.DIAMOND_STEEL_INGOT.get(), actualConvertible);
        boolean addedToInventory = player.m_150109_().m_36054_(diamondSteelStack);
        if (!addedToInventory) {
            player.m_36176_(diamondSteelStack, false);
        }
        int xpToRemove = actualConvertible * 3;
        this.removeExperience(player, xpToRemove);
        depletedStack.m_41774_(actualConvertible);
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11871_, SoundSource.PLAYERS, 0.5f, 1.0f + (level.f_46441_.m_188501_() - 0.5f) * 0.2f);
        return InteractionResultHolder.m_19092_((Object)depletedStack, (boolean)false);
    }

    private int getTotalExperience(Player player) {
        int experience = 0;
        int level = player.f_36078_;
        experience = level <= 16 ? level * level + 6 * level : (level <= 31 ? (int)(2.5 * (double)level * (double)level - 40.5 * (double)level + 360.0) : (int)(4.5 * (double)level * (double)level - 162.5 * (double)level + 2220.0));
        return experience += Math.round(player.f_36080_ * (float)player.m_36323_());
    }

    private void removeExperience(Player player, int xpToRemove) {
        int currentXP = this.getTotalExperience(player);
        int newXP = Math.max(0, currentXP - xpToRemove);
        player.f_36078_ = 0;
        player.f_36080_ = 0.0f;
        player.f_36079_ = 0;
        player.m_6756_(newXP);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"item.scguns.depleted_diamond_steel_ingot.tooltip.usage"));
        tooltip.add((Component)Component.m_237110_((String)"item.scguns.depleted_diamond_steel_ingot.tooltip.cost", (Object[])new Object[]{3}));
        super.m_7373_(stack, level, tooltip, flag);
    }
}

