/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.init;

import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import top.ribs.scguns.init.ModItems;

public enum ModArmorMaterials implements ArmorMaterial
{
    SCRAP("scrap", 6, new int[]{5, 6, 6, 4}, 9, SoundEvents.f_11678_, 0.5f, 0.05f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_151052_})),
    REDCOAT("redcoat", 12, new int[]{2, 4, 3, 2}, 9, SoundEvents.f_11678_, 0.0f, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42454_})),
    ADRIEN("adrien", 22, new int[]{3, 6, 6, 4}, 8, SoundEvents.f_11677_, 0.5f, 0.1f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.TREATED_IRON_INGOT.get()})),
    ANTHRALITE("anthralite", 32, new int[]{3, 5, 4, 3}, 12, SoundEvents.f_11676_, 1.0f, 0.05f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.ANTHRALITE_INGOT.get()})),
    DIAMOND_STEEL("diamond_steel", 36, new int[]{3, 7, 5, 3}, 16, SoundEvents.f_11673_, 2.0f, 0.05f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.DIAMOND_STEEL_INGOT.get()})),
    TREATED_BRASS("treated_brass", 30, new int[]{4, 5, 5, 4}, 10, SoundEvents.f_11677_, 0.0f, 0.2f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.TREATED_BRASS_INGOT.get()})),
    ANCIENT_BRASS("ancient_brass", 16, new int[]{3, 5, 4, 3}, 10, SoundEvents.f_11677_, 0.0f, 0.15f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.ANCIENT_BRASS.get()})),
    EXO_SUIT("exo_suit", 200, new int[]{1, 1, 1, 1}, 6, SoundEvents.f_11679_, 0.0f, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.TREATED_IRON_INGOT.get()}));

    private final String name;
    private final int durabilityMultiplier;
    private final int[] protectionAmounts;
    private final int enchantmentValue;
    private final SoundEvent equipSound;
    private final float toughness;
    private final float knockbackResistance;
    private final Supplier<Ingredient> repairIngredient;
    private static final int[] BASE_DURABILITY;

    private ModArmorMaterials(String name, int durabilityMultiplier, int[] protectionAmounts, int enchantmentValue, SoundEvent equipSound, float toughness, float knockbackResistance, Supplier<Ingredient> repairIngredient) {
        this.name = name;
        this.durabilityMultiplier = durabilityMultiplier;
        this.protectionAmounts = protectionAmounts;
        this.enchantmentValue = enchantmentValue;
        this.equipSound = equipSound;
        this.toughness = toughness;
        this.knockbackResistance = knockbackResistance;
        this.repairIngredient = repairIngredient;
    }

    public int m_266425_(ArmorItem.Type pType) {
        return BASE_DURABILITY[pType.ordinal()] * this.durabilityMultiplier;
    }

    public int m_7366_(ArmorItem.Type pType) {
        return this.protectionAmounts[pType.ordinal()];
    }

    public int m_6646_() {
        return this.enchantmentValue;
    }

    public SoundEvent m_7344_() {
        return this.equipSound;
    }

    public Ingredient m_6230_() {
        return this.repairIngredient.get();
    }

    public String m_6082_() {
        return "scguns:" + this.name;
    }

    public float m_6651_() {
        return this.toughness;
    }

    public float m_6649_() {
        return this.knockbackResistance;
    }

    static {
        BASE_DURABILITY = new int[]{8, 12, 12, 9};
    }
}

