/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.projectile.turret;

import com.mrcrayfish.framework.network.message.IMessage;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import top.ribs.scguns.init.ModEntities;
import top.ribs.scguns.init.ModSounds;
import top.ribs.scguns.network.PacketHandler;
import top.ribs.scguns.network.message.S2CMessageTurretBulletTrail;

public class TurretProjectileEntity
extends AbstractArrow {
    private static final float GIBBS_ROUND_XP_MULTIPLIER = 0.25f;
    private static final int GIBBS_ROUND_LOOTING_LEVEL = 4;
    private static boolean eventRegistered = false;
    private static final int SHRAPNEL_COUNT = 20;
    private static final float SHRAPNEL_RANGE = 5.0f;
    private static final float SHRAPNEL_DAMAGE_MULTIPLIER = 0.3f;
    private boolean trailSpawned = false;
    private float armorPenetration = 0.0f;
    private int mobPenetration = 0;
    private int entitiesHit = 0;
    private boolean isGibbsRound = false;
    private boolean isShatterRound = false;

    public TurretProjectileEntity(EntityType<? extends AbstractArrow> type, Level world) {
        super(type, world);
        this.m_20242_(true);
        TurretProjectileEntity.registerLootingEventHandler();
    }

    public TurretProjectileEntity(Level world) {
        super((EntityType)ModEntities.TURRET_PROJECTILE.get(), world);
        this.m_20242_(true);
        TurretProjectileEntity.registerLootingEventHandler();
    }

    private static synchronized void registerLootingEventHandler() {
        if (!eventRegistered) {
            MinecraftForge.EVENT_BUS.register(TurretProjectileEntity.class);
            eventRegistered = true;
        }
    }

    @SubscribeEvent
    public static void onLootingLevel(LootingLevelEvent event) {
        Entity entity;
        if (event.getDamageSource() != null && (entity = event.getDamageSource().m_7640_()) instanceof TurretProjectileEntity) {
            TurretProjectileEntity projectile = (TurretProjectileEntity)entity;
            if (projectile.isGibbsRound) {
                event.setLootingLevel(event.getLootingLevel() + 4);
            }
        }
    }

    @NotNull
    protected ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }

    public void m_6686_(double x, double y, double z, float velocity, float inaccuracy) {
        super.m_6686_(x, y, z, velocity, inaccuracy);
        this.m_20256_(this.m_20184_().m_82541_().m_82490_((double)velocity));
    }

    protected void m_5790_(EntityHitResult pResult) {
        Entity entity = pResult.m_82443_();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            float damageAmount = (float)this.m_36789_();
            if (this.armorPenetration > 0.0f) {
                float originalArmor = livingEntity.m_21230_();
                float reducedArmor = Math.max(0.0f, originalArmor - this.armorPenetration);
                float armorReduction = (originalArmor - reducedArmor) / 25.0f;
                damageAmount += damageAmount * armorReduction;
            }
            boolean wasAlive = livingEntity.m_6084_();
            if (livingEntity.m_6469_(this.m_269291_().m_269418_((AbstractArrow)this, this.m_19749_()), damageAmount) && livingEntity.m_6084_()) {
                this.m_7761_(livingEntity);
            }
            if (wasAlive && !livingEntity.m_6084_() && this.isGibbsRound) {
                this.spawnGibbsXPBonus(livingEntity, entity.m_20182_());
            }
            if (this.isShatterRound) {
                this.explodeShrapnel(pResult.m_82450_());
            }
            livingEntity.m_21317_(livingEntity.m_21234_() - 1);
            entity.f_19802_ = 0;
            ++this.entitiesHit;
            if (this.mobPenetration > 0 && this.entitiesHit <= this.mobPenetration) {
                this.m_20256_(this.m_20184_().m_82490_(0.8));
                return;
            }
        }
        this.m_146870_();
    }

    private void spawnGibbsXPBonus(LivingEntity killedEntity, Vec3 position) {
        int baseXP;
        int gibbsXP;
        if (!this.m_9236_().f_46443_ && (gibbsXP = Math.round((float)(baseXP = killedEntity.m_213860_()) * 0.25f)) > 0) {
            ExperienceOrb xpOrb = new ExperienceOrb(this.m_9236_(), position.f_82479_, position.f_82480_, position.f_82481_, gibbsXP);
            this.m_9236_().m_7967_((Entity)xpOrb);
        }
    }

    public void m_36745_(LivingEntity pShooter, float pVelocity) {
    }

    public boolean m_36792_() {
        return false;
    }

    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
        if (this.isShatterRound) {
            this.explodeShrapnel(result.m_82450_());
        }
        this.m_146870_();
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && !this.trailSpawned && this.f_19797_ == 1) {
            this.spawnBulletTrail();
            this.trailSpawned = true;
        }
        if (this.f_36703_ || this.f_19797_ > 100) {
            this.m_146870_();
        }
    }

    private void spawnBulletTrail() {
        Vec3 position = this.m_20182_();
        Vec3 motion = this.m_20184_();
        int trailColor = 0xFF6600;
        double trailLength = 1.0;
        int maxAge = 100;
        double trailThickness = 0.8;
        S2CMessageTurretBulletTrail message = new S2CMessageTurretBulletTrail(this.m_19879_(), position, motion, trailColor, trailLength, maxAge, trailThickness);
        PacketHandler.getPlayChannel().sendToTrackingEntity(() -> this, (IMessage)message);
    }

    protected void m_6532_(HitResult hitResult) {
        super.m_6532_(hitResult);
        this.m_146870_();
    }

    @NotNull
    protected SoundEvent m_7239_() {
        return (SoundEvent)ModSounds.BULLET_FLYBY.get();
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128347_("TurretDamage", this.m_36789_());
        compound.m_128379_("TrailSpawned", this.trailSpawned);
        compound.m_128350_("ArmorPenetration", this.armorPenetration);
        compound.m_128405_("MobPenetration", this.mobPenetration);
        compound.m_128405_("EntitiesHit", this.entitiesHit);
        compound.m_128379_("IsGibbsRound", this.isGibbsRound);
        compound.m_128379_("IsShatterRound", this.isShatterRound);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("TurretDamage")) {
            this.m_36781_(compound.m_128459_("TurretDamage"));
        }
        this.trailSpawned = compound.m_128471_("TrailSpawned");
        if (compound.m_128441_("ArmorPenetration")) {
            this.armorPenetration = compound.m_128457_("ArmorPenetration");
        }
        if (compound.m_128441_("MobPenetration")) {
            this.mobPenetration = compound.m_128451_("MobPenetration");
        }
        if (compound.m_128441_("EntitiesHit")) {
            this.entitiesHit = compound.m_128451_("EntitiesHit");
        }
        if (compound.m_128441_("IsGibbsRound")) {
            this.isGibbsRound = compound.m_128471_("IsGibbsRound");
        }
        if (compound.m_128441_("IsShatterRound")) {
            this.isShatterRound = compound.m_128471_("IsShatterRound");
        }
    }

    public void m_5496_(SoundEvent soundEvent, float volume, float pitch) {
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_20221_(BlockPos pos) {
        this.m_146870_();
    }

    private void explodeShrapnel(Vec3 explosionPos) {
        if (this.m_9236_().f_46443_) {
            return;
        }
        this.createShrapnelExplosionEffects(explosionPos);
        this.fireShrapnel(explosionPos);
    }

    private void createShrapnelExplosionEffects(Vec3 pos) {
        ServerLevel serverLevel = (ServerLevel)this.m_9236_();
        this.m_9236_().m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundEvents.f_11983_, SoundSource.NEUTRAL, 2.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
        this.m_9236_().m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundEvents.f_144050_, SoundSource.NEUTRAL, 1.5f, 1.2f + this.f_19796_.m_188501_() * 0.3f);
        for (int i = 0; i < 40; ++i) {
            double angle = this.f_19796_.m_188500_() * Math.PI * 2.0;
            double pitch = (this.f_19796_.m_188500_() - 0.5) * Math.PI * 0.5;
            double speed = 0.3 + this.f_19796_.m_188500_() * 0.4;
            double offsetX = Math.cos(angle) * Math.cos(pitch) * speed;
            double offsetY = Math.sin(pitch) * speed;
            double offsetZ = Math.sin(angle) * Math.cos(pitch) * speed;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123797_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 1, offsetX, offsetY, offsetZ, 0.02);
        }
        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123766_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 1, 0.1, 0.1, 0.1, 0.0);
    }

    private void fireShrapnel(Vec3 origin) {
        float shrapnelDamage = (float)this.m_36789_() * 0.3f;
        for (int i = 0; i < 20; ++i) {
            Vec3 direction = this.generateRandomDirection();
            Vec3 endPos = origin.m_82549_(direction.m_82490_(5.0));
            this.traceShrapnelRay(origin, endPos, shrapnelDamage);
        }
    }

    private Vec3 generateRandomDirection() {
        float z;
        float y;
        float x;
        float lengthSquared;
        while ((lengthSquared = (x = this.f_19796_.m_188501_() * 2.0f - 1.0f) * x + (y = this.f_19796_.m_188501_() * 2.0f - 1.0f) * y + (z = this.f_19796_.m_188501_() * 2.0f - 1.0f) * z) > 1.0f || lengthSquared < 0.001f) {
        }
        float length = Mth.m_14116_((float)lengthSquared);
        return new Vec3((double)(x / length), (double)(y / length), (double)(z / length));
    }

    private void traceShrapnelRay(Vec3 start, Vec3 end, float damage) {
        AABB searchBox = new AABB(start, end).m_82400_(1.0);
        Entity owner = this.m_19749_();
        List hitEntities = this.m_9236_().m_6249_((Entity)this, searchBox, entity -> !(entity == null || !entity.m_6087_() || entity.m_5833_() || owner != null && entity == owner || owner != null && entity.m_19879_() == owner.m_19879_()));
        Vec3 traceEnd = end;
        Entity closestEntity = null;
        double closestDistance = Double.MAX_VALUE;
        Vec3 closestHitPos = null;
        for (Entity entity2 : hitEntities) {
            double distance;
            AABB boundingBox = entity2.m_20191_();
            Optional hitPos = boundingBox.m_82371_(start, end);
            if (!hitPos.isPresent() || !((distance = start.m_82557_((Vec3)hitPos.get())) < closestDistance)) continue;
            closestDistance = distance;
            closestEntity = entity2;
            closestHitPos = (Vec3)hitPos.get();
        }
        if (closestEntity != null) {
            closestEntity.m_6469_(this.m_269291_().m_269418_((AbstractArrow)this, owner), damage);
            closestEntity.f_19802_ = Math.min(closestEntity.f_19802_, 3);
            traceEnd = closestHitPos;
        } else {
            ClipContext clipContext = new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this);
            BlockHitResult blockHit = this.m_9236_().m_45547_(clipContext);
            if (blockHit.m_6662_() != HitResult.Type.MISS) {
                traceEnd = blockHit.m_82450_();
            }
        }
        this.createShrapnelTracer(start, traceEnd);
    }

    private void createShrapnelTracer(Vec3 start, Vec3 end) {
        ServerLevel serverLevel = (ServerLevel)this.m_9236_();
        Vec3 direction = end.m_82546_(start);
        double distance = direction.m_82553_();
        if (distance < 0.1) {
            return;
        }
        direction = direction.m_82541_();
        int maxSegments = Math.min(12, (int)(distance * 1.5));
        for (int i = 1; i <= maxSegments; ++i) {
            double progress = (double)i / (double)maxSegments;
            Vec3 particlePos = start.m_82549_(direction.m_82490_(distance * progress));
            double densityFactor = Math.max(0.2, 1.0 - progress * 0.8);
            int particlesAtThisPoint = Math.max(1, (int)(4.0 * densityFactor));
            double spreadRadius = 0.02 + progress * 0.1;
            for (int j = 0; j < particlesAtThisPoint; ++j) {
                double offsetX = (this.f_19796_.m_188500_() - 0.5) * spreadRadius;
                double offsetY = (this.f_19796_.m_188500_() - 0.5) * spreadRadius;
                double offsetZ = (this.f_19796_.m_188500_() - 0.5) * spreadRadius;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123797_, particlePos.f_82479_ + offsetX, particlePos.f_82480_ + offsetY, particlePos.f_82481_ + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    public float getArmorPenetration() {
        return this.armorPenetration;
    }

    public void setArmorPenetration(float armorPenetration) {
        this.armorPenetration = armorPenetration;
    }

    public int getMobPenetration() {
        return this.mobPenetration;
    }

    public void setMobPenetration(int mobPenetration) {
        this.mobPenetration = mobPenetration;
    }

    public boolean isGibbsRound() {
        return this.isGibbsRound;
    }

    public void setGibbsRound(boolean isGibbsRound) {
        this.isGibbsRound = isGibbsRound;
    }

    public boolean isShatterRound() {
        return this.isShatterRound;
    }

    public void setShatterRound(boolean isShatterRound) {
        this.isShatterRound = isShatterRound;
    }
}

