/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.projectile;

import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class TraumaHookEntity
extends FishingHook {
    private boolean isRetracting = false;
    private static final double GRAVITY = 0.03;
    private static final double AIR_RESISTANCE = 0.98;
    private static final double GROUND_FRICTION = 0.8;
    private static final int MAX_LIFETIME = 200;
    private static final double RETRACT_SPEED_BASE = 0.4;

    public TraumaHookEntity(EntityType<? extends TraumaHookEntity> entityType, Level level) {
        super(entityType, level);
        this.f_19811_ = true;
    }

    public TraumaHookEntity(EntityType<? extends TraumaHookEntity> entityType, LivingEntity owner, Level level) {
        super(entityType, level);
        this.m_5602_((Entity)owner);
        this.f_19811_ = true;
        this.m_7678_(owner.m_20185_(), owner.m_20188_() - 0.1, owner.m_20189_(), owner.m_146908_(), owner.m_146909_());
    }

    protected void m_5790_(EntityHitResult result) {
        Entity entity = result.m_82443_();
        if (entity instanceof LivingEntity && entity != this.m_19749_() && !this.isRetracting) {
            super.m_5790_(result);
            this.m_20256_(Vec3.f_82478_);
        }
    }

    protected boolean m_5603_(Entity entity) {
        return !this.isRetracting && entity instanceof LivingEntity && entity != this.m_19749_();
    }

    public void m_8119_() {
        this.m_6075_();
        if (this.m_9236_().m_5776_()) {
            if (!this.isRetracting && !this.m_20096_()) {
                Vec3 motion = this.m_20184_();
                motion = motion.m_82520_(0.0, -0.03, 0.0);
                motion = motion.m_82490_(0.98);
                this.m_20256_(motion);
                this.m_6478_(MoverType.SELF, motion);
            }
            return;
        }
        Entity owner = this.m_19749_();
        if (owner == null || owner.m_213877_()) {
            this.m_146870_();
            return;
        }
        if (!this.isRetracting) {
            boolean shouldRetract = false;
            if (this.f_19797_ > 200) {
                shouldRetract = true;
            } else if (this.m_20096_() && this.m_37170_() == null && this.f_19797_ > 20) {
                shouldRetract = true;
            } else if ((double)this.m_20270_(owner) > 32.0) {
                shouldRetract = true;
            } else if (!owner.m_6084_()) {
                shouldRetract = true;
            }
            if (shouldRetract) {
                this.startRetraction();
            }
        }
        if (this.isRetracting) {
            this.handleRetraction();
        } else {
            this.handleNormalFlight();
        }
        this.m_37283_();
    }

    private void handleNormalFlight() {
        HitResult hitResult = ProjectileUtil.m_278158_((Entity)this, this::m_5603_);
        if (hitResult.m_6662_() != HitResult.Type.MISS) {
            this.m_6532_(hitResult);
            return;
        }
        Vec3 motion = this.m_20184_();
        if (!this.m_20096_()) {
            motion = motion.m_82520_(0.0, -0.03, 0.0);
            motion = motion.m_82490_(0.98);
            this.m_20256_(motion);
            this.m_6478_(MoverType.SELF, motion);
        } else {
            motion = motion.m_82542_(0.8, 0.0, 0.8);
            this.m_20256_(motion);
        }
    }

    private void startRetraction() {
        this.isRetracting = true;
        if (this.m_37170_() != null) {
            // empty if block
        }
    }

    private void handleRetraction() {
        Entity owner = this.m_19749_();
        if (owner == null) {
            this.m_146870_();
            return;
        }
        Vec3 ownerPos = new Vec3(owner.m_20185_(), owner.m_20188_() - 0.1, owner.m_20189_());
        Vec3 hookPos = this.m_20182_();
        double distanceToOwner = hookPos.m_82554_(ownerPos);
        if (distanceToOwner < 1.0) {
            this.m_146870_();
            return;
        }
        Vec3 direction = ownerPos.m_82546_(hookPos).m_82541_();
        double retractSpeed = 0.4 + distanceToOwner * 0.05;
        retractSpeed = Math.min(retractSpeed, 1.5);
        Vec3 retractVelocity = direction.m_82490_(retractSpeed);
        this.m_20256_(retractVelocity);
        this.m_6478_(MoverType.SELF, retractVelocity);
    }

    public void m_37283_() {
        Vec3 motion = this.m_20184_();
        if (motion.m_165925_() > 1.0E-7) {
            this.m_146922_((float)(Math.atan2(motion.f_82479_, motion.f_82481_) * 180.0 / Math.PI));
            this.m_146926_((float)(Math.atan2(motion.f_82480_, motion.m_165924_()) * 180.0 / Math.PI));
            this.f_19859_ = this.m_146908_();
            this.f_19860_ = this.m_146909_();
        }
    }

    public boolean isRetracting() {
        return this.isRetracting;
    }

    public void m_6686_(double x, double y, double z, float velocity, float inaccuracy) {
        Vec3 direction = new Vec3(x, y, z);
        direction = direction.m_82541_();
        direction = direction.m_82520_(this.f_19796_.m_216328_(0.0, 0.0172275 * (double)inaccuracy), this.f_19796_.m_216328_(0.0, 0.0172275 * (double)inaccuracy), this.f_19796_.m_216328_(0.0, 0.0172275 * (double)inaccuracy));
        direction = direction.m_82541_().m_82490_((double)velocity);
        this.m_20256_(direction);
        this.m_146922_((float)(Math.atan2(direction.f_82479_, direction.f_82481_) * 180.0 / Math.PI));
        this.m_146926_((float)(Math.atan2(direction.f_82480_, direction.m_165924_()) * 180.0 / Math.PI));
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
    }

    public boolean m_6783_(double distance) {
        return distance < 4096.0;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Nullable
    public Player m_37168_() {
        return null;
    }
}

