/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.projectile;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import top.ribs.scguns.common.Gun;
import top.ribs.scguns.entity.projectile.ProjectileEntity;
import top.ribs.scguns.init.ModParticleTypes;
import top.ribs.scguns.item.GunItem;

public class RocketEntity
extends ProjectileEntity {
    private static final float EXPLOSION_RADIUS = 7.0f;
    private static final float SHIELD_DISABLE_CHANCE = 1.0f;

    public RocketEntity(EntityType<? extends ProjectileEntity> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    public RocketEntity(EntityType<? extends ProjectileEntity> entityType, Level worldIn, LivingEntity shooter, ItemStack weapon, GunItem item, Gun modifiedGun) {
        super(entityType, worldIn, shooter, weapon, item, modifiedGun);
    }

    @Override
    protected void onProjectileTick() {
        if (this.m_9236_().f_46443_) {
            for (int i = 5; i > 0; --i) {
                this.m_9236_().m_6493_((ParticleOptions)ModParticleTypes.ROCKET_TRAIL.get(), true, this.m_20185_() - this.m_20184_().m_7096_() / (double)i, this.m_20186_() - this.m_20184_().m_7098_() / (double)i, this.m_20189_() - this.m_20184_().m_7094_() / (double)i, 0.0, 0.0, 0.0);
            }
            if (this.m_9236_().f_46441_.m_188503_(2) == 0) {
                this.m_9236_().m_6493_((ParticleOptions)ParticleTypes.f_123762_, true, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
                this.m_9236_().m_6493_((ParticleOptions)ParticleTypes.f_123744_, true, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    protected void onHitEntity(Entity entity, Vec3 hitVec, Vec3 startVec, Vec3 endVec, boolean headshot) {
        if (entity instanceof Player) {
            boolean isBlockingOffHand;
            Player player = (Player)entity;
            ItemStack mainHandItem = player.m_21205_();
            ItemStack offHandItem = player.m_21206_();
            boolean isBlockingMainHand = player.m_21254_() && mainHandItem.m_41720_() instanceof ShieldItem;
            boolean bl = isBlockingOffHand = player.m_21254_() && offHandItem.m_41720_() instanceof ShieldItem;
            if (isBlockingMainHand || isBlockingOffHand) {
                ItemStack shield = isBlockingMainHand ? mainHandItem : offHandItem;
                InteractionHand hand = isBlockingMainHand ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
                player.m_36335_().m_41524_(shield.m_41720_(), 100);
                player.m_5810_();
                player.m_9236_().m_7605_((Entity)player, (byte)30);
                player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12347_, SoundSource.PLAYERS, 1.0f, 0.8f + player.m_9236_().m_213780_().m_188501_() * 0.4f);
                shield.m_41622_(15, (LivingEntity)player, p -> p.m_21190_(hand));
            }
        }
        float exactDamage = this.getDamage();
        RocketEntity.createRocketExplosion(this, 7.0f, exactDamage, false);
    }

    @Override
    protected void onHitBlock(BlockState state, BlockPos pos, Direction face, double x, double y, double z) {
        float exactDamage = this.getDamage();
        RocketEntity.createRocketExplosion(this, 7.0f, exactDamage, false);
    }

    @Override
    public void onExpired() {
        float exactDamage = this.getDamage();
        RocketEntity.createRocketExplosion(this, 7.0f, exactDamage, false);
    }

    @Override
    public float getDamage() {
        return super.getDamage();
    }
}

