/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.projectile;

import com.mrcrayfish.framework.network.message.IMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import top.ribs.scguns.Config;
import top.ribs.scguns.common.Gun;
import top.ribs.scguns.entity.projectile.ProjectileEntity;
import top.ribs.scguns.init.ModDamageTypes;
import top.ribs.scguns.init.ModParticleTypes;
import top.ribs.scguns.init.ModTags;
import top.ribs.scguns.item.GunItem;
import top.ribs.scguns.network.PacketHandler;
import top.ribs.scguns.network.message.S2CMessageBlood;
import top.ribs.scguns.network.message.S2CMessageProjectileHitEntity;
import top.ribs.scguns.util.GunEnchantmentHelper;

public class BeowulfProjectileEntity
extends ProjectileEntity {
    private static final float SHIELD_DISABLE_CHANCE = 0.5f;
    private static final float SHIELD_DAMAGE_PENETRATION = 0.3f;
    private static final float BEOWULF_XP_MULTIPLIER = 0.75f;
    private static final int BEOWULF_LOOTING_LEVEL = 3;
    private static boolean eventRegistered = false;

    public BeowulfProjectileEntity(EntityType<? extends Entity> entityType, Level worldIn) {
        super(entityType, worldIn);
        BeowulfProjectileEntity.registerLootingEventHandler();
    }

    public BeowulfProjectileEntity(EntityType<? extends Entity> entityType, Level worldIn, LivingEntity shooter, ItemStack weapon, GunItem item, Gun modifiedGun) {
        super(entityType, worldIn, shooter, weapon, item, modifiedGun);
        BeowulfProjectileEntity.registerLootingEventHandler();
    }

    private static synchronized void registerLootingEventHandler() {
        if (!eventRegistered) {
            MinecraftForge.EVENT_BUS.register(BeowulfProjectileEntity.class);
            eventRegistered = true;
        }
    }

    @SubscribeEvent
    public static void onLootingLevel(LootingLevelEvent event) {
        if (event.getDamageSource() != null && event.getDamageSource().m_7640_() instanceof BeowulfProjectileEntity) {
            event.setLootingLevel(event.getLootingLevel() + 3);
        }
    }

    @Override
    protected void onProjectileTick() {
        if (this.m_9236_().f_46443_ && this.f_19797_ > 1 && this.f_19797_ < this.life && this.f_19797_ % 2 == 0) {
            double offsetX = (this.f_19796_.m_188500_() - 0.5) * 0.5;
            double offsetY = (this.f_19796_.m_188500_() - 0.5) * 0.5;
            double offsetZ = (this.f_19796_.m_188500_() - 0.5) * 0.5;
            double velocityX = (this.f_19796_.m_188500_() - 0.5) * 0.1;
            double velocityY = (this.f_19796_.m_188500_() - 0.5) * 0.1;
            double velocityZ = (this.f_19796_.m_188500_() - 0.5) * 0.1;
            this.m_9236_().m_6493_((ParticleOptions)ParticleTypes.f_175834_, true, this.m_20185_() + offsetX, this.m_20186_() + offsetY, this.m_20189_() + offsetZ, velocityX, velocityY, velocityZ);
        }
        if (this.m_9236_().f_46443_ && this.f_19797_ > 1 && this.f_19797_ < this.life && this.f_19797_ % 5 == 0) {
            this.m_9236_().m_6493_((ParticleOptions)ModParticleTypes.BEOWULF_IMPACT.get(), true, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected void onHitEntity(Entity entity, Vec3 hitVec, Vec3 startVec, Vec3 endVec, boolean headshot) {
        LivingEntity livingEntity;
        boolean wasAlive;
        float newDamage;
        float damage = this.getDamage();
        boolean critical = damage != (newDamage = this.getCriticalDamage(this.getWeapon(), this.f_19796_, damage));
        damage = newDamage;
        ResourceLocation advantage = this.getProjectile().getAdvantage();
        damage *= this.advantageMultiplier(entity);
        boolean bl = wasAlive = entity instanceof LivingEntity && entity.m_6084_();
        if (headshot) {
            damage = (float)((double)damage * (Double)Config.COMMON.gameplay.headShotDamageMultiplier.get());
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)entity;
            damage = GunEnchantmentHelper.getPuncturingDamageReduction(this.getWeapon(), livingTarget, damage);
            damage = this.applyProjectileProtection(livingTarget, damage);
            damage = this.calculateArmorBypassDamage(livingTarget, damage);
        }
        DamageSource source = ModDamageTypes.Sources.projectile(this.m_9236_().m_9598_(), this, (LivingEntity)this.getOwner());
        boolean blocked = ProjectileEntity.ProjectileHelper.handleShieldHit(entity, this, damage, 0.5f);
        if (blocked) {
            float penetratingDamage = damage * 0.3f;
            entity.m_6469_(source, penetratingDamage);
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity2 = (LivingEntity)entity;
                ResourceLocation effectLocation = this.getProjectile().getImpactEffect();
                if (effectLocation != null) {
                    MobEffect effect;
                    float effectChance = this.getProjectile().getImpactEffectChance() * 0.3f;
                    if (this.f_19796_.m_188501_() < effectChance && (effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(effectLocation)) != null) {
                        int reducedDuration = (int)((float)this.getProjectile().getImpactEffectDuration() * 0.3f);
                        livingEntity2.m_7292_(new MobEffectInstance(effect, reducedDuration, this.getProjectile().getImpactEffectAmplifier()));
                    }
                }
            }
        } else if (!entity.m_6095_().m_204039_(ModTags.Entities.GHOST) || advantage.equals((Object)ModTags.Entities.UNDEAD.f_203868_())) {
            entity.m_6469_(source, damage);
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity3 = (LivingEntity)entity;
                ResourceLocation effectLocation = this.getProjectile().getImpactEffect();
                if (effectLocation != null) {
                    MobEffect effect;
                    float effectChance = this.getProjectile().getImpactEffectChance();
                    if (headshot) {
                        effectChance = Math.min(1.0f, effectChance * 1.25f);
                    }
                    if (this.f_19796_.m_188501_() < effectChance && (effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(effectLocation)) != null) {
                        int duration = this.getProjectile().getImpactEffectDuration();
                        if (headshot) {
                            duration = (int)((float)duration * 1.25f);
                        }
                        livingEntity3.m_7292_(new MobEffectInstance(effect, duration, this.getProjectile().getImpactEffectAmplifier()));
                    }
                }
            }
        }
        if (entity instanceof LivingEntity) {
            GunEnchantmentHelper.applyElementalPopEffect(this.getWeapon(), (LivingEntity)entity);
        }
        if (this.shooter instanceof Player) {
            int hitType = critical ? 2 : (headshot ? 1 : 0);
            PacketHandler.getPlayChannel().sendToPlayer(() -> (ServerPlayer)this.shooter, (IMessage)new S2CMessageProjectileHitEntity(hitVec.f_82479_, hitVec.f_82480_, hitVec.f_82481_, hitType, entity instanceof Player));
        }
        if (wasAlive && entity instanceof LivingEntity && !(livingEntity = (LivingEntity)entity).m_6084_()) {
            this.checkForDiamondSteelBonus(livingEntity, hitVec);
            this.checkForBeowulfXPBonus(livingEntity, hitVec);
        }
        PacketHandler.getPlayChannel().sendToTracking(() -> entity, (IMessage)new S2CMessageBlood(hitVec.f_82479_, hitVec.f_82480_, hitVec.f_82481_, entity.m_6095_()));
        this.spawnExplosionParticles(hitVec);
    }

    private void checkForBeowulfXPBonus(LivingEntity killedEntity, Vec3 position) {
        int baseXP;
        int beowulfXP;
        if (!this.m_9236_().f_46443_ && this.getShooter() instanceof Player && (beowulfXP = Math.round((float)(baseXP = killedEntity.m_213860_()) * 0.75f)) > 0) {
            ExperienceOrb xpOrb = new ExperienceOrb(this.m_9236_(), position.f_82479_, position.f_82480_, position.f_82481_, beowulfXP);
            this.m_9236_().m_7967_((Entity)xpOrb);
        }
    }

    @Override
    protected void onHitBlock(BlockState state, BlockPos pos, Direction face, double x, double y, double z) {
        this.spawnExplosionParticles(new Vec3(x, y + 0.1, z));
    }

    @Override
    public void onExpired() {
        this.spawnExplosionParticles(new Vec3(this.m_20185_(), this.m_20186_() + 0.1, this.m_20189_()));
    }

    private void spawnExplosionParticles(Vec3 position) {
        if (!this.m_9236_().f_46443_) {
            ServerLevel serverLevel = (ServerLevel)this.m_9236_();
            int particleCount = 5;
            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.BEOWULF_IMPACT.get()), position.f_82479_, position.f_82480_, position.f_82481_, particleCount, 0.0, 0.0, 0.0, 0.1);
            for (int i = 0; i < particleCount; ++i) {
                double offsetX = (this.f_19796_.m_188500_() - 0.5) * 0.2;
                double offsetY = (this.f_19796_.m_188500_() - 0.5) * 0.2;
                double offsetZ = (this.f_19796_.m_188500_() - 0.5) * 0.2;
                double speedX = (this.f_19796_.m_188500_() - 0.5) * 0.5;
                double speedY = (this.f_19796_.m_188500_() - 0.5) * 0.5;
                double speedZ = (this.f_19796_.m_188500_() - 0.5) * 0.5;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123744_, position.f_82479_ + offsetX, position.f_82480_ + offsetY, position.f_82481_ + offsetZ, 1, speedX, speedY, speedZ, 0.1);
            }
        }
    }
}

