/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.monster;

import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.CaveSpider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.ribs.scguns.blockentity.EnemyTurretBlockEntity;
import top.ribs.scguns.config.MerchantTradeConfig;
import top.ribs.scguns.init.ModBlocks;

public class TheMerchantEntity
extends PathfinderMob
implements Merchant {
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(TheMerchantEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DESPAWN_TIMER = SynchedEntityData.m_135353_(TheMerchantEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DAMAGE_COUNT = SynchedEntityData.m_135353_(TheMerchantEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> WALKING_TO_SUMMONER = SynchedEntityData.m_135353_(TheMerchantEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SUMMONED_BY_PACT = SynchedEntityData.m_135353_(TheMerchantEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private boolean summonedByPact = false;
    private static final int DEFAULT_DESPAWN_TIME = 5000;
    private static final int MAX_DAMAGE_BEFORE_VANISH = 3;
    private static final Logger LOGGER = LogManager.getLogger(TheMerchantEntity.class);
    private int teleportCooldown = 0;
    private static final int TELEPORT_COOLDOWN_TICKS = 3000;
    private static final double TELEPORT_RANGE = 8.0;
    private long tradesSeed = 0L;
    private boolean tradesInitialized = false;
    private UUID summonerUUID;
    @Nullable
    private Player tradingPlayer;
    private MerchantOffers offers = new MerchantOffers();

    public TheMerchantEntity(EntityType<? extends PathfinderMob> pEntityType, Level pLevel, boolean summonedByPact) {
        super(pEntityType, pLevel);
        this.summonedByPact = summonedByPact;
        this.setSummonedByPact(summonedByPact);
        if (summonedByPact) {
            this.setDespawnTimer(5000);
            this.setDamageCount(0);
        }
        this.initializeTrades();
    }

    public TheMerchantEntity(EntityType<? extends PathfinderMob> pEntityType, Level pLevel) {
        this(pEntityType, pLevel, false);
    }

    private void initializeTrades() {
        if (!this.tradesInitialized) {
            if (this.tradesSeed == 0L) {
                this.tradesSeed = this.f_19796_.m_188505_();
            }
            Random tradeRandom = new Random(this.tradesSeed);
            this.offers = MerchantTradeConfig.createRandomizedOffers(tradeRandom);
            this.tradesInitialized = true;
        }
    }

    @NotNull
    public InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        if (!this.m_9236_().m_5776_() && this.m_6084_()) {
            if (this.canTradeWith(player)) {
                this.m_7189_(player);
                this.m_45301_(player, this.m_5446_(), 1);
                return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
    }

    private boolean canTradeWith(Player player) {
        return true;
    }

    public void m_7189_(@Nullable Player player) {
        this.tradingPlayer = player;
    }

    @Nullable
    public Player m_7962_() {
        return this.tradingPlayer;
    }

    @NotNull
    public MerchantOffers m_6616_() {
        return this.offers;
    }

    public void m_6255_(@NotNull MerchantOffers offers) {
        this.offers = offers;
    }

    public void m_6996_(MerchantOffer offer) {
        Level level;
        offer.m_45374_();
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12432_, SoundSource.NEUTRAL, 1.2f, 0.6f);
        if (!this.m_9236_().m_5776_() && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (int i = 0; i < 8; ++i) {
                double angle = (double)i * Math.PI * 2.0 / 8.0;
                double x = this.m_20185_() + Math.cos(angle) * 1.5;
                double z = this.m_20189_() + Math.sin(angle) * 1.5;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123771_, x, this.m_20186_() + 1.5, z, 1, 0.1, 0.1, 0.1, 0.02);
            }
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), 3, 0.3, 0.3, 0.3, 0.01);
        }
    }

    public void m_7713_(@NotNull ItemStack stack) {
    }

    public int m_7809_() {
        return 0;
    }

    public void m_6621_(int xp) {
    }

    public boolean m_7826_() {
        return false;
    }

    @NotNull
    public SoundEvent m_7596_() {
        return SoundEvents.f_12435_;
    }

    public boolean m_183595_() {
        return this.m_9236_().m_5776_();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.m_21183_().m_22268_(Attributes.f_22276_, 130.0).m_22268_(Attributes.f_22277_, 24.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22285_, 0.5).m_22268_(Attributes.f_22284_, 2.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22282_, 0.0).m_22268_(Attributes.f_22281_, 0.0);
    }

    public boolean isSummonedByPact() {
        return (Boolean)this.f_19804_.m_135370_(SUMMONED_BY_PACT);
    }

    public void setSummonedByPact(boolean summoned) {
        this.f_19804_.m_135381_(SUMMONED_BY_PACT, (Object)summoned);
        this.summonedByPact = summoned;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_()) {
            if (this.isSummonedByPact()) {
                this.handleDespawnTimer();
                this.handleWalkingToSummoner();
                if (this.teleportCooldown > 0) {
                    --this.teleportCooldown;
                }
                if (this.teleportCooldown <= 0 && this.isSuffocating()) {
                    this.attemptEmergencyTeleport();
                }
            }
            if (!this.isWalkingToSummoner()) {
                this.handleLookAtNearbyPlayers();
            }
        }
    }

    public boolean m_6469_(@NotNull DamageSource pSource, float pAmount) {
        if (!this.m_9236_().m_5776_() && this.isSummonedByPact()) {
            boolean isSuffocationDamage;
            boolean bl = isSuffocationDamage = pSource == this.m_269291_().m_269318_() || pSource == this.m_269291_().m_269354_();
            if (isSuffocationDamage && this.teleportCooldown <= 0 && this.attemptEmergencyTeleport()) {
                return false;
            }
            if (this.teleportCooldown <= 0 && this.f_19796_.m_188501_() < 0.7f) {
                this.attemptEmergencyTeleport();
            }
            int damageCount = this.getDamageCount() + 1;
            this.setDamageCount(damageCount);
            this.createDamageEffect();
            if (damageCount >= 3) {
                this.despawnWithSpiders();
                return false;
            }
        }
        return super.m_6469_(pSource, pAmount);
    }

    private boolean isSuffocating() {
        BlockPos pos = this.m_20183_();
        BlockState blockState = this.m_9236_().m_8055_(pos);
        BlockState blockStateAbove = this.m_9236_().m_8055_(pos.m_7494_());
        return !blockState.m_60795_() || !blockStateAbove.m_60795_();
    }

    private boolean attemptEmergencyTeleport() {
        Vec3 currentPos = this.m_20182_();
        ServerLevel serverLevel = (ServerLevel)this.m_9236_();
        for (int attempts = 0; attempts < 16; ++attempts) {
            double angle = (double)attempts * Math.PI * 2.0 / 16.0;
            double distance = 3.0 + this.f_19796_.m_188500_() * 8.0;
            double newX = currentPos.f_82479_ + Math.cos(angle) * distance;
            double newZ = currentPos.f_82481_ + Math.sin(angle) * distance;
            for (int yOffset = 2; yOffset >= -3; --yOffset) {
                double newY = currentPos.f_82480_ + (double)yOffset;
                if (!this.isValidTeleportPosition(serverLevel, newX, newY, newZ)) continue;
                this.m_6021_(newX, newY, newZ);
                this.createTeleportEffect(currentPos);
                this.createTeleportEffect(this.m_20182_());
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11852_, SoundSource.NEUTRAL, 1.0f, 1.2f);
                this.teleportCooldown = 3000;
                return true;
            }
        }
        return false;
    }

    private boolean isValidTeleportPosition(ServerLevel level, double x, double y, double z) {
        BlockPos spawnPos = new BlockPos((int)x, (int)y, (int)z);
        BlockPos headPos = spawnPos.m_7494_();
        if (!level.m_8055_(spawnPos).m_60795_() || !level.m_8055_(headPos).m_60795_()) {
            return false;
        }
        boolean hasGroundSupport = false;
        for (int checkY = (int)y; checkY >= (int)y - 3; --checkY) {
            BlockPos checkPos = new BlockPos((int)x, checkY, (int)z);
            if (!level.m_8055_(checkPos).m_60804_((BlockGetter)level, checkPos)) continue;
            hasGroundSupport = true;
            break;
        }
        if (level.m_8055_(spawnPos).m_278721_() || level.m_8055_(spawnPos).m_204336_(BlockTags.f_13076_)) {
            return false;
        }
        return hasGroundSupport;
    }

    private void createTeleportEffect(Vec3 position) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            double offsetZ;
            double offsetY;
            double offsetX;
            int i;
            ServerLevel serverLevel = (ServerLevel)level;
            for (i = 0; i < 20; ++i) {
                offsetX = (this.f_19796_.m_188500_() - 0.5) * 2.0;
                offsetY = this.f_19796_.m_188500_() * 2.0;
                offsetZ = (this.f_19796_.m_188500_() - 0.5) * 2.0;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123771_, position.f_82479_ + offsetX, position.f_82480_ + offsetY, position.f_82481_ + offsetZ, 1, 0.1, 0.1, 0.1, 0.05);
            }
            for (i = 0; i < 10; ++i) {
                offsetX = (this.f_19796_.m_188500_() - 0.5) * 1.5;
                offsetY = this.f_19796_.m_188500_() * 1.5;
                offsetZ = (this.f_19796_.m_188500_() - 0.5) * 1.5;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123755_, position.f_82479_ + offsetX, position.f_82480_ + offsetY + 0.5, position.f_82481_ + offsetZ, 1, 0.0, 0.05, 0.0, 0.02);
            }
        }
    }

    private void handleDespawnTimer() {
        int currentTimer = this.getDespawnTimer();
        if (currentTimer > 0) {
            this.setDespawnTimer(currentTimer - 1);
        } else {
            this.despawnPeacefully();
        }
    }

    private void despawnPeacefully() {
        this.createSmokeEffect();
        this.m_146870_();
    }

    private void handleWalkingToSummoner() {
        if (this.isWalkingToSummoner()) {
            Player summoner = this.getSummoner();
            if (summoner != null) {
                double distance = this.m_20270_((Entity)summoner);
                if (distance <= 3.0) {
                    this.setWalkingToSummoner(false);
                    this.m_21573_().m_26573_();
                    this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12432_, SoundSource.NEUTRAL, 1.5f, 0.5f);
                } else {
                    this.m_21573_().m_5624_((Entity)summoner, 1.0);
                }
            } else {
                this.setWalkingToSummoner(false);
                this.m_21573_().m_26573_();
            }
        }
    }

    private void handleLookAtNearbyPlayers() {
        Player target = this.getSummoner();
        if (target == null || target.m_20280_((Entity)this) > 64.0) {
            target = this.m_9236_().m_45930_((Entity)this, 8.0);
        }
        if (target != null && target.m_20280_((Entity)this) <= 64.0) {
            Vec3 targetPos = target.m_146892_();
            Vec3 merchantPos = this.m_146892_();
            Vec3 lookVector = targetPos.m_82546_(merchantPos).m_82541_();
            double yaw = Math.atan2(-lookVector.f_82479_, lookVector.f_82481_) * 57.29577951308232;
            double pitch = Math.asin(-lookVector.f_82480_) * 57.29577951308232;
            float targetYaw = (float)yaw;
            float targetPitch = (float)Mth.m_14008_((double)pitch, (double)-20.0, (double)20.0);
            float yawDiff = Mth.m_14177_((float)(targetYaw - this.m_146908_()));
            float pitchDiff = targetPitch - this.m_146909_();
            this.m_146922_(this.m_146908_() + Mth.m_14036_((float)yawDiff, (float)-3.0f, (float)3.0f));
            this.m_146926_(this.m_146909_() + Mth.m_14036_((float)pitchDiff, (float)-2.0f, (float)2.0f));
            this.f_20885_ = this.m_146908_();
        }
    }

    private void createDamageEffect() {
        Level level;
        if (!this.m_9236_().m_5776_() && (level = this.m_9236_()) instanceof ServerLevel) {
            double offsetZ;
            double offsetY;
            double offsetX;
            int i;
            ServerLevel serverLevel = (ServerLevel)level;
            for (i = 0; i < 15; ++i) {
                offsetX = this.f_19796_.m_188500_() - 0.5;
                offsetY = this.f_19796_.m_188500_();
                offsetZ = this.f_19796_.m_188500_() - 0.5;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123792_, this.m_20185_() + offsetX, this.m_20186_() + offsetY + 1.0, this.m_20189_() + offsetZ, 1, 0.0, 0.05, 0.0, 0.01);
            }
            for (i = 0; i < 8; ++i) {
                offsetX = (this.f_19796_.m_188500_() - 0.5) * 1.5;
                offsetY = this.f_19796_.m_188500_() * 1.5;
                offsetZ = (this.f_19796_.m_188500_() - 0.5) * 1.5;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_() + offsetX, this.m_20186_() + offsetY + 1.0, this.m_20189_() + offsetZ, 1, 0.0, 0.05, 0.0, 0.01);
            }
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12434_, SoundSource.NEUTRAL, 1.5f, 0.4f);
        }
    }

    private void despawnWithSpiders() {
        this.spawnRevengeSpiders();
        this.spawnRevengeTurrets();
        this.createDespawnEffect();
        this.m_146870_();
    }

    private void spawnRevengeTurrets() {
        Level level;
        if (!this.m_9236_().m_5776_() && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            int turretCount = 3;
            for (int i = 0; i < turretCount; ++i) {
                double angle = (double)i * Math.PI * 2.0 / (double)turretCount;
                double distance = 3.0 + this.f_19796_.m_188500_() * 2.0;
                double x = this.m_20185_() + Math.cos(angle) * distance;
                double z = this.m_20189_() + Math.sin(angle) * distance;
                BlockPos spawnPos = this.findSuitableGroundPosition(serverLevel, x, this.m_20186_(), z);
                if (spawnPos == null) continue;
                BlockState turretState = ((Block)ModBlocks.ENEMY_TURRET.get()).m_49966_();
                serverLevel.m_7731_(spawnPos, turretState, 3);
                BlockEntity blockEntity = serverLevel.m_7702_(spawnPos);
                if (blockEntity instanceof EnemyTurretBlockEntity) {
                    EnemyTurretBlockEntity turretEntity = (EnemyTurretBlockEntity)blockEntity;
                    turretEntity.setDamageMultiplier(1.25f);
                    turretEntity.setFireRateMultiplier(0.5f);
                }
                this.createTurretSpawnEffect(serverLevel, spawnPos);
            }
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12009_, SoundSource.HOSTILE, 2.0f, 0.5f);
        }
    }

    private BlockPos findSuitableGroundPosition(ServerLevel level, double x, double y, double z) {
        BlockPos basePos = new BlockPos((int)x, (int)y, (int)z);
        for (int yOffset = -2; yOffset <= 4; ++yOffset) {
            BlockPos testPos = basePos.m_7918_(0, yOffset, 0);
            BlockPos groundPos = testPos.m_7495_();
            if (!level.m_8055_(groundPos).m_60804_((BlockGetter)level, groundPos) || !level.m_8055_(testPos).m_60795_() || !level.m_8055_(testPos.m_7494_()).m_60795_()) continue;
            return testPos;
        }
        return null;
    }

    private void createTurretSpawnEffect(ServerLevel serverLevel, BlockPos pos) {
        double offsetZ;
        double offsetY;
        double offsetX;
        int i;
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 0.5;
        double z = (double)pos.m_123343_() + 0.5;
        for (i = 0; i < 15; ++i) {
            offsetX = (this.f_19796_.m_188500_() - 0.5) * 1.5;
            offsetY = this.f_19796_.m_188500_() * 2.0;
            offsetZ = (this.f_19796_.m_188500_() - 0.5) * 1.5;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123755_, x + offsetX, y + offsetY, z + offsetZ, 1, 0.0, 0.1, 0.0, 0.05);
        }
        for (i = 0; i < 8; ++i) {
            offsetX = this.f_19796_.m_188500_() - 0.5;
            offsetY = this.f_19796_.m_188500_();
            offsetZ = this.f_19796_.m_188500_() - 0.5;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123744_, x + offsetX, y + offsetY, z + offsetZ, 1, 0.0, 0.05, 0.0, 0.02);
        }
    }

    private void spawnRevengeSpiders() {
        Level level;
        if (!this.m_9236_().m_5776_() && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            int spiderCount = 4 + this.f_19796_.m_188503_(4);
            block0: for (int i = 0; i < spiderCount; ++i) {
                double angle = (double)i * Math.PI * 2.0 / (double)spiderCount;
                double distance = 2.0 + this.f_19796_.m_188500_() * 2.5;
                double x = this.m_20185_() + Math.cos(angle) * distance;
                double z = this.m_20189_() + Math.sin(angle) * distance;
                double y = this.m_20186_();
                BlockPos spawnPos = new BlockPos((int)x, (int)y, (int)z);
                for (int yOffset = -1; yOffset <= 2; ++yOffset) {
                    BlockPos testPos = spawnPos.m_7918_(0, yOffset, 0);
                    if (!serverLevel.m_8055_(testPos).m_60795_() || !serverLevel.m_8055_(testPos.m_7495_()).m_60804_((BlockGetter)serverLevel, testPos.m_7495_())) continue;
                    CaveSpider spider = new CaveSpider(EntityType.f_20554_, (Level)serverLevel);
                    spider.m_6034_((double)testPos.m_123341_() + 0.5, (double)testPos.m_123342_(), (double)testPos.m_123343_() + 0.5);
                    spider.m_6710_((LivingEntity)this.m_9236_().m_45930_((Entity)spider, 16.0));
                    if (!serverLevel.m_7967_((Entity)spider)) continue block0;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, spider.m_20185_(), spider.m_20186_() + 0.5, spider.m_20189_(), 5, 0.2, 0.2, 0.2, 0.02);
                    continue block0;
                }
            }
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12432_, SoundSource.HOSTILE, 2.0f, 0.3f);
        }
    }

    private void createDespawnEffect() {
        Level level;
        if (!this.m_9236_().m_5776_() && (level = this.m_9236_()) instanceof ServerLevel) {
            double offsetZ;
            double offsetY;
            double offsetX;
            int i;
            ServerLevel serverLevel = (ServerLevel)level;
            for (i = 0; i < 30; ++i) {
                offsetX = (this.f_19796_.m_188500_() - 0.5) * 3.0;
                offsetY = this.f_19796_.m_188500_() * 3.0;
                offsetZ = (this.f_19796_.m_188500_() - 0.5) * 3.0;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123755_, this.m_20185_() + offsetX, this.m_20186_() + offsetY + 1.0, this.m_20189_() + offsetZ, 1, 0.0, 0.15, 0.0, 0.04);
            }
            for (i = 0; i < 20; ++i) {
                offsetX = (this.f_19796_.m_188500_() - 0.5) * 2.5;
                offsetY = this.f_19796_.m_188500_() * 2.5;
                offsetZ = (this.f_19796_.m_188500_() - 0.5) * 2.5;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123771_, this.m_20185_() + offsetX, this.m_20186_() + offsetY + 1.0, this.m_20189_() + offsetZ, 1, 0.0, 0.1, 0.0, 0.03);
            }
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12433_, SoundSource.NEUTRAL, 1.8f, 0.3f);
        }
    }

    private void createSmokeEffect() {
        Level level;
        if (!this.m_9236_().m_5776_() && (level = this.m_9236_()) instanceof ServerLevel) {
            double offsetZ;
            double offsetY;
            double offsetX;
            int i;
            ServerLevel serverLevel = (ServerLevel)level;
            for (i = 0; i < 20; ++i) {
                offsetX = (this.f_19796_.m_188500_() - 0.5) * 2.0;
                offsetY = this.f_19796_.m_188500_() * 2.0;
                offsetZ = (this.f_19796_.m_188500_() - 0.5) * 2.0;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123755_, this.m_20185_() + offsetX, this.m_20186_() + offsetY + 1.0, this.m_20189_() + offsetZ, 1, 0.0, 0.1, 0.0, 0.02);
            }
            for (i = 0; i < 10; ++i) {
                offsetX = (this.f_19796_.m_188500_() - 0.5) * 1.5;
                offsetY = this.f_19796_.m_188500_() * 1.5;
                offsetZ = (this.f_19796_.m_188500_() - 0.5) * 1.5;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_() + offsetX, this.m_20186_() + offsetY + 1.0, this.m_20189_() + offsetZ, 1, 0.0, 0.05, 0.0, 0.01);
            }
            for (i = 0; i < 10; ++i) {
                offsetX = (this.f_19796_.m_188500_() - 0.5) * 1.5;
                offsetY = this.f_19796_.m_188500_() * 1.5;
                offsetZ = (this.f_19796_.m_188500_() - 0.5) * 1.5;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123777_, this.m_20185_() + offsetX, this.m_20186_() + offsetY + 1.0, this.m_20189_() + offsetZ, 1, 0.0, 0.05, 0.0, 0.01);
            }
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11852_, SoundSource.NEUTRAL, 1.0f, 1.2f);
        }
    }

    public void createSpawnEffect() {
        Level level;
        if (!this.m_9236_().m_5776_() && (level = this.m_9236_()) instanceof ServerLevel) {
            double offsetZ;
            double offsetY;
            double offsetX;
            int i;
            ServerLevel serverLevel = (ServerLevel)level;
            for (i = 0; i < 40; ++i) {
                offsetX = (this.f_19796_.m_188500_() - 0.5) * 2.5;
                offsetY = this.f_19796_.m_188500_() * 2.5;
                offsetZ = (this.f_19796_.m_188500_() - 0.5) * 2.5;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123755_, this.m_20185_() + offsetX, this.m_20186_() + offsetY, this.m_20189_() + offsetZ, 1, 0.0, 0.15, 0.0, 0.03);
            }
            for (i = 0; i < 15; ++i) {
                offsetX = (this.f_19796_.m_188500_() - 0.5) * 2.0;
                offsetY = this.f_19796_.m_188500_() * 2.0;
                offsetZ = (this.f_19796_.m_188500_() - 0.5) * 2.0;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123771_, this.m_20185_() + offsetX, this.m_20186_() + offsetY + 1.0, this.m_20189_() + offsetZ, 1, 0.0, 0.1, 0.0, 0.02);
            }
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11852_, SoundSource.NEUTRAL, 1.0f, 0.8f);
        }
    }

    public void setSummoner(Player player) {
        this.summonerUUID = player.m_20148_();
    }

    @Nullable
    public Player getSummoner() {
        if (this.summonerUUID != null && !this.m_9236_().m_5776_()) {
            return Objects.requireNonNull(this.m_9236_().m_7654_()).m_6846_().m_11259_(this.summonerUUID);
        }
        return null;
    }

    public boolean isWalkingToSummoner() {
        return (Boolean)this.f_19804_.m_135370_(WALKING_TO_SUMMONER);
    }

    public void setWalkingToSummoner(boolean walking) {
        this.f_19804_.m_135381_(WALKING_TO_SUMMONER, (Object)walking);
    }

    public void setAttacking(boolean attacking) {
        this.f_19804_.m_135381_(ATTACKING, (Object)attacking);
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING);
    }

    public void setDespawnTimer(int timer) {
        this.f_19804_.m_135381_(DESPAWN_TIMER, (Object)timer);
    }

    public int getDespawnTimer() {
        return (Integer)this.f_19804_.m_135370_(DESPAWN_TIMER);
    }

    public void setDamageCount(int count) {
        this.f_19804_.m_135381_(DAMAGE_COUNT, (Object)count);
    }

    public int getDamageCount() {
        return (Integer)this.f_19804_.m_135370_(DAMAGE_COUNT);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
        this.f_19804_.m_135372_(DESPAWN_TIMER, (Object)5000);
        this.f_19804_.m_135372_(DAMAGE_COUNT, (Object)0);
        this.f_19804_.m_135372_(WALKING_TO_SUMMONER, (Object)false);
        this.f_19804_.m_135372_(SUMMONED_BY_PACT, (Object)false);
    }

    protected void m_267689_(float pPartialTick) {
        float f = this.m_20089_() == Pose.STANDING ? Math.min(pPartialTick * 6.0f, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(f, 0.2f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return SoundEvents.f_12432_;
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource pDamageSource) {
        return SoundEvents.f_12434_;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_12433_;
    }

    protected float m_6121_() {
        return 1.0f;
    }

    public float m_6100_() {
        return 0.4f;
    }

    public boolean m_8023_() {
        return true;
    }

    public boolean m_6785_(double pDistanceToClosestPlayer) {
        return false;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("SummonedByPact", this.summonedByPact);
        compound.m_128356_("TradesSeed", this.tradesSeed);
        compound.m_128379_("TradesInitialized", this.tradesInitialized);
        ListTag offersTag = new ListTag();
        for (MerchantOffer offer : this.offers) {
            CompoundTag offerTag = offer.m_45384_();
            offersTag.add((Object)offerTag);
        }
        compound.m_128365_("Offers", (Tag)offersTag);
        if (this.summonerUUID != null) {
            compound.m_128362_("SummonerUUID", this.summonerUUID);
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.summonedByPact = compound.m_128471_("SummonedByPact");
        this.setSummonedByPact(this.summonedByPact);
        if (compound.m_128441_("TradesSeed")) {
            this.tradesSeed = compound.m_128454_("TradesSeed");
        }
        if (compound.m_128441_("TradesInitialized")) {
            this.tradesInitialized = compound.m_128471_("TradesInitialized");
        }
        if (compound.m_128441_("SummonerUUID")) {
            this.summonerUUID = compound.m_128342_("SummonerUUID");
        }
        this.offers = new MerchantOffers();
        if (compound.m_128425_("Offers", 9)) {
            ListTag offersTag = compound.m_128437_("Offers", 10);
            for (int i = 0; i < offersTag.size(); ++i) {
                try {
                    CompoundTag offerTag = offersTag.m_128728_(i);
                    MerchantOffer offer = new MerchantOffer(offerTag);
                    if (!offer.m_45352_().m_41619_() && !offer.m_45368_().m_41619_()) {
                        this.offers.add((Object)offer);
                        continue;
                    }
                    LOGGER.warn("Skipping invalid offer at index {}: empty buy or sell item", (Object)i);
                    continue;
                }
                catch (Exception e) {
                    LOGGER.error("Failed to load merchant offer at index {}: {}", (Object)i, (Object)e.getMessage());
                }
            }
        }
        if (this.offers.isEmpty() && !this.tradesInitialized) {
            this.initializeTrades();
        }
    }
}

