/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.monster;

import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.ribs.scguns.entity.monster.BeaconProjectileEntity;
import top.ribs.scguns.entity.monster.ScampRocketEntity;
import top.ribs.scguns.entity.monster.ScamplerEntity;
import top.ribs.scguns.entity.monster.SkyCarrierEntity;
import top.ribs.scguns.entity.projectile.EnemyProjectileEntity;
import top.ribs.scguns.init.ModEntities;
import top.ribs.scguns.init.ModSounds;
import top.ribs.scguns.init.ModTags;

public class ScampTankEntity
extends Monster
implements RangedAttackMob {
    private static final EntityDataAccessor<Integer> MAIN_TURRET_FLASH_TIMER = SynchedEntityData.m_135353_(ScampTankEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> MACHINE_GUN_FLASH_TIMER = SynchedEntityData.m_135353_(ScampTankEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> IS_CHARGING = SynchedEntityData.m_135353_(ScampTankEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_IN_SECOND_PHASE = SynchedEntityData.m_135353_(ScampTankEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_IN_THIRD_PHASE = SynchedEntityData.m_135353_(ScampTankEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private boolean hasTriggeredWeaponDestruction = false;
    private int mainCannonCooldown = 0;
    private int machineGunCooldown = 0;
    private static final int MAIN_CANNON_COOLDOWN_TICKS = 40;
    private static final int MACHINE_GUN_COOLDOWN_TICKS = 5;
    private static final double MAIN_CANNON_RANGE = 35.0;
    private static final double MACHINE_GUN_RANGE = 12.0;
    private static final double PREFERRED_COMBAT_RANGE = 12.0;
    private static final double MIN_COMBAT_RANGE = 4.0;
    private static final double DETECTION_RANGE = 50.0;
    private int beaconSpawnCooldown = 0;
    private static final int BEACON_SPAWN_COOLDOWN = 60;
    private static final int MAX_SKY_CARRIERS_IN_AREA = 4;
    private static final double SKY_CARRIER_CHECK_RADIUS = 40.0;
    private Vec3 chargeDirection = Vec3.f_82478_;
    private int chargeCooldown = 0;
    private int chargeWarmupTicks = 0;
    private int chargeActiveTicks = 0;
    private static final int CHARGE_WARMUP_DURATION = 20;
    private static final int CHARGE_DURATION = 35;
    private static final int CHARGE_COOLDOWN_DURATION = 60;
    private static final double CHARGE_SPEED = 1.5;
    private static final double CHARGE_DAMAGE = 8.0;
    private static final double CHARGE_RANGE = 45.0;
    private int postChargeRotationTicks = 0;
    private static final int POST_CHARGE_ROTATION_DURATION = 30;
    private boolean isRegenerating = false;
    private int regenerationTicks = 0;
    private static final int REGENERATION_DURATION = 60;
    private static final float REGENERATION_TARGET_HEALTH = 700.0f;
    private static final float REGENERATION_RATE = 2.0f;
    private boolean hasTriggeredThirdPhase = false;
    private boolean isRegeneratingThirdPhase = false;
    private int regenerationTicksThirdPhase = 0;
    private static final int THIRD_PHASE_REGENERATION_DURATION = 60;
    private static final float THIRD_PHASE_REGENERATION_TARGET_HEALTH = 350.0f;
    private static final float THIRD_PHASE_REGENERATION_RATE = 2.5f;
    private int scamplerSpawnCooldown = 0;
    private static final int SCAMPLER_SPAWN_COOLDOWN = 30;
    private static final int MAX_SCAMPLERS_IN_AREA = 10;
    private static final double SCAMPLER_CHECK_RADIUS = 30.0;
    private int thirdPhaseBeaconCooldown = 0;
    private static final int THIRD_PHASE_BEACON_COOLDOWN = 60;
    private static final float THIRD_PHASE_BEACON_CHANCE = 0.65f;
    private int repositionCooldown = 0;
    private int terrainDestructionCooldown = 0;
    private static final int TERRAIN_DESTRUCTION_COOLDOWN_TICKS = 10;
    private final ServerBossEvent bossEvent = new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.YELLOW, BossEvent.BossBarOverlay.PROGRESS);
    private final int avoidanceTimer = 0;
    private int noLineOfSightTimer = 0;
    private static final int NO_LOS_THRESHOLD = 60;
    private boolean isAggressivelyRepositioning = false;
    private Vec3 lastKnownTargetPosition = null;
    private int frustratedShotAttempts = 0;

    public ScampTankEntity(EntityType<? extends ScampTankEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_274367_(2.0f);
        this.bossEvent.m_8321_(false);
        this.f_21364_ = 50;
        this.m_21530_();
        this.m_21153_(this.m_21233_());
    }

    public boolean m_8023_() {
        return true;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public boolean isInSecondPhase() {
        return (Boolean)this.f_19804_.m_135370_(IS_IN_SECOND_PHASE);
    }

    public boolean m_6673_(DamageSource source) {
        return source.m_269533_(DamageTypeTags.f_268745_) || super.m_6673_(source);
    }

    public void setInSecondPhase(boolean inSecondPhase) {
        this.f_19804_.m_135381_(IS_IN_SECOND_PHASE, (Object)inSecondPhase);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 1000.0).m_22268_(Attributes.f_22277_, 35.0).m_22268_(Attributes.f_22279_, 0.35).m_22268_(Attributes.f_22285_, (double)0.8f).m_22268_(Attributes.f_22284_, 12.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22282_, 0.5).m_22268_(Attributes.f_22281_, 3.0);
    }

    public void onRemovedFromWorld() {
        super.onRemovedFromWorld();
        if (!this.m_9236_().f_46443_) {
            this.bossEvent.m_7706_();
        }
    }

    public boolean m_7301_(@NotNull MobEffectInstance pPotionEffect) {
        MobEffect effect = pPotionEffect.m_19544_();
        if (effect == MobEffects.f_19614_ || effect == MobEffects.f_19615_ || effect == MobEffects.f_19612_ || effect == MobEffects.f_19605_ || effect == MobEffects.f_19618_ || effect == MobEffects.f_19604_ || effect == MobEffects.f_19610_ || effect == MobEffects.f_19613_ || effect == MobEffects.f_19597_ || effect == MobEffects.f_19599_ || effect == MobEffects.f_19602_ || effect == MobEffects.f_19601_) {
            return false;
        }
        return super.m_7301_(pPotionEffect);
    }

    public void m_6667_(@NotNull DamageSource pCause) {
        if (this.isRegenerating) {
            this.isRegenerating = false;
            this.m_21195_(MobEffects.f_19606_);
        }
        if (this.isRegeneratingThirdPhase) {
            this.isRegeneratingThirdPhase = false;
            this.m_21195_(MobEffects.f_19606_);
        }
        this.f_19804_.m_135381_(IS_CHARGING, (Object)false);
        this.chargeWarmupTicks = 0;
        this.chargeActiveTicks = 0;
        this.postChargeRotationTicks = 0;
        if (!this.m_9236_().f_46443_) {
            this.bossEvent.m_7706_();
        }
        super.m_6667_(pCause);
    }

    public void m_6593_(Component name) {
        super.m_6593_(name);
        this.bossEvent.m_6456_(name != null ? name : this.m_5446_());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MAIN_TURRET_FLASH_TIMER, (Object)0);
        this.f_19804_.m_135372_(MACHINE_GUN_FLASH_TIMER, (Object)0);
        this.f_19804_.m_135372_(IS_CHARGING, (Object)false);
        this.f_19804_.m_135372_(IS_IN_SECOND_PHASE, (Object)false);
        this.f_19804_.m_135372_(IS_IN_THIRD_PHASE, (Object)false);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new TankChargeGoal());
        this.f_21345_.m_25352_(2, (Goal)new TankChaseGoal());
        this.f_21345_.m_25352_(3, (Goal)new TankLookGoal());
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new ExtendedRangeTargetGoal());
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_269533_(DamageTypeTags.f_268415_)) {
            amount *= 0.5f;
        }
        return super.m_6469_(source, amount);
    }

    public boolean isInThirdPhase() {
        return (Boolean)this.f_19804_.m_135370_(IS_IN_THIRD_PHASE);
    }

    public void setInThirdPhase(boolean inThirdPhase) {
        this.f_19804_.m_135381_(IS_IN_THIRD_PHASE, (Object)inThirdPhase);
    }

    private void triggerWeaponDestruction() {
        if (!this.m_9236_().f_46443_ && !this.hasTriggeredWeaponDestruction && this.m_6084_()) {
            this.hasTriggeredWeaponDestruction = true;
            this.setInSecondPhase(true);
            this.m_21153_(700.0f);
            this.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 60, 1));
            this.isRegenerating = true;
            this.regenerationTicks = 60;
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11913_, SoundSource.HOSTILE, 2.0f, 0.8f);
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                int i;
                ServerLevel serverLevel = (ServerLevel)level;
                double turretX = this.m_20185_();
                double turretY = this.m_20186_() + (double)this.m_20206_() * 0.8;
                double turretZ = this.m_20189_();
                for (int i2 = 0; i2 < 30; ++i2) {
                    double offsetX = (this.f_19796_.m_188500_() - 0.5) * 4.0;
                    double offsetY = (this.f_19796_.m_188500_() - 0.5) * 2.0;
                    double offsetZ = (this.f_19796_.m_188500_() - 0.5) * 4.0;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123813_, turretX + offsetX, turretY + offsetY, turretZ + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
                }
                double machineGunX = this.m_20185_() + Math.cos(Math.toRadians(this.m_146908_() + 90.0f)) * 2.0;
                double machineGunY = this.m_20186_() + (double)this.m_20206_() * 0.6;
                double machineGunZ = this.m_20189_() + Math.sin(Math.toRadians(this.m_146908_() + 90.0f)) * 2.0;
                for (i = 0; i < 20; ++i) {
                    double offsetX = (this.f_19796_.m_188500_() - 0.5) * 2.0;
                    double offsetY = this.f_19796_.m_188500_() - 0.5;
                    double offsetZ = (this.f_19796_.m_188500_() - 0.5) * 2.0;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123813_, machineGunX + offsetX, machineGunY + offsetY, machineGunZ + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
                }
                for (i = 0; i < 50; ++i) {
                    double smokeX = turretX + (this.f_19796_.m_188500_() - 0.5) * 6.0;
                    double smokeY = turretY + this.f_19796_.m_188500_() * 3.0;
                    double smokeZ = turretZ + (this.f_19796_.m_188500_() - 0.5) * 6.0;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123755_, smokeX, smokeY, smokeZ, 1, 0.0, 0.1, 0.0, 0.02);
                }
            }
        }
    }

    private void triggerThirdPhase() {
        if (!this.m_9236_().f_46443_ && !this.hasTriggeredThirdPhase && this.m_6084_()) {
            this.hasTriggeredThirdPhase = true;
            this.setInThirdPhase(true);
            this.m_21153_(350.0f);
            this.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 60, 2));
            this.isRegeneratingThirdPhase = true;
            this.regenerationTicksThirdPhase = 60;
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12563_, SoundSource.HOSTILE, 2.0f, 0.6f);
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                int i;
                ServerLevel serverLevel = (ServerLevel)level;
                for (i = 0; i < 50; ++i) {
                    double offsetX = (this.f_19796_.m_188500_() - 0.5) * 6.0;
                    double offsetY = (this.f_19796_.m_188500_() - 0.5) * 4.0;
                    double offsetZ = (this.f_19796_.m_188500_() - 0.5) * 6.0;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123745_, this.m_20185_() + offsetX, this.m_20186_() + 2.0 + offsetY, this.m_20189_() + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
                }
                for (i = 0; i < 40; ++i) {
                    double smokeX = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 8.0;
                    double smokeY = this.m_20186_() + this.f_19796_.m_188500_() * 4.0;
                    double smokeZ = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 8.0;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123755_, smokeX, smokeY, smokeZ, 1, 0.0, 0.15, 0.0, 0.03);
                }
            }
        }
    }

    private int countNearbyScamplers() {
        if (this.m_9236_().f_46443_) {
            return 0;
        }
        AABB searchArea = new AABB(this.m_20185_() - 30.0, this.m_20186_() - 10.0, this.m_20189_() - 30.0, this.m_20185_() + 30.0, this.m_20186_() + 10.0, this.m_20189_() + 30.0);
        List scamplers = this.m_9236_().m_45976_(ScamplerEntity.class, searchArea);
        return scamplers.size();
    }

    private void spawnScampler() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (this.countNearbyScamplers() >= 10) {
            return;
        }
        for (int attempt = 0; attempt < 10; ++attempt) {
            double angle = this.f_19796_.m_188500_() * Math.PI * 2.0;
            double distance = 3.0 + this.f_19796_.m_188500_() * 4.0;
            double spawnX = this.m_20185_() + Math.cos(angle) * distance;
            double spawnZ = this.m_20189_() + Math.sin(angle) * distance;
            double spawnY = this.m_20186_();
            BlockPos spawnPos = new BlockPos((int)spawnX, (int)spawnY, (int)spawnZ);
            for (int y = 0; y < 5; ++y) {
                BlockPos checkPos = spawnPos.m_6625_(y);
                if (this.m_9236_().m_8055_(checkPos).m_60795_()) continue;
                spawnY = checkPos.m_123342_() + 1;
                break;
            }
            BlockPos finalSpawnPos = new BlockPos((int)spawnX, (int)spawnY, (int)spawnZ);
            if (!this.m_9236_().m_8055_(finalSpawnPos).m_60795_() || !this.m_9236_().m_8055_(finalSpawnPos.m_7494_()).m_60795_()) continue;
            ScamplerEntity scampler = new ScamplerEntity((EntityType<? extends Monster>)((EntityType)ModEntities.SCAMPLER.get()), this.m_9236_());
            scampler.m_7678_(spawnX, spawnY, spawnZ, this.f_19796_.m_188501_() * 360.0f, 0.0f);
            if (this.m_5448_() != null) {
                scampler.m_6710_(this.m_5448_());
            }
            this.m_9236_().m_7967_((Entity)scampler);
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (int i = 0; i < 15; ++i) {
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123759_, spawnX, spawnY + 0.5, spawnZ, 1, 0.3, 0.3, 0.3, 0.1);
                }
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123745_, spawnX, spawnY + 0.5, spawnZ, 5, 0.2, 0.2, 0.2, 0.05);
            }
            this.m_9236_().m_6263_(null, spawnX, spawnY, spawnZ, SoundEvents.f_12601_, SoundSource.HOSTILE, 0.8f, 1.5f);
            break;
        }
    }

    private void checkAndDestroyTerrain() {
        if (this.m_9236_().f_46443_ || this.terrainDestructionCooldown > 0) {
            return;
        }
        AABB destructionBox = this.m_20191_().m_82377_(0.5, 0.2, 0.5);
        BlockPos minPos = new BlockPos((int)Math.floor(destructionBox.f_82288_), (int)Math.floor(destructionBox.f_82289_), (int)Math.floor(destructionBox.f_82290_));
        BlockPos maxPos = new BlockPos((int)Math.ceil(destructionBox.f_82291_), (int)Math.ceil(destructionBox.f_82292_ + 1.0), (int)Math.ceil(destructionBox.f_82293_));
        boolean destroyedAny = false;
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)minPos, (BlockPos)maxPos)) {
            BlockState state = this.m_9236_().m_8055_(pos);
            if (!this.canDestroyBlock(state, pos)) continue;
            this.destroyBlock(pos, state, false);
            destroyedAny = true;
        }
        if (destroyedAny) {
            this.terrainDestructionCooldown = 10;
        }
    }

    private void chargeDestroyTerrain() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        Vec3 chargeDir = this.chargeDirection.m_82541_();
        double checkDistance = 3.0;
        for (double d = 0.0; d <= checkDistance; d += 0.5) {
            Vec3 checkPos = this.m_20182_().m_82549_(chargeDir.m_82490_(d));
            for (int x = -1; x <= 1; ++x) {
                for (int y = 0; y <= 2; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        BlockPos pos = new BlockPos((int)(checkPos.f_82479_ + (double)x), (int)(checkPos.f_82480_ + (double)y), (int)(checkPos.f_82481_ + (double)z));
                        BlockState state = this.m_9236_().m_8055_(pos);
                        if (!this.canDestroyBlock(state, pos)) continue;
                        this.destroyBlock(pos, state, true);
                    }
                }
            }
        }
    }

    private boolean canDestroyBlock(BlockState state, BlockPos pos) {
        if (state.m_60795_()) {
            return false;
        }
        return state.m_204336_(ModTags.Blocks.TANK_BREAKABLE);
    }

    private void destroyBlock(BlockPos pos, BlockState state, boolean isCharging) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (serverLevel.m_46469_().m_46207_(GameRules.f_46136_)) {
                float f = this.f_19796_.m_188501_();
                float f2 = isCharging ? 0.1f : 0.2f;
                if (f < f2) {
                    Block.m_49881_((BlockState)state, (Level)serverLevel, (BlockPos)pos, null, (Entity)this, (ItemStack)ItemStack.f_41583_);
                }
            }
            this.m_9236_().m_46961_(pos, false);
            serverLevel.m_8767_((ParticleOptions)(isCharging ? ParticleTypes.f_123813_ : ParticleTypes.f_123796_), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, isCharging ? 3 : 5, 0.25, 0.25, 0.25, 0.1);
            this.m_9236_().m_5594_(null, pos, isCharging ? SoundEvents.f_12442_ : SoundEvents.f_12630_, SoundSource.BLOCKS, isCharging ? 1.5f : 1.0f, isCharging ? 0.7f : 0.9f);
            if (isCharging) {
                for (int i = 0; i < 10; ++i) {
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123754_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 1, this.f_19796_.m_188583_() * 0.3, this.f_19796_.m_188500_() * 0.3 + 0.2, this.f_19796_.m_188583_() * 0.3, 0.15);
                }
            }
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_6084_()) {
            if (this.isRegenerating) {
                this.isRegenerating = false;
                this.m_21195_(MobEffects.f_19606_);
            }
            if (this.isRegeneratingThirdPhase) {
                this.isRegeneratingThirdPhase = false;
                this.m_21195_(MobEffects.f_19606_);
            }
            this.f_19804_.m_135381_(IS_CHARGING, (Object)false);
            if (!this.m_9236_().f_46443_) {
                this.bossEvent.m_7706_();
            }
            return;
        }
        if (!this.m_9236_().f_46443_) {
            Vec3 movement;
            double speed;
            if (this.terrainDestructionCooldown > 0) {
                --this.terrainDestructionCooldown;
            }
            if ((speed = (movement = this.m_20184_()).m_165924_()) > 0.1) {
                this.checkAndDestroyTerrain();
            }
            this.updateFlashTimers();
            this.updateAttackCooldowns();
            this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
            if (this.isInThirdPhase()) {
                this.bossEvent.m_6451_(BossEvent.BossBarColor.PURPLE);
                this.triggerThirdPhase();
                this.handleThirdPhase();
            } else if (this.isInSecondPhase()) {
                this.bossEvent.m_6451_(BossEvent.BossBarColor.RED);
                this.triggerWeaponDestruction();
                this.handleChargingPhase();
                if (this.m_21223_() / this.m_21233_() <= 0.25f && !this.isRegenerating) {
                    this.setInThirdPhase(true);
                }
                if (this.isRegenerating && this.regenerationTicks > 0) {
                    float currentHealth = this.m_21223_();
                    if (currentHealth < 700.0f) {
                        this.m_21153_(Math.min(currentHealth + 2.0f, 700.0f));
                    }
                    --this.regenerationTicks;
                    if (this.regenerationTicks <= 0) {
                        this.isRegenerating = false;
                        this.m_21195_(MobEffects.f_19606_);
                    }
                }
                if (this.beaconSpawnCooldown > 0) {
                    --this.beaconSpawnCooldown;
                }
            } else {
                this.bossEvent.m_6451_(BossEvent.BossBarColor.YELLOW);
                if (this.m_21223_() / this.m_21233_() <= 0.25f) {
                    this.setInSecondPhase(true);
                } else {
                    this.handleCombat();
                }
            }
            for (ServerPlayer player : Objects.requireNonNull(this.m_9236_().m_7654_()).m_6846_().m_11314_()) {
                double distance = this.m_20280_((Entity)player);
                if (distance < 2500.0 && this.m_6084_()) {
                    this.bossEvent.m_6543_(player);
                    continue;
                }
                this.bossEvent.m_6539_(player);
            }
            if (this.repositionCooldown > 0) {
                --this.repositionCooldown;
            }
            if (this.chargeCooldown > 0) {
                --this.chargeCooldown;
            }
            if (this.scamplerSpawnCooldown > 0) {
                --this.scamplerSpawnCooldown;
            }
            if (this.thirdPhaseBeaconCooldown > 0) {
                --this.thirdPhaseBeaconCooldown;
            }
        }
        if (this.m_9236_().f_46443_ && this.m_6084_()) {
            this.addMovementParticles();
            if (this.isCharging()) {
                this.addChargingParticles();
            }
            if (this.isInThirdPhase()) {
                this.addThirdPhaseParticles();
            }
        }
    }

    private void handleThirdPhase() {
        if (!this.m_6084_()) {
            return;
        }
        if (this.isRegeneratingThirdPhase && this.regenerationTicksThirdPhase > 0) {
            float currentHealth = this.m_21223_();
            if (currentHealth < 350.0f) {
                this.m_21153_(Math.min(currentHealth + 2.5f, 350.0f));
            }
            --this.regenerationTicksThirdPhase;
            if (this.regenerationTicksThirdPhase <= 0) {
                this.isRegeneratingThirdPhase = false;
                this.m_21195_(MobEffects.f_19606_);
            }
        }
        if (this.scamplerSpawnCooldown <= 0) {
            this.spawnScampler();
            this.scamplerSpawnCooldown = 30;
        }
        if (this.thirdPhaseBeaconCooldown <= 0) {
            if (this.f_19796_.m_188501_() < 0.65f) {
                this.spawnThirdPhaseBeacon();
                this.thirdPhaseBeaconCooldown = 60;
            } else {
                this.thirdPhaseBeaconCooldown = 60;
            }
        }
        if (this.m_21573_().m_26571_() && this.f_19796_.m_188503_(100) < 3) {
            double wanderX = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 16.0;
            double wanderZ = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 16.0;
            this.m_21573_().m_26519_(wanderX, this.m_20186_(), wanderZ, 0.4);
        }
    }

    private void spawnThirdPhaseBeacon() {
        Vec3 targetDirection;
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (this.countNearbySkyCatriers() >= 4) {
            return;
        }
        LivingEntity target = this.m_5448_();
        if (target != null) {
            double dx = target.m_20185_() - this.m_20185_();
            double dz = target.m_20189_() - this.m_20189_();
            double length = Math.sqrt(dx * dx + dz * dz);
            double angle = Math.atan2(dz, dx) + (this.f_19796_.m_188500_() - 0.5) * Math.PI * 0.3;
            double distance = 8.0 + this.f_19796_.m_188500_() * 12.0;
            targetDirection = new Vec3(Math.cos(angle) * distance, 0.0, Math.sin(angle) * distance);
        } else {
            double angle = this.f_19796_.m_188500_() * Math.PI * 2.0;
            double distance = 6.0 + this.f_19796_.m_188500_() * 14.0;
            targetDirection = new Vec3(Math.cos(angle) * distance, 0.0, Math.sin(angle) * distance);
        }
        BeaconProjectileEntity beaconProjectile = new BeaconProjectileEntity((EntityType<? extends BeaconProjectileEntity>)((EntityType)ModEntities.BEACON_PROJECTILE.get()), this.m_9236_(), (LivingEntity)this);
        double launchX = this.m_20185_();
        double launchY = this.m_20186_() + (double)this.m_20206_() + 1.0;
        double launchZ = this.m_20189_();
        beaconProjectile.m_6034_(launchX, launchY, launchZ);
        Vec3 landingPos = this.m_20182_().m_82549_(targetDirection);
        beaconProjectile.setLandingTarget(landingPos.f_82479_, landingPos.f_82481_);
        double dx = landingPos.f_82479_ - launchX;
        double dz = landingPos.f_82481_ - launchZ;
        double distance = Math.sqrt(dx * dx + dz * dz);
        double launchVelocity = 1.4;
        double launchAngle = 0.6283185307179586;
        Vec3 launchVector = new Vec3(dx / distance * launchVelocity * Math.cos(launchAngle), launchVelocity * Math.sin(launchAngle), dz / distance * launchVelocity * Math.cos(launchAngle));
        beaconProjectile.m_20256_(launchVector);
        this.m_9236_().m_7967_((Entity)beaconProjectile);
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11798_, SoundSource.HOSTILE, 1.2f, 0.6f);
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            int i;
            ServerLevel serverLevel = (ServerLevel)level;
            for (i = 0; i < 8; ++i) {
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123745_, launchX, launchY, launchZ, 1, 0.2, 0.1, 0.2, 0.08);
            }
            for (i = 0; i < 5; ++i) {
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123755_, launchX, launchY, launchZ, 1, 0.3, 0.1, 0.3, 0.1);
            }
        }
    }

    private void addThirdPhaseParticles() {
        if (this.f_19796_.m_188503_(3) == 0) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123745_, this.m_20185_() + this.f_19796_.m_188583_() * 3.0, this.m_20186_() + 1.0 + this.f_19796_.m_188500_() * 2.0, this.m_20189_() + this.f_19796_.m_188583_() * 3.0, this.f_19796_.m_188583_() * 0.02, 0.05, this.f_19796_.m_188583_() * 0.02);
        }
        if (this.f_19796_.m_188503_(5) == 0) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20185_() + this.f_19796_.m_188583_() * 2.5, this.m_20186_() + 2.0, this.m_20189_() + this.f_19796_.m_188583_() * 2.5, 0.0, 0.08, 0.0);
        }
        if (this.f_19796_.m_188503_(8) == 0) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175830_, this.m_20185_() + this.f_19796_.m_188583_() * 2.0, this.m_20186_() + 1.0 + this.f_19796_.m_188500_(), this.m_20189_() + this.f_19796_.m_188583_() * 2.0, this.f_19796_.m_188583_() * 0.1, this.f_19796_.m_188500_() * 0.1, this.f_19796_.m_188583_() * 0.1);
        }
    }

    private void handleChargingPhase() {
        if (!this.m_6084_()) {
            return;
        }
        LivingEntity target = this.m_5448_();
        if (target == null) {
            return;
        }
        float targetPostChargeYaw = 0.0f;
        if (this.chargeWarmupTicks > 0) {
            --this.chargeWarmupTicks;
            this.m_20256_(this.m_20184_().m_82542_(0.1, 1.0, 0.1));
            if (this.chargeWarmupTicks == 0) {
                this.chargeActiveTicks = 35;
                this.f_19804_.m_135381_(IS_CHARGING, (Object)true);
                double dx = target.m_20185_() - this.m_20185_();
                double dz = target.m_20189_() - this.m_20189_();
                double length = Math.sqrt(dx * dx + dz * dz);
                this.chargeDirection = length > 0.0 ? new Vec3(dx / length, 0.0, dz / length) : Vec3.f_82478_;
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12363_, SoundSource.HOSTILE, 2.0f, 0.7f);
            }
        } else if (this.chargeActiveTicks > 0) {
            --this.chargeActiveTicks;
            this.executeCharge();
            if (this.chargeActiveTicks == 0) {
                this.f_19804_.m_135381_(IS_CHARGING, (Object)false);
                this.chargeCooldown = 60;
                this.m_20256_(this.m_20184_().m_82542_(0.2, 1.0, 0.2));
                this.spawnSupplyBeacons();
                double dx = target.m_20185_() - this.m_20185_();
                double dz = target.m_20189_() - this.m_20189_();
                this.postChargeRotationTicks = 30;
            }
        } else if (this.postChargeRotationTicks > 0) {
            --this.postChargeRotationTicks;
            double dx = target.m_20185_() - this.m_20185_();
            double dz = target.m_20189_() - this.m_20189_();
            targetPostChargeYaw = (float)(Math.atan2(dz, dx) * 57.29577951308232 - 90.0);
            float currentYaw = this.m_146908_();
            float newYaw = this.lerpAngle(currentYaw, targetPostChargeYaw, 0.5f);
            this.m_146922_(newYaw);
            this.f_20883_ = newYaw;
            this.m_5616_(newYaw);
            this.m_20256_(this.m_20184_().m_82542_(0.0, 1.0, 0.0));
            this.m_21573_().m_26573_();
            if (this.postChargeRotationTicks == 0) {
                this.m_146922_(targetPostChargeYaw);
                this.f_20883_ = targetPostChargeYaw;
                this.m_5616_(targetPostChargeYaw);
            }
        }
    }

    private float lerpAngle(float current, float target, float factor) {
        float difference;
        for (difference = target - current; difference > 180.0f; difference -= 360.0f) {
        }
        while (difference < -180.0f) {
            difference += 360.0f;
        }
        return current + difference * factor;
    }

    private void executeCharge() {
        Vec3 movement = this.chargeDirection.m_82490_(1.5);
        this.m_20334_(movement.f_82479_, this.m_20184_().f_82480_, movement.f_82481_);
        this.chargeDestroyTerrain();
        AABB hitBox = this.m_20191_().m_82369_(movement).m_82400_(0.5);
        List entities = this.m_9236_().m_6443_(LivingEntity.class, hitBox, entity -> entity != this && entity.m_6084_() && !entity.m_5833_());
        for (LivingEntity entity2 : entities) {
            double dz;
            if (!entity2.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 8.0f)) continue;
            double dx = entity2.m_20185_() - this.m_20185_();
            double distance = Math.sqrt(dx * dx + (dz = entity2.m_20189_() - this.m_20189_()) * dz);
            if (distance > 0.0) {
                entity2.m_20256_(entity2.m_20184_().m_82520_(dx / distance * 1.5, 0.3, dz / distance * 1.5));
            }
            this.m_9236_().m_6263_(null, entity2.m_20185_(), entity2.m_20186_(), entity2.m_20189_(), SoundEvents.f_215710_, SoundSource.HOSTILE, 1.5f, 0.8f);
        }
        BlockPos frontPos = new BlockPos((int)(this.m_20185_() + this.chargeDirection.f_82479_ * 2.5), (int)this.m_20186_(), (int)(this.m_20189_() + this.chargeDirection.f_82481_ * 2.5));
        BlockState blockState = this.m_9236_().m_8055_(frontPos);
        if (!blockState.m_60795_() && blockState.m_280555_()) {
            this.chargeActiveTicks = 0;
            this.f_19804_.m_135381_(IS_CHARGING, (Object)false);
            this.chargeCooldown = 20;
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (int i = 0; i < 25; ++i) {
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123797_, (double)frontPos.m_123341_() + 0.5, (double)frontPos.m_123342_() + 1.0, (double)frontPos.m_123343_() + 0.5, 1, 0.5, 0.5, 0.5, 0.1);
                }
            }
            this.m_9236_().m_6263_(null, (double)frontPos.m_123341_(), (double)frontPos.m_123342_(), (double)frontPos.m_123343_(), SoundEvents.f_11666_, SoundSource.HOSTILE, 2.0f, 0.6f);
        }
    }

    private void addChargingParticles() {
        if (this.f_19796_.m_188503_(2) == 0) {
            double backX = this.m_20185_() - Math.cos(Math.toRadians(this.m_146908_())) * 2.5;
            double backZ = this.m_20189_() - Math.sin(Math.toRadians(this.m_146908_())) * 2.5;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, backX + this.f_19796_.m_188583_() * 0.3, this.m_20186_() + 2.0 + this.f_19796_.m_188500_() * 0.5, backZ + this.f_19796_.m_188583_() * 0.3, this.f_19796_.m_188583_() * 0.05, 0.1, this.f_19796_.m_188583_() * 0.05);
        }
        if (this.f_19796_.m_188503_(1) == 0) {
            this.addIntenseTreadParticles();
        }
        if (this.f_19796_.m_188503_(3) == 0) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175830_, this.m_20185_() + this.f_19796_.m_188583_() * 2.0, this.m_20186_() + 1.0 + this.f_19796_.m_188500_(), this.m_20189_() + this.f_19796_.m_188583_() * 2.0, this.f_19796_.m_188583_() * 0.2, this.f_19796_.m_188500_() * 0.2, this.f_19796_.m_188583_() * 0.2);
        }
    }

    private void addIntenseTreadParticles() {
        for (int side = 0; side < 2; ++side) {
            double sideOffset = side == 0 ? -1.5 : 1.5;
            double treadX = this.m_20185_() + sideOffset * Math.cos(Math.toRadians(this.m_146908_() + 90.0f));
            double treadZ = this.m_20189_() + sideOffset * Math.sin(Math.toRadians(this.m_146908_() + 90.0f));
            for (int i = 0; i < 4; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123759_, treadX + this.f_19796_.m_188583_() * 0.5, this.m_20186_() + 0.1, treadZ + this.f_19796_.m_188583_() * 0.5, this.f_19796_.m_188583_() * 0.3, this.f_19796_.m_188500_() * 0.2, this.f_19796_.m_188583_() * 0.3);
            }
        }
    }

    private boolean hasCleanLineOfSight(LivingEntity target) {
        double[][] checkPoints;
        if (target == null) {
            return false;
        }
        for (double[] point : checkPoints = new double[][]{{0.0, (double)this.m_20206_() * 0.8, 0.0}, {0.0, (double)this.m_20206_() * 0.6, 0.0}, {0.0, (double)this.m_20206_() * 1.2, 0.0}}) {
            Vec3 tankPos = new Vec3(this.m_20185_() + point[0], this.m_20186_() + point[1], this.m_20189_() + point[2]);
            Vec3 targetPos = new Vec3(target.m_20185_(), target.m_20186_() + (double)target.m_20206_() * 0.5, target.m_20189_());
            if (this.m_9236_().m_45547_(new ClipContext(tankPos, targetPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).m_6662_() != HitResult.Type.MISS) continue;
            return true;
        }
        return false;
    }

    public void m_6710_(@Nullable LivingEntity target) {
        super.m_6710_(target);
        if (target != null && !this.m_9236_().f_46443_) {
            this.bossEvent.m_8321_(true);
        }
    }

    private void handleCombat() {
        Player player;
        LivingEntity target = this.m_5448_();
        if (target == null) {
            this.noLineOfSightTimer = 0;
            return;
        }
        if (target instanceof Player && ((player = (Player)target).m_7500_() || player.m_5833_())) {
            this.m_6710_(null);
            return;
        }
        boolean hasLOS = this.hasCleanLineOfSight(target);
        double distanceToTarget = this.m_20280_((Entity)target);
        if (!hasLOS) {
            ++this.noLineOfSightTimer;
            this.lastKnownTargetPosition = target.m_20182_();
            if (this.noLineOfSightTimer >= 60 && !this.isAggressivelyRepositioning) {
                this.initiateAggressiveRepositioning();
            }
            if (this.noLineOfSightTimer < 20 && this.lastKnownTargetPosition != null) {
                this.attemptPredictiveShot(target);
            }
        } else {
            this.noLineOfSightTimer = 0;
            this.isAggressivelyRepositioning = false;
            this.frustratedShotAttempts = 0;
            if (distanceToTarget <= 144.0 && this.machineGunCooldown <= 0) {
                this.fireMachineGun(target);
                this.machineGunCooldown = 5;
            } else if (distanceToTarget > 144.0 && distanceToTarget <= 1225.0 && this.mainCannonCooldown <= 0) {
                this.fireMainCannon(target);
                this.mainCannonCooldown = 40;
            }
        }
    }

    private void initiateAggressiveRepositioning() {
        LivingEntity target = this.m_5448_();
        if (target == null) {
            return;
        }
        this.isAggressivelyRepositioning = true;
        ++this.frustratedShotAttempts;
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12363_, SoundSource.HOSTILE, 1.5f, 0.5f);
        if (this.frustratedShotAttempts >= 3 && !this.isInSecondPhase()) {
            this.fireSuppressionBarrage(this.lastKnownTargetPosition);
            this.frustratedShotAttempts = 0;
        }
    }

    private void attemptPredictiveShot(LivingEntity target) {
        if (this.mainCannonCooldown > 0 || this.lastKnownTargetPosition == null) {
            return;
        }
        Vec3 targetVelocity = target.m_20184_();
        Vec3 predictedPos = this.lastKnownTargetPosition.m_82520_(targetVelocity.f_82479_ * 20.0, targetVelocity.f_82480_ * 10.0, targetVelocity.f_82481_ * 20.0);
        double turretHeight = (double)this.m_20206_() * 1.2;
        double spawnX = this.m_20185_();
        double spawnY = this.m_20186_() + turretHeight;
        double spawnZ = this.m_20189_();
        ScampRocketEntity rocket = new ScampRocketEntity((EntityType<? extends ScampRocketEntity>)((EntityType)ModEntities.SCAMP_ROCKET.get()), this.m_9236_(), (LivingEntity)this);
        rocket.m_6034_(spawnX, spawnY, spawnZ);
        rocket.setDamage(5.0);
        rocket.setExplosionRadius(4.0f);
        double dx = predictedPos.f_82479_ - spawnX;
        double dy = predictedPos.f_82480_ - spawnY;
        double dz = predictedPos.f_82481_ - spawnZ;
        rocket.m_6686_(dx, dy, dz, 2.8f, 2.0f);
        this.m_9236_().m_7967_((Entity)rocket);
        this.mainCannonCooldown = 20;
    }

    private void fireSuppressionBarrage(Vec3 targetArea) {
        if (this.m_9236_().f_46443_) {
            return;
        }
        for (int i = 0; i < 5; ++i) {
            ScampRocketEntity rocket = new ScampRocketEntity((EntityType<? extends ScampRocketEntity>)((EntityType)ModEntities.SCAMP_ROCKET.get()), this.m_9236_(), (LivingEntity)this);
            double spawnX = this.m_20185_();
            double spawnY = this.m_20186_() + (double)this.m_20206_() * 1.2;
            double spawnZ = this.m_20189_();
            rocket.m_6034_(spawnX, spawnY, spawnZ);
            rocket.setDamage(4.0);
            rocket.setExplosionRadius(3.0f);
            double spreadX = (this.f_19796_.m_188500_() - 0.5) * 8.0;
            double spreadZ = (this.f_19796_.m_188500_() - 0.5) * 8.0;
            double dx = targetArea.f_82479_ + spreadX - spawnX;
            double dy = targetArea.f_82480_ - spawnY;
            double dz = targetArea.f_82481_ + spreadZ - spawnZ;
            rocket.m_6686_(dx, dy, dz, 2.5f, 3.0f);
            this.m_9236_().m_7967_((Entity)rocket);
        }
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11932_, SoundSource.HOSTILE, 2.0f, 0.6f);
        this.mainCannonCooldown = 80;
    }

    private void updateFlashTimers() {
        int machineTimer;
        int mainTimer = (Integer)this.f_19804_.m_135370_(MAIN_TURRET_FLASH_TIMER);
        if (mainTimer > 0) {
            this.f_19804_.m_135381_(MAIN_TURRET_FLASH_TIMER, (Object)(mainTimer - 1));
        }
        if ((machineTimer = ((Integer)this.f_19804_.m_135370_(MACHINE_GUN_FLASH_TIMER)).intValue()) > 0) {
            this.f_19804_.m_135381_(MACHINE_GUN_FLASH_TIMER, (Object)(machineTimer - 1));
        }
    }

    private void updateAttackCooldowns() {
        if (this.mainCannonCooldown > 0) {
            --this.mainCannonCooldown;
        }
        if (this.machineGunCooldown > 0) {
            --this.machineGunCooldown;
        }
    }

    public boolean isCharging() {
        return (Boolean)this.f_19804_.m_135370_(IS_CHARGING);
    }

    private void addMovementParticles() {
        Vec3 deltaMovement = this.m_20184_();
        double speed = deltaMovement.m_165924_();
        if (speed > 0.02) {
            float intensity = (float)Math.min(speed * 2.0, 1.0);
            if (this.f_19796_.m_188503_(2) == 0) {
                this.addTreadDustParticles(intensity);
            }
            if (this.f_19796_.m_188503_(3) == 0) {
                this.addExhaustSmoke(intensity);
            }
            if (speed > 0.1 && this.f_19796_.m_188503_(4) == 0) {
                this.addGroundImpactParticles(intensity);
            }
            if (speed > 0.03 && this.f_19796_.m_188503_(8) == 0) {
                this.addMechanicalSparks();
            }
        }
    }

    private void addTreadDustParticles(float intensity) {
        double leftX = this.m_20185_() - 1.5 * Math.cos(Math.toRadians(this.m_146908_() + 90.0f));
        double leftZ = this.m_20189_() - 1.5 * Math.sin(Math.toRadians(this.m_146908_() + 90.0f));
        for (int i = 0; i < (int)(3.0f * intensity); ++i) {
            double offsetX = this.f_19796_.m_188583_() * 0.3;
            double offsetZ = this.f_19796_.m_188583_() * 0.3;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123759_, leftX + offsetX, this.m_20186_() + 0.1, leftZ + offsetZ, this.f_19796_.m_188583_() * 0.1, this.f_19796_.m_188500_() * 0.1, this.f_19796_.m_188583_() * 0.1);
        }
        double rightX = this.m_20185_() + 1.5 * Math.cos(Math.toRadians(this.m_146908_() + 90.0f));
        double rightZ = this.m_20189_() + 1.5 * Math.sin(Math.toRadians(this.m_146908_() + 90.0f));
        for (int i = 0; i < (int)(3.0f * intensity); ++i) {
            double offsetX = this.f_19796_.m_188583_() * 0.3;
            double offsetZ = this.f_19796_.m_188583_() * 0.3;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123759_, rightX + offsetX, this.m_20186_() + 0.1, rightZ + offsetZ, this.f_19796_.m_188583_() * 0.1, this.f_19796_.m_188500_() * 0.1, this.f_19796_.m_188583_() * 0.1);
        }
        if (this.f_19796_.m_188503_(3) == 0) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123796_, this.m_20185_() + this.f_19796_.m_188583_() * 2.0, this.m_20186_() + 0.2, this.m_20189_() + this.f_19796_.m_188583_() * 2.0, 0.0, 0.05, 0.0);
        }
    }

    private void addExhaustSmoke(float intensity) {
        double backX = this.m_20185_() - 2.0 * Math.cos(Math.toRadians(this.m_146908_()));
        double backZ = this.m_20189_() - 2.0 * Math.sin(Math.toRadians(this.m_146908_()));
        for (int i = 0; i < (int)(2.0f * intensity); ++i) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, backX + this.f_19796_.m_188583_() * 0.5, this.m_20186_() + 2.0 + this.f_19796_.m_188500_() * 0.5, backZ + this.f_19796_.m_188583_() * 0.5, this.f_19796_.m_188583_() * 0.02, 0.05 + this.f_19796_.m_188500_() * 0.03, this.f_19796_.m_188583_() * 0.02);
        }
        if (this.f_19796_.m_188503_(5) == 0) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, backX, this.m_20186_() + 2.2, backZ, 0.0, 0.08, 0.0);
        }
    }

    private void addGroundImpactParticles(float intensity) {
        for (int i = 0; i < (int)(4.0f * intensity); ++i) {
            double offsetX = this.f_19796_.m_188583_() * 1.5;
            double offsetZ = this.f_19796_.m_188583_() * 1.5;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123796_, this.m_20185_() + offsetX, this.m_20186_(), this.m_20189_() + offsetZ, this.f_19796_.m_188583_() * 0.1, this.f_19796_.m_188500_() * 0.2, this.f_19796_.m_188583_() * 0.1);
        }
        if (this.f_19796_.m_188503_(6) == 0) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123777_, this.m_20185_() + this.f_19796_.m_188583_() * 2.0, this.m_20186_() + 0.1, this.m_20189_() + this.f_19796_.m_188583_() * 2.0, 0.0, 0.03, 0.0);
        }
    }

    private void addMechanicalSparks() {
        double sparkX = this.m_20185_() + this.f_19796_.m_188583_() * 2.0;
        double sparkZ = this.m_20189_() + this.f_19796_.m_188583_() * 2.0;
        if (this.f_19796_.m_188503_(3) == 0) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175830_, sparkX, this.m_20186_() + 1.0, sparkZ, this.f_19796_.m_188583_() * 0.1, this.f_19796_.m_188500_() * 0.15, this.f_19796_.m_188583_() * 0.1);
        }
    }

    private void fireMainCannon(LivingEntity target) {
        double turretHeight = (double)this.m_20206_() * 1.2;
        double turretForwardOffset = 2.0;
        double spawnX = this.m_20185_() + Math.cos(Math.toRadians(this.m_146908_() + 90.0f)) * turretForwardOffset;
        double spawnY = this.m_20186_() + turretHeight;
        double spawnZ = this.m_20189_() + Math.sin(Math.toRadians(this.m_146908_() + 90.0f)) * turretForwardOffset;
        ScampRocketEntity rocket = new ScampRocketEntity((EntityType<? extends ScampRocketEntity>)((EntityType)ModEntities.SCAMP_ROCKET.get()), this.m_9236_(), (LivingEntity)this);
        rocket.m_6034_(spawnX, spawnY, spawnZ);
        rocket.setDamage(5.0);
        rocket.setExplosionRadius(3.5f);
        double dx = target.m_20185_() + target.m_20184_().f_82479_ * 10.0 - spawnX;
        double dy = target.m_20188_() - spawnY;
        double dz = target.m_20189_() + target.m_20184_().f_82481_ * 10.0 - spawnZ;
        rocket.m_6686_(dx, dy, dz, 2.6f, 1.0f);
        this.m_9236_().m_7967_((Entity)rocket);
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11913_, SoundSource.HOSTILE, 1.2f, 0.7f);
        this.triggerMainTurretFlash();
    }

    private void fireMachineGun(LivingEntity target) {
        double machineGunHeight = (double)this.m_20206_() * 0.8;
        double machineGunOffset = 1.0;
        double spawnX = this.m_20185_() + Math.cos(Math.toRadians(this.m_146908_() + 90.0f)) * machineGunOffset;
        double spawnY = this.m_20186_() + machineGunHeight;
        double spawnZ = this.m_20189_() + Math.sin(Math.toRadians(this.m_146908_() + 90.0f)) * machineGunOffset;
        EnemyProjectileEntity bolt = new EnemyProjectileEntity(this.m_9236_(), (LivingEntity)this);
        bolt.m_6034_(spawnX, spawnY, spawnZ);
        double dx = target.m_20185_() - spawnX;
        double dy = target.m_20188_() - spawnY;
        double dz = target.m_20189_() - spawnZ;
        bolt.m_6686_(dx, dy, dz, 3.0f, 1.5f);
        this.m_9236_().m_7967_((Entity)bolt);
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSounds.BRUISER_SILENCED_FIRE.get(), SoundSource.HOSTILE, 0.8f, 1.2f);
        this.triggerMachineGunFlash();
    }

    private int countNearbySkyCatriers() {
        if (this.m_9236_().f_46443_) {
            return 0;
        }
        AABB searchArea = new AABB(this.m_20185_() - 40.0, this.m_20186_() - 20.0, this.m_20189_() - 40.0, this.m_20185_() + 40.0, this.m_20186_() + 40.0, this.m_20189_() + 40.0);
        List skyCarriers = this.m_9236_().m_45976_(SkyCarrierEntity.class, searchArea);
        return skyCarriers.size();
    }

    private void shootBeaconProjectile() {
        Vec3 targetDirection;
        if (this.m_9236_().f_46443_) {
            return;
        }
        LivingEntity target = this.m_5448_();
        if (target != null) {
            double dx = target.m_20185_() - this.m_20185_();
            double dz = target.m_20189_() - this.m_20189_();
            double length = Math.sqrt(dx * dx + dz * dz);
            double angle = Math.atan2(dz, dx) + (this.f_19796_.m_188500_() - 0.5) * Math.PI * 0.5;
            double distance = 15.0 + this.f_19796_.m_188500_() * 10.0;
            targetDirection = new Vec3(Math.cos(angle) * distance, 0.0, Math.sin(angle) * distance);
        } else {
            double angle = this.f_19796_.m_188500_() * Math.PI * 2.0;
            double distance = 10.0 + this.f_19796_.m_188500_() * 20.0;
            targetDirection = new Vec3(Math.cos(angle) * distance, 0.0, Math.sin(angle) * distance);
        }
        BeaconProjectileEntity beaconProjectile = new BeaconProjectileEntity((EntityType<? extends BeaconProjectileEntity>)((EntityType)ModEntities.BEACON_PROJECTILE.get()), this.m_9236_(), (LivingEntity)this);
        double launchX = this.m_20185_();
        double launchY = this.m_20186_() + (double)this.m_20206_() + 1.0;
        double launchZ = this.m_20189_();
        beaconProjectile.m_6034_(launchX, launchY, launchZ);
        Vec3 landingPos = this.m_20182_().m_82549_(targetDirection);
        beaconProjectile.setLandingTarget(landingPos.f_82479_, landingPos.f_82481_);
        double dx = landingPos.f_82479_ - launchX;
        double dz = landingPos.f_82481_ - launchZ;
        double distance = Math.sqrt(dx * dx + dz * dz);
        double launchVelocity = 1.2;
        double launchAngle = 0.5235987755982988;
        Vec3 launchVector = new Vec3(dx / distance * launchVelocity * Math.cos(launchAngle), launchVelocity * Math.sin(launchAngle), dz / distance * launchVelocity * Math.cos(launchAngle));
        beaconProjectile.m_20256_(launchVector);
        this.m_9236_().m_7967_((Entity)beaconProjectile);
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11798_, SoundSource.HOSTILE, 1.5f, 0.8f);
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (int i = 0; i < 10; ++i) {
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, launchX, launchY, launchZ, 1, 0.3, 0.1, 0.3, 0.1);
            }
        }
    }

    private boolean shouldSpawnBeacon() {
        if (this.beaconSpawnCooldown > 0) {
            return false;
        }
        if (this.countNearbySkyCatriers() >= 4) {
            return false;
        }
        return this.f_19796_.m_188501_() < 0.3f;
    }

    private void spawnSupplyBeacons() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (!this.shouldSpawnBeacon()) {
            return;
        }
        this.shootBeaconProjectile();
        this.beaconSpawnCooldown = 60;
    }

    public void triggerMainTurretFlash() {
        this.f_19804_.m_135381_(MAIN_TURRET_FLASH_TIMER, (Object)4);
    }

    public void triggerMachineGunFlash() {
        this.f_19804_.m_135381_(MACHINE_GUN_FLASH_TIMER, (Object)4);
    }

    public boolean isMainTurretFlashVisible() {
        return (Integer)this.f_19804_.m_135370_(MAIN_TURRET_FLASH_TIMER) > 0;
    }

    public boolean isMachineGunFlashVisible() {
        return (Integer)this.f_19804_.m_135370_(MACHINE_GUN_FLASH_TIMER) > 0;
    }

    public void m_6504_(@NotNull LivingEntity target, float distanceFactor) {
    }

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return SoundEvents.f_12010_;
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource pDamageSource) {
        return SoundEvents.f_12008_;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_12059_;
    }

    private class TankChargeGoal
    extends Goal {
        public TankChargeGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            if (!ScampTankEntity.this.m_6084_()) {
                return false;
            }
            if (!ScampTankEntity.this.isInSecondPhase() || ScampTankEntity.this.isInThirdPhase()) {
                return false;
            }
            if (ScampTankEntity.this.chargeCooldown > 0) {
                return false;
            }
            if (ScampTankEntity.this.chargeWarmupTicks > 0 || ScampTankEntity.this.chargeActiveTicks > 0) {
                return false;
            }
            if (ScampTankEntity.this.postChargeRotationTicks > 0) {
                return false;
            }
            LivingEntity target = ScampTankEntity.this.m_5448_();
            if (target == null || !target.m_6084_()) {
                return false;
            }
            double distance = ScampTankEntity.this.m_20270_((Entity)target);
            return distance <= 45.0 && ScampTankEntity.this.m_142582_((Entity)target);
        }

        public boolean m_8045_() {
            if (!ScampTankEntity.this.m_6084_()) {
                return false;
            }
            return ScampTankEntity.this.chargeWarmupTicks > 0 || ScampTankEntity.this.chargeActiveTicks > 0 || ScampTankEntity.this.postChargeRotationTicks > 0;
        }

        public void m_8056_() {
            double dz;
            LivingEntity target = ScampTankEntity.this.m_5448_();
            if (target == null) {
                return;
            }
            Vec3 targetVelocity = target.m_20184_();
            double predictionTime = 1.25;
            double predictedX = target.m_20185_() + targetVelocity.f_82479_ * predictionTime * 20.0;
            double predictedZ = target.m_20189_() + targetVelocity.f_82481_ * predictionTime * 20.0;
            double dx = predictedX - ScampTankEntity.this.m_20185_();
            double distance = Math.sqrt(dx * dx + (dz = predictedZ - ScampTankEntity.this.m_20189_()) * dz);
            if (distance > 0.0) {
                ScampTankEntity.this.chargeDirection = new Vec3(dx / distance, 0.0, dz / distance);
                float yaw = (float)(Math.atan2(dz, dx) * 57.29577951308232 - 90.0);
                ScampTankEntity.this.m_146922_(yaw);
                ScampTankEntity.this.f_20883_ = yaw;
                ScampTankEntity.this.chargeWarmupTicks = 20;
                ScampTankEntity.this.m_9236_().m_6263_(null, ScampTankEntity.this.m_20185_(), ScampTankEntity.this.m_20186_(), ScampTankEntity.this.m_20189_(), SoundEvents.f_12312_, SoundSource.HOSTILE, 2.0f, 0.5f);
            }
        }

        public void m_8037_() {
            ScampTankEntity.this.m_21573_().m_26573_();
        }

        public void m_8041_() {
            ScampTankEntity.this.f_19804_.m_135381_(IS_CHARGING, (Object)false);
        }
    }

    private class TankChaseGoal
    extends Goal {
        private int pathUpdateTimer = 0;
        private double targetX;
        private double targetZ;
        private boolean hasDestination = false;

        public TankChaseGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            if (!ScampTankEntity.this.m_6084_()) {
                return false;
            }
            if (ScampTankEntity.this.isInThirdPhase()) {
                return true;
            }
            if (ScampTankEntity.this.isInSecondPhase() || ScampTankEntity.this.postChargeRotationTicks > 0) {
                return false;
            }
            LivingEntity target = ScampTankEntity.this.m_5448_();
            if (target == null || !target.m_6084_()) {
                return false;
            }
            double distance = ScampTankEntity.this.m_20270_((Entity)target);
            return distance > 4.0 || ScampTankEntity.this.avoidanceTimer > 0;
        }

        public boolean m_8045_() {
            if (!ScampTankEntity.this.m_6084_()) {
                return false;
            }
            if (ScampTankEntity.this.isInThirdPhase()) {
                return this.hasDestination && !ScampTankEntity.this.m_21573_().m_26571_();
            }
            if (ScampTankEntity.this.isInSecondPhase() || ScampTankEntity.this.postChargeRotationTicks > 0) {
                return false;
            }
            LivingEntity target = ScampTankEntity.this.m_5448_();
            return target != null && target.m_6084_();
        }

        public void m_8056_() {
            this.pathUpdateTimer = 0;
            this.calculateDestination();
        }

        public void m_8037_() {
            double distToDestination;
            LivingEntity target = ScampTankEntity.this.m_5448_();
            if (target == null) {
                return;
            }
            ++this.pathUpdateTimer;
            if (ScampTankEntity.this.isAggressivelyRepositioning) {
                if (this.pathUpdateTimer % 10 == 0) {
                    this.calculateAggressiveDestination(target);
                }
            } else if (this.pathUpdateTimer >= 40) {
                this.pathUpdateTimer = 0;
                this.calculateDestination();
            }
            if (this.hasDestination && (distToDestination = Math.sqrt(Math.pow(ScampTankEntity.this.m_20185_() - this.targetX, 2.0) + Math.pow(ScampTankEntity.this.m_20189_() - this.targetZ, 2.0))) < 3.0) {
                this.hasDestination = false;
                if (ScampTankEntity.this.isAggressivelyRepositioning && ScampTankEntity.this.hasCleanLineOfSight(target)) {
                    ScampTankEntity.this.isAggressivelyRepositioning = false;
                }
            }
        }

        private void calculateDestination() {
            double dz;
            double dx;
            double length;
            LivingEntity target = ScampTankEntity.this.m_5448_();
            if (target == null) {
                return;
            }
            double distance = ScampTankEntity.this.m_20270_((Entity)target);
            if (distance > 15.0) {
                double dz2;
                double dx2 = target.m_20185_() - ScampTankEntity.this.m_20185_();
                double length2 = Math.sqrt(dx2 * dx2 + (dz2 = target.m_20189_() - ScampTankEntity.this.m_20189_()) * dz2);
                if (length2 > 0.0) {
                    double targetDistance = 12.0;
                    this.targetX = target.m_20185_() - dx2 / length2 * targetDistance;
                    this.targetZ = target.m_20189_() - dz2 / length2 * targetDistance;
                    ScampTankEntity.this.m_21573_().m_26519_(this.targetX, target.m_20186_(), this.targetZ, 0.8);
                    this.hasDestination = true;
                }
            } else if (distance < 4.0 && (length = Math.sqrt((dx = ScampTankEntity.this.m_20185_() - target.m_20185_()) * dx + (dz = ScampTankEntity.this.m_20189_() - target.m_20189_()) * dz)) > 0.0) {
                this.targetX = ScampTankEntity.this.m_20185_() + dx / length * 8.0;
                this.targetZ = ScampTankEntity.this.m_20189_() + dz / length * 8.0;
                ScampTankEntity.this.m_21573_().m_26519_(this.targetX, target.m_20186_(), this.targetZ, 0.6);
                this.hasDestination = true;
            }
        }

        private void calculateAggressiveDestination(LivingEntity target) {
            double[] angleOffsets;
            double angle = Math.atan2(target.m_20189_() - ScampTankEntity.this.m_20189_(), target.m_20185_() - ScampTankEntity.this.m_20185_());
            for (double offset : angleOffsets = new double[]{1.0471975511965976, -1.0471975511965976, 1.5707963267948966, -1.5707963267948966, 2.0943951023931953, -2.0943951023931953}) {
                double testAngle = angle + offset;
                double testDistance = 12.0;
                this.targetX = target.m_20185_() + Math.cos(testAngle) * testDistance;
                this.targetZ = target.m_20189_() + Math.sin(testAngle) * testDistance;
                BlockPos testPos = new BlockPos((int)this.targetX, (int)ScampTankEntity.this.m_20186_(), (int)this.targetZ);
                if (!ScampTankEntity.this.m_9236_().m_8055_(testPos).m_60795_()) continue;
                ScampTankEntity.this.m_21573_().m_26519_(this.targetX, target.m_20186_(), this.targetZ, 1.2);
                this.hasDestination = true;
                break;
            }
        }

        public void m_8041_() {
            ScampTankEntity.this.m_21573_().m_26573_();
            this.hasDestination = false;
        }
    }

    private class TankLookGoal
    extends Goal {
        private float targetYaw = 0.0f;
        private static final float MAX_ROTATION_SPEED = 4.0f;

        public TankLookGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            if (!ScampTankEntity.this.m_6084_()) {
                return false;
            }
            return ScampTankEntity.this.m_5448_() != null && !ScampTankEntity.this.isInSecondPhase() && ScampTankEntity.this.postChargeRotationTicks <= 0 && ScampTankEntity.this.avoidanceTimer <= 0;
        }

        public void m_8037_() {
            float yawDiff;
            LivingEntity target = ScampTankEntity.this.m_5448_();
            if (target == null) {
                return;
            }
            double dx = target.m_20185_() - ScampTankEntity.this.m_20185_();
            double dz = target.m_20189_() - ScampTankEntity.this.m_20189_();
            this.targetYaw = (float)(Math.atan2(dz, dx) * 57.29577951308232 - 90.0);
            float currentYaw = ScampTankEntity.this.m_146908_();
            for (yawDiff = this.targetYaw - currentYaw; yawDiff > 180.0f; yawDiff -= 360.0f) {
            }
            while (yawDiff < -180.0f) {
                yawDiff += 360.0f;
            }
            float rotation = Math.signum(yawDiff) * Math.min(Math.abs(yawDiff), 4.0f);
            float newYaw = currentYaw + rotation;
            if (Math.abs(yawDiff) > 1.0f) {
                ScampTankEntity.this.m_146922_(newYaw);
                ScampTankEntity.this.f_20883_ = newYaw;
                ScampTankEntity.this.m_5616_(newYaw);
            }
        }
    }

    private class ExtendedRangeTargetGoal
    extends Goal {
        private int targetSearchDelay = 0;

        public ExtendedRangeTargetGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
        }

        public boolean m_8036_() {
            if (--this.targetSearchDelay <= 0) {
                this.targetSearchDelay = 20;
                Player target = this.findNearestPlayer();
                if (target != null) {
                    ScampTankEntity.this.m_6710_((LivingEntity)target);
                    return true;
                }
            }
            return false;
        }

        public void m_8056_() {
            Player target = this.findNearestPlayer();
            ScampTankEntity.this.m_6710_((LivingEntity)target);
        }

        private Player findNearestPlayer() {
            AABB searchBox = ScampTankEntity.this.m_20191_().m_82400_(50.0);
            List players = ScampTankEntity.this.m_9236_().m_45976_(Player.class, searchBox);
            Player closest = null;
            double closestDistance = 2500.0;
            for (Player player : players) {
                double distance;
                if (player.m_7500_() || player.m_5833_() || !((distance = ScampTankEntity.this.m_20280_((Entity)player)) < closestDistance)) continue;
                closest = player;
                closestDistance = distance;
            }
            return closest;
        }
    }
}

