/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.monster;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.ribs.scguns.config.EntityEquipmentConfig;
import top.ribs.scguns.entity.ai.AIType;
import top.ribs.scguns.entity.ai.GunAttackGoal;
import top.ribs.scguns.item.GunItem;

public class FinforcerEntity
extends Monster
implements RangedAttackMob {
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(FinforcerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> ATTACK_TIMEOUT = SynchedEntityData.m_135353_(FinforcerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final double ALLIANCE_RANGE = 32.0;
    private static final int ALERT_RANGE_Y = 10;
    private int ticksUntilNextAlert = 0;

    public FinforcerEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 35.0).m_22268_(Attributes.f_22277_, 28.0).m_22268_(Attributes.f_22279_, 0.26).m_22268_(Attributes.f_22285_, 0.5).m_22268_(Attributes.f_22284_, 3.0).m_22268_(Attributes.f_22278_, (double)0.4f).m_22268_(Attributes.f_22282_, (double)0.3f).m_22268_(Attributes.f_22281_, 4.0);
    }

    public HumanoidArm m_5737_() {
        return HumanoidArm.LEFT;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        EntityEquipmentConfig.equipEntity((Mob)this, "scguns:finforcer");
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
        this.f_19804_.m_135372_(ATTACK_TIMEOUT, (Object)0);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            if (this.isAttacking() && this.getAttackTimeout() > 0) {
                LivingEntity target;
                this.setAttackTimeout(this.getAttackTimeout() - 1);
                if (this.getAttackTimeout() == 6 && (target = this.m_5448_()) != null && this.m_20280_((Entity)target) <= (double)(this.m_20205_() * 2.0f * this.m_20205_() * 2.0f + target.m_20205_())) {
                    this.m_7327_((Entity)target);
                }
                if (this.getAttackTimeout() <= 0) {
                    this.setAttacking(false);
                }
            }
            if (this.m_5448_() != null) {
                this.maybeAlertAllies();
            }
        }
    }

    protected void m_8099_() {
        ItemStack mainHandItem = this.m_21205_();
        boolean hasGun = mainHandItem.m_41720_() instanceof GunItem;
        if (hasGun) {
            this.f_21345_.m_25352_(1, new GunAttackGoal<FinforcerEntity>(this, mainHandItem, 1.0f, AIType.TACTICAL, 2));
        } else {
            this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false){

                protected void m_6739_(LivingEntity pEnemy, double pDistToEnemySqr) {
                    if (pDistToEnemySqr <= this.m_6639_(pEnemy) && this.m_25565_() <= 0 && !FinforcerEntity.this.isAttacking()) {
                        FinforcerEntity.this.setAttacking(true);
                        this.m_25563_();
                        this.f_25540_.m_6674_(InteractionHand.MAIN_HAND);
                    }
                }

                protected double m_6639_(LivingEntity pEnemy) {
                    return super.m_6639_(pEnemy) * 1.2;
                }
            });
        }
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.9));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(9, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]){

            public boolean m_8036_() {
                if (this.f_26135_.m_21188_() instanceof FinforcerEntity) {
                    return false;
                }
                return super.m_8036_();
            }
        }.m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, player -> !((Player)player).m_7500_() && !player.m_5833_()));
    }

    public boolean m_6779_(LivingEntity target) {
        if (target instanceof FinforcerEntity) {
            return false;
        }
        return super.m_6779_(target);
    }

    private void maybeAlertAllies() {
        if (this.ticksUntilNextAlert > 0) {
            --this.ticksUntilNextAlert;
        } else {
            if (this.m_21574_().m_148306_((Entity)this.m_5448_())) {
                this.alertAllies();
            }
            this.ticksUntilNextAlert = 20 + this.f_19796_.m_188503_(20);
        }
    }

    private void alertAllies() {
        AABB alertArea = AABB.m_82333_((Vec3)this.m_20182_()).m_82377_(32.0, 10.0, 32.0);
        this.m_9236_().m_6443_(FinforcerEntity.class, alertArea, EntitySelector.f_20408_).stream().filter(entity -> entity != this).filter(entity -> entity.m_5448_() == null).filter(entity -> !entity.m_7307_((Entity)this.m_5448_())).forEach(entity -> entity.m_6710_(this.m_5448_()));
    }

    public void m_6710_(@Nullable LivingEntity target) {
        if (target instanceof FinforcerEntity) {
            return;
        }
        if (this.m_5448_() == null && target != null) {
            this.ticksUntilNextAlert = this.f_19796_.m_188503_(20);
        }
        super.m_6710_(target);
    }

    public void setAttacking(boolean attacking) {
        this.f_19804_.m_135381_(ATTACKING, (Object)attacking);
        if (attacking) {
            this.setAttackTimeout(12);
        }
    }

    public void setAttackTimeout(int timeout) {
        this.f_19804_.m_135381_(ATTACK_TIMEOUT, (Object)timeout);
    }

    public int getAttackTimeout() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_TIMEOUT);
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING);
    }

    protected void m_267689_(float pPartialTick) {
        float f = this.m_20089_() == Pose.STANDING ? Math.min(pPartialTick * 6.0f, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(f, 0.2f);
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_11799_;
    }

    @NotNull
    protected SoundEvent m_7975_(@NotNull DamageSource pDamageSource) {
        return SoundEvents.f_11804_;
    }

    @NotNull
    protected SoundEvent m_5592_() {
        return SoundEvents.f_11802_;
    }

    public void m_6504_(@NotNull LivingEntity target, float distanceFactor) {
        this.m_7327_((Entity)target);
    }

    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("AlertCooldown", this.ticksUntilNextAlert);
    }

    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        this.ticksUntilNextAlert = tag.m_128451_("AlertCooldown");
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_6063_() {
        return false;
    }
}

