/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.config;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="scguns")
public class ProjectileAdvantageConfig {
    private static final Map<String, AdvantageData> ADVANTAGE_MAP = new HashMap<String, AdvantageData>();
    private static final ResourceLocation CONFIG_LOCATION = new ResourceLocation("scguns", "entity/advantages.json");

    public static void loadConfig(ResourceManager resourceManager) {
        block12: {
            ADVANTAGE_MAP.clear();
            try {
                Resource resource = resourceManager.m_213713_(CONFIG_LOCATION).orElse(null);
                if (resource != null) {
                    try (InputStreamReader reader = new InputStreamReader(resource.m_215507_(), StandardCharsets.UTF_8);){
                        Gson gson = new Gson();
                        JsonObject json = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
                        if (json != null && json.has("advantages")) {
                            JsonObject advantages = json.getAsJsonObject("advantages");
                            for (Map.Entry entry : advantages.entrySet()) {
                                String advantageKey = (String)entry.getKey();
                                JsonObject advantageObj = ((JsonElement)entry.getValue()).getAsJsonObject();
                                float multiplier = advantageObj.has("multiplier") ? advantageObj.get("multiplier").getAsFloat() : 1.0f;
                                boolean causesFire = advantageObj.has("causes_fire") && advantageObj.get("causes_fire").getAsBoolean();
                                int fireDuration = advantageObj.has("fire_duration") ? advantageObj.get("fire_duration").getAsInt() : 2;
                                HashSet<String> targetTags = new HashSet<String>();
                                if (advantageObj.has("target_tags")) {
                                    for (JsonElement tagElement : advantageObj.getAsJsonArray("target_tags")) {
                                        targetTags.add(tagElement.getAsString());
                                    }
                                }
                                ADVANTAGE_MAP.put(advantageKey, new AdvantageData(multiplier, causesFire, fireDuration, targetTags));
                            }
                        }
                        break block12;
                    }
                }
                ProjectileAdvantageConfig.loadDefaults();
            }
            catch (Exception e) {
                ProjectileAdvantageConfig.loadDefaults();
            }
        }
    }

    private static void loadDefaults() {
        ADVANTAGE_MAP.put("scguns:undead", new AdvantageData(1.25f, true, 2, Set.of("scguns:undead", "scguns:wither", "scguns:ghost")));
        ADVANTAGE_MAP.put("scguns:heavy", new AdvantageData(1.25f, false, 0, Set.of("scguns:heavy", "scguns:very_heavy")));
        ADVANTAGE_MAP.put("scguns:very_heavy", new AdvantageData(1.25f, false, 0, Set.of("scguns:heavy", "scguns:very_heavy")));
        ADVANTAGE_MAP.put("scguns:fire", new AdvantageData(1.25f, false, 0, Set.of("scguns:fire")));
        ADVANTAGE_MAP.put("scguns:illager", new AdvantageData(1.5f, false, 0, Set.of("scguns:illager")));
        ADVANTAGE_MAP.put("scguns:water", new AdvantageData(1.65f, false, 0, Set.of("scguns:water")));
        ADVANTAGE_MAP.put("scguns:bot", new AdvantageData(1.5f, false, 0, Set.of("scguns:bot")));
        ADVANTAGE_MAP.put("scguns:wither", new AdvantageData(1.25f, false, 0, Set.of("scguns:wither")));
    }

    public static AdvantageData getAdvantageData(String advantageKey) {
        return ADVANTAGE_MAP.get(advantageKey);
    }

    public static Map<String, AdvantageData> getAllAdvantages() {
        return new HashMap<String, AdvantageData>(ADVANTAGE_MAP);
    }

    @SubscribeEvent
    public static void onAddReloadListener(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new SimplePreparableReloadListener<Void>(){

            protected Void prepare(@NotNull ResourceManager resourceManager, ProfilerFiller profiler) {
                return null;
            }

            protected void apply(Void object, ResourceManager resourceManager, ProfilerFiller profiler) {
                ProjectileAdvantageConfig.loadConfig(resourceManager);
            }
        });
    }

    public record AdvantageData(float multiplier, boolean causesFire, int fireDuration, Set<String> targetTags) {
    }
}

