/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.config;

import net.minecraft.world.Difficulty;
import top.ribs.scguns.Config;

public class GunMobValues {
    public static boolean enabled = true;
    public static double gunnerSpawnChance = 0.25;
    public static boolean scaleToDifficulty = true;
    public static boolean elitesEnabled = true;
    public static double eliteChance = 0.15;

    public static void init() {
        enabled = (Boolean)Config.COMMON.gunnerMobs.gunnerMobSpawning.get();
        gunnerSpawnChance = (Double)Config.COMMON.gunnerMobs.gunnerSpawnChance.get();
        scaleToDifficulty = (Boolean)Config.COMMON.gunnerMobs.scaleToDifficulty.get();
        elitesEnabled = (Boolean)Config.COMMON.gunnerMobs.eliteSpawning.get();
        eliteChance = (Double)Config.COMMON.gunnerMobs.eliteChance.get();
    }

    public static double getGunnerSpawnChance(Difficulty difficulty) {
        if (!scaleToDifficulty) {
            return gunnerSpawnChance;
        }
        return gunnerSpawnChance * GunMobValues.getDifficultyMultiplier(difficulty);
    }

    public static double getEliteChance(Difficulty difficulty) {
        if (!scaleToDifficulty) {
            return eliteChance;
        }
        return eliteChance * GunMobValues.getDifficultyMultiplier(difficulty);
    }

    private static double getDifficultyMultiplier(Difficulty difficulty) {
        return switch (difficulty) {
            default -> throw new IncompatibleClassChangeError();
            case Difficulty.PEACEFUL -> 0.5;
            case Difficulty.EASY -> 0.75;
            case Difficulty.NORMAL -> 1.0;
            case Difficulty.HARD -> 1.5;
        };
    }
}

