/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.common.exosuit;

import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.ribs.scguns.common.SulfurGasCloud;
import top.ribs.scguns.common.exosuit.ExoSuitData;
import top.ribs.scguns.common.exosuit.ExoSuitPowerManager;
import top.ribs.scguns.common.exosuit.ExoSuitUpgrade;
import top.ribs.scguns.common.exosuit.ExoSuitUpgradeManager;
import top.ribs.scguns.item.animated.ExoSuitItem;
import top.ribs.scguns.item.exosuit.GasMaskModuleItem;

@Mod.EventBusSubscriber(modid="scguns", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ExoSuitGasMaskHandler {
    private static final int CHECK_INTERVAL = 20;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.player.m_9236_().f_46443_) {
            return;
        }
        Player player = event.player;
        if (player.f_19797_ % 20 != 0) {
            return;
        }
        ExoSuitGasMaskHandler.handleGasMask(player);
    }

    private static void handleGasMask(Player player) {
        GasMaskModuleItem gasMaskModule;
        Item item;
        if (ExoSuitGasMaskHandler.hasGasMaskModule(player)) {
            return;
        }
        if (!ExoSuitGasMaskHandler.isPlayerInGasArea(player)) {
            return;
        }
        ItemStack gasMaskUpgrade = ExoSuitGasMaskHandler.findGasMaskModule(player);
        if (!gasMaskUpgrade.m_41619_() && (item = gasMaskUpgrade.m_41720_()) instanceof GasMaskModuleItem && !(gasMaskModule = (GasMaskModuleItem)item).canFunctionWithoutPower()) {
            ExoSuitPowerManager.consumeEnergyForUpgrade(player, "breathing", gasMaskUpgrade);
        }
    }

    private static boolean hasGasMaskModule(Player player) {
        return ExoSuitGasMaskHandler.findGasMaskModule(player).m_41619_();
    }

    private static ItemStack findGasMaskModule(Player player) {
        for (ItemStack armorStack : player.m_6168_()) {
            ExoSuitItem exosuit;
            Item item = armorStack.m_41720_();
            if (!(item instanceof ExoSuitItem) || (exosuit = (ExoSuitItem)item).m_266204_() != ArmorItem.Type.HELMET) continue;
            for (int slot = 0; slot < 4; ++slot) {
                ExoSuitUpgrade upgrade;
                ItemStack upgradeItem = ExoSuitData.getUpgradeInSlot(armorStack, slot);
                if (upgradeItem.m_41619_() || (upgrade = ExoSuitUpgradeManager.getUpgradeForItem(upgradeItem)) == null || !upgrade.getType().equals("breathing") || !(upgradeItem.m_41720_() instanceof GasMaskModuleItem)) continue;
                return upgradeItem;
            }
        }
        return ItemStack.f_41583_;
    }

    private static boolean isPlayerInGasArea(Player player) {
        Vec3 playerPos = player.m_20182_();
        return SulfurGasCloud.isInGasEffectArea(player.m_9236_(), playerPos, 8);
    }

    public static boolean hasProtection(Player player) {
        Item item;
        if (ExoSuitGasMaskHandler.hasGasMaskModule(player)) {
            return false;
        }
        ItemStack gasMaskUpgrade = ExoSuitGasMaskHandler.findGasMaskModule(player);
        if (!gasMaskUpgrade.m_41619_() && (item = gasMaskUpgrade.m_41720_()) instanceof GasMaskModuleItem) {
            GasMaskModuleItem gasMaskModule = (GasMaskModuleItem)item;
            if (gasMaskModule.canFunctionWithoutPower()) {
                return true;
            }
            return ExoSuitPowerManager.canUpgradeFunction(player, "breathing");
        }
        return false;
    }
}

