/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.common;

import net.minecraft.world.item.ItemStack;
import top.ribs.scguns.interfaces.IGunModifier;
import top.ribs.scguns.item.GunItem;

public class GunModifiers {
    public static final IGunModifier LONG_SCOPE_SENSITIVITY_COMPENSATION = new IGunModifier(){};
    public static final IGunModifier MEDIUM_SCOPE_SENSITIVITY_COMPENSATION = new IGunModifier(){};
    public static final IGunModifier SILENCED = new IGunModifier(){

        @Override
        public boolean silencedFire() {
            return true;
        }

        @Override
        public double modifyFireSoundRadius(double radius) {
            return radius * 0.5;
        }
    };
    public static final IGunModifier REDUCED_DAMAGE = new IGunModifier(){

        @Override
        public float modifyProjectileDamage(float damage) {
            return damage * 0.95f;
        }
    };
    public static final IGunModifier INCREASED_DAMAGE = new IGunModifier(){

        @Override
        public float modifyProjectileDamage(float damage) {
            return damage * 1.2f;
        }
    };
    public static final IGunModifier IRON_BAYONET_DAMAGE = new IGunModifier(){

        @Override
        public float additionalDamage() {
            return 2.0f;
        }

        @Override
        public boolean isMeleeOnly() {
            return false;
        }
    };
    public static final IGunModifier ANTHRALITE_BAYONET_DAMAGE = new IGunModifier(){

        @Override
        public float additionalDamage() {
            return 3.0f;
        }

        @Override
        public boolean isMeleeOnly() {
            return false;
        }
    };
    public static final IGunModifier DIAMOND_BAYONET_DAMAGE = new IGunModifier(){

        @Override
        public float additionalDamage() {
            return 3.5f;
        }

        @Override
        public boolean isMeleeOnly() {
            return false;
        }
    };
    public static final IGunModifier NETHERITE_BAYONET_DAMAGE = new IGunModifier(){

        @Override
        public float additionalDamage() {
            return 4.0f;
        }

        @Override
        public boolean isMeleeOnly() {
            return false;
        }
    };
    public static final IGunModifier EXTENDED_BARREL = new IGunModifier(){

        @Override
        public double modifyProjectileSpeed(double speed) {
            return speed * 1.2;
        }

        @Override
        public float modifyProjectileSpread(float spread) {
            return spread * 0.8f;
        }

        @Override
        public float recoilModifier() {
            return 1.25f;
        }

        @Override
        public double modifyAimDownSightSpeed(double speed) {
            return speed * 0.9;
        }
    };
    public static final IGunModifier SLOW_ADS = new IGunModifier(){

        @Override
        public double modifyAimDownSightSpeed(double speed) {
            return speed * (double)0.97f;
        }
    };
    public static final IGunModifier LONG_SCOPE_RECOIL_REDUCTION = new IGunModifier(){

        @Override
        public float recoilModifier() {
            return 0.9f;
        }

        @Override
        public float kickModifier() {
            return 0.9f;
        }
    };
    public static final IGunModifier MEDIUM_SCOPE_RECOIL_REDUCTION = new IGunModifier(){

        @Override
        public float recoilModifier() {
            return 0.9f;
        }

        @Override
        public float kickModifier() {
            return 0.85f;
        }
    };
    public static final IGunModifier REFLEX_SIGHT_CRIT_BONUS = new IGunModifier(){

        @Override
        public float criticalChance() {
            return 0.025f;
        }
    };
    public static final IGunModifier REFLEX_SIGHT_ADS_BONUS = new IGunModifier(){

        @Override
        public double modifyAimDownSightSpeed(double speed) {
            return speed * (double)1.1f;
        }

        @Override
        public float modifyProjectileSpread(float spread) {
            return spread * 0.9f;
        }
    };
    public static final IGunModifier LASER_SIGHT_SPREAD_REDUCTION = new IGunModifier(){

        @Override
        public float modifyProjectileSpread(float spread) {
            return spread * 0.85f;
        }

        @Override
        public float criticalChance() {
            return 0.05f;
        }
    };
    public static final IGunModifier LASER_SIGHT_ADS_BONUS = new IGunModifier(){

        @Override
        public double modifyAimDownSightSpeed(double speed) {
            return speed * (double)1.15f;
        }

        @Override
        public float recoilModifier() {
            return 0.95f;
        }
    };
    public static final IGunModifier SLOWER_ADS = new IGunModifier(){

        @Override
        public double modifyAimDownSightSpeed(double speed) {
            return speed * (double)0.85f;
        }

        @Override
        public float recoilModifier() {
            return 1.05f;
        }
    };
    public static final IGunModifier NORMAL_ADS = new IGunModifier(){

        @Override
        public double modifyAimDownSightSpeed(double speed) {
            return speed * (double)1.2f;
        }
    };
    public static final IGunModifier LIGHT_RECOIL = new IGunModifier(){

        @Override
        public float recoilModifier() {
            return 0.85f;
        }

        @Override
        public float kickModifier() {
            return 0.85f;
        }

        @Override
        public double modifyAimDownSightSpeed(double speed) {
            return speed * (double)1.2f;
        }
    };
    public static final IGunModifier REDUCED_RECOIL = new IGunModifier(){

        @Override
        public float recoilModifier() {
            return 0.7f;
        }

        @Override
        public float kickModifier() {
            return 0.8f;
        }

        @Override
        public double modifyAimDownSightSpeed(double speed) {
            return speed * (double)0.97f;
        }
    };
    public static final IGunModifier EXTENDED_MAG = new IGunModifier(){

        @Override
        public int modifyAmmoCapacity(int baseCapacity) {
            return (int)((double)baseCapacity * 2.0);
        }
    };
    public static final IGunModifier PLUS_P_MAG = new IGunModifier(){

        @Override
        public int modifyAmmoCapacity(int baseCapacity) {
            return (int)((double)baseCapacity * 0.5);
        }
    };
    public static final IGunModifier LIGHT_STOCK_MODIFIER = new IGunModifier(){

        @Override
        public float recoilModifier() {
            return 0.9f;
        }

        @Override
        public double modifyAimDownSightSpeed(double speed) {
            return speed * (double)1.1f;
        }

        @Override
        public double modifyDrawSpeed(double speed) {
            return speed * (double)1.2f;
        }
    };
    public static final IGunModifier WEIGHTED_STOCK_MODIFIER = new IGunModifier(){

        @Override
        public float recoilModifier() {
            return 0.75f;
        }

        @Override
        public double modifyAimDownSightSpeed(double speed) {
            return speed * (double)0.85f;
        }

        @Override
        public float kickModifier() {
            return 0.9f;
        }

        @Override
        public double modifyDrawSpeed(double speed) {
            return speed * (double)0.85f;
        }
    };
    public static final IGunModifier WOODEN_STOCK_MODIFIER = new IGunModifier(){

        @Override
        public float recoilModifier() {
            return 0.85f;
        }

        @Override
        public double modifyAimDownSightSpeed(double speed) {
            return speed * (double)1.05f;
        }

        @Override
        public float criticalChance() {
            return 0.05f;
        }
    };
    public static final IGunModifier BUMP_STOCK_MODIFIER = new IGunModifier(){

        @Override
        public int modifyFireRate(int rate) {
            if (rate <= 3) {
                return Math.max(rate - 1, 1);
            }
            if (rate <= 10) {
                return Math.max((int)((float)rate * 0.75f), 1);
            }
            return Math.max((int)((float)rate * 0.85f), 1);
        }

        @Override
        public float recoilModifier() {
            return 0.95f;
        }

        @Override
        public double modifyAimDownSightSpeed(double speed) {
            return speed * (double)0.92f;
        }
    };
    public static final IGunModifier MUZZLE_BRAKE_MODIFIER = new IGunModifier(){

        @Override
        public float modifyProjectileSpread(float spread) {
            return spread * 0.6f;
        }

        @Override
        public double modifyProjectileSpeed(double speed) {
            return speed * 0.9;
        }

        @Override
        public float recoilModifier() {
            return 0.95f;
        }

        @Override
        public float modifyDamageFalloffStart(float range) {
            return range * 1.1f;
        }

        @Override
        public float modifyDamageFalloffEnd(float range) {
            return range * 1.1f;
        }
    };
    public static final IGunModifier SLUG_SPLITTER_MODIFIER = new IGunModifier(){};
    public static final IGunModifier EXTENDED_BARREL_MODIFIER = new IGunModifier(){

        @Override
        public double modifyProjectileSpeed(double speed) {
            return speed * 1.15;
        }

        @Override
        public float modifyProjectileSpread(float spread) {
            return spread * 0.85f;
        }

        @Override
        public float recoilModifier(ItemStack weapon) {
            return this.isCarbineCandidate(weapon) ? 0.7f : 1.25f;
        }

        @Override
        public float kickModifier(ItemStack weapon) {
            return this.isCarbineCandidate(weapon) ? 0.85f : 1.2f;
        }

        @Override
        public float modifyProjectileDamage(float damage) {
            return damage * 1.1f;
        }

        @Override
        public float modifyDamageFalloffStart(float range) {
            return range * 1.25f;
        }

        @Override
        public float modifyDamageFalloffEnd(float range) {
            return range * 1.25f;
        }

        private boolean isCarbineCandidate(ItemStack weapon) {
            if (weapon == null || weapon.m_41619_()) {
                return false;
            }
            return ((GunItem)weapon.m_41720_()).isOneHandedCarbineCandidate(weapon);
        }

        @Override
        public double modifyDrawSpeed(double speed) {
            return speed * (double)0.95f;
        }
    };
    public static final IGunModifier SILENCER_MODIFIER = new IGunModifier(){

        @Override
        public float modifyProjectileDamage(float damage) {
            return damage * 0.9f;
        }

        @Override
        public double modifyProjectileSpeed(double speed) {
            return speed * 0.9;
        }

        @Override
        public float criticalChance() {
            return 0.15f;
        }
    };
    public static final IGunModifier ADVANCED_SILENCER_MODIFIER = new IGunModifier(){

        @Override
        public double modifyProjectileSpeed(double speed) {
            return speed * 0.93;
        }

        @Override
        public float criticalChance() {
            return 0.25f;
        }
    };
    public static final IGunModifier EXTENDED_MAG_MODIFIER = new IGunModifier(){

        @Override
        public double modifyReloadSpeed(double reloadSpeed) {
            return reloadSpeed * 1.4;
        }

        @Override
        public int modifyAmmoCapacity(int baseCapacity) {
            return (int)((double)baseCapacity * 2.0);
        }

        @Override
        public float recoilModifier() {
            return 0.9f;
        }

        @Override
        public float kickModifier() {
            return 0.9f;
        }

        @Override
        public double modifyDrawSpeed(double speed) {
            return speed * (double)0.95f;
        }
    };
    public static final IGunModifier SPEED_MAG_MODIFIER = new IGunModifier(){

        @Override
        public double modifyReloadSpeed(double reloadSpeed) {
            return reloadSpeed * 0.65;
        }

        @Override
        public double modifyAimDownSightSpeed(double speed) {
            return speed * (double)1.1f;
        }

        @Override
        public float recoilModifier() {
            return 0.9f;
        }

        @Override
        public float kickModifier() {
            return 0.95f;
        }

        @Override
        public double modifyDrawSpeed(double speed) {
            return speed * (double)1.15f;
        }
    };
    public static final IGunModifier CARBINE_ONE_HANDED_BONUS = new IGunModifier(){

        @Override
        public double modifyAimDownSightSpeed(double speed) {
            return speed * 1.25;
        }

        @Override
        public double modifyDrawSpeed(double speed) {
            return speed * (double)1.3f;
        }

        @Override
        public double modifyReloadSpeed(double reloadSpeed) {
            return reloadSpeed * 0.9;
        }

        @Override
        public float recoilModifier() {
            return 0.85f;
        }

        @Override
        public float kickModifier() {
            return 0.9f;
        }

        @Override
        public float criticalChance() {
            return 0.1f;
        }
    };
}

