/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.common;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import top.ribs.scguns.client.render.IHeldAnimation;
import top.ribs.scguns.client.render.pose.BazookaPose;
import top.ribs.scguns.client.render.pose.DualWieldPose;
import top.ribs.scguns.client.render.pose.MiniGun2Pose;
import top.ribs.scguns.client.render.pose.MiniGun3Pose;
import top.ribs.scguns.client.render.pose.MiniGun4Pose;
import top.ribs.scguns.client.render.pose.MiniGun5Pose;
import top.ribs.scguns.client.render.pose.MiniGunPose;
import top.ribs.scguns.client.render.pose.OneHanded2Pose;
import top.ribs.scguns.client.render.pose.OneHandedPose;
import top.ribs.scguns.client.render.pose.TwoHandedPose;
import top.ribs.scguns.client.render.pose.TwoHandedShotgunPose;
import top.ribs.scguns.client.render.pose.TwoHandedSmgPose;

public record GripType(ResourceLocation id, IHeldAnimation heldAnimation) {
    public static final GripType ONE_HANDED = new GripType(new ResourceLocation("scguns", "one_handed"), new OneHandedPose());
    public static final GripType ONE_HANDED_2 = new GripType(new ResourceLocation("scguns", "one_handed_2"), new OneHanded2Pose());
    public static final GripType TWO_HANDED = new GripType(new ResourceLocation("scguns", "two_handed"), new TwoHandedPose());
    public static final GripType TWO_HANDED_SHOTGUN = new GripType(new ResourceLocation("scguns", "two_handed_shotgun"), new TwoHandedShotgunPose());
    public static final GripType TWO_HANDED_SMG = new GripType(new ResourceLocation("scguns", "two_handed_smg"), new TwoHandedSmgPose());
    public static final GripType DUAL_WIELD = new GripType(new ResourceLocation("scguns", "dual_wield"), new DualWieldPose());
    public static final GripType MINI_GUN = new GripType(new ResourceLocation("scguns", "mini_gun"), new MiniGunPose());
    public static final GripType MINI_GUN_2 = new GripType(new ResourceLocation("scguns", "mini_gun_2"), new MiniGun2Pose());
    public static final GripType MINI_GUN_3 = new GripType(new ResourceLocation("scguns", "mini_gun_3"), new MiniGun3Pose());
    public static final GripType MINI_GUN_4 = new GripType(new ResourceLocation("scguns", "mini_gun_4"), new MiniGun4Pose());
    public static final GripType MINI_GUN_5 = new GripType(new ResourceLocation("scguns", "mini_gun_5"), new MiniGun5Pose());
    public static final GripType BAZOOKA = new GripType(new ResourceLocation("scguns", "bazooka"), new BazookaPose());
    private static final Map<ResourceLocation, GripType> gripTypeMap = new HashMap<ResourceLocation, GripType>();

    public static boolean applyBackTransforms(Player player, PoseStack poseStack) {
        if (player.m_6844_(EquipmentSlot.CHEST).m_41720_() == Items.f_42741_) {
            return false;
        }
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        if (player.m_6047_()) {
            poseStack.m_85837_(0.0, -0.4375, -0.25);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(30.0f));
        } else {
            poseStack.m_85837_(0.0, -0.3125, -0.125);
        }
        if (!player.m_6844_(EquipmentSlot.CHEST).m_41619_()) {
            poseStack.m_85837_(0.0, 0.0, -0.0625);
        }
        poseStack.m_252781_(Axis.f_252403_.m_252977_(-45.0f));
        poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        return true;
    }

    public static void registerType(GripType type) {
        gripTypeMap.putIfAbsent(type.id(), type);
    }

    public static GripType getType(ResourceLocation id) {
        return gripTypeMap.getOrDefault(id, ONE_HANDED);
    }

    static {
        GripType.registerType(ONE_HANDED);
        GripType.registerType(ONE_HANDED_2);
        GripType.registerType(TWO_HANDED);
        GripType.registerType(TWO_HANDED_SMG);
        GripType.registerType(TWO_HANDED_SHOTGUN);
        GripType.registerType(DUAL_WIELD);
        GripType.registerType(MINI_GUN);
        GripType.registerType(MINI_GUN_2);
        GripType.registerType(MINI_GUN_3);
        GripType.registerType(MINI_GUN_4);
        GripType.registerType(MINI_GUN_5);
        GripType.registerType(BAZOOKA);
    }
}

