/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.client.screen;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.SlotItemHandler;
import top.ribs.scguns.blockentity.PolarGeneratorBlockEntity;
import top.ribs.scguns.client.screen.ModMenuTypes;
import top.ribs.scguns.init.ModBlocks;

public class PolarGeneratorMenu
extends AbstractContainerMenu {
    public final PolarGeneratorBlockEntity blockEntity;
    private final Level level;
    private final ContainerData data;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int FUEL_SLOT_INDEX = 36;

    public PolarGeneratorMenu(int id, Inventory inv, FriendlyByteBuf extraData) {
        this(id, inv, inv.f_35978_.m_9236_().m_7702_(extraData.m_130135_()), (ContainerData)new SimpleContainerData(4));
    }

    public PolarGeneratorMenu(int id, Inventory inv, BlockEntity entity, ContainerData data) {
        super((MenuType)ModMenuTypes.POLAR_GENERATOR_MENU.get(), id);
        PolarGeneratorMenu.m_38869_((Container)inv, (int)1);
        this.blockEntity = (PolarGeneratorBlockEntity)entity;
        this.level = inv.f_35978_.m_9236_();
        this.data = data;
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        this.blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> this.m_38897_((Slot)new SlotItemHandler(handler, 0, 80, 45)));
        this.m_38884_(data);
    }

    public boolean isGenerating() {
        return this.data.m_6413_(0) > 0;
    }

    public int getEnergy() {
        return this.data.m_6413_(2);
    }

    public int getMaxEnergy() {
        return this.data.m_6413_(3);
    }

    public int getScaledFuelProgress() {
        int fuelTime = this.data.m_6413_(0);
        int maxFuelTime = this.data.m_6413_(1);
        int fuelProgressSize = 14;
        return maxFuelTime != 0 && fuelTime != 0 ? fuelTime * fuelProgressSize / maxFuelTime : 0;
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index == 36) {
                if (!this.m_38903_(itemstack1, 0, 36, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstack1, itemstack);
            } else if (index >= 0 && index < 36 ? (this.isFuel(itemstack1) ? !this.m_38903_(itemstack1, 36, 37, false) : (index >= 0 && index < 27 ? !this.m_38903_(itemstack1, 27, 36, false) : index >= 27 && index < 36 && !this.m_38903_(itemstack1, 0, 27, false))) : !this.m_38903_(itemstack1, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, itemstack1);
        }
        return itemstack;
    }

    public boolean m_6875_(Player player) {
        return PolarGeneratorMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)this.blockEntity.m_58899_()), (Player)player, (Block)((Block)ModBlocks.POLAR_GENERATOR.get()));
    }

    private boolean isFuel(ItemStack stack) {
        return ForgeHooks.getBurnTime((ItemStack)stack, (RecipeType)RecipeType.f_44108_) > 0;
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.m_38897_(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }
}

