/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.client.screen;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Iterator;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class MechanicalPressRecipe
implements Recipe<SimpleContainer> {
    private final NonNullList<Ingredient> inputItems;
    private final Ingredient moldItem;
    private final ItemStack output;
    private final int processingTime;
    private final ResourceLocation id;

    public MechanicalPressRecipe(ResourceLocation id, NonNullList<Ingredient> inputItems, Ingredient moldItem, ItemStack output, int processingTime) {
        this.id = id;
        this.inputItems = inputItems;
        this.moldItem = moldItem;
        this.output = output;
        this.processingTime = processingTime;
    }

    public boolean requiresMold() {
        return !this.moldItem.m_43947_();
    }

    public boolean matches(SimpleContainer inv, Level world) {
        if (world.m_5776_()) {
            return false;
        }
        NonNullList requiredIngredients = NonNullList.m_122779_();
        requiredIngredients.addAll(this.inputItems);
        boolean moldMatched = this.moldItem.m_43947_() || this.moldItem.test(inv.m_8020_(3));
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stackInSlot;
            if (i == 3 || (stackInSlot = inv.m_8020_(i)).m_41619_()) continue;
            boolean matched = false;
            Iterator iterator = requiredIngredients.iterator();
            while (iterator.hasNext()) {
                Ingredient ingredient = (Ingredient)iterator.next();
                if (!ingredient.test(stackInSlot)) continue;
                iterator.remove();
                matched = true;
                break;
            }
            if (matched) continue;
        }
        return requiredIngredients.isEmpty() && moldMatched;
    }

    public ItemStack assemble(SimpleContainer inv, RegistryAccess registryAccess) {
        return this.output.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.output.m_41777_();
    }

    public int getProcessingTime() {
        return this.processingTime;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.inputItems;
    }

    public Ingredient getMoldItem() {
        return this.moldItem;
    }

    public static class Serializer
    implements RecipeSerializer<MechanicalPressRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("scguns", "mechanical_pressing");

        public MechanicalPressRecipe fromJson(@NotNull ResourceLocation recipeId, JsonObject json) {
            JsonArray ingredientsArray = json.getAsJsonArray("ingredients");
            NonNullList ingredients = NonNullList.m_122780_((int)ingredientsArray.size(), (Object)Ingredient.f_43901_);
            for (int i = 0; i < ingredientsArray.size(); ++i) {
                ingredients.set(i, (Object)Ingredient.m_43917_((JsonElement)ingredientsArray.get(i)));
            }
            Ingredient moldItem = Ingredient.f_43901_;
            if (json.has("mold") && !json.get("mold").isJsonNull()) {
                moldItem = Ingredient.m_43917_((JsonElement)json.getAsJsonObject("mold"));
            }
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)json.getAsJsonObject("result"));
            int processingTime = json.get("processingTime").getAsInt();
            return new MechanicalPressRecipe(recipeId, (NonNullList<Ingredient>)ingredients, moldItem, output, processingTime);
        }

        public MechanicalPressRecipe fromNetwork(@NotNull ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int size = buffer.readInt();
            NonNullList ingredients = NonNullList.m_122780_((int)size, (Object)Ingredient.f_43901_);
            for (int i = 0; i < size; ++i) {
                ingredients.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            Ingredient moldItem = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStack output = buffer.m_130267_();
            int processingTime = buffer.readInt();
            return new MechanicalPressRecipe(recipeId, (NonNullList<Ingredient>)ingredients, moldItem, output, processingTime);
        }

        public void toNetwork(FriendlyByteBuf buffer, MechanicalPressRecipe recipe) {
            buffer.writeInt(recipe.inputItems.size());
            for (Ingredient ingredient : recipe.inputItems) {
                ingredient.m_43923_(buffer);
            }
            recipe.getMoldItem().m_43923_(buffer);
            buffer.writeItemStack(recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_), false);
            buffer.writeInt(recipe.getProcessingTime());
        }
    }

    public static class Type
    implements RecipeType<MechanicalPressRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "mechanical_pressing";
    }
}

