/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.client.screen;

import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.NotNull;
import top.ribs.scguns.client.screen.BlueprintScreen;
import top.ribs.scguns.client.screen.GunBenchRecipe;
import top.ribs.scguns.client.screen.ModMenuTypes;
import top.ribs.scguns.entity.player.PlayerGunProgression;
import top.ribs.scguns.event.GunProgressionEventHandler;
import top.ribs.scguns.item.BlueprintItem;

public class GunBenchMenu
extends AbstractContainerMenu {
    private final Container container;
    private final ContainerLevelAccess containerAccess;
    private final Player player;
    public static final int SLOT_GRIP = 8;
    public static final int SLOT_MAGAZINE = 9;
    public static final int SLOT_BARREL_1 = 6;
    public static final int SLOT_BARREL_2 = 7;
    public static final int SLOT_INTERNAL_1 = 4;
    public static final int SLOT_INTERNAL_2 = 5;
    public static final int SLOT_TOP_INTERNAL_1 = 0;
    public static final int SLOT_TOP_INTERNAL_2 = 1;
    public static final int SLOT_TOP_BARREL_1 = 2;
    public static final int SLOT_TOP_BARREL_2 = 3;
    public static final int SLOT_OUTPUT = 10;
    public static final int SLOT_BLUEPRINT = 11;

    public GunBenchMenu(int id, Inventory playerInventory, FriendlyByteBuf extraData) {
        this(id, playerInventory, (Container)new SimpleContainer(12), ContainerLevelAccess.f_39287_);
    }

    public GunBenchMenu(int id, Inventory playerInventory, ContainerLevelAccess containerAccess) {
        this(id, playerInventory, (Container)new SimpleContainer(12), containerAccess);
    }

    public GunBenchMenu(int id, Inventory playerInventory, Container container, ContainerLevelAccess containerAccess) {
        super((MenuType)ModMenuTypes.GUN_BENCH.get(), id);
        GunBenchMenu.m_38869_((Container)container, (int)12);
        this.container = container;
        this.containerAccess = containerAccess;
        this.player = playerInventory.f_35978_;
        container.m_5856_(playerInventory.f_35978_);
        this.m_38897_(new Slot(container, 0, 26, 17));
        this.m_38897_(new Slot(container, 1, 44, 17));
        this.m_38897_(new Slot(container, 2, 62, 17));
        this.m_38897_(new Slot(container, 3, 80, 17));
        this.m_38897_(new Slot(container, 4, 26, 35));
        this.m_38897_(new Slot(container, 5, 44, 35));
        this.m_38897_(new Slot(container, 6, 62, 35));
        this.m_38897_(new Slot(container, 7, 80, 35));
        this.m_38897_(new Slot(container, 8, 26, 53));
        this.m_38897_(new Slot(container, 9, 62, 53));
        this.m_38897_(new Slot(container, 11, 116, 17){

            public boolean m_5857_(@NotNull ItemStack stack) {
                return stack.m_41720_() instanceof BlueprintItem;
            }

            public void m_6654_() {
                super.m_6654_();
                GunBenchMenu.this.attemptAutoCrafting();
            }
        });
        this.m_38897_(new Slot(container, 10, 140, 44){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }

            public void m_142406_(Player player, ItemStack stack) {
                PlayerGunProgression progression;
                super.m_142406_(player, stack);
                if (!player.m_9236_().f_46443_ && !stack.m_41619_() && (progression = PlayerGunProgression.get(player)).checkAndUpdateFromItem(stack)) {
                    PlayerGunProgression.save(player, progression);
                    GunProgressionEventHandler.sendTierUnlockedMessage(player, progression.getCurrentTier());
                }
                GunBenchMenu.this.consumeIngredients();
            }
        });
        this.m_38897_(new Slot(container, 11, 116, 17){

            public boolean m_5857_(@NotNull ItemStack stack) {
                return stack.m_41720_() instanceof BlueprintItem;
            }

            public void m_6654_() {
                super.m_6654_();
                GunBenchMenu.this.attemptAutoCrafting();
            }
        });
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)playerInventory, col, 8 + col * 18, 142));
        }
        this.m_6199_(container);
    }

    private void attemptAutoCrafting() {
        this.containerAccess.m_39292_((level, pos) -> {
            if (level.f_46443_) {
                return;
            }
            ItemStack blueprintStack = this.container.m_8020_(11);
            if (blueprintStack.m_41619_() || !(blueprintStack.m_41720_() instanceof BlueprintItem)) {
                return;
            }
            ResourceLocation activeRecipeId = BlueprintScreen.getActiveRecipe(blueprintStack);
            if (activeRecipeId == null) {
                return;
            }
            Optional<GunBenchRecipe> recipeOptional = level.m_7465_().m_44013_((RecipeType)GunBenchRecipe.Type.INSTANCE).stream().filter(recipe -> recipe.m_6423_().equals((Object)activeRecipeId)).findFirst();
            if (recipeOptional.isEmpty()) {
                return;
            }
            GunBenchRecipe recipe2 = recipeOptional.get();
            for (int i = 0; i < 10; ++i) {
                ItemStack existing = this.container.m_8020_(i);
                if (existing.m_41619_()) continue;
                if (!this.player.m_150109_().m_36054_(existing)) {
                    this.player.m_36176_(existing, false);
                }
                this.container.m_6836_(i, ItemStack.f_41583_);
            }
            NonNullList<Ingredient> ingredients = recipe2.m_7527_();
            for (int slotIndex = 0; slotIndex < Math.min(ingredients.size(), 10); ++slotIndex) {
                ItemStack foundItem;
                Ingredient ingredient = (Ingredient)ingredients.get(slotIndex);
                if (ingredient.m_43947_() || (foundItem = this.findAndRemoveIngredientFromInventory(ingredient)).m_41619_()) continue;
                this.container.m_6836_(slotIndex, foundItem);
            }
            this.m_6199_(this.container);
        });
    }

    private ItemStack findAndRemoveIngredientFromInventory(Ingredient ingredient) {
        ItemStack stack;
        int i;
        for (i = 9; i < this.player.m_150109_().m_6643_(); ++i) {
            stack = this.player.m_150109_().m_8020_(i);
            if (stack.m_41619_() || !ingredient.test(stack)) continue;
            ItemStack result = stack.m_41777_();
            result.m_41764_(1);
            stack.m_41774_(1);
            return result;
        }
        for (i = 0; i < 9; ++i) {
            stack = this.player.m_150109_().m_8020_(i);
            if (stack.m_41619_() || !ingredient.test(stack)) continue;
            ItemStack result = stack.m_41777_();
            result.m_41764_(1);
            stack.m_41774_(1);
            return result;
        }
        return ItemStack.f_41583_;
    }

    public void m_6199_(Container container) {
        this.containerAccess.m_39292_((level, pos) -> {
            if (!level.f_46443_) {
                SimpleContainer craftingContainer = new SimpleContainer(12);
                for (int i = 0; i < 12; ++i) {
                    craftingContainer.m_6836_(i, container.m_8020_(i));
                }
                Optional recipe = level.m_7465_().m_44015_((RecipeType)GunBenchRecipe.Type.INSTANCE, (Container)craftingContainer, level);
                if (recipe.isPresent()) {
                    ItemStack result = ((GunBenchRecipe)recipe.get()).m_5874_((Container)craftingContainer, level.m_9598_());
                    container.m_6836_(10, result);
                } else {
                    container.m_6836_(10, ItemStack.f_41583_);
                }
            }
        });
    }

    private void consumeIngredients() {
        this.containerAccess.m_39292_((level, pos) -> {
            if (!level.f_46443_) {
                SimpleContainer craftingContainer = new SimpleContainer(12);
                for (int i = 0; i < 12; ++i) {
                    craftingContainer.m_6836_(i, this.container.m_8020_(i));
                }
                Optional recipeOptional = level.m_7465_().m_44015_((RecipeType)GunBenchRecipe.Type.INSTANCE, (Container)craftingContainer, level);
                if (recipeOptional.isPresent()) {
                    GunBenchRecipe recipe = (GunBenchRecipe)recipeOptional.get();
                    NonNullList<Ingredient> ingredients = recipe.m_7527_();
                    for (int i = 0; i < ingredients.size(); ++i) {
                        Ingredient requiredIngredient = (Ingredient)ingredients.get(i);
                        ItemStack stackInSlot = this.container.m_8020_(i);
                        if (requiredIngredient.m_43947_() || stackInSlot.m_41619_()) continue;
                        stackInSlot.m_41774_(1);
                        this.container.m_6836_(i, stackInSlot);
                    }
                }
            }
        });
    }

    public void m_38946_() {
        super.m_38946_();
        this.m_6199_(this.container);
    }

    public boolean m_6875_(Player player) {
        return this.container.m_6542_(player);
    }

    @NotNull
    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            boolean moveSuccess;
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index >= this.container.m_6643_() ? (itemstack1.m_41720_() instanceof BlueprintItem ? !(moveSuccess = this.m_38903_(itemstack1, 11, 12, false)) && !this.m_38903_(itemstack1, 0, 9, false) : !this.m_38903_(itemstack1, 0, this.container.m_6643_(), false)) : !this.m_38903_(itemstack1, this.container.m_6643_(), this.f_38839_.size(), true)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, itemstack1);
        }
        return itemstack;
    }
}

