/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.client.render.gun.model;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import top.ribs.scguns.client.SpecialModels;
import top.ribs.scguns.client.render.gun.IOverrideModel;
import top.ribs.scguns.client.util.RenderUtil;
import top.ribs.scguns.common.Gun;
import top.ribs.scguns.init.ModItems;
import top.ribs.scguns.item.attachment.IAttachment;

public class ForlornHopeModel
implements IOverrideModel {
    @Override
    public void render(float partialTicks, ItemDisplayContext transformType, ItemStack stack, ItemStack parent, LivingEntity entity, PoseStack matrixStack, MultiBufferSource buffer, int light, int overlay) {
        RenderUtil.renderModel(SpecialModels.FORLORN_HOPE_MAIN.getModel(), stack, matrixStack, buffer, light, overlay);
        if (Gun.getScope(stack) == null) {
            RenderUtil.renderModel(SpecialModels.FORLORN_HOPE_SIGHTS.getModel(), stack, matrixStack, buffer, light, overlay);
        } else {
            RenderUtil.renderModel(SpecialModels.FORLORN_HOPE_NO_SIGHTS.getModel(), stack, matrixStack, buffer, light, overlay);
        }
        this.renderStockAttachments(stack, matrixStack, buffer, light, overlay);
        this.renderUnderBarrelAttachments(stack, matrixStack, buffer, light, overlay);
    }

    private void renderStockAttachments(ItemStack stack, PoseStack matrixStack, MultiBufferSource buffer, int light, int overlay) {
        if (Gun.hasAttachmentEquipped(stack, IAttachment.Type.STOCK)) {
            if (Gun.getAttachment(IAttachment.Type.STOCK, stack).m_41720_() == ModItems.WOODEN_STOCK.get()) {
                RenderUtil.renderModel(SpecialModels.FORLORN_HOPE_WOODEN_STOCK.getModel(), stack, matrixStack, buffer, light, overlay);
            } else if (Gun.getAttachment(IAttachment.Type.STOCK, stack).m_41720_() == ModItems.LIGHT_STOCK.get()) {
                RenderUtil.renderModel(SpecialModels.FORLORN_HOPE_LIGHT_STOCK.getModel(), stack, matrixStack, buffer, light, overlay);
            } else if (Gun.getAttachment(IAttachment.Type.STOCK, stack).m_41720_() == ModItems.WEIGHTED_STOCK.get()) {
                RenderUtil.renderModel(SpecialModels.FORLORN_HOPE_HEAVY_STOCK.getModel(), stack, matrixStack, buffer, light, overlay);
            } else if (Gun.getAttachment(IAttachment.Type.STOCK, stack).m_41720_() == ModItems.BUMP_STOCK.get()) {
                RenderUtil.renderModel(SpecialModels.FORLORN_HOPE_HEAVY_STOCK.getModel(), stack, matrixStack, buffer, light, overlay);
            }
        }
    }

    private void renderUnderBarrelAttachments(ItemStack stack, PoseStack matrixStack, MultiBufferSource buffer, int light, int overlay) {
        if (Gun.hasAttachmentEquipped(stack, IAttachment.Type.UNDER_BARREL)) {
            if (Gun.getAttachment(IAttachment.Type.UNDER_BARREL, stack).m_41720_() == ModItems.VERTICAL_GRIP.get()) {
                RenderUtil.renderModel(SpecialModels.FORLORN_HOPE_VERTICAL_GRIP.getModel(), stack, matrixStack, buffer, light, overlay);
            } else if (Gun.getAttachment(IAttachment.Type.UNDER_BARREL, stack).m_41720_() == ModItems.LIGHT_GRIP.get()) {
                RenderUtil.renderModel(SpecialModels.FORLORN_HOPE_LIGHT_GRIP.getModel(), stack, matrixStack, buffer, light, overlay);
            } else if (Gun.getAttachment(IAttachment.Type.UNDER_BARREL, stack).m_41720_() == ModItems.IRON_BAYONET.get()) {
                RenderUtil.renderModel(SpecialModels.FORLORN_HOPE_IRON_BAYONET.getModel(), stack, matrixStack, buffer, light, overlay);
            } else if (Gun.getAttachment(IAttachment.Type.UNDER_BARREL, stack).m_41720_() == ModItems.ANTHRALITE_BAYONET.get()) {
                RenderUtil.renderModel(SpecialModels.FORLORN_HOPE_ANTHRALITE_BAYONET.getModel(), stack, matrixStack, buffer, light, overlay);
            } else if (Gun.getAttachment(IAttachment.Type.UNDER_BARREL, stack).m_41720_() == ModItems.DIAMOND_BAYONET.get()) {
                RenderUtil.renderModel(SpecialModels.FORLORN_HOPE_DIAMOND_BAYONET.getModel(), stack, matrixStack, buffer, light, overlay);
            } else if (Gun.getAttachment(IAttachment.Type.UNDER_BARREL, stack).m_41720_() == ModItems.NETHERITE_BAYONET.get()) {
                RenderUtil.renderModel(SpecialModels.FORLORN_HOPE_NETHERITE_BAYONET.getModel(), stack, matrixStack, buffer, light, overlay);
            }
        }
    }

    private double ease(double x) {
        return 1.0 - Math.pow(1.0 - 2.0 * x, 4.0);
    }
}

