/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.client.render.crosshair;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;
import top.ribs.scguns.client.handler.AimingHandler;
import top.ribs.scguns.client.render.crosshair.Crosshair;

public class TexturedCrosshair
extends Crosshair {
    private final ResourceLocation texture;
    private final boolean blend;

    public TexturedCrosshair(ResourceLocation id) {
        this(id, true);
    }

    public TexturedCrosshair(ResourceLocation id, boolean blend) {
        super(id);
        this.texture = new ResourceLocation(id.m_135827_(), "textures/crosshair/" + id.m_135815_() + ".png");
        this.blend = blend;
    }

    @Override
    public void render(Minecraft mc, PoseStack stack, int windowWidth, int windowHeight, float partialTicks) {
        stack.m_85836_();
        float alpha = 1.0f - (float)AimingHandler.get().getNormalisedAdsProgress();
        float size = 8.0f;
        stack.m_252880_(((float)windowWidth - size) / 2.0f, ((float)windowHeight - size) / 2.0f, 0.0f);
        RenderSystem.setShader(GameRenderer::m_172820_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.texture);
        RenderSystem.enableBlend();
        if (this.blend) {
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        }
        Matrix4f matrix = stack.m_85850_().m_252922_();
        BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        buffer.m_252986_(matrix, 0.0f, size, 0.0f).m_7421_(0.0f, 1.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        buffer.m_252986_(matrix, size, size, 0.0f).m_7421_(1.0f, 1.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        buffer.m_252986_(matrix, size, 0.0f, 0.0f).m_7421_(1.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        buffer.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_7421_(0.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
        if (this.blend) {
            RenderSystem.defaultBlendFunc();
        }
        stack.m_85849_();
    }
}

