/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.client.handler;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.ribs.scguns.init.ModEffects;

@Mod.EventBusSubscriber(modid="scguns", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class SulfurHeartsEventHandler {
    private static final ResourceLocation SULFUR_FULL = new ResourceLocation("scguns", "textures/gui/heart/sulfur_poisoned_full.png");
    private static final ResourceLocation SULFUR_HALF = new ResourceLocation("scguns", "textures/gui/heart/sulfur_poisoned_half.png");
    private static final ResourceLocation SULFUR_FULL_BLINKING = new ResourceLocation("scguns", "textures/gui/heart/sulfur_poisoned_full_blinking.png");
    private static final ResourceLocation SULFUR_HALF_BLINKING = new ResourceLocation("scguns", "textures/gui/heart/sulfur_poisoned_half_blinking.png");
    private static final ResourceLocation SULFUR_FULL_HARDCORE = new ResourceLocation("scguns", "textures/gui/heart/sulfur_poisoned_full_hardcore.png");
    private static final ResourceLocation SULFUR_HALF_HARDCORE = new ResourceLocation("scguns", "textures/gui/heart/sulfur_poisoned_half_hardcore.png");
    private static final ResourceLocation SULFUR_FULL_BLINKING_HARDCORE = new ResourceLocation("scguns", "textures/gui/heart/sulfur_poisoned_full_blinking_hardcore.png");
    private static final ResourceLocation SULFUR_HALF_BLINKING_HARDCORE = new ResourceLocation("scguns", "textures/gui/heart/sulfur_poisoned_half_blinking_hardcore.png");

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRenderGui(RenderGuiEvent.Post event) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null || mc.f_91066_.f_92062_) {
            return;
        }
        MobEffectInstance sulfurEffect = player.m_21124_((MobEffect)ModEffects.SULFUR_POISONING.get());
        if (sulfurEffect == null) {
            return;
        }
        int amplifier = sulfurEffect.m_19564_();
        int duration = sulfurEffect.m_19557_();
        float alpha = Math.min(1.0f, (float)duration / 100.0f);
        if ((alpha = Math.min(1.0f, alpha + (float)amplifier * 0.2f)) <= 0.1f) {
            return;
        }
        int health = Mth.m_14167_((float)player.m_21223_());
        int maxHealth = Mth.m_14167_((float)player.m_21233_());
        if (health <= 0 || maxHealth <= 0) {
            return;
        }
        boolean isHardcore = player.m_9236_().m_6106_().m_5466_();
        long currentTime = System.currentTimeMillis();
        boolean isBlinking = currentTime / 250L % 2L == 0L;
        GuiGraphics guiGraphics = event.getGuiGraphics();
        int screenWidth = mc.m_91268_().m_85445_();
        int screenHeight = mc.m_91268_().m_85446_();
        int left = screenWidth / 2 - 91;
        int top = screenHeight - 39;
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, alpha);
        SulfurHeartsEventHandler.renderSulfurHeartOverlay(guiGraphics, left, top, health, maxHealth, isHardcore, isBlinking);
        guiGraphics.m_280168_().m_85849_();
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private static void renderSulfurHeartOverlay(GuiGraphics guiGraphics, int x, int y, int health, int maxHealth, boolean hardcore, boolean blinking) {
        int heartsInThisRow;
        int heartsPerRow = 10;
        int fullHearts = health / 2;
        boolean hasHalfHeart = health % 2 == 1;
        for (int row = 0; row < (maxHealth + 19) / 20 && (heartsInThisRow = Math.min(heartsPerRow, maxHealth / 2 - row * heartsPerRow)) > 0; ++row) {
            for (int col = 0; col < heartsInThisRow; ++col) {
                int heartIndex = row * heartsPerRow + col;
                int heartX = x + col * 8;
                int heartY = y - row * 10;
                if (heartIndex >= fullHearts && (heartIndex != fullHearts || !hasHalfHeart)) continue;
                ResourceLocation textureToUse = SulfurHeartsEventHandler.getSulfurHeartTexture(heartIndex, fullHearts, hasHalfHeart, hardcore, blinking);
                guiGraphics.m_280163_(textureToUse, heartX, heartY, 0.0f, 0.0f, 9, 9, 9, 9);
            }
        }
    }

    private static ResourceLocation getSulfurHeartTexture(int heartIndex, int fullHearts, boolean hasHalfHeart, boolean hardcore, boolean blinking) {
        boolean isHalfHeart;
        boolean isFullHeart = heartIndex < fullHearts;
        boolean bl = isHalfHeart = heartIndex == fullHearts && hasHalfHeart;
        if (isFullHeart) {
            if (hardcore) {
                return blinking ? SULFUR_FULL_BLINKING_HARDCORE : SULFUR_FULL_HARDCORE;
            }
            return blinking ? SULFUR_FULL_BLINKING : SULFUR_FULL;
        }
        if (isHalfHeart) {
            if (hardcore) {
                return blinking ? SULFUR_HALF_BLINKING_HARDCORE : SULFUR_HALF_HARDCORE;
            }
            return blinking ? SULFUR_HALF_BLINKING : SULFUR_HALF;
        }
        return SULFUR_FULL;
    }
}

