/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.client.handler;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import top.ribs.scguns.Config;
import top.ribs.scguns.client.handler.AimingHandler;
import top.ribs.scguns.common.Gun;
import top.ribs.scguns.event.GunFireEvent;
import top.ribs.scguns.item.GunItem;
import top.ribs.scguns.util.ExoSuitRecoilHelper;
import top.ribs.scguns.util.GunEnchantmentHelper;
import top.ribs.scguns.util.GunModifierHelper;

public class RecoilHandler {
    private static RecoilHandler instance;
    private final Random random = new Random();
    private double gunRecoilNormal;
    private double gunRecoilAngle;
    private float gunRecoilRandom;
    private float cameraRecoil;
    private float progressCameraRecoil;
    private boolean enableRecoil = true;
    private static int recoilRand;

    public static RecoilHandler get() {
        if (instance == null) {
            instance = new RecoilHandler();
        }
        return instance;
    }

    private RecoilHandler() {
    }

    public void updateConfig() {
        try {
            if (Config.SERVER != null && Config.SERVER.enableCameraRecoil != null) {
                this.enableRecoil = (Boolean)Config.SERVER.enableCameraRecoil.get();
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public void preShoot(GunFireEvent.Pre event) {
        if (!event.isClient()) {
            return;
        }
        if (!this.enableRecoil) {
            return;
        }
        recoilRand = this.random.nextInt(2);
    }

    @SubscribeEvent
    public void onGunFire(GunFireEvent.Post event) {
        if (!event.isClient()) {
            return;
        }
        if (!this.enableRecoil) {
            return;
        }
        ItemStack heldItem = event.getStack();
        GunItem gunItem = (GunItem)heldItem.m_41720_();
        Gun modifiedGun = gunItem.getModifiedGun(heldItem);
        if (Minecraft.m_91087_().f_91074_ == null) {
            return;
        }
        float baseRecoilAngle = modifiedGun.getProjectile().getRecoilAngle();
        float exoSuitModifiedRecoil = ExoSuitRecoilHelper.getModifiedRecoilAngle((Player)Minecraft.m_91087_().f_91074_, baseRecoilAngle);
        float recoilModifier = 1.0f - GunModifierHelper.getRecoilModifier(heldItem);
        if (Minecraft.m_91087_().f_91074_ != null) {
            float enchantmentMultiplier = GunEnchantmentHelper.getRecoilModifier((Player)Minecraft.m_91087_().f_91074_, heldItem);
            recoilModifier *= enchantmentMultiplier;
        }
        this.cameraRecoil = exoSuitModifiedRecoil * (recoilModifier *= (float)this.getAdsRecoilReduction(modifiedGun));
        this.progressCameraRecoil = 0.0f;
        this.gunRecoilRandom = this.random.nextFloat();
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        if (event.phase != TickEvent.Phase.END || this.cameraRecoil <= 0.0f) {
            return;
        }
        if (!this.enableRecoil) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        float recoilAmount = this.cameraRecoil * mc.m_91297_() * 0.15f;
        float startProgress = this.progressCameraRecoil / this.cameraRecoil;
        float endProgress = (this.progressCameraRecoil + recoilAmount) / this.cameraRecoil;
        float pitch = mc.f_91074_.m_146909_();
        float yaw = mc.f_91074_.m_146908_();
        if (startProgress < 0.2f) {
            mc.f_91074_.m_146926_(pitch - (endProgress - startProgress) / 0.2f * this.cameraRecoil);
            if (recoilRand == 1) {
                mc.f_91074_.m_146922_(yaw - (endProgress - startProgress) / 0.2f * this.cameraRecoil / 2.0f);
            } else {
                mc.f_91074_.m_146922_(yaw + (endProgress - startProgress) / 0.2f * this.cameraRecoil / 2.0f);
            }
        } else {
            mc.f_91074_.m_146926_(pitch + (endProgress - startProgress) / 0.8f * this.cameraRecoil);
            if (recoilRand == 1) {
                mc.f_91074_.m_146922_(yaw + (endProgress - startProgress) / 0.8f * this.cameraRecoil / 2.0f);
            } else {
                mc.f_91074_.m_146922_(yaw - (endProgress - startProgress) / 0.8f * this.cameraRecoil / 2.0f);
            }
        }
        this.progressCameraRecoil += recoilAmount;
        if (this.progressCameraRecoil >= this.cameraRecoil) {
            this.cameraRecoil = 0.0f;
            this.progressCameraRecoil = 0.0f;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onRenderOverlay(RenderHandEvent event) {
        if (event.getHand() != InteractionHand.MAIN_HAND) {
            return;
        }
        ItemStack heldItem = event.getItemStack();
        Item item = heldItem.m_41720_();
        if (!(item instanceof GunItem)) {
            return;
        }
        GunItem gunItem = (GunItem)item;
        Gun modifiedGun = gunItem.getModifiedGun(heldItem);
        assert (Minecraft.m_91087_().f_91074_ != null);
        ItemCooldowns tracker = Minecraft.m_91087_().f_91074_.m_36335_();
        float cooldown = tracker.m_41521_((Item)gunItem, Minecraft.m_91087_().m_91296_());
        float f = cooldown = cooldown >= modifiedGun.getGeneral().getRecoilDurationOffset() ? (cooldown - modifiedGun.getGeneral().getRecoilDurationOffset()) / (1.0f - modifiedGun.getGeneral().getRecoilDurationOffset()) : 0.0f;
        if ((double)cooldown >= 0.8) {
            amount = (1.0f - cooldown) / 0.2f;
            this.gunRecoilNormal = 1.0f - (amount -= 1.0f) * amount * amount * amount;
        } else {
            amount = cooldown / 0.8f;
            this.gunRecoilNormal = (double)amount < 0.5 ? (double)(2.0f * amount * amount) : (double)(-1.0f + (4.0f - 2.0f * amount) * amount);
        }
        float baseRecoilAngle = modifiedGun.getProjectile().getRecoilAngle();
        if (Minecraft.m_91087_().f_91074_ != null) {
            float exoSuitModifiedRecoil = ExoSuitRecoilHelper.getModifiedRecoilAngle((Player)Minecraft.m_91087_().f_91074_, baseRecoilAngle);
            float recoilModifier = 1.0f - GunModifierHelper.getRecoilModifier(heldItem);
            float enchantmentMultiplier = GunEnchantmentHelper.getRecoilModifier((Player)Minecraft.m_91087_().f_91074_, heldItem);
            this.gunRecoilAngle = exoSuitModifiedRecoil * (recoilModifier *= enchantmentMultiplier);
        } else {
            this.gunRecoilAngle = baseRecoilAngle;
        }
    }

    public double getAdsRecoilReduction(Gun gun) {
        return 1.0 - (double)gun.getGeneral().getRecoilAdsReduction() * AimingHandler.get().getNormalisedAdsProgress();
    }

    public double getGunRecoilNormal() {
        return this.gunRecoilNormal;
    }

    public double getGunRecoilAngle() {
        return this.gunRecoilAngle;
    }

    public float getGunRecoilRandom() {
        return this.gunRecoilRandom;
    }
}

