/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.block;

import java.util.ArrayList;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import top.ribs.scguns.init.ModItems;
import top.ribs.scguns.init.ModParticleTypes;

public class ViciousAcidCauldronBlock
extends AbstractCauldronBlock {
    private static final int DAMAGE_INTERVAL = 10;
    private static final float DAMAGE_AMOUNT = 2.0f;
    private static final int ARMOR_DAMAGE = 3;
    private static final int HELD_ITEM_DAMAGE = 5;
    private static final int DROPPED_ITEM_DAMAGE = 5;
    private static final float ENCHANTMENT_REMOVAL_CHANCE = 0.2f;

    public ViciousAcidCauldronBlock(BlockBehaviour.Properties properties) {
        super(properties, Map.of());
    }

    protected double m_142446_(BlockState state) {
        return 0.9375;
    }

    public boolean m_142596_(BlockState state) {
        return true;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_150930_(Items.f_42446_)) {
            if (!level.f_46443_) {
                player.m_21008_(hand, new ItemStack((ItemLike)ModItems.VICIOUS_ACID_BUCKET.get()));
                level.m_46597_(pos, Blocks.f_50256_.m_49966_());
                level.m_5594_(null, pos, SoundEvents.f_11781_, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_142346_(null, GameEvent.f_157816_, pos);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (random.m_188503_(4) == 0) {
            double x = (double)pos.m_123341_() + 0.3 + random.m_188500_() * 0.4;
            double y = (double)pos.m_123342_() + 0.85;
            double z = (double)pos.m_123343_() + 0.3 + random.m_188500_() * 0.4;
            level.m_7106_((ParticleOptions)ModParticleTypes.ACID_BUBBLE.get(), x, y, z, 0.0, 0.0, 0.0);
        }
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (level.f_46443_) {
            return;
        }
        if (!this.m_151979_(state, pos, entity)) {
            return;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (entity.f_19797_ % 10 == 0) {
                entity.m_6469_(level.m_269111_().m_269425_(), 2.0f);
                this.damageAndTryCurseClear(livingEntity.m_6168_(), 3, level, pos, entity);
                this.damageAndTryClearHeldItems(livingEntity, level, pos);
            }
        } else if (entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            if (entity.f_19797_ % 10 == 0) {
                ItemStack stack = itemEntity.m_32055_();
                if (stack.m_41763_() && stack.m_41773_() >= stack.m_41776_() - 1) {
                    return;
                }
                if (this.tryRemoveEnchantment(stack, level, pos)) {
                    return;
                }
                if (stack.m_41763_()) {
                    int newDamage = stack.m_41773_() + 5;
                    if (newDamage >= stack.m_41776_() - 1) {
                        stack.m_41721_(stack.m_41776_() - 1);
                    } else {
                        stack.m_41721_(newDamage);
                    }
                }
            }
        }
    }

    private void damageAndTryCurseClear(Iterable<ItemStack> items, int damage, Level level, BlockPos pos, Entity entity) {
        for (ItemStack stack : items) {
            if (stack.m_41619_() || stack.m_41763_() && stack.m_41773_() >= stack.m_41776_() - 1 || this.tryRemoveEnchantment(stack, level, pos) || !stack.m_41763_() || !(entity instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity;
            int newDamage = stack.m_41773_() + damage;
            if (newDamage >= stack.m_41776_() - 1) {
                stack.m_41721_(stack.m_41776_() - 1);
                continue;
            }
            stack.m_41622_(damage, living, e -> {});
        }
    }

    private void damageAndTryClearHeldItems(LivingEntity entity, Level level, BlockPos pos) {
        ItemStack offHand;
        ItemStack mainHand = entity.m_21205_();
        if (!mainHand.m_41619_() && mainHand.m_41763_() && mainHand.m_41773_() < mainHand.m_41776_() - 1 && !this.tryRemoveEnchantment(mainHand, level, pos) && mainHand.m_41763_()) {
            int newDamage = mainHand.m_41773_() + 5;
            if (newDamage >= mainHand.m_41776_() - 1) {
                mainHand.m_41721_(mainHand.m_41776_() - 1);
            } else {
                mainHand.m_41622_(5, entity, e -> {});
            }
        }
        if (!(offHand = entity.m_21206_()).m_41619_() && offHand.m_41763_() && offHand.m_41773_() < offHand.m_41776_() - 1 && !this.tryRemoveEnchantment(offHand, level, pos) && offHand.m_41763_()) {
            int newDamage = offHand.m_41773_() + 5;
            if (newDamage >= offHand.m_41776_() - 1) {
                offHand.m_41721_(offHand.m_41776_() - 1);
            } else {
                offHand.m_41622_(5, entity, e -> {});
            }
        }
    }

    private boolean tryRemoveEnchantment(ItemStack stack, Level level, BlockPos pos) {
        if (stack.m_41619_() || level.f_46441_.m_188501_() > 0.2f) {
            return false;
        }
        Map enchantments = EnchantmentHelper.m_44831_((ItemStack)stack);
        if (enchantments.isEmpty()) {
            return false;
        }
        ArrayList allEnchants = new ArrayList(enchantments.keySet());
        Enchantment toRemove = (Enchantment)allEnchants.get(level.f_46441_.m_188503_(allEnchants.size()));
        enchantments.remove(toRemove);
        EnchantmentHelper.m_44865_((Map)enchantments, (ItemStack)stack);
        this.spawnEnchantmentRemovalParticles(level, pos);
        return true;
    }

    private void spawnEnchantmentRemovalParticles(Level level, BlockPos pos) {
        if (level instanceof ServerLevel) {
            double offsetZ;
            double offsetY;
            double offsetX;
            int i;
            ServerLevel serverLevel = (ServerLevel)level;
            for (i = 0; i < 20; ++i) {
                offsetX = level.f_46441_.m_188583_() * 0.3;
                offsetY = level.f_46441_.m_188500_() * 0.3 + 0.5;
                offsetZ = level.f_46441_.m_188583_() * 0.3;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175830_, (double)pos.m_123341_() + 0.5 + offsetX, (double)pos.m_123342_() + offsetY, (double)pos.m_123343_() + 0.5 + offsetZ, 1, 0.0, 0.1, 0.0, 0.05);
            }
            for (i = 0; i < 10; ++i) {
                offsetX = level.f_46441_.m_188583_() * 0.2;
                offsetY = level.f_46441_.m_188500_() * 0.3 + 0.5;
                offsetZ = level.f_46441_.m_188583_() * 0.2;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, (double)pos.m_123341_() + 0.5 + offsetX, (double)pos.m_123342_() + offsetY, (double)pos.m_123343_() + 0.5 + offsetZ, 1, 0.0, 0.1, 0.0, 0.02);
            }
        }
    }
}

