/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.network.NetworkHooks;
import top.ribs.scguns.block.GeothermalVentBlock;
import top.ribs.scguns.block.SulfurVentBlock;
import top.ribs.scguns.blockentity.VentCollectorBlockEntity;

public class VentCollectorBlock
extends Block
implements EntityBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty ATTACHED = BooleanProperty.m_61465_((String)"attached");
    private static final VoxelShape SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);

    public VentCollectorBlock(BlockBehaviour.Properties properties) {
        super(properties.m_60978_(0.5f).m_60918_(SoundType.f_56743_));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)ATTACHED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED, FACING, ATTACHED});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        BlockPos pos = context.m_8083_().m_121945_(context.m_8125_().m_122424_());
        boolean attached = context.m_43725_().m_7702_(pos) != null;
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_))).m_61124_((Property)ATTACHED, (Comparable)Boolean.valueOf(attached));
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        if (direction == state.m_61143_((Property)FACING)) {
            boolean attached = this.hasInventory(level, neighborPos, direction.m_122424_());
            return (BlockState)state.m_61124_((Property)ATTACHED, (Comparable)Boolean.valueOf(attached));
        }
        return super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    private boolean hasInventory(LevelAccessor level, BlockPos pos, Direction direction) {
        BlockEntity be = level.m_7702_(pos);
        return be != null && be.getCapability(ForgeCapabilities.ITEM_HANDLER, direction).isPresent();
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new VentCollectorBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return level.f_46443_ ? null : (lvl, pos, st, t) -> {
            if (t instanceof VentCollectorBlockEntity) {
                VentCollectorBlockEntity.tick(lvl, pos, st, (VentCollectorBlockEntity)t);
            }
        };
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity;
        if (!level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof VentCollectorBlockEntity) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)((VentCollectorBlockEntity)blockEntity), (BlockPos)pos);
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (!state.m_60713_(newState.m_60734_()) && (blockEntity = level.m_7702_(pos)) instanceof VentCollectorBlockEntity) {
            ((VentCollectorBlockEntity)blockEntity).drops();
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof VentCollectorBlockEntity) {
            return AbstractContainerMenu.m_38938_((Container)((Container)blockEntity));
        }
        return 0;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        boolean isActive;
        BlockState belowState = level.m_8055_(pos.m_7495_());
        boolean isGeothermalVentBelow = belowState.m_60734_() instanceof GeothermalVentBlock;
        boolean isSulfurVentBelow = belowState.m_60734_() instanceof SulfurVentBlock;
        boolean bl = isActive = isGeothermalVentBelow && (Boolean)belowState.m_61143_((Property)GeothermalVentBlock.ACTIVE) != false || isSulfurVentBelow && (Boolean)belowState.m_61143_((Property)SulfurVentBlock.ACTIVE) != false;
        if (isActive) {
            if (random.m_188503_(20) == 0) {
                level.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_11784_, SoundSource.BLOCKS, 0.5f + random.m_188501_(), random.m_188501_() * 0.7f + 0.6f, false);
            }
            BlockEntity blockEntity = level.m_7702_(pos);
            boolean hasFilterCharge = false;
            if (blockEntity instanceof VentCollectorBlockEntity) {
                VentCollectorBlockEntity ventCollector = (VentCollectorBlockEntity)blockEntity;
                hasFilterCharge = ventCollector.getFilterCharge() > 0;
            }
            Direction facing = (Direction)state.m_61143_((Property)FACING);
            double x = (double)pos.m_123341_() + 0.5;
            double y = (double)pos.m_123342_() + 0.55;
            double z = (double)pos.m_123343_() + 0.7;
            if (facing == Direction.NORTH) {
                z += 0.45;
            } else if (facing == Direction.SOUTH) {
                z -= 0.45;
            } else if (facing == Direction.WEST) {
                x += 0.45;
            } else if (facing == Direction.EAST) {
                x -= 0.45;
            }
            for (int i = 0; i < random.m_188503_(2) + 2; ++i) {
                double offsetX = random.m_188500_() * 0.05 - 0.025;
                double offsetY = 0.05 + random.m_188500_() * 0.05;
                double offsetZ = random.m_188500_() * 0.05 - 0.025;
                if (hasFilterCharge) {
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123796_, x, y, z, offsetX, offsetY, offsetZ);
                    continue;
                }
                level.m_7106_((ParticleOptions)ParticleTypes.f_123755_, x, y, z, offsetX, offsetY, offsetZ);
            }
        }
    }
}

