/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.block;

import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import top.ribs.scguns.block.VentCollectorBlock;
import top.ribs.scguns.common.Vent;
import top.ribs.scguns.common.VentManager;

public abstract class VentBlock
extends Block {
    public static final EnumProperty<VentType> VENT_TYPE = EnumProperty.m_61587_((String)"vent_type", VentType.class);
    public static final BooleanProperty ACTIVE = BooleanProperty.m_61465_((String)"active");
    public static final IntegerProperty VENT_POWER = IntegerProperty.m_61631_((String)"vent_power", (int)1, (int)5);
    protected static final VoxelShape SHAPE_BASE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_MIDDLE_TOP = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    protected static final int BASE_TICK_INTERVAL = 100;
    protected final Random random = new Random();
    public final ResourceLocation ventId;
    public Vent config;

    public VentBlock(BlockBehaviour.Properties properties, ResourceLocation ventId) {
        super(properties);
        this.ventId = ventId;
        this.config = VentManager.getVent(ventId);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(VENT_TYPE, (Comparable)((Object)VentType.BASE))).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)VENT_POWER, (Comparable)Integer.valueOf(1)));
    }

    public void reloadConfig() {
        this.config = VentManager.getVent(this.ventId);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{VENT_TYPE, ACTIVE, VENT_POWER});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        boolean isActive = this.isActive((LevelAccessor)level, pos);
        int ventPower = this.calculateVentPower((LevelAccessor)level, pos);
        return (BlockState)((BlockState)this.updateState(level.m_8055_(pos.m_7495_()), level.m_8055_(pos.m_7494_())).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(isActive))).m_61124_((Property)VENT_POWER, (Comparable)Integer.valueOf(ventPower));
    }

    @NotNull
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (level instanceof Level) {
            boolean isActive = this.isActive(level, pos);
            int ventPower = this.calculateVentPower((LevelAccessor)((Level)level), pos);
            return (BlockState)((BlockState)this.updateState(level.m_8055_(pos.m_7495_()), level.m_8055_(pos.m_7494_())).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(isActive))).m_61124_((Property)VENT_POWER, (Comparable)Integer.valueOf(ventPower));
        }
        return this.updateState(level.m_8055_(pos.m_7495_()), level.m_8055_(pos.m_7494_()));
    }

    protected int calculateVentPower(LevelAccessor level, BlockPos pos) {
        if (this.config == null) {
            this.reloadConfig();
            if (this.config == null) {
                return 1;
            }
        }
        BlockPos basePos = this.getBasePos(level, pos);
        int power = 1;
        BlockPos checkPos = basePos.m_7494_();
        int maxPower = this.config.getPower().getMaxPower();
        while (level.m_8055_(checkPos).m_60734_() instanceof VentBlock && power < maxPower) {
            ++power;
            checkPos = checkPos.m_7494_();
        }
        return power;
    }

    protected void updateVentPower(Level level, BlockPos pos) {
        BlockPos basePos = this.getBasePos((LevelAccessor)level, pos);
        int power = this.calculateVentPower((LevelAccessor)level, basePos);
        BlockState baseState = level.m_8055_(basePos);
        level.m_7731_(basePos, (BlockState)baseState.m_61124_((Property)VENT_POWER, (Comparable)Integer.valueOf(power)), 3);
        BlockPos checkPos = basePos.m_7494_();
        while (level.m_8055_(checkPos).m_60734_() instanceof VentBlock) {
            BlockState state = level.m_8055_(checkPos);
            level.m_7731_(checkPos, (BlockState)state.m_61124_((Property)VENT_POWER, (Comparable)Integer.valueOf(power)), 3);
            checkPos = checkPos.m_7494_();
        }
    }

    protected BlockState updateState(BlockState belowState, BlockState aboveState) {
        if (belowState.m_60734_() instanceof VentBlock) {
            if (aboveState.m_60734_() instanceof VentBlock) {
                return (BlockState)this.m_49966_().m_61124_(VENT_TYPE, (Comparable)((Object)VentType.MIDDLE));
            }
            return (BlockState)this.m_49966_().m_61124_(VENT_TYPE, (Comparable)((Object)VentType.TOP));
        }
        return (BlockState)this.m_49966_().m_61124_(VENT_TYPE, (Comparable)((Object)VentType.BASE));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return state.m_61143_(VENT_TYPE) == VentType.BASE ? SHAPE_BASE : SHAPE_MIDDLE_TOP;
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.DESTROY;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, level, pos, block, fromPos, isMoving);
        if (block instanceof PistonBaseBlock) {
            level.m_46961_(pos, true);
        }
        boolean isActive = this.isActive((LevelAccessor)level, pos);
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(isActive)), 3);
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        boolean isActive = this.isActive((LevelAccessor)level, pos);
        int ventPower = this.calculateVentPower((LevelAccessor)level, pos);
        level.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(isActive))).m_61124_((Property)VENT_POWER, (Comparable)Integer.valueOf(ventPower)), 3);
        level.m_186460_(pos, (Block)this, this.calculateNextTickInterval());
        this.updateVentPower(level, pos);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockState stateBelow;
        super.m_6810_(state, level, pos, newState, isMoving);
        if (!(newState.m_60734_() instanceof VentBlock) && (stateBelow = level.m_8055_(pos.m_7495_())).m_60734_() instanceof VentBlock) {
            this.updateVentPower(level, pos.m_7495_());
        }
    }

    public abstract void m_213897_(BlockState var1, ServerLevel var2, BlockPos var3, RandomSource var4);

    protected int calculateNextTickInterval() {
        if (this.config == null) {
            this.reloadConfig();
            if (this.config == null) {
                return 100;
            }
        }
        return this.config.getPower().getBaseTickInterval() + this.random.nextInt(this.config.getPower().getTickWiggleRoom());
    }

    protected boolean hasVentCollectorAbove(LevelReader level, BlockPos pos) {
        BlockPos topPos = this.getTopPos(level, pos);
        return level.m_8055_(topPos.m_7494_()).m_60734_() instanceof VentCollectorBlock;
    }

    protected BlockPos getTopPos(LevelReader level, BlockPos pos) {
        while (level.m_8055_(pos.m_7494_()).m_60734_() instanceof VentBlock) {
            pos = pos.m_7494_();
        }
        return pos;
    }

    protected BlockPos getBasePos(LevelAccessor level, BlockPos pos) {
        while (level.m_8055_(pos.m_7495_()).m_60734_() instanceof VentBlock && pos.m_123342_() > 0) {
            pos = pos.m_7495_();
        }
        return pos;
    }

    protected boolean isVentAbove(Level level, BlockPos pos) {
        BlockPos abovePos = pos.m_7494_();
        return level.m_8055_(abovePos).m_60734_() instanceof VentBlock;
    }

    protected abstract boolean isActive(LevelAccessor var1, BlockPos var2);

    protected boolean isTopOrBaseWithoutTop(BlockState state, Level level, BlockPos pos) {
        return state.m_61143_(VENT_TYPE) == VentType.TOP || state.m_61143_(VENT_TYPE) == VentType.BASE && !this.isVentAbove(level, pos);
    }

    protected void playAmbientSound(Level level, BlockPos pos, RandomSource random) {
        if (this.config == null || !this.config.getParticles().showActive()) {
            return;
        }
        ResourceLocation soundLoc = this.config.getParticles().getActiveSound();
        if (soundLoc == null) {
            return;
        }
        SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(soundLoc);
        if (sound == null) {
            return;
        }
        if (random.m_188503_(20) == 0) {
            level.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, sound, SoundSource.BLOCKS, 0.5f + random.m_188501_(), random.m_188501_() * 0.7f + 0.6f, false);
        }
    }

    public ItemStack selectRandomOutput(RandomSource random) {
        if (this.config == null) {
            return ItemStack.f_41583_;
        }
        List<Vent.Production.OutputItem> outputs = this.config.getProduction().getOutputs();
        if (outputs.isEmpty()) {
            return ItemStack.f_41583_;
        }
        int totalWeight = 0;
        for (Vent.Production.OutputItem output : outputs) {
            totalWeight += output.getWeight();
        }
        if (totalWeight <= 0) {
            return ItemStack.f_41583_;
        }
        int randomValue = random.m_188503_(totalWeight);
        int currentWeight = 0;
        for (Vent.Production.OutputItem output : outputs) {
            Item item;
            if (randomValue >= (currentWeight += output.getWeight()) || (item = output.getItem()) == null) continue;
            return new ItemStack((ItemLike)item, 1);
        }
        return ItemStack.f_41583_;
    }

    public boolean shouldProduce(RandomSource random) {
        if (this.config == null) {
            return false;
        }
        return random.m_188501_() < this.config.getProduction().getProductionChance();
    }

    protected boolean shouldShowParticles() {
        if (this.config == null) {
            return true;
        }
        return this.config.getParticles().showActive();
    }

    public static enum VentType implements StringRepresentable
    {
        BASE("base"),
        MIDDLE("middle"),
        TOP("top");

        private final String name;

        private VentType(String name) {
            this.name = name;
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

