/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.block;

import java.util.List;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;
import top.ribs.scguns.blockentity.ThermolithBlockEntity;
import top.ribs.scguns.init.ModBlockEntities;

public class ThermolithBlock
extends BaseEntityBlock {
    public static final BooleanProperty LIT = BooleanProperty.m_61465_((String)"lit");
    private static final ResourceLocation THERMOLITH_INGREDIENT_TAG = new ResourceLocation("scguns", "thermolith_ingredient");

    public ThermolithBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LIT});
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ThermolithBlockEntity(pos, state);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity;
        if (!world.f_46443_ && (blockEntity = world.m_7702_(pos)) instanceof ThermolithBlockEntity) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)((MenuProvider)blockEntity), (BlockPos)pos);
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof ThermolithBlockEntity) {
                ThermolithBlockEntity thermolithBlockEntity = (ThermolithBlockEntity)blockEntity;
                thermolithBlockEntity.drops();
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return ThermolithBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.THERMOLITH.get()), (level1, pos, state1, blockEntity) -> blockEntity.tick());
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue() && level.f_46443_) {
            double x = (double)pos.m_123341_() + 0.5;
            double y = (double)pos.m_123342_() + 1.0;
            double z = (double)pos.m_123343_() + 0.5;
            if (random.m_188500_() < 0.3) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123756_, x, y, z, 0.0, 0.0, 0.0);
            }
            for (Direction direction : Direction.values()) {
                BlockPos relativePos;
                if (direction == Direction.UP || level.m_8055_(relativePos = pos.m_121945_(direction)).m_60804_((BlockGetter)level, relativePos)) continue;
                double xOffset = (double)direction.m_122429_() * 0.52;
                double yOffset = random.m_188500_() * 0.5;
                double zOffset = (double)direction.m_122431_() * 0.52;
                level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x + xOffset, y + yOffset, z + zOffset, 0.0, 0.0, 0.0);
            }
            if (random.m_188500_() < 0.1) {
                level.m_7785_(x, y, z, SoundEvents.f_12032_, SoundSource.BLOCKS, 0.2f + random.m_188501_() * 0.2f, 0.9f + random.m_188501_() * 0.15f, false);
            }
        }
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        super.m_5871_(stack, level, tooltip, flag);
        if (Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237113_((String)""));
            tooltip.add((Component)Component.m_237115_((String)"info.scguns.thermolith.accepted_fuel").m_130940_(ChatFormatting.GOLD));
            TagKey ingredientTag = ItemTags.create((ResourceLocation)THERMOLITH_INGREDIENT_TAG);
            List<Item> fuelItems = StreamSupport.stream(BuiltInRegistries.f_257033_.m_206058_(ingredientTag).spliterator(), false).map(holder -> (Item)holder.m_203334_()).toList();
            if (!fuelItems.isEmpty()) {
                for (Item item : fuelItems) {
                    tooltip.add((Component)Component.m_237113_((String)"  ").m_7220_((Component)Component.m_237115_((String)item.m_5524_()).m_130940_(ChatFormatting.WHITE)));
                }
            } else {
                tooltip.add((Component)Component.m_237113_((String)"  ").m_7220_((Component)Component.m_237115_((String)"info.scguns.no_fuels")).m_130940_(ChatFormatting.DARK_GRAY));
            }
            tooltip.add((Component)Component.m_237113_((String)""));
            tooltip.add((Component)Component.m_237115_((String)"info.scguns.thermolith.function").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.ITALIC}));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"info.scguns.thermolith.shift_fuel").m_130940_(ChatFormatting.GRAY));
        }
    }
}

